/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.Collections;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class ListReplaceAllTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testReplaceAll() {
        this.getList().replaceAll(e -> this.samples.e3());
        this.expectContents(Collections.nCopies(this.getNumElements(), this.samples.e3()));
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testReplaceAll_changesSome() {
        this.getList().replaceAll(e -> e.equals(this.samples.e0()) ? this.samples.e3() : e);
        E[] expected = this.createSamplesArray();
        for (int i = 0; i < expected.length; ++i) {
            if (!expected[i].equals(this.samples.e0())) continue;
            expected[i] = this.samples.e3();
        }
        this.expectContents(expected);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testReplaceAll_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getList().replaceAll(e -> e));
        this.expectUnchanged();
    }
}

