/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
public class FakeTicker
extends Ticker {
    private final AtomicLong nanos = new AtomicLong();
    private volatile long autoIncrementStepNanos;

    @CanIgnoreReturnValue
    public FakeTicker advance(long time, TimeUnit timeUnit) {
        return this.advance(timeUnit.toNanos(time));
    }

    @CanIgnoreReturnValue
    public FakeTicker advance(long nanoseconds) {
        this.nanos.addAndGet(nanoseconds);
        return this;
    }

    @GwtIncompatible
    @J2ktIncompatible
    @CanIgnoreReturnValue
    public FakeTicker advance(Duration duration) {
        return this.advance(duration.toNanos());
    }

    @CanIgnoreReturnValue
    public FakeTicker setAutoIncrementStep(long autoIncrementStep, TimeUnit timeUnit) {
        Preconditions.checkArgument((autoIncrementStep >= 0L ? 1 : 0) != 0, (Object)"May not auto-increment by a negative amount");
        this.autoIncrementStepNanos = timeUnit.toNanos(autoIncrementStep);
        return this;
    }

    @GwtIncompatible
    @J2ktIncompatible
    @CanIgnoreReturnValue
    public FakeTicker setAutoIncrementStep(Duration autoIncrementStep) {
        return this.setAutoIncrementStep(autoIncrementStep.toNanos(), TimeUnit.NANOSECONDS);
    }

    public long read() {
        return this.nanos.getAndAdd(this.autoIncrementStepNanos);
    }
}

