/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.collect.testing.features;

import static com.google.common.collect.testing.Helpers.copyToSet;

import com.google.common.annotations.GwtCompatible;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;

/**
 * Optional features of classes derived from {@code Set}.
 *
 * @author George van den Driessche
 */
@SuppressWarnings("rawtypes") // maybe avoidable if we rework the whole package?
@GwtCompatible
public enum SetFeature implements Feature<Set> {
  GENERAL_PURPOSE(CollectionFeature.GENERAL_PURPOSE);

  private final Set<Feature<? super Set>> implied;

  SetFeature(Feature<? super Set>... implied) {
    this.implied = copyToSet(implied);
  }

  @Override
  public Set<Feature<? super Set>> getImpliedFeatures() {
    return implied;
  }

  @Retention(RetentionPolicy.RUNTIME)
  @Inherited
  @TesterAnnotation
  public @interface Require {
    public abstract SetFeature[] value() default {};

    public abstract SetFeature[] absent() default {};
  }
}
