/*
 * Copyright (C) 2013 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.collect.testing.google;

import static com.google.common.collect.testing.Helpers.copyToSet;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.TesterAnnotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;

/**
 * Optional features of classes derived from {@code Multimap}.
 *
 * @author Louis Wasserman
 */
@SuppressWarnings("rawtypes") // maybe avoidable if we rework the whole package?
@GwtCompatible
public enum MultimapFeature implements Feature<Multimap> {
  VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE;

  private final Set<Feature<? super Multimap>> implied;

  MultimapFeature(Feature<? super Multimap>... implied) {
    this.implied = copyToSet(implied);
  }

  @Override
  public Set<Feature<? super Multimap>> getImpliedFeatures() {
    return implied;
  }

  @Retention(RetentionPolicy.RUNTIME)
  @Inherited
  @TesterAnnotation
  public @interface Require {
    public abstract MultimapFeature[] value() default {};

    public abstract MultimapFeature[] absent() default {};
  }
}
