/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Platform;
import junit.framework.TestCase;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@GwtCompatible(emulated=true)
public class AbstractTester<G>
extends TestCase {
    private G subjectGenerator;
    private String suiteName;
    private @Nullable Runnable setUp;
    private @Nullable Runnable tearDown;

    public void setUp() throws Exception {
        if (this.setUp != null) {
            this.setUp.run();
        }
    }

    public void tearDown() throws Exception {
        if (this.tearDown != null) {
            this.tearDown.run();
        }
    }

    public final void init(G subjectGenerator, String suiteName, @Nullable Runnable setUp, @Nullable Runnable tearDown) {
        this.subjectGenerator = subjectGenerator;
        this.suiteName = suiteName;
        this.setUp = setUp;
        this.tearDown = tearDown;
    }

    public final void init(G subjectGenerator, String suiteName) {
        this.init(subjectGenerator, suiteName, null, null);
    }

    public G getSubjectGenerator() {
        return this.subjectGenerator;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public final String getTestMethodName() {
        return super.getName();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public String getName() {
        return Platform.format("%s[%s]", super.getName(), this.suiteName);
    }

    public static void assertNull(String message, Object object) {
        AbstractTester.assertEquals((String)message, null, (Object)object);
    }
}

