/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapPutIterableTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})::iterator));
        this.assertGet(this.k0(), this.v0(), this.v3(), this.v4());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(this.k0(), this.v0(), this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})::iterator));
        this.assertGet(this.k3(), this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(this.k3(), this.v3(), this.v4());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnPresentKey_supported() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null})));
        this.assertGet(this.k0(), this.v0(), this.v3(), null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnAbsentKey_supported() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null})));
        this.assertGet(this.k3(), this.v3(), null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueSingle_unsupported() {
        this.multimap().putAll(this.k1(), (Iterable)Lists.newArrayList((Object[])new Object[]{null}));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueNullLast_unsupported() {
        int size = this.getNumElements();
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null})));
        Collection values = this.multimap().get(this.k3());
        if (values.size() == 0) {
            this.expectUnchanged();
            MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList(), (Object)Lists.newArrayList((Iterable)values));
            MultimapPutIterableTester.assertEquals((int)size, (int)this.multimap().size());
        } else {
            MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{this.v3()}), (Object)Lists.newArrayList((Iterable)values));
            MultimapPutIterableTester.assertEquals((int)(size + 1), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueNullFirst_unsupported() {
        int size = this.getNumElements();
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{null, this.v3()})));
        this.expectUnchanged();
        MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList(), (Object)Lists.newArrayList((Iterable)this.multimap().get(this.k3())));
        MultimapPutIterableTester.assertEquals((int)size, (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllOnPresentNullKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(null, (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(null, this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllNullForbidden() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().putAll(null, Collections.singletonList(this.v3())));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.k3(), Collections.emptyList()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnAbsentKey() {
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.k3(), Collections::emptyIterator));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnPresentKey() {
        this.multimap().putAll(this.k0(), Collections.emptyList());
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllOnlyCallsIteratorOnce() {
        Iterable iterable = new Iterable<V>(){
            private boolean calledIteratorAlready = false;

            @Override
            public Iterator<V> iterator() {
                Preconditions.checkState((!this.calledIteratorAlready ? 1 : 0) != 0);
                this.calledIteratorAlready = true;
                return Iterators.forArray((Object[])new Object[]{MultimapPutIterableTester.this.v3()});
            }
        };
        this.multimap().putAll(this.k3(), iterable);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllPropagatesToGet() {
        Collection getCollection = this.multimap().get(this.k0());
        int getCollectionSize = getCollection.size();
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        MultimapPutIterableTester.assertEquals((int)(getCollectionSize + 2), (int)getCollection.size());
        Helpers.assertContainsAllOf(getCollection, this.v3(), this.v4());
    }
}

