/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@GwtCompatible
public class TestLogHandler
extends Handler {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final List<LogRecord> list = new ArrayList<LogRecord>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nullable LogRecord record) {
        Object object = this.lock;
        synchronized (object) {
            if (record != null) {
                this.list.add(record);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogRecord> getStoredLogRecords() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<LogRecord> result = new ArrayList<LogRecord>(this.list);
            return Collections.unmodifiableList(result);
        }
    }
}

