/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class MapReplaceAllTester<K, V>
extends AbstractMapTester<K, V> {
    private SampleElements<K> keys() {
        return new SampleElements(this.k0(), this.k1(), this.k2(), this.k3(), this.k4());
    }

    private SampleElements<V> values() {
        return new SampleElements(this.v0(), this.v1(), this.v2(), this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testReplaceAllRotate() {
        this.getMap().replaceAll((k, v) -> {
            int index = this.keys().asList().indexOf(k);
            return this.values().asList().get(index + 1);
        });
        ArrayList expectedEntries = new ArrayList();
        for (Map.Entry entry : this.getSampleEntries()) {
            int index = this.keys().asList().indexOf(entry.getKey());
            expectedEntries.add(Helpers.mapEntry(entry.getKey(), this.values().asList().get(index + 1)));
        }
        this.expectContents(expectedEntries);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testReplaceAllPreservesOrder() {
        this.getMap().replaceAll((k, v) -> {
            int index = this.keys().asList().indexOf(k);
            return this.values().asList().get(index + 1);
        });
        List orderedEntries = this.getOrderedElements();
        int index = 0;
        for (Object key : this.getMap().keySet()) {
            MapReplaceAllTester.assertEquals(((Map.Entry)orderedEntries.get(index)).getKey(), key);
            ++index;
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceAll_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().replaceAll((k, v) -> {
            int index = this.keys().asList().indexOf(k);
            return this.values().asList().get(index + 1);
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testReplaceAll_unsupportedByEmptyCollection() {
        try {
            this.getMap().replaceAll((k, v) -> {
                int index = this.keys().asList().indexOf(k);
                return this.values().asList().get(index + 1);
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testReplaceAll_unsupportedNoOpFunction() {
        try {
            this.getMap().replaceAll((k, v) -> v);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

