/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.DerivedCollectionGenerators;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapClearTester;
import com.google.common.collect.testing.testers.MapComputeIfAbsentTester;
import com.google.common.collect.testing.testers.MapComputeIfPresentTester;
import com.google.common.collect.testing.testers.MapComputeTester;
import com.google.common.collect.testing.testers.MapContainsKeyTester;
import com.google.common.collect.testing.testers.MapContainsValueTester;
import com.google.common.collect.testing.testers.MapCreationTester;
import com.google.common.collect.testing.testers.MapEntrySetTester;
import com.google.common.collect.testing.testers.MapEqualsTester;
import com.google.common.collect.testing.testers.MapForEachTester;
import com.google.common.collect.testing.testers.MapGetOrDefaultTester;
import com.google.common.collect.testing.testers.MapGetTester;
import com.google.common.collect.testing.testers.MapHashCodeTester;
import com.google.common.collect.testing.testers.MapIsEmptyTester;
import com.google.common.collect.testing.testers.MapMergeTester;
import com.google.common.collect.testing.testers.MapPutAllTester;
import com.google.common.collect.testing.testers.MapPutIfAbsentTester;
import com.google.common.collect.testing.testers.MapPutTester;
import com.google.common.collect.testing.testers.MapRemoveEntryTester;
import com.google.common.collect.testing.testers.MapRemoveTester;
import com.google.common.collect.testing.testers.MapReplaceAllTester;
import com.google.common.collect.testing.testers.MapReplaceEntryTester;
import com.google.common.collect.testing.testers.MapReplaceTester;
import com.google.common.collect.testing.testers.MapSerializationTester;
import com.google.common.collect.testing.testers.MapSizeTester;
import com.google.common.collect.testing.testers.MapToStringTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class MapTestSuiteBuilder<K, V>
extends PerCollectionSizeTestSuiteBuilder<MapTestSuiteBuilder<K, V>, TestMapGenerator<K, V>, Map<K, V>, Map.Entry<K, V>> {
    public static <K, V> MapTestSuiteBuilder<K, V> using(TestMapGenerator<K, V> generator) {
        return (MapTestSuiteBuilder)new MapTestSuiteBuilder<K, V>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        return Arrays.asList(MapClearTester.class, MapComputeTester.class, MapComputeIfAbsentTester.class, MapComputeIfPresentTester.class, MapContainsKeyTester.class, MapContainsValueTester.class, MapCreationTester.class, MapEntrySetTester.class, MapEqualsTester.class, MapForEachTester.class, MapGetTester.class, MapGetOrDefaultTester.class, MapHashCodeTester.class, MapIsEmptyTester.class, MapMergeTester.class, MapPutTester.class, MapPutAllTester.class, MapPutIfAbsentTester.class, MapRemoveTester.class, MapRemoveEntryTester.class, MapReplaceTester.class, MapReplaceAllTester.class, MapReplaceEntryTester.class, MapSerializationTester.class, MapSizeTester.class, MapToStringTester.class);
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new ReserializedMapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeReserializedMapFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " reserialized")).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)this.createDerivedEntrySetSuite(new DerivedCollectionGenerators.MapEntrySetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeEntrySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " entrySet")).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)this.createDerivedKeySetSuite(DerivedCollectionGenerators.keySetGenerator(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeKeySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " keys")).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        derivedSuites.add(((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)this.createDerivedValueCollectionSuite(new DerivedCollectionGenerators.MapValueCollectionGenerator<K, V>(parentBuilder.getSubjectGenerator())).named(parentBuilder.getName() + " values")).withFeatures(MapTestSuiteBuilder.computeValuesCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        return derivedSuites;
    }

    protected SetTestSuiteBuilder<Map.Entry<K, V>> createDerivedEntrySetSuite(TestSetGenerator<Map.Entry<K, V>> entrySetGenerator) {
        return SetTestSuiteBuilder.using(entrySetGenerator);
    }

    protected SetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return SetTestSuiteBuilder.using(keySetGenerator);
    }

    protected CollectionTestSuiteBuilder<V> createDerivedValueCollectionSuite(TestCollectionGenerator<V> valueCollectionGenerator) {
        return CollectionTestSuiteBuilder.using(valueCollectionGenerator);
    }

    private static Set<Feature<?>> computeReserializedMapFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(mapFeatures);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    private static Set<Feature<?>> computeEntrySetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> entrySetFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_ENTRY_QUERIES)) {
            entrySetFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return entrySetFeatures;
    }

    private static Set<Feature<?>> computeKeySetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> keySetFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        keySetFeatures.add(CollectionFeature.SUBSET_VIEW);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_KEYS)) {
            keySetFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        } else if (mapFeatures.contains(MapFeature.ALLOWS_NULL_KEY_QUERIES)) {
            keySetFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return keySetFeatures;
    }

    private static Set<Feature<?>> computeValuesCollectionFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> valuesCollectionFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUE_QUERIES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        return valuesCollectionFeatures;
    }

    public static Set<Feature<?>> computeCommonDerivedCollectionFeatures(Set<Feature<?>> mapFeatures) {
        mapFeatures = new HashSet(mapFeatures);
        HashSet derivedFeatures = new HashSet();
        mapFeatures.remove(CollectionFeature.SERIALIZABLE);
        if (mapFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.add(CollectionFeature.SERIALIZABLE);
        }
        if (mapFeatures.contains(MapFeature.SUPPORTS_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE);
        }
        if (mapFeatures.contains(MapFeature.REJECTS_DUPLICATES_AT_CREATION)) {
            derivedFeatures.add(CollectionFeature.REJECTS_DUPLICATES_AT_CREATION);
        }
        if (mapFeatures.contains(MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION)) {
            derivedFeatures.add(CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION);
        }
        for (CollectionFeature collectionFeature : CollectionFeature.values()) {
            if (!mapFeatures.contains(collectionFeature)) continue;
            derivedFeatures.add(collectionFeature);
        }
        for (Enum enum_ : CollectionSize.values()) {
            if (!mapFeatures.contains(enum_)) continue;
            derivedFeatures.add((Feature<?>)((Object)enum_));
        }
        return derivedFeatures;
    }

    private static final class ReserializedMapGenerator<K, V>
    implements TestMapGenerator<K, V> {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;

        ReserializedMapGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.mapGenerator.samples();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.mapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.mapGenerator.order(insertionOrder);
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return SerializableTester.reserialize((Map)this.mapGenerator.create(elements));
        }

        @Override
        public K[] createKeyArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
        }
    }
}

