/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class CollectionRemoveTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_present() {
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue((String)"remove(present) should return true", (boolean)this.collection.remove(this.e0()));
        CollectionRemoveTester.assertEquals((String)"remove(present) should decrease a collection's size by one.", (int)(initialSize - 1), (int)this.collection.size());
        this.expectMissing(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemovePresentConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            CollectionRemoveTester.assertTrue((boolean)this.collection.remove(this.e0()));
            iterator.next();
        });
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_notPresent() {
        CollectionRemoveTester.assertFalse((String)"remove(notPresent) should return false", (boolean)this.collection.remove(this.e3()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_nullPresent() {
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullElement());
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue((String)"remove(null) should return true", (boolean)this.collection.remove(null));
        CollectionRemoveTester.assertEquals((String)"remove(present) should decrease a collection's size by one.", (int)(initialSize - 1), (int)this.collection.size());
        this.expectMissing(new Object[]{null});
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.collection.remove(this.e0()));
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue((String)"remove(present) should not remove the element", (boolean)this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedNotPresent() {
        try {
            CollectionRemoveTester.assertFalse((String)"remove(notPresent) should return false or throw UnsupportedOperationException", (boolean)this.collection.remove(this.e3()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullNotSupported() {
        try {
            CollectionRemoveTester.assertFalse((String)"remove(null) should return false or throw NullPointerException", (boolean)this.collection.remove(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullAllowed() {
        CollectionRemoveTester.assertFalse((String)"remove(null) should return false", (boolean)this.collection.remove(null));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIteratorRemove_unsupported() {
        Iterator iterator = this.collection.iterator();
        iterator.next();
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, iterator::remove);
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue((boolean)this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_wrongType() {
        try {
            CollectionRemoveTester.assertFalse((boolean)this.collection.remove((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

