/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class ListAddAtIndexTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_supportedPresent() {
        this.getList().add(0, this.e0());
        this.expectAdded(0, this.e0());
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_unsupportedPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getList().add(0, this.e0()));
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_supportedNotPresent() {
        this.getList().add(0, this.e3());
        this.expectAdded(0, this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndexConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            this.getList().add(0, this.e3());
            iterator.next();
        });
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_unsupportedNotPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getList().add(0, this.e3()));
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testAddAtIndex_middle() {
        this.getList().add(this.getNumElements() / 2, this.e3());
        this.expectAdded(this.getNumElements() / 2, this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_end() {
        this.getList().add(this.getNumElements(), this.e3());
        this.expectAdded(this.getNumElements(), this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAtIndex_nullSupported() {
        this.getList().add(0, null);
        this.expectAdded(0, new Object[]{null});
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAtIndex_nullUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getList().add(0, null));
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported add(n, null)");
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_negative() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().add(-1, this.e3()));
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_tooLarge() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().add(this.getNumElements() + 1, this.e3()));
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddNullSupportedMethod() {
        return Helpers.getMethod(ListAddAtIndexTester.class, "testAddAtIndex_nullSupported");
    }
}

