/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;

class BenchmarkHelpers {
    private static final String WHITESPACE_CHARACTERS = "\u00a0\u180e\u202f\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a";
    private static final String ASCII_CHARACTERS;
    private static final String ALL_DIGITS;

    BenchmarkHelpers() {
    }

    static /* synthetic */ String access$000() {
        return ASCII_CHARACTERS;
    }

    static /* synthetic */ String access$100() {
        return ALL_DIGITS;
    }

    static {
        int spaceInAscii = 32;
        int sevenBitAsciiMax = 128;
        StringBuilder sb = new StringBuilder(sevenBitAsciiMax - spaceInAscii);
        for (int ch = spaceInAscii; ch < sevenBitAsciiMax; ++ch) {
            sb.append((char)ch);
        }
        ASCII_CHARACTERS = sb.toString();
        StringBuilder sb2 = new StringBuilder();
        String zeros = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char base : zeros.toCharArray()) {
            for (int offset = 0; offset < 10; ++offset) {
                sb2.append((char)(base + offset));
            }
        }
        ALL_DIGITS = sb2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SampleMatcherConfig {
        WHITESPACE(CharMatcher.WHITESPACE, "\u00a0\u180e\u202f\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a"),
        HASH(CharMatcher.is((char)'#'), "#"),
        ASCII(CharMatcher.ASCII, BenchmarkHelpers.access$000()),
        WESTERN_DIGIT("0123456789"),
        ALL_DIGIT(CharMatcher.DIGIT, BenchmarkHelpers.access$100()),
        OPS_5("+-*/%"),
        HEX_16(CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'F')), "0123456789ABCDEF"),
        HEX_22(CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'F')).or(CharMatcher.inRange((char)'a', (char)'f')), "0123456789ABCDEFabcdef"),
        GERMAN_59(CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc")), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc");

        public final CharMatcher matcher;
        public final String matchingChars;

        private SampleMatcherConfig(String matchingChars) {
            this(CharMatcher.anyOf((CharSequence)matchingChars), matchingChars);
        }

        private SampleMatcherConfig(CharMatcher matcher, String matchingChars) {
            this.matcher = matcher;
            this.matchingChars = matchingChars;
        }
    }
}

