/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class FunctionsTest
extends TestCase {
    public void testIdentity_same() {
        Function identity = Functions.identity();
        FunctionsTest.assertNull((Object)identity.apply(null));
        FunctionsTest.assertSame((Object)"foo", (Object)identity.apply((Object)"foo"));
    }

    public void testIdentity_notSame() {
        Function identity = Functions.identity();
        FunctionsTest.assertNotSame((Object)new Long(135135L), (Object)identity.apply((Object)new Long(135135L)));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testIdentitySerializable() {
        FunctionsTest.checkCanReserializeSingleton(Functions.identity());
    }

    public void testToStringFunction_apply() {
        FunctionsTest.assertEquals((String)"3", (String)((String)Functions.toStringFunction().apply((Object)3)));
        FunctionsTest.assertEquals((String)"hiya", (String)((String)Functions.toStringFunction().apply((Object)"hiya")));
        FunctionsTest.assertEquals((String)"I'm a string", (String)((String)Functions.toStringFunction().apply(new Object(){

            public String toString() {
                return "I'm a string";
            }
        })));
        try {
            Functions.toStringFunction().apply(null);
            FunctionsTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="SerializableTester")
    public void testToStringFunctionSerializable() {
        FunctionsTest.checkCanReserializeSingleton(Functions.toStringFunction());
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Functions.class);
    }

    public void testForMapWithoutDefault() {
        HashMap map = Maps.newHashMap();
        map.put("One", 1);
        map.put("Three", 3);
        map.put("Null", null);
        Function function = Functions.forMap((Map)map);
        FunctionsTest.assertEquals((int)1, (int)((Integer)function.apply((Object)"One")));
        FunctionsTest.assertEquals((int)3, (int)((Integer)function.apply((Object)"Three")));
        FunctionsTest.assertNull((Object)function.apply((Object)"Null"));
        try {
            function.apply((Object)"Two");
            FunctionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new EqualsTester().addEqualityGroup(new Object[]{function, Functions.forMap((Map)map)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, (Object)42)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForMapWithoutDefaultSerializable() {
        FunctionsTest.checkCanReserialize(Functions.forMap((Map)ImmutableMap.of((Object)1, (Object)2)));
    }

    public void testForMapWithDefault() {
        HashMap map = Maps.newHashMap();
        map.put("One", 1);
        map.put("Three", 3);
        map.put("Null", null);
        Function function = Functions.forMap((Map)map, (Object)42);
        FunctionsTest.assertEquals((int)1, (int)((Integer)function.apply((Object)"One")));
        FunctionsTest.assertEquals((int)42, (int)((Integer)function.apply((Object)"Two")));
        FunctionsTest.assertEquals((int)3, (int)((Integer)function.apply((Object)"Three")));
        FunctionsTest.assertNull((Object)function.apply((Object)"Null"));
        new EqualsTester().addEqualityGroup(new Object[]{function, Functions.forMap((Map)map, (Object)42)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, null)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, (Object)43)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForMapWithDefault_includeSerializable() {
        HashMap map = Maps.newHashMap();
        map.put("One", 1);
        map.put("Three", 3);
        Function function = Functions.forMap((Map)map, (Object)42);
        FunctionsTest.assertEquals((int)1, (int)((Integer)function.apply((Object)"One")));
        FunctionsTest.assertEquals((int)42, (int)((Integer)function.apply((Object)"Two")));
        FunctionsTest.assertEquals((int)3, (int)((Integer)function.apply((Object)"Three")));
        new EqualsTester().addEqualityGroup(new Object[]{function, Functions.forMap((Map)map, (Object)42), SerializableTester.reserialize((Object)function)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, null)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, (Object)43)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForMapWithDefaultSerializable() {
        FunctionsTest.checkCanReserialize(Functions.forMap((Map)ImmutableMap.of((Object)1, (Object)2), (Object)3));
    }

    public void testForMapWithDefault_null() {
        ImmutableMap map = ImmutableMap.of((Object)"One", (Object)1);
        Function function = Functions.forMap((Map)map, null);
        FunctionsTest.assertEquals((Object)1, (Object)function.apply((Object)"One"));
        FunctionsTest.assertNull((Object)function.apply((Object)"Two"));
        new EqualsTester().addEqualityGroup(new Object[]{function}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, (Object)1)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForMapWithDefault_null_compareWithSerializable() {
        ImmutableMap map = ImmutableMap.of((Object)"One", (Object)1);
        Function function = Functions.forMap((Map)map, null);
        FunctionsTest.assertEquals((Object)1, (Object)function.apply((Object)"One"));
        FunctionsTest.assertNull((Object)function.apply((Object)"Two"));
        new EqualsTester().addEqualityGroup(new Object[]{function, SerializableTester.reserialize((Object)function)}).addEqualityGroup(new Object[]{Functions.forMap((Map)map, (Object)1)}).testEquals();
    }

    public void testForMapWildCardWithDefault() {
        HashMap map = Maps.newHashMap();
        map.put("One", 1);
        map.put("Three", 3);
        Double number = 42.0;
        Function function = Functions.forMap((Map)map, (Object)number);
        FunctionsTest.assertEquals((int)1, (int)((Number)function.apply((Object)"One")).intValue());
        FunctionsTest.assertEquals((Object)number, (Object)function.apply((Object)"Two"));
        FunctionsTest.assertEquals((long)3L, (long)((Number)function.apply((Object)"Three")).longValue());
    }

    public void testComposition() {
        HashMap mJapaneseToInteger = Maps.newHashMap();
        mJapaneseToInteger.put("Ichi", 1);
        mJapaneseToInteger.put("Ni", 2);
        mJapaneseToInteger.put("San", 3);
        Function japaneseToInteger = Functions.forMap((Map)mJapaneseToInteger);
        HashMap mIntegerToSpanish = Maps.newHashMap();
        mIntegerToSpanish.put(1, "Uno");
        mIntegerToSpanish.put(3, "Tres");
        mIntegerToSpanish.put(4, "Cuatro");
        Function integerToSpanish = Functions.forMap((Map)mIntegerToSpanish);
        Function japaneseToSpanish = Functions.compose((Function)integerToSpanish, (Function)japaneseToInteger);
        FunctionsTest.assertEquals((String)"Uno", (String)((String)japaneseToSpanish.apply((Object)"Ichi")));
        try {
            japaneseToSpanish.apply((Object)"Ni");
            FunctionsTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        FunctionsTest.assertEquals((String)"Tres", (String)((String)japaneseToSpanish.apply((Object)"San")));
        try {
            japaneseToSpanish.apply((Object)"Shi");
            FunctionsTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        new EqualsTester().addEqualityGroup(new Object[]{japaneseToSpanish, Functions.compose((Function)integerToSpanish, (Function)japaneseToInteger)}).addEqualityGroup(new Object[]{japaneseToInteger}).addEqualityGroup(new Object[]{integerToSpanish}).addEqualityGroup(new Object[]{Functions.compose((Function)japaneseToInteger, (Function)integerToSpanish)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testComposition_includeReserializabled() {
        HashMap mJapaneseToInteger = Maps.newHashMap();
        mJapaneseToInteger.put("Ichi", 1);
        mJapaneseToInteger.put("Ni", 2);
        mJapaneseToInteger.put("San", 3);
        Function japaneseToInteger = Functions.forMap((Map)mJapaneseToInteger);
        HashMap mIntegerToSpanish = Maps.newHashMap();
        mIntegerToSpanish.put(1, "Uno");
        mIntegerToSpanish.put(3, "Tres");
        mIntegerToSpanish.put(4, "Cuatro");
        Function integerToSpanish = Functions.forMap((Map)mIntegerToSpanish);
        Function japaneseToSpanish = Functions.compose((Function)integerToSpanish, (Function)japaneseToInteger);
        new EqualsTester().addEqualityGroup(new Object[]{japaneseToSpanish, Functions.compose((Function)integerToSpanish, (Function)japaneseToInteger), SerializableTester.reserialize((Object)japaneseToSpanish)}).addEqualityGroup(new Object[]{japaneseToInteger}).addEqualityGroup(new Object[]{integerToSpanish}).addEqualityGroup(new Object[]{Functions.compose((Function)japaneseToInteger, (Function)integerToSpanish)}).testEquals();
    }

    public void testCompositionWildcard() {
        HashMap mapJapaneseToInteger = Maps.newHashMap();
        Function japaneseToInteger = Functions.forMap((Map)mapJapaneseToInteger);
        Function numberToSpanish = Functions.constant((Object)"Yo no se");
        Function japaneseToSpanish = Functions.compose((Function)numberToSpanish, (Function)japaneseToInteger);
    }

    public void testComposeOfFunctionsIsAssociative() {
        ImmutableMap m = ImmutableMap.of((Object)Float.valueOf(4.0f), (Object)"A", (Object)Float.valueOf(3.0f), (Object)"B", (Object)Float.valueOf(2.0f), (Object)"C", (Object)Float.valueOf(1.0f), (Object)"D");
        Function h = Functions.constant((Object)Boolean.TRUE);
        HashCodeFunction g = new HashCodeFunction();
        Function f = Functions.forMap((Map)m, (Object)"F");
        Function c1 = Functions.compose((Function)Functions.compose((Function)h, (Function)g), (Function)f);
        Function c2 = Functions.compose((Function)h, (Function)Functions.compose((Function)g, (Function)f));
        FunctionsTest.assertEquals((int)c1.hashCode(), (int)c2.hashCode());
        FunctionsTest.assertEquals((Object)c1.apply((Object)Float.valueOf(1.0f)), (Object)c2.apply((Object)Float.valueOf(1.0f)));
        FunctionsTest.assertEquals((Object)c1.apply((Object)Float.valueOf(5.0f)), (Object)c2.apply((Object)Float.valueOf(5.0f)));
    }

    public void testComposeOfPredicateAndFunctionIsAssociative() {
        ImmutableMap m = ImmutableMap.of((Object)Float.valueOf(4.0f), (Object)"A", (Object)Float.valueOf(3.0f), (Object)"B", (Object)Float.valueOf(2.0f), (Object)"C", (Object)Float.valueOf(1.0f), (Object)"D");
        Predicate h = Predicates.equalTo((Object)42);
        HashCodeFunction g = new HashCodeFunction();
        Function f = Functions.forMap((Map)m, (Object)"F");
        Predicate p1 = Predicates.compose((Predicate)Predicates.compose((Predicate)h, (Function)g), (Function)f);
        Predicate p2 = Predicates.compose((Predicate)h, (Function)Functions.compose((Function)g, (Function)f));
        FunctionsTest.assertEquals((int)p1.hashCode(), (int)p2.hashCode());
        FunctionsTest.assertEquals((boolean)p1.apply((Object)Float.valueOf(1.0f)), (boolean)p2.apply((Object)Float.valueOf(1.0f)));
        FunctionsTest.assertEquals((boolean)p1.apply((Object)Float.valueOf(5.0f)), (boolean)p2.apply((Object)Float.valueOf(5.0f)));
    }

    public void testForPredicate() {
        Function alwaysTrue = Functions.forPredicate((Predicate)Predicates.alwaysTrue());
        Function alwaysFalse = Functions.forPredicate((Predicate)Predicates.alwaysFalse());
        FunctionsTest.assertTrue((boolean)((Boolean)alwaysTrue.apply((Object)0)));
        FunctionsTest.assertFalse((boolean)((Boolean)alwaysFalse.apply((Object)0)));
        new EqualsTester().addEqualityGroup(new Object[]{alwaysTrue, Functions.forPredicate((Predicate)Predicates.alwaysTrue())}).addEqualityGroup(new Object[]{alwaysFalse}).addEqualityGroup(new Object[]{Functions.identity()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForPredicateSerializable() {
        FunctionsTest.checkCanReserialize(Functions.forPredicate((Predicate)Predicates.equalTo((Object)5)));
    }

    public void testConstant() {
        Function f = Functions.constant((Object)"correct");
        FunctionsTest.assertEquals((Object)"correct", (Object)f.apply(new Object()));
        FunctionsTest.assertEquals((Object)"correct", (Object)f.apply(null));
        Function g = Functions.constant(null);
        FunctionsTest.assertEquals(null, (String)((String)g.apply((Object)2)));
        FunctionsTest.assertEquals(null, (String)((String)g.apply(null)));
        new EqualsTester().addEqualityGroup(new Object[]{f, Functions.constant((Object)"correct")}).addEqualityGroup(new Object[]{Functions.constant((Object)"incorrect")}).addEqualityGroup(new Object[]{Functions.toStringFunction()}).addEqualityGroup(new Object[]{g}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{g, Functions.constant(null)}).addEqualityGroup(new Object[]{Functions.constant((Object)"incorrect")}).addEqualityGroup(new Object[]{Functions.toStringFunction()}).addEqualityGroup(new Object[]{f}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testConstantSerializable() {
        FunctionsTest.checkCanReserialize(Functions.constant((Object)5));
    }

    public void testForSupplier() {
        CountingSupplier supplier = new CountingSupplier();
        Function function = Functions.forSupplier((Supplier)supplier);
        FunctionsTest.assertEquals((int)1, (int)((Integer)function.apply(null)));
        FunctionsTest.assertEquals((int)2, (int)((Integer)function.apply((Object)"foo")));
        new EqualsTester().addEqualityGroup(new Object[]{function, Functions.forSupplier((Supplier)supplier)}).addEqualityGroup(new Object[]{Functions.forSupplier((Supplier)new CountingSupplier())}).addEqualityGroup(new Object[]{Functions.forSupplier((Supplier)Suppliers.ofInstance((Object)12))}).addEqualityGroup(new Object[]{Functions.toStringFunction()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testForSupplierSerializable() {
        FunctionsTest.checkCanReserialize(Functions.forSupplier((Supplier)new CountingSupplier()));
    }

    @GwtIncompatible(value="reflection")
    public void testNulls() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Functions.class).testNulls();
    }

    @GwtIncompatible(value="reflection")
    public void testEqualsAndSerializable() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Functions.class).testEqualsAndSerializable();
    }

    @GwtIncompatible(value="SerializableTester")
    private static <Y> void checkCanReserialize(Function<? super Integer, Y> f) {
        Function g = (Function)SerializableTester.reserializeAndAssert(f);
        for (int i = 1; i < 5; ++i) {
            Object expected = null;
            try {
                expected = f.apply((Object)i);
            }
            catch (IllegalArgumentException e) {
                try {
                    g.apply((Object)i);
                    FunctionsTest.fail();
                }
                catch (IllegalArgumentException ok) {
                    continue;
                }
            }
            FunctionsTest.assertEquals((Object)expected, (Object)g.apply((Object)i));
        }
    }

    @GwtIncompatible(value="SerializableTester")
    private static <Y> void checkCanReserializeSingleton(Function<? super String, Y> f) {
        Function g = (Function)SerializableTester.reserializeAndAssert(f);
        FunctionsTest.assertSame(f, (Object)g);
        Integer i = 1;
        while (i < 5) {
            FunctionsTest.assertEquals((Object)f.apply((Object)i.toString()), (Object)g.apply((Object)i.toString()));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingSupplier
    implements Supplier<Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private int value;

        private CountingSupplier() {
        }

        public Integer get() {
            return ++this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CountingSupplier) {
                return this.value == ((CountingSupplier)obj).value;
            }
            return false;
        }

        public int hashCode() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashCodeFunction
    implements Function<Object, Integer> {
        private HashCodeFunction() {
        }

        public Integer apply(Object o) {
            return o == null ? 0 : o.hashCode();
        }
    }
}

