/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class PredicatesTest
extends TestCase {
    private static final Predicate<Integer> TRUE = Predicates.alwaysTrue();
    private static final Predicate<Integer> FALSE = Predicates.alwaysFalse();
    private static final Predicate<Integer> NEVER_REACHED = new Predicate<Integer>(){

        public boolean apply(Integer i) {
            throw new AssertionFailedError("This predicate should never have been evaluated");
        }
    };

    private static IsOdd isOdd() {
        return new IsOdd();
    }

    public void testAlwaysTrue_apply() {
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.alwaysTrue());
    }

    public void testAlwaysTrue_equality() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{TRUE, Predicates.alwaysTrue()}).addEqualityGroup(new Object[]{PredicatesTest.isOdd()}).addEqualityGroup(new Object[]{Predicates.alwaysFalse()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAlwaysTrue_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.alwaysTrue());
    }

    public void testAlwaysFalse_apply() throws Exception {
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.alwaysFalse());
    }

    public void testAlwaysFalse_equality() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{FALSE, Predicates.alwaysFalse()}).addEqualityGroup(new Object[]{PredicatesTest.isOdd()}).addEqualityGroup(new Object[]{Predicates.alwaysTrue()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAlwaysFalse_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.alwaysFalse());
    }

    public void testNot_apply() {
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.not(FALSE));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.not(TRUE));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.not((Predicate)Predicates.not((Predicate)PredicatesTest.isOdd())));
    }

    public void testNot_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.not((Predicate)PredicatesTest.isOdd()), Predicates.not((Predicate)PredicatesTest.isOdd())}).addEqualityGroup(new Object[]{Predicates.not(TRUE)}).addEqualityGroup(new Object[]{PredicatesTest.isOdd()}).testEquals();
    }

    public void testNot_equalityForNotOfKnownValues() {
        new EqualsTester().addEqualityGroup(new Object[]{TRUE, Predicates.alwaysTrue()}).addEqualityGroup(new Object[]{FALSE}).addEqualityGroup(new Object[]{Predicates.not(TRUE)}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{FALSE, Predicates.alwaysFalse()}).addEqualityGroup(new Object[]{TRUE}).addEqualityGroup(new Object[]{Predicates.not(FALSE)}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.isNull(), Predicates.isNull()}).addEqualityGroup(new Object[]{Predicates.notNull()}).addEqualityGroup(new Object[]{Predicates.not((Predicate)Predicates.isNull())}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.notNull(), Predicates.notNull()}).addEqualityGroup(new Object[]{Predicates.isNull()}).addEqualityGroup(new Object[]{Predicates.not((Predicate)Predicates.notNull())}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testNot_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.not((Predicate)PredicatesTest.isOdd()));
    }

    public void testAnd_applyNoArgs() {
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[0]));
    }

    public void testAnd_equalityNoArgs() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[0]), Predicates.and((Predicate[])new Predicate[0])}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{FALSE})}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[0])}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAnd_serializationNoArgs() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[0]));
    }

    public void testAnd_applyOneArg() {
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{PredicatesTest.isOdd()}));
    }

    public void testAnd_equalityOneArg() {
        Object[] notEqualObjects = new Object[]{Predicates.and(NEVER_REACHED, FALSE)};
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{NEVER_REACHED}), Predicates.and((Predicate[])new Predicate[]{NEVER_REACHED})}).addEqualityGroup(notEqualObjects).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{PredicatesTest.isOdd()})}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[0])}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{NEVER_REACHED})}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAnd_serializationOneArg() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{PredicatesTest.isOdd()}));
    }

    public void testAnd_applyBinary() {
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and((Predicate)PredicatesTest.isOdd(), TRUE));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and(TRUE, (Predicate)PredicatesTest.isOdd()));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.and(FALSE, NEVER_REACHED));
    }

    public void testAnd_equalityBinary() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.and(TRUE, NEVER_REACHED), Predicates.and(TRUE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.and(NEVER_REACHED, TRUE)}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.or(TRUE, NEVER_REACHED)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAnd_serializationBinary() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.and(TRUE, (Predicate)PredicatesTest.isOdd()));
    }

    public void testAnd_applyTernary() {
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{PredicatesTest.isOdd(), TRUE, TRUE}));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{TRUE, PredicatesTest.isOdd(), TRUE}));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{TRUE, TRUE, PredicatesTest.isOdd()}));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{TRUE, FALSE, NEVER_REACHED}));
    }

    public void testAnd_equalityTernary() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{TRUE, PredicatesTest.isOdd(), NEVER_REACHED}), Predicates.and((Predicate[])new Predicate[]{TRUE, PredicatesTest.isOdd(), NEVER_REACHED})}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{PredicatesTest.isOdd(), NEVER_REACHED, TRUE})}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE, PredicatesTest.isOdd(), NEVER_REACHED})}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAnd_serializationTernary() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.and((Predicate[])new Predicate[]{TRUE, PredicatesTest.isOdd(), FALSE}));
    }

    public void testAnd_applyIterable() {
        List<Object> empty = Arrays.asList(new Object[0]);
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.and(empty));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and(Arrays.asList(PredicatesTest.isOdd())));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.and(Arrays.asList(TRUE, PredicatesTest.isOdd())));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.and(Arrays.asList(FALSE, NEVER_REACHED)));
    }

    public void testAnd_equalityIterable() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.and(Arrays.asList(TRUE, NEVER_REACHED)), Predicates.and(Arrays.asList(TRUE, NEVER_REACHED)), Predicates.and(TRUE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.and(FALSE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.or(TRUE, NEVER_REACHED)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAnd_serializationIterable() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.and(Arrays.asList(TRUE, FALSE)));
    }

    public void testAnd_arrayDefensivelyCopied() {
        Predicate[] array = new Predicate[]{Predicates.alwaysFalse()};
        Predicate predicate = Predicates.and((Predicate[])array);
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
        array[0] = Predicates.alwaysTrue();
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
    }

    public void testAnd_listDefensivelyCopied() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.and((Iterable)list);
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)1));
        list.add(Predicates.alwaysFalse());
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)1));
    }

    public void testAnd_iterableDefensivelyCopied() {
        final ArrayList list = Lists.newArrayList();
        Iterable<Predicate<Object>> iterable = new Iterable<Predicate<Object>>(){

            @Override
            public Iterator<Predicate<Object>> iterator() {
                return list.iterator();
            }
        };
        Predicate predicate = Predicates.and((Iterable)iterable);
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)1));
        list.add(Predicates.alwaysFalse());
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)1));
    }

    public void testOr_applyNoArgs() {
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[0]));
    }

    public void testOr_equalityNoArgs() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[0]), Predicates.or((Predicate[])new Predicate[0])}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[0])}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testOr_serializationNoArgs() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[0]));
    }

    public void testOr_applyOneArg() {
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{TRUE}));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{FALSE}));
    }

    public void testOr_equalityOneArg() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{NEVER_REACHED}), Predicates.or((Predicate[])new Predicate[]{NEVER_REACHED})}).addEqualityGroup(new Object[]{Predicates.or(NEVER_REACHED, TRUE)}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[0])}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{NEVER_REACHED})}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testOr_serializationOneArg() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{PredicatesTest.isOdd()}));
    }

    public void testOr_applyBinary() {
        Predicate falseOrFalse = Predicates.or(FALSE, FALSE);
        Predicate falseOrTrue = Predicates.or(FALSE, TRUE);
        Predicate trueOrAnything = Predicates.or(TRUE, NEVER_REACHED);
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)falseOrFalse);
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)falseOrTrue);
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)trueOrAnything);
    }

    public void testOr_equalityBinary() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.or(FALSE, NEVER_REACHED), Predicates.or(FALSE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.or(NEVER_REACHED, FALSE)}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.and(FALSE, NEVER_REACHED)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testOr_serializationBinary() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.or((Predicate)PredicatesTest.isOdd(), TRUE));
    }

    public void testOr_applyTernary() {
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{PredicatesTest.isOdd(), FALSE, FALSE}));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{FALSE, PredicatesTest.isOdd(), FALSE}));
        PredicatesTest.assertEvalsLikeOdd((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{FALSE, FALSE, PredicatesTest.isOdd()}));
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{FALSE, TRUE, NEVER_REACHED}));
    }

    public void testOr_equalityTernary() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{FALSE, NEVER_REACHED, TRUE}), Predicates.or((Predicate[])new Predicate[]{FALSE, NEVER_REACHED, TRUE})}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE, NEVER_REACHED, FALSE})}).addEqualityGroup(new Object[]{Predicates.or((Predicate[])new Predicate[]{TRUE})}).addEqualityGroup(new Object[]{Predicates.and((Predicate[])new Predicate[]{FALSE, NEVER_REACHED, TRUE})}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testOr_serializationTernary() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.or((Predicate[])new Predicate[]{FALSE, PredicatesTest.isOdd(), TRUE}));
    }

    public void testOr_applyIterable() {
        Predicate vacuouslyFalse = Predicates.or(Collections.emptyList());
        Predicate troo = Predicates.or(Collections.singletonList(TRUE));
        Predicate trueAndFalse = Predicates.or(Arrays.asList(TRUE, FALSE));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)vacuouslyFalse);
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)troo);
        PredicatesTest.assertEvalsToTrue((Predicate<? super Integer>)trueAndFalse);
    }

    public void testOr_equalityIterable() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.or(Arrays.asList(FALSE, NEVER_REACHED)), Predicates.or(Arrays.asList(FALSE, NEVER_REACHED)), Predicates.or(FALSE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.or(TRUE, NEVER_REACHED)}).addEqualityGroup(new Object[]{Predicates.and(FALSE, NEVER_REACHED)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testOr_serializationIterable() {
        Predicate pre = Predicates.or(Arrays.asList(TRUE, FALSE));
        Predicate post = (Predicate)SerializableTester.reserializeAndAssert((Object)pre);
        PredicatesTest.assertEquals((boolean)pre.apply((Object)0), (boolean)post.apply((Object)0));
    }

    public void testOr_arrayDefensivelyCopied() {
        Predicate[] array = new Predicate[]{Predicates.alwaysFalse()};
        Predicate predicate = Predicates.or((Predicate[])array);
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
        array[0] = Predicates.alwaysTrue();
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
    }

    public void testOr_listDefensivelyCopied() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.or((Iterable)list);
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
        list.add(Predicates.alwaysTrue());
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
    }

    public void testOr_iterableDefensivelyCopied() {
        final ArrayList list = Lists.newArrayList();
        Iterable<Predicate<Object>> iterable = new Iterable<Predicate<Object>>(){

            @Override
            public Iterator<Predicate<Object>> iterator() {
                return list.iterator();
            }
        };
        Predicate predicate = Predicates.or((Iterable)iterable);
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
        list.add(Predicates.alwaysTrue());
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
    }

    public void testIsEqualTo_apply() {
        Predicate isOne = Predicates.equalTo((Object)1);
        PredicatesTest.assertTrue((boolean)isOne.apply((Object)1));
        PredicatesTest.assertFalse((boolean)isOne.apply((Object)2));
        PredicatesTest.assertFalse((boolean)isOne.apply(null));
    }

    public void testIsEqualTo_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.equalTo((Object)1), Predicates.equalTo((Object)1)}).addEqualityGroup(new Object[]{Predicates.equalTo((Object)2)}).addEqualityGroup(new Object[]{Predicates.equalTo(null)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testIsEqualTo_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.equalTo((Object)1));
    }

    public void testIsEqualToNull_apply() {
        Predicate isNull = Predicates.equalTo(null);
        PredicatesTest.assertTrue((boolean)isNull.apply(null));
        PredicatesTest.assertFalse((boolean)isNull.apply((Object)1));
    }

    public void testIsEqualToNull_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.equalTo(null), Predicates.equalTo(null)}).addEqualityGroup(new Object[]{Predicates.equalTo((Object)1)}).addEqualityGroup(new Object[]{Predicates.equalTo((Object)"null")}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testIsEqualToNull_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.equalTo(null));
    }

    @GwtIncompatible(value="Predicates.instanceOf")
    public void testIsInstanceOf_apply() {
        Predicate isInteger = Predicates.instanceOf(Integer.class);
        PredicatesTest.assertTrue((boolean)isInteger.apply((Object)1));
        PredicatesTest.assertFalse((boolean)isInteger.apply((Object)Float.valueOf(2.0f)));
        PredicatesTest.assertFalse((boolean)isInteger.apply((Object)""));
        PredicatesTest.assertFalse((boolean)isInteger.apply(null));
    }

    @GwtIncompatible(value="Predicates.instanceOf")
    public void testIsInstanceOf_subclass() {
        Predicate isNumber = Predicates.instanceOf(Number.class);
        PredicatesTest.assertTrue((boolean)isNumber.apply((Object)1));
        PredicatesTest.assertTrue((boolean)isNumber.apply((Object)Float.valueOf(2.0f)));
        PredicatesTest.assertFalse((boolean)isNumber.apply((Object)""));
        PredicatesTest.assertFalse((boolean)isNumber.apply(null));
    }

    @GwtIncompatible(value="Predicates.instanceOf")
    public void testIsInstanceOf_interface() {
        Predicate isComparable = Predicates.instanceOf(Comparable.class);
        PredicatesTest.assertTrue((boolean)isComparable.apply((Object)1));
        PredicatesTest.assertTrue((boolean)isComparable.apply((Object)Float.valueOf(2.0f)));
        PredicatesTest.assertTrue((boolean)isComparable.apply((Object)""));
        PredicatesTest.assertFalse((boolean)isComparable.apply(null));
    }

    @GwtIncompatible(value="Predicates.instanceOf")
    public void testIsInstanceOf_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.instanceOf(Integer.class), Predicates.instanceOf(Integer.class)}).addEqualityGroup(new Object[]{Predicates.instanceOf(Number.class)}).addEqualityGroup(new Object[]{Predicates.instanceOf(Float.class)}).testEquals();
    }

    @GwtIncompatible(value="Predicates.instanceOf, SerializableTester")
    public void testIsInstanceOf_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.instanceOf(Integer.class));
    }

    @GwtIncompatible(value="Predicates.assignableFrom")
    public void testIsAssignableFrom_apply() {
        Predicate isInteger = Predicates.assignableFrom(Integer.class);
        PredicatesTest.assertTrue((boolean)isInteger.apply(Integer.class));
        PredicatesTest.assertFalse((boolean)isInteger.apply(Float.class));
        try {
            isInteger.apply(null);
            PredicatesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Predicates.assignableFrom")
    public void testIsAssignableFrom_subclass() {
        Predicate isNumber = Predicates.assignableFrom(Number.class);
        PredicatesTest.assertTrue((boolean)isNumber.apply(Integer.class));
        PredicatesTest.assertTrue((boolean)isNumber.apply(Float.class));
    }

    @GwtIncompatible(value="Predicates.assignableFrom")
    public void testIsAssignableFrom_interface() {
        Predicate isComparable = Predicates.assignableFrom(Comparable.class);
        PredicatesTest.assertTrue((boolean)isComparable.apply(Integer.class));
        PredicatesTest.assertTrue((boolean)isComparable.apply(Float.class));
    }

    @GwtIncompatible(value="Predicates.assignableFrom")
    public void testIsAssignableFrom_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.assignableFrom(Integer.class), Predicates.assignableFrom(Integer.class)}).addEqualityGroup(new Object[]{Predicates.assignableFrom(Number.class)}).addEqualityGroup(new Object[]{Predicates.assignableFrom(Float.class)}).testEquals();
    }

    @GwtIncompatible(value="Predicates.assignableFrom, SerializableTester")
    public void testIsAssignableFrom_serialization() {
        Predicate predicate = Predicates.assignableFrom(Integer.class);
        Predicate reserialized = (Predicate)SerializableTester.reserializeAndAssert((Object)predicate);
        PredicatesTest.assertEvalsLike(predicate, reserialized, Integer.class);
        PredicatesTest.assertEvalsLike(predicate, reserialized, Float.class);
        PredicatesTest.assertEvalsLike(predicate, reserialized, null);
    }

    public void testIsNull_apply() {
        Predicate isNull = Predicates.isNull();
        PredicatesTest.assertTrue((boolean)isNull.apply(null));
        PredicatesTest.assertFalse((boolean)isNull.apply((Object)1));
    }

    public void testIsNull_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.isNull(), Predicates.isNull()}).addEqualityGroup(new Object[]{Predicates.notNull()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testIsNull_serialization() {
        Predicate pre = Predicates.isNull();
        Predicate post = (Predicate)SerializableTester.reserializeAndAssert((Object)pre);
        PredicatesTest.assertEquals((boolean)pre.apply((Object)"foo"), (boolean)post.apply((Object)"foo"));
        PredicatesTest.assertEquals((boolean)pre.apply(null), (boolean)post.apply(null));
    }

    public void testNotNull_apply() {
        Predicate notNull = Predicates.notNull();
        PredicatesTest.assertFalse((boolean)notNull.apply(null));
        PredicatesTest.assertTrue((boolean)notNull.apply((Object)1));
    }

    public void testNotNull_equality() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.notNull(), Predicates.notNull()}).addEqualityGroup(new Object[]{Predicates.isNull()}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testNotNull_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.notNull());
    }

    public void testIn_apply() {
        List<Integer> nums = Arrays.asList(1, 5);
        Predicate isOneOrFive = Predicates.in(nums);
        PredicatesTest.assertTrue((boolean)isOneOrFive.apply((Object)1));
        PredicatesTest.assertTrue((boolean)isOneOrFive.apply((Object)5));
        PredicatesTest.assertFalse((boolean)isOneOrFive.apply((Object)3));
        PredicatesTest.assertFalse((boolean)isOneOrFive.apply(null));
    }

    public void testIn_equality() {
        ImmutableSet nums = ImmutableSet.of((Object)1, (Object)5);
        ImmutableSet sameOrder = ImmutableSet.of((Object)1, (Object)5);
        ImmutableSet differentOrder = ImmutableSet.of((Object)5, (Object)1);
        ImmutableSet differentNums = ImmutableSet.of((Object)1, (Object)3, (Object)5);
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.in((Collection)nums), Predicates.in((Collection)nums), Predicates.in((Collection)sameOrder), Predicates.in((Collection)differentOrder)}).addEqualityGroup(new Object[]{Predicates.in((Collection)differentNums)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testIn_serialization() {
        PredicatesTest.checkSerialization((Predicate<? super Integer>)Predicates.in(Arrays.asList(1, 2, 3, null)));
    }

    public void testIn_handlesNullPointerException() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CollectionThatThrowsNPE<T>
        extends ArrayList<T> {
            private static final long serialVersionUID = 1L;

            CollectionThatThrowsNPE() {
            }

            @Override
            public boolean contains(Object element) {
                Preconditions.checkNotNull((Object)element);
                return super.contains(element);
            }
        }
        CollectionThatThrowsNPE nums = new CollectionThatThrowsNPE();
        Predicate isFalse = Predicates.in(nums);
        PredicatesTest.assertFalse((boolean)isFalse.apply(null));
    }

    public void testIn_handlesClassCastException() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CollectionThatThrowsCCE<T>
        extends ArrayList<T> {
            private static final long serialVersionUID = 1L;

            CollectionThatThrowsCCE() {
            }

            @Override
            public boolean contains(Object element) {
                throw new ClassCastException("");
            }
        }
        CollectionThatThrowsCCE nums = new CollectionThatThrowsCCE();
        nums.add(3);
        Predicate isThree = Predicates.in(nums);
        PredicatesTest.assertFalse((boolean)isThree.apply((Object)3));
    }

    public void testIn_compilesWithExplicitSupertype() {
        ImmutableSet nums = ImmutableSet.of();
        Predicate p1 = Predicates.in((Collection)nums);
        Predicate p2 = Predicates.in((Collection)nums);
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Predicates.class);
    }

    @GwtIncompatible(value="SerializbleTester")
    public void testCascadingSerialization() throws Exception {
        Predicate nasty = Predicates.not((Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.or((Predicate[])new Predicate[]{Predicates.equalTo((Object)1), Predicates.equalTo(null), Predicates.alwaysFalse(), Predicates.alwaysTrue(), Predicates.isNull(), Predicates.notNull(), Predicates.in(Arrays.asList(1))})}));
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)nasty);
        Predicate stillNasty = (Predicate)SerializableTester.reserializeAndAssert((Object)nasty);
        PredicatesTest.assertEvalsToFalse((Predicate<? super Integer>)stillNasty);
    }

    public void testCompose() {
        TrimStringFunction trim = TrimStringFunction.INSTANCE;
        Predicate equalsFoo = Predicates.equalTo((Object)"Foo");
        Predicate equalsBar = Predicates.equalTo((Object)"Bar");
        Predicate trimEqualsFoo = Predicates.compose((Predicate)equalsFoo, (Function)trim);
        Function identity = Functions.identity();
        PredicatesTest.assertTrue((boolean)trimEqualsFoo.apply((Object)"Foo"));
        PredicatesTest.assertTrue((boolean)trimEqualsFoo.apply((Object)"   Foo   "));
        PredicatesTest.assertFalse((boolean)trimEqualsFoo.apply((Object)"Foo-b-que"));
        new EqualsTester().addEqualityGroup(new Object[]{trimEqualsFoo, Predicates.compose((Predicate)equalsFoo, (Function)trim)}).addEqualityGroup(new Object[]{equalsFoo}).addEqualityGroup(new Object[]{trim}).addEqualityGroup(new Object[]{Predicates.compose((Predicate)equalsFoo, (Function)identity)}).addEqualityGroup(new Object[]{Predicates.compose((Predicate)equalsBar, (Function)trim)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testComposeSerialization() {
        TrimStringFunction trim = TrimStringFunction.INSTANCE;
        Predicate equalsFoo = Predicates.equalTo((Object)"Foo");
        Predicate trimEqualsFoo = Predicates.compose((Predicate)equalsFoo, (Function)trim);
        SerializableTester.reserializeAndAssert((Object)trimEqualsFoo);
    }

    @GwtIncompatible(value="Predicates.containsPattern")
    public void testContainsPattern_apply() {
        Predicate isFoobar = Predicates.containsPattern((String)"^Fo.*o.*bar$");
        PredicatesTest.assertTrue((boolean)isFoobar.apply((Object)"Foxyzoabcbar"));
        PredicatesTest.assertFalse((boolean)isFoobar.apply((Object)"Foobarx"));
    }

    @GwtIncompatible(value="Predicates.containsPattern")
    public void testContains_apply() {
        Predicate isFoobar = Predicates.contains((Pattern)Pattern.compile("^Fo.*o.*bar$"));
        PredicatesTest.assertTrue((boolean)isFoobar.apply((Object)"Foxyzoabcbar"));
        PredicatesTest.assertFalse((boolean)isFoobar.apply((Object)"Foobarx"));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testContainsPattern_nulls() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        Predicate isWooString = Predicates.containsPattern((String)"Woo");
        tester.testAllPublicInstanceMethods((Object)isWooString);
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testContains_nulls() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        Predicate isWooPattern = Predicates.contains((Pattern)Pattern.compile("Woo"));
        tester.testAllPublicInstanceMethods((Object)isWooPattern);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testContainsPattern_serialization() {
        Predicate pre = Predicates.containsPattern((String)"foo");
        Predicate post = (Predicate)SerializableTester.reserializeAndAssert((Object)pre);
        PredicatesTest.assertEquals((boolean)pre.apply((Object)"foo"), (boolean)post.apply((Object)"foo"));
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testContains_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Predicates.contains((Pattern)Pattern.compile("foo")), Predicates.containsPattern((String)"foo")}).addEqualityGroup(new Object[]{Predicates.contains((Pattern)Pattern.compile("foo", 2))}).addEqualityGroup(new Object[]{Predicates.containsPattern((String)"bar")}).testEquals();
    }

    public void assertEqualHashCode(Predicate<? super Integer> expected, Predicate<? super Integer> actual) {
        PredicatesTest.assertEquals((String)(actual + " should hash like " + expected), (int)expected.hashCode(), (int)actual.hashCode());
    }

    public void testHashCodeForBooleanOperations() {
        Predicate p1 = Predicates.isNull();
        IsOdd p2 = PredicatesTest.isOdd();
        this.assertEqualHashCode((Predicate<? super Integer>)Predicates.not((Predicate)p1), (Predicate<? super Integer>)Predicates.not((Predicate)p1));
        this.assertEqualHashCode((Predicate<? super Integer>)Predicates.and((Predicate)p1, (Predicate)p2), (Predicate<? super Integer>)Predicates.and((Predicate)p1, (Predicate)p2));
        this.assertEqualHashCode((Predicate<? super Integer>)Predicates.or((Predicate)p1, (Predicate)p2), (Predicate<? super Integer>)Predicates.or((Predicate)p1, (Predicate)p2));
        PredicatesTest.assertTrue((Predicates.and((Predicate)p1, (Predicate)p2).hashCode() != Predicates.or((Predicate)p1, (Predicate)p2).hashCode() ? 1 : 0) != 0);
    }

    @GwtIncompatible(value="reflection")
    public void testNulls() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Predicates.class).testNulls();
    }

    @GwtIncompatible(value="reflection")
    public void testEqualsAndSerializable() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Predicates.class).testEqualsAndSerializable();
    }

    private static void assertEvalsToTrue(Predicate<? super Integer> predicate) {
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)0));
        PredicatesTest.assertTrue((boolean)predicate.apply((Object)1));
        PredicatesTest.assertTrue((boolean)predicate.apply(null));
    }

    private static void assertEvalsToFalse(Predicate<? super Integer> predicate) {
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)0));
        PredicatesTest.assertFalse((boolean)predicate.apply((Object)1));
        PredicatesTest.assertFalse((boolean)predicate.apply(null));
    }

    private static void assertEvalsLikeOdd(Predicate<? super Integer> predicate) {
        PredicatesTest.assertEvalsLike(PredicatesTest.isOdd(), predicate);
    }

    private static void assertEvalsLike(Predicate<? super Integer> expected, Predicate<? super Integer> actual) {
        PredicatesTest.assertEvalsLike(expected, actual, 0);
        PredicatesTest.assertEvalsLike(expected, actual, 1);
        PredicatesTest.assertEvalsLike(expected, actual, null);
    }

    private static <T> void assertEvalsLike(Predicate<? super T> expected, Predicate<? super T> actual, T input) {
        Boolean expectedResult = null;
        RuntimeException expectedRuntimeException = null;
        try {
            expectedResult = expected.apply(input);
        }
        catch (RuntimeException e) {
            expectedRuntimeException = e;
        }
        Boolean actualResult = null;
        RuntimeException actualRuntimeException = null;
        try {
            actualResult = actual.apply(input);
        }
        catch (RuntimeException e) {
            actualRuntimeException = e;
        }
        PredicatesTest.assertEquals((Object)expectedResult, (Object)actualResult);
        if (expectedRuntimeException != null) {
            PredicatesTest.assertNotNull((Object)actualRuntimeException);
            PredicatesTest.assertEquals(expectedRuntimeException.getClass(), actualRuntimeException.getClass());
        }
    }

    @GwtIncompatible(value="SerializableTester")
    private static void checkSerialization(Predicate<? super Integer> predicate) {
        Predicate reserialized = (Predicate)SerializableTester.reserializeAndAssert(predicate);
        PredicatesTest.assertEvalsLike(predicate, (Predicate<? super Integer>)reserialized);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TrimStringFunction implements Function<String, String>
    {
        INSTANCE;


        public String apply(String string) {
            return CharMatcher.WHITESPACE.trimFrom((CharSequence)string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsOdd
    implements Predicate<Integer>,
    Serializable {
        private static final long serialVersionUID = 86237L;

        IsOdd() {
        }

        public boolean apply(Integer i) {
            return (i & 1) == 1;
        }

        public int hashCode() {
            return 86237;
        }

        public boolean equals(Object obj) {
            return obj instanceof IsOdd;
        }

        public String toString() {
            return "IsOdd";
        }
    }
}

