/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class VerifyTest
extends TestCase {
    private static final String NON_NULL_STRING = "foo";
    private static final Object IGNORE_ME = new Object(){

        public String toString() {
            throw new AssertionFailedError();
        }
    };
    private static final String FORMAT = "I ate %s pies.";

    public void testVerify_simple_success() {
        Verify.verify((boolean)true);
    }

    public void testVerify_simple_failure() {
        try {
            Verify.verify((boolean)false);
            VerifyTest.fail();
        }
        catch (VerifyException verifyException) {
            // empty catch block
        }
    }

    public void testVerify_simpleMessage_success() {
        Verify.verify((boolean)true, (String)"message", (Object[])new Object[0]);
    }

    public void testVerify_simpleMessage_failure() {
        try {
            Verify.verify((boolean)false, (String)"message", (Object[])new Object[0]);
            VerifyTest.fail();
        }
        catch (VerifyException expected) {
            VerifyTest.assertEquals((String)"message", (String)expected.getMessage());
        }
    }

    public void testVerify_complexMessage_success() {
        Verify.verify((boolean)true, (String)"%s", (Object[])new Object[]{IGNORE_ME});
    }

    public void testVerify_complexMessage_failure() {
        try {
            Verify.verify((boolean)false, (String)FORMAT, (Object[])new Object[]{5});
            VerifyTest.fail();
        }
        catch (VerifyException expected) {
            VerifyTest.checkMessage((Exception)((Object)expected));
        }
    }

    public void testVerifyNotNull_simple_success() {
        String result = (String)Verify.verifyNotNull((Object)NON_NULL_STRING);
        VerifyTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testVerifyNotNull_simple_failure() {
        try {
            Verify.verifyNotNull(null);
            VerifyTest.fail();
        }
        catch (VerifyException verifyException) {
            // empty catch block
        }
    }

    public void testVerifyNotNull_complexMessage_success() {
        String result = (String)Verify.verifyNotNull((Object)NON_NULL_STRING, (String)"%s", (Object[])new Object[]{IGNORE_ME});
        VerifyTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testVerifyNotNull_simpleMessage_failure() {
        try {
            Verify.verifyNotNull(null, (String)FORMAT, (Object[])new Object[]{5});
            VerifyTest.fail();
        }
        catch (VerifyException expected) {
            VerifyTest.checkMessage((Exception)((Object)expected));
        }
    }

    private static void checkMessage(Exception e) {
        VerifyTest.assertEquals((String)"I ate 5 pies.", (String)e.getMessage());
    }
}

