/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.cache.TestingWeighers;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheEvictionTest
extends TestCase {
    static final int MAX_SIZE = 100;

    public void testEviction_setMaxSegmentSize() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        for (int i = 1; i < 1000; ++i) {
            LoadingCache cache = CacheBuilder.newBuilder().maximumSize((long)i).build(loader);
            CacheEvictionTest.assertEquals((int)i, (int)CacheTesting.getTotalSegmentSize(cache));
        }
    }

    public void testEviction_setMaxSegmentWeight() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        for (int i = 1; i < 1000; ++i) {
            LoadingCache cache = CacheBuilder.newBuilder().maximumWeight((long)i).weigher(TestingWeighers.constantWeigher(1)).build(loader);
            CacheEvictionTest.assertEquals((int)i, (int)CacheTesting.getTotalSegmentSize(cache));
        }
    }

    public void testEviction_maxSizeOneSegment() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(100L).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertEquals((long)Math.min(i + 1, 100), (long)cache.size());
        }
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeightOneSegment() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(200L).weigher(TestingWeighers.constantWeigher(2)).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertEquals((long)Math.min(i + 1, 100), (long)cache.size());
        }
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxSize() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).removalListener(removalListener).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertTrue((cache.size() <= 100L ? 1 : 0) != 0);
        }
        CacheEvictionTest.assertEquals((int)100, (int)CacheTesting.accessQueueSize(cache));
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.processPendingNotifications(cache);
        CacheEvictionTest.assertEquals((int)100, (int)removalListener.getCount());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeight() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().maximumWeight(200L).weigher(TestingWeighers.constantWeigher(2)).removalListener(removalListener).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertTrue((cache.size() <= 100L ? 1 : 0) != 0);
        }
        CacheEvictionTest.assertEquals((int)100, (int)CacheTesting.accessQueueSize(cache));
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.processPendingNotifications(cache);
        CacheEvictionTest.assertEquals((int)100, (int)removalListener.getCount());
        CacheTesting.checkValidState(cache);
    }

    public void testUpdateRecency_onGet() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        final LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).build(loader);
        CacheTesting.checkRecency((LoadingCache<Integer, Integer>)cache, 100, new CacheTesting.Receiver<LocalCache.ReferenceEntry<Integer, Integer>>(){

            @Override
            public void accept(LocalCache.ReferenceEntry<Integer, Integer> entry) {
                cache.getUnchecked(entry.getKey());
            }
        });
    }

    public void testUpdateRecency_onInvalidate() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        final LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).concurrencyLevel(1).build(loader);
        CacheTesting.checkRecency((LoadingCache<Integer, Integer>)cache, 100, new CacheTesting.Receiver<LocalCache.ReferenceEntry<Integer, Integer>>(){

            @Override
            public void accept(LocalCache.ReferenceEntry<Integer, Integer> entry) {
                Integer key = (Integer)entry.getKey();
                cache.invalidate((Object)key);
            }
        });
    }

    public void testEviction_lru() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(10L).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)3, (Object)4, (Object[])new Integer[]{5, 6, 7, 8, 9, 0, 1, 2});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(10, 11, 12));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)7, (Object[])new Integer[]{8, 9, 0, 1, 2, 10, 11, 12});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(6, 7, 8));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)9, (Object)0, (Object[])new Integer[]{1, 2, 10, 11, 12, 6, 7, 8});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(13, 14, 15));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)2, (Object)10, (Object[])new Integer[]{11, 12, 6, 7, 8, 13, 14, 15});
    }

    public void testEviction_weightedLru() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(45L).weigher(TestingWeighers.intKeyWeigher()).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)3, (Object)4, (Object[])new Integer[]{5, 6, 7, 8, 9, 0, 1, 2});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(10));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)7, (Object[])new Integer[]{8, 9, 0, 1, 2, 10});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(6, 7, 8));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)9, (Object)0, (Object[])new Integer[]{1, 2, 10, 6, 7, 8});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(15));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)6, (Object[])new Integer[]{7, 8, 15});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(9));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)6, (Object[])new Integer[]{7, 8, 15, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(1));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)7, (Object[])new Integer[]{8, 15, 9, 1});
    }

    public void testEviction_overweight() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(45L).weigher(TestingWeighers.intKeyWeigher()).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(45));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)45, (Object[])new Integer[0]);
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(46));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().item((Object)0);
    }

    public void testEviction_invalidateAll() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(10L).build(loader);
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).isEmpty();
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2, 3, 4));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4});
        cache.invalidateAll();
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).isEmpty();
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)5, (Object)6, (Object[])new Integer[]{7, 8, 9, 10, 11, 12});
    }

    private void getAll(LoadingCache<Integer, Integer> cache, List<Integer> keys) {
        for (int i : keys) {
            cache.getUnchecked((Object)i);
        }
    }
}

