/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.collect.Iterators;
import com.google.common.testing.FakeTicker;
import com.google.common.util.concurrent.Callables;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheExpirationTest
extends TestCase {
    private static final long EXPIRING_TIME = 1000L;
    private static final int VALUE_PREFIX = 12345;
    private static final String KEY_PREFIX = "key prefix:";

    public void testExpiration_expireAfterWrite() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.checkExpiration((LoadingCache<String, Integer>)cache, loader, ticker, removalListener);
    }

    public void testExpiration_expireAfterAccess() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.checkExpiration((LoadingCache<String, Integer>)cache, loader, ticker, removalListener);
    }

    private void checkExpiration(LoadingCache<String, Integer> cache, WatchedCreatorLoader loader, FakeTicker ticker, TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener) {
        int i;
        for (i = 0; i < 10; ++i) {
            CacheExpirationTest.assertEquals((Object)(12345 + i), (Object)cache.getUnchecked((Object)(KEY_PREFIX + i)));
        }
        for (i = 0; i < 10; ++i) {
            loader.reset();
            CacheExpirationTest.assertEquals((Object)(12345 + i), (Object)cache.getUnchecked((Object)(KEY_PREFIX + i)));
            CacheExpirationTest.assertFalse((String)("Creator should not have been called @#" + i), (boolean)loader.wasCalled());
        }
        CacheTesting.expireEntries(cache, 1000L, ticker);
        CacheExpirationTest.assertEquals((String)"Map must be empty by now", (long)0L, (long)cache.size());
        CacheExpirationTest.assertEquals((String)"Eviction notifications must be received", (int)10, (int)removalListener.getCount());
        CacheTesting.expireEntries(cache, 1000L, ticker);
        CacheExpirationTest.assertEquals((String)"Eviction notifications must be received", (int)10, (int)removalListener.getCount());
    }

    public void testExpiringGet_expireAfterWrite() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.runExpirationTest((LoadingCache<String, Integer>)cache, loader, ticker, removalListener);
    }

    public void testExpiringGet_expireAfterAccess() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.runExpirationTest((LoadingCache<String, Integer>)cache, loader, ticker, removalListener);
    }

    private void runExpirationTest(LoadingCache<String, Integer> cache, WatchedCreatorLoader loader, FakeTicker ticker, TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener) {
        int i;
        for (i = 0; i < 10; ++i) {
            CacheExpirationTest.assertEquals((Object)(12345 + i), (Object)cache.getUnchecked((Object)(KEY_PREFIX + i)));
        }
        for (i = 0; i < 10; ++i) {
            loader.reset();
            CacheExpirationTest.assertEquals((Object)(12345 + i), (Object)cache.getUnchecked((Object)(KEY_PREFIX + i)));
            CacheExpirationTest.assertFalse((String)("Loader should NOT have been called @#" + i), (boolean)loader.wasCalled());
        }
        ticker.advance(10000L, TimeUnit.MILLISECONDS);
        cache.getUnchecked((Object)"key prefix:11");
        CacheExpirationTest.assertEquals((int)1, (int)Iterators.size(cache.asMap().entrySet().iterator()));
        CacheExpirationTest.assertEquals((int)1, (int)Iterators.size(cache.asMap().keySet().iterator()));
        CacheExpirationTest.assertEquals((int)1, (int)Iterators.size(cache.asMap().values().iterator()));
        CacheTesting.expireEntries(cache, 1000L, ticker);
        for (i = 0; i < 11; ++i) {
            CacheExpirationTest.assertFalse((boolean)cache.asMap().containsKey(KEY_PREFIX + i));
        }
        CacheExpirationTest.assertEquals((int)11, (int)removalListener.getCount());
        for (i = 0; i < 10; ++i) {
            CacheExpirationTest.assertFalse((boolean)cache.asMap().containsKey(KEY_PREFIX + i));
            loader.reset();
            CacheExpirationTest.assertEquals((Object)(12345 + i), (Object)cache.getUnchecked((Object)(KEY_PREFIX + i)));
            CacheExpirationTest.assertTrue((String)("Creator should have been called @#" + i), (boolean)loader.wasCalled());
        }
        CacheTesting.expireEntries(cache, 1000L, ticker);
        CacheExpirationTest.assertEquals((String)"Eviction notifications must be received", (int)21, (int)removalListener.getCount());
        CacheTesting.expireEntries(cache, 1000L, ticker);
        CacheExpirationTest.assertEquals((String)"Eviction notifications must be received", (int)21, (int)removalListener.getCount());
    }

    public void testRemovalListener_expireAfterWrite() {
        FakeTicker ticker = new FakeTicker();
        final AtomicInteger evictionCount = new AtomicInteger();
        final AtomicInteger applyCount = new AtomicInteger();
        final AtomicInteger totalSum = new AtomicInteger();
        RemovalListener<Integer, AtomicInteger> removalListener = new RemovalListener<Integer, AtomicInteger>(){

            public void onRemoval(RemovalNotification<Integer, AtomicInteger> notification) {
                if (notification.wasEvicted()) {
                    evictionCount.incrementAndGet();
                    totalSum.addAndGet(((AtomicInteger)notification.getValue()).get());
                }
            }
        };
        CacheLoader<Integer, AtomicInteger> loader = new CacheLoader<Integer, AtomicInteger>(){

            public AtomicInteger load(Integer key) {
                applyCount.incrementAndGet();
                return new AtomicInteger();
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().removalListener((RemovalListener)removalListener).expireAfterWrite(10L, TimeUnit.MILLISECONDS).ticker((Ticker)ticker).build((CacheLoader)loader);
        for (int i = 0; i < 100; ++i) {
            ((AtomicInteger)cache.getUnchecked((Object)10)).incrementAndGet();
            ticker.advance(1L, TimeUnit.MILLISECONDS);
        }
        CacheExpirationTest.assertEquals((int)(evictionCount.get() + 1), (int)applyCount.get());
        int remaining = ((AtomicInteger)cache.getUnchecked((Object)10)).get();
        CacheExpirationTest.assertEquals((int)100, (int)(totalSum.get() + remaining));
    }

    public void testRemovalScheduler_expireAfterWrite() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.runRemovalScheduler((LoadingCache<String, Integer>)cache, removalListener, loader, ticker, KEY_PREFIX, 1000L);
    }

    public void testRemovalScheduler_expireAfterAccess() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.runRemovalScheduler((LoadingCache<String, Integer>)cache, removalListener, loader, ticker, KEY_PREFIX, 1000L);
    }

    public void testRemovalScheduler_expireAfterBoth() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener = TestingRemovalListeners.countingRemovalListener();
        WatchedCreatorLoader loader = new WatchedCreatorLoader();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(1000L, TimeUnit.MILLISECONDS).expireAfterWrite(1000L, TimeUnit.MILLISECONDS).removalListener(removalListener).ticker((Ticker)ticker).build((CacheLoader)loader);
        this.runRemovalScheduler((LoadingCache<String, Integer>)cache, removalListener, loader, ticker, KEY_PREFIX, 1000L);
    }

    public void testExpirationOrder_access() {
        FakeTicker ticker = new FakeTicker();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(11L, TimeUnit.MILLISECONDS).ticker((Ticker)ticker).build(loader);
        for (int i = 0; i < 10; ++i) {
            cache.getUnchecked((Object)i);
            ticker.advance(1L, TimeUnit.MILLISECONDS);
        }
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(2L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)3, (Object)4, (Object[])new Integer[]{5, 6, 7, 8, 9, 0, 1, 2});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)4, (Object)5, (Object[])new Integer[]{6, 7, 8, 9, 0, 1, 2});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(5, 7, 9));
        CacheTesting.drainRecencyQueues(cache);
        Truth.ASSERT.that(keySet).has().exactly((Object)4, (Object)6, (Object[])new Integer[]{8, 0, 1, 2, 5, 7, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)8, (Object[])new Integer[]{0, 1, 2, 5, 7, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)8, (Object[])new Integer[]{0, 1, 2, 5, 7, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)8, (Object)0, (Object[])new Integer[]{1, 2, 5, 7, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)8, (Object)0, (Object[])new Integer[]{1, 2, 5, 7, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 5, 7, 9});
    }

    public void testExpirationOrder_write() throws ExecutionException {
        FakeTicker ticker = new FakeTicker();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(11L, TimeUnit.MILLISECONDS).ticker((Ticker)ticker).build(loader);
        for (int i = 0; i < 10; ++i) {
            cache.getUnchecked((Object)i);
            ticker.advance(1L, TimeUnit.MILLISECONDS);
        }
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)2, (Object)3, (Object[])new Integer[]{4, 5, 6, 7, 8, 9, 0});
        cache.get((Object)2, Callables.returning((Object)-2));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)3, (Object)4, (Object[])new Integer[]{5, 6, 7, 8, 9, 0});
        cache.asMap().put(3, -3);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)4, (Object)5, (Object[])new Integer[]{6, 7, 8, 9, 0, 3});
        cache.asMap().replace(4, -4);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)5, (Object)6, (Object[])new Integer[]{7, 8, 9, 0, 3, 4});
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)7, (Object[])new Integer[]{8, 9, 0, 3, 4});
    }

    public void testExpirationOrder_writeAccess() throws ExecutionException {
        int i;
        FakeTicker ticker = new FakeTicker();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(5L, TimeUnit.MILLISECONDS).expireAfterAccess(3L, TimeUnit.MILLISECONDS).ticker((Ticker)ticker).build(loader);
        for (i = 0; i < 5; ++i) {
            cache.getUnchecked((Object)i);
        }
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        for (i = 5; i < 10; ++i) {
            cache.getUnchecked((Object)i);
        }
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Set keySet = cache.asMap().keySet();
        Truth.ASSERT.that(keySet).has().exactly((Object)0, (Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(1, 3));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)5, (Object)6, (Object[])new Integer[]{7, 8, 9, 1, 3});
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(6, 8));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)1, (Object)3, (Object[])new Integer[]{6, 8});
        cache.asMap().put(3, -3);
        this.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(1));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)6, (Object)8, (Object[])new Integer[]{3});
        cache.asMap().replace(6, -6);
        cache.get((Object)8, Callables.returning((Object)-8));
        CacheTesting.drainRecencyQueues(cache);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.ASSERT.that(keySet).has().exactly((Object)3, (Object)6, (Object[])new Integer[0]);
    }

    private void runRemovalScheduler(LoadingCache<String, Integer> cache, TestingRemovalListeners.CountingRemovalListener<String, Integer> removalListener, WatchedCreatorLoader loader, FakeTicker ticker, String keyPrefix, long ttl) {
        int i;
        int shift1 = 12355;
        loader.setValuePrefix(shift1);
        for (int i2 = 0; i2 < 10; ++i2) {
            CacheExpirationTest.assertEquals((Object)(i2 + shift1), (Object)cache.getUnchecked((Object)(keyPrefix + i2)));
        }
        CacheExpirationTest.assertEquals((int)10, (int)CacheTesting.expirationQueueSize(cache));
        CacheExpirationTest.assertEquals((int)0, (int)removalListener.getCount());
        ticker.advance(ttl * 2L / 3L, TimeUnit.MILLISECONDS);
        CacheExpirationTest.assertEquals((int)10, (int)CacheTesting.expirationQueueSize(cache));
        CacheExpirationTest.assertEquals((int)0, (int)removalListener.getCount());
        int shift2 = shift1 + 10;
        loader.setValuePrefix(shift2);
        for (i = 0; i < 10; ++i) {
            cache.invalidate((Object)(keyPrefix + i));
            CacheExpirationTest.assertEquals((String)("key: " + keyPrefix + i), (Object)(i + shift2), (Object)cache.getUnchecked((Object)(keyPrefix + i)));
        }
        CacheExpirationTest.assertEquals((int)10, (int)CacheTesting.expirationQueueSize(cache));
        CacheExpirationTest.assertEquals((int)10, (int)removalListener.getCount());
        ticker.advance(ttl * 2L / 3L, TimeUnit.MILLISECONDS);
        CacheExpirationTest.assertEquals((int)10, (int)CacheTesting.expirationQueueSize(cache));
        CacheExpirationTest.assertEquals((int)10, (int)removalListener.getCount());
        for (i = 0; i < 10; ++i) {
            loader.reset();
            CacheExpirationTest.assertEquals((Object)(i + shift2), (Object)cache.getUnchecked((Object)(keyPrefix + i)));
            CacheExpirationTest.assertFalse((String)("Creator should NOT have been called @#" + i), (boolean)loader.wasCalled());
        }
        CacheExpirationTest.assertEquals((int)10, (int)removalListener.getCount());
    }

    private void getAll(LoadingCache<Integer, Integer> cache, List<Integer> keys) {
        for (int i : keys) {
            cache.getUnchecked((Object)i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatchedCreatorLoader
    extends CacheLoader<String, Integer> {
        boolean wasCalled = false;
        String keyPrefix = "key prefix:";
        int valuePrefix = 12345;

        public void reset() {
            this.wasCalled = false;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setValuePrefix(int valuePrefix) {
            this.valuePrefix = valuePrefix;
        }

        public Integer load(String key) {
            this.wasCalled = true;
            return this.valuePrefix + Integer.parseInt(key.substring(this.keyPrefix.length()));
        }
    }
}

