/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import junit.framework.TestCase;

public class CacheManualTest
extends TestCase {
    public void testGetIfPresent() {
        Cache cache = CacheBuilder.newBuilder().recordStats().build();
        CacheStats stats = cache.stats();
        CacheManualTest.assertEquals((long)0L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        Object one = new Object();
        Object two = new Object();
        CacheManualTest.assertNull((Object)cache.getIfPresent(one));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)1L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheManualTest.assertNull(cache.asMap().get(one));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsKey(one));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsValue(two));
        CacheManualTest.assertNull((Object)cache.getIfPresent(two));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)2L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheManualTest.assertNull(cache.asMap().get(two));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsKey(two));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsValue(one));
        cache.put(one, two);
        CacheManualTest.assertSame((Object)two, (Object)cache.getIfPresent(one));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)2L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)1L, (long)stats.hitCount());
        CacheManualTest.assertSame((Object)two, cache.asMap().get(one));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsKey(one));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsValue(two));
        CacheManualTest.assertNull((Object)cache.getIfPresent(two));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)3L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)1L, (long)stats.hitCount());
        CacheManualTest.assertNull(cache.asMap().get(two));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsKey(two));
        CacheManualTest.assertFalse((boolean)cache.asMap().containsValue(one));
        cache.put(two, one);
        CacheManualTest.assertSame((Object)two, (Object)cache.getIfPresent(one));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)3L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)2L, (long)stats.hitCount());
        CacheManualTest.assertSame((Object)two, cache.asMap().get(one));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsKey(one));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsValue(two));
        CacheManualTest.assertSame((Object)one, (Object)cache.getIfPresent(two));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)3L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)3L, (long)stats.hitCount());
        CacheManualTest.assertSame((Object)one, cache.asMap().get(two));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsKey(two));
        CacheManualTest.assertTrue((boolean)cache.asMap().containsValue(one));
    }

    public void testGetAllPresent() {
        Cache cache = CacheBuilder.newBuilder().recordStats().build();
        CacheStats stats = cache.stats();
        CacheManualTest.assertEquals((long)0L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheManualTest.assertEquals((Object)ImmutableMap.of(), (Object)cache.getAllPresent((Iterable)ImmutableList.of()));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)0L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheManualTest.assertEquals((Object)ImmutableMap.of(), (Object)cache.getAllPresent(Arrays.asList(1, 2, 3)));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)3L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.put((Object)2, (Object)22);
        CacheManualTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)22), (Object)cache.getAllPresent(Arrays.asList(1, 2, 3)));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)5L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)1L, (long)stats.hitCount());
        cache.put((Object)3, (Object)33);
        CacheManualTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)22, (Object)3, (Object)33), (Object)cache.getAllPresent(Arrays.asList(1, 2, 3)));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)6L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)3L, (long)stats.hitCount());
        cache.put((Object)1, (Object)11);
        CacheManualTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)11, (Object)2, (Object)22, (Object)3, (Object)33), (Object)cache.getAllPresent(Arrays.asList(1, 2, 3)));
        stats = cache.stats();
        CacheManualTest.assertEquals((long)6L, (long)stats.missCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheManualTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheManualTest.assertEquals((long)6L, (long)stats.hitCount());
    }
}

