/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.ForwardingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class ForwardingCacheTest
extends TestCase {
    private Cache<String, Boolean> forward;
    private Cache<String, Boolean> mock;

    public void setUp() throws Exception {
        super.setUp();
        this.mock = (Cache)EasyMock.createMock(Cache.class);
        this.forward = new ForwardingCache<String, Boolean>(){

            protected Cache<String, Boolean> delegate() {
                return ForwardingCacheTest.this.mock;
            }
        };
    }

    public void testGetIfPresent() throws ExecutionException {
        EasyMock.expect((Object)this.mock.getIfPresent((Object)"key")).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.getIfPresent((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testGetAllPresent() throws ExecutionException {
        EasyMock.expect((Object)this.mock.getAllPresent((Iterable)ImmutableList.of((Object)"key"))).andReturn((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE));
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingCacheTest.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE), (Object)this.forward.getAllPresent((Iterable)ImmutableList.of((Object)"key")));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testInvalidate() {
        this.mock.invalidate((Object)"key");
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.invalidate((Object)"key");
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testInvalidateAllIterable() {
        this.mock.invalidateAll((Iterable)ImmutableList.of((Object)"key"));
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.invalidateAll((Iterable)ImmutableList.of((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testInvalidateAll() {
        this.mock.invalidateAll();
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.invalidateAll();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testSize() {
        EasyMock.expect((Object)this.mock.size()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.size();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testStats() {
        EasyMock.expect((Object)this.mock.stats()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingCacheTest.assertNull((Object)this.forward.stats());
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testAsMap() {
        EasyMock.expect((Object)this.mock.asMap()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingCacheTest.assertNull((Object)this.forward.asMap());
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testCleanUp() {
        this.mock.cleanUp();
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.cleanUp();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OnlyGet<K, V>
    extends ForwardingCache<K, V> {
        private OnlyGet() {
        }

        protected Cache<K, V> delegate() {
            return null;
        }
    }
}

