/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Equivalence;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LocalCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.cache.TestingWeighers;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.testing.FakeTicker;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.testing.TestLogHandler;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCacheTest
extends TestCase {
    static final int SMALL_MAX_SIZE = 315;
    TestLogHandler logHandler;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(LocalCacheTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            public Map<String, String> create(Map.Entry<String, String>[] entries) {
                LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder());
                for (Map.Entry<String, String> entry : entries) {
                    map.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return map;
            }
        }).named("LocalCache with defaults")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.logHandler = new TestLogHandler();
        LocalCache.logger.addHandler((Handler)this.logHandler);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        LocalCache.logger.removeHandler((Handler)this.logHandler);
    }

    private Throwable popLoggedThrowable() {
        List logRecords = this.logHandler.getStoredLogRecords();
        LocalCacheTest.assertSame((Object)1, (Object)logRecords.size());
        LogRecord logRecord = (LogRecord)logRecords.get(0);
        this.logHandler.clear();
        return logRecord.getThrown();
    }

    private void checkNothingLogged() {
        LocalCacheTest.assertTrue((boolean)this.logHandler.getStoredLogRecords().isEmpty());
    }

    private void checkLogged(Throwable t) {
        LocalCacheTest.assertSame((Object)t, (Object)this.popLoggedThrowable());
    }

    private static <K, V> LocalCache<K, V> makeLocalCache(CacheBuilder<? super K, ? super V> builder) {
        return new LocalCache(builder, null);
    }

    private static CacheBuilder<Object, Object> createCacheBuilder() {
        return new CacheBuilder();
    }

    public void testDefaults() {
        LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder());
        LocalCacheTest.assertSame((Object)LocalCache.Strength.STRONG, (Object)map.keyStrength);
        LocalCacheTest.assertSame((Object)LocalCache.Strength.STRONG, (Object)map.valueStrength);
        LocalCacheTest.assertSame((Object)map.keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
        LocalCacheTest.assertSame((Object)map.valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
        LocalCacheTest.assertEquals((long)0L, (long)map.expireAfterAccessNanos);
        LocalCacheTest.assertEquals((long)0L, (long)map.expireAfterWriteNanos);
        LocalCacheTest.assertEquals((long)0L, (long)map.refreshNanos);
        LocalCacheTest.assertEquals((long)-1L, (long)map.maxWeight);
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG, (Object)map.entryFactory);
        LocalCacheTest.assertSame((Object)CacheBuilder.NullListener.INSTANCE, (Object)map.removalListener);
        LocalCacheTest.assertSame((Object)LocalCache.DISCARDING_QUEUE, (Object)map.removalNotificationQueue);
        LocalCacheTest.assertSame((Object)CacheBuilder.NULL_TICKER, (Object)map.ticker);
        LocalCacheTest.assertEquals((int)4, (int)map.concurrencyLevel);
        LocalCacheTest.assertEquals((int)4, (int)map.segments.length);
        LocalCacheTest.assertEquals((int)(16 / map.segments.length), (int)map.segments[0].table.length());
        LocalCacheTest.assertFalse((boolean)map.evictsBySize());
        LocalCacheTest.assertFalse((boolean)map.expires());
        LocalCacheTest.assertFalse((boolean)map.expiresAfterWrite());
        LocalCacheTest.assertFalse((boolean)map.expiresAfterAccess());
        LocalCacheTest.assertFalse((boolean)map.refreshes());
    }

    public void testSetKeyEquivalence() {
        Equivalence<Object> testEquivalence = new Equivalence<Object>(){

            protected boolean doEquivalent(Object a, Object b) {
                return false;
            }

            protected int doHash(Object t) {
                return 0;
            }
        };
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().keyEquivalence((Equivalence)testEquivalence));
        LocalCacheTest.assertSame((Object)testEquivalence, (Object)map.keyEquivalence);
        LocalCacheTest.assertSame((Object)map.valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
    }

    public void testSetValueEquivalence() {
        Equivalence<Object> testEquivalence = new Equivalence<Object>(){

            protected boolean doEquivalent(Object a, Object b) {
                return false;
            }

            protected int doHash(Object t) {
                return 0;
            }
        };
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().valueEquivalence((Equivalence)testEquivalence));
        LocalCacheTest.assertSame((Object)testEquivalence, (Object)map.valueEquivalence);
        LocalCacheTest.assertSame((Object)map.keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
    }

    public void testSetConcurrencyLevel() {
        LocalCacheTest.checkConcurrencyLevel(1, 1);
        LocalCacheTest.checkConcurrencyLevel(2, 2);
        LocalCacheTest.checkConcurrencyLevel(3, 4);
        LocalCacheTest.checkConcurrencyLevel(4, 4);
        LocalCacheTest.checkConcurrencyLevel(5, 8);
        LocalCacheTest.checkConcurrencyLevel(6, 8);
        LocalCacheTest.checkConcurrencyLevel(7, 8);
        LocalCacheTest.checkConcurrencyLevel(8, 8);
    }

    private static void checkConcurrencyLevel(int concurrencyLevel, int segmentCount) {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(concurrencyLevel));
        LocalCacheTest.assertEquals((int)segmentCount, (int)map.segments.length);
    }

    public void testSetInitialCapacity() {
        LocalCacheTest.checkInitialCapacity(1, 0, 1);
        LocalCacheTest.checkInitialCapacity(1, 1, 1);
        LocalCacheTest.checkInitialCapacity(1, 2, 2);
        LocalCacheTest.checkInitialCapacity(1, 3, 4);
        LocalCacheTest.checkInitialCapacity(1, 4, 4);
        LocalCacheTest.checkInitialCapacity(1, 5, 8);
        LocalCacheTest.checkInitialCapacity(1, 6, 8);
        LocalCacheTest.checkInitialCapacity(1, 7, 8);
        LocalCacheTest.checkInitialCapacity(1, 8, 8);
        LocalCacheTest.checkInitialCapacity(2, 0, 1);
        LocalCacheTest.checkInitialCapacity(2, 1, 1);
        LocalCacheTest.checkInitialCapacity(2, 2, 1);
        LocalCacheTest.checkInitialCapacity(2, 3, 2);
        LocalCacheTest.checkInitialCapacity(2, 4, 2);
        LocalCacheTest.checkInitialCapacity(2, 5, 4);
        LocalCacheTest.checkInitialCapacity(2, 6, 4);
        LocalCacheTest.checkInitialCapacity(2, 7, 4);
        LocalCacheTest.checkInitialCapacity(2, 8, 4);
        LocalCacheTest.checkInitialCapacity(4, 0, 1);
        LocalCacheTest.checkInitialCapacity(4, 1, 1);
        LocalCacheTest.checkInitialCapacity(4, 2, 1);
        LocalCacheTest.checkInitialCapacity(4, 3, 1);
        LocalCacheTest.checkInitialCapacity(4, 4, 1);
        LocalCacheTest.checkInitialCapacity(4, 5, 2);
        LocalCacheTest.checkInitialCapacity(4, 6, 2);
        LocalCacheTest.checkInitialCapacity(4, 7, 2);
        LocalCacheTest.checkInitialCapacity(4, 8, 2);
    }

    private static void checkInitialCapacity(int concurrencyLevel, int initialCapacity, int segmentSize) {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity));
        for (int i = 0; i < map.segments.length; ++i) {
            LocalCacheTest.assertEquals((int)segmentSize, (int)map.segments[i].table.length());
        }
    }

    public void testSetMaximumSize() {
        for (int maxSize = 1; maxSize < 100; ++maxSize) {
            LocalCacheTest.checkMaximumSize(1, 8, maxSize);
            LocalCacheTest.checkMaximumSize(2, 8, maxSize);
            LocalCacheTest.checkMaximumSize(4, 8, maxSize);
            LocalCacheTest.checkMaximumSize(8, 8, maxSize);
        }
        LocalCacheTest.checkMaximumSize(1, 8, Long.MAX_VALUE);
        LocalCacheTest.checkMaximumSize(2, 8, Long.MAX_VALUE);
        LocalCacheTest.checkMaximumSize(4, 8, Long.MAX_VALUE);
        LocalCacheTest.checkMaximumSize(8, 8, Long.MAX_VALUE);
        for (int capacity = 0; capacity < 8; ++capacity) {
            LocalCacheTest.checkMaximumSize(1, capacity, 4L);
            LocalCacheTest.checkMaximumSize(2, capacity, 4L);
            LocalCacheTest.checkMaximumSize(4, capacity, 4L);
            LocalCacheTest.checkMaximumSize(8, capacity, 4L);
        }
    }

    private static void checkMaximumSize(int concurrencyLevel, int initialCapacity, long maxSize) {
        int i;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxSize));
        long totalCapacity = 0L;
        LocalCacheTest.assertTrue((String)("segments=" + map.segments.length + ", maxSize=" + maxSize), ((long)map.segments.length <= Math.max(1L, maxSize / 10L) ? 1 : 0) != 0);
        for (i = 0; i < map.segments.length; ++i) {
            totalCapacity += map.segments[i].maxSegmentWeight;
        }
        LocalCacheTest.assertTrue((String)("totalCapacity=" + totalCapacity + ", maxSize=" + maxSize), (totalCapacity == maxSize ? 1 : 0) != 0);
        map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumWeight(maxSize).weigher(TestingWeighers.constantWeigher(1)));
        LocalCacheTest.assertTrue((String)("segments=" + map.segments.length + ", maxSize=" + maxSize), ((long)map.segments.length <= Math.max(1L, maxSize / 10L) ? 1 : 0) != 0);
        totalCapacity = 0L;
        for (i = 0; i < map.segments.length; ++i) {
            totalCapacity += map.segments[i].maxSegmentWeight;
        }
        LocalCacheTest.assertTrue((String)("totalCapacity=" + totalCapacity + ", maxSize=" + maxSize), (totalCapacity == maxSize ? 1 : 0) != 0);
    }

    public void testSetWeigher() {
        Weigher<Object, Object> testWeigher = new Weigher<Object, Object>(){

            public int weigh(Object key, Object value) {
                return 42;
            }
        };
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().maximumWeight(1L).weigher((Weigher)testWeigher));
        LocalCacheTest.assertSame((Object)testWeigher, (Object)map.weigher);
    }

    public void testSetWeakKeys() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().weakKeys());
        LocalCacheTest.checkStrength(map, LocalCache.Strength.WEAK, LocalCache.Strength.STRONG);
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.WEAK, (Object)map.entryFactory);
    }

    public void testSetWeakValues() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().weakValues());
        LocalCacheTest.checkStrength(map, LocalCache.Strength.STRONG, LocalCache.Strength.WEAK);
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG, (Object)map.entryFactory);
    }

    public void testSetSoftValues() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().softValues());
        LocalCacheTest.checkStrength(map, LocalCache.Strength.STRONG, LocalCache.Strength.SOFT);
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG, (Object)map.entryFactory);
    }

    private static void checkStrength(LocalCache<Object, Object> map, LocalCache.Strength keyStrength, LocalCache.Strength valueStrength) {
        LocalCacheTest.assertSame((Object)keyStrength, (Object)map.keyStrength);
        LocalCacheTest.assertSame((Object)valueStrength, (Object)map.valueStrength);
        LocalCacheTest.assertSame((Object)keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
        LocalCacheTest.assertSame((Object)valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
    }

    public void testSetExpireAfterWrite() {
        long duration = 42L;
        TimeUnit unit = TimeUnit.SECONDS;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().expireAfterWrite(duration, unit));
        LocalCacheTest.assertEquals((long)unit.toNanos(duration), (long)map.expireAfterWriteNanos);
    }

    public void testSetExpireAfterAccess() {
        long duration = 42L;
        TimeUnit unit = TimeUnit.SECONDS;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().expireAfterAccess(duration, unit));
        LocalCacheTest.assertEquals((long)unit.toNanos(duration), (long)map.expireAfterAccessNanos);
    }

    public void testSetRefresh() {
        long duration = 42L;
        TimeUnit unit = TimeUnit.SECONDS;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().refreshAfterWrite(duration, unit));
        LocalCacheTest.assertEquals((long)unit.toNanos(duration), (long)map.refreshNanos);
    }

    public void testSetRemovalListener() {
        TestingRemovalListeners.NullRemovalListener testListener = TestingRemovalListeners.nullRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().removalListener(testListener));
        LocalCacheTest.assertSame(testListener, (Object)map.removalListener);
    }

    public void testSetTicker() {
        Ticker testTicker = new Ticker(){

            public long read() {
                return 0L;
            }
        };
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().ticker(testTicker));
        LocalCacheTest.assertSame((Object)testTicker, (Object)map.ticker);
    }

    public void testEntryFactory() {
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.STRONG, (boolean)false, (boolean)false));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG_ACCESS, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.STRONG, (boolean)true, (boolean)false));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG_WRITE, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.STRONG, (boolean)false, (boolean)true));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.STRONG_ACCESS_WRITE, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.STRONG, (boolean)true, (boolean)true));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.WEAK, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.WEAK, (boolean)false, (boolean)false));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.WEAK_ACCESS, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.WEAK, (boolean)true, (boolean)false));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.WEAK_WRITE, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.WEAK, (boolean)false, (boolean)true));
        LocalCacheTest.assertSame((Object)LocalCache.EntryFactory.WEAK_ACCESS_WRITE, (Object)LocalCache.EntryFactory.getFactory((LocalCache.Strength)LocalCache.Strength.WEAK, (boolean)true, (boolean)true));
    }

    public void testCompute() throws ExecutionException {
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder());
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        Object key = new Object();
        Object value = map.get(key, (CacheLoader)loader);
        LocalCacheTest.assertEquals((int)1, (int)loader.getCount());
        LocalCacheTest.assertEquals((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)1, (int)loader.getCount());
    }

    public void testRecordReadOnCompute() throws ExecutionException {
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            LocalCache.ReferenceEntry entry;
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 315; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                map.get(key, (CacheLoader)loader);
                entry = segment.getEntry(key, hash);
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                entry = (LocalCache.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                map.get(entry.getKey(), (CacheLoader)loader);
                reads.add(entry);
                i.remove();
                LocalCacheTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            int undrainedIndex = reads.size() - segment.recencyQueue.size();
            LocalCacheTest.checkAndDrainRecencyQueue(map, segment, reads.subList(undrainedIndex, reads.size()));
            readOrder.addAll(reads);
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
        }
    }

    public void testComputeExistingEntry() throws ExecutionException {
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder());
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        Object key = new Object();
        Object value = new Object();
        map.put(key, value);
        LocalCacheTest.assertEquals((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
    }

    public void testComputePartiallyCollectedKey() throws ExecutionException {
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().concurrencyLevel(1);
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        LocalCache map = LocalCacheTest.makeLocalCache(builder);
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference valueRef = DummyValueReference.create(value);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        entry.clearKey();
        LocalCacheTest.assertNotSame((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)1, (int)loader.getCount());
        LocalCacheTest.assertEquals((int)2, (int)segment.count);
    }

    public void testComputePartiallyCollectedValue() throws ExecutionException {
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().concurrencyLevel(1);
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        LocalCache map = LocalCacheTest.makeLocalCache(builder);
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference valueRef = DummyValueReference.create(value);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        valueRef.clear();
        LocalCacheTest.assertNotSame((Object)value, (Object)map.get(key, (CacheLoader)loader));
        LocalCacheTest.assertEquals((int)1, (int)loader.getCount());
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
    }

    public void testComputeExpiredEntry() throws ExecutionException {
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().expireAfterWrite(1L, TimeUnit.NANOSECONDS);
        TestingCacheLoaders.CountingLoader loader = new TestingCacheLoaders.CountingLoader();
        LocalCache map = LocalCacheTest.makeLocalCache(builder);
        LocalCacheTest.assertEquals((int)0, (int)loader.getCount());
        Object key = new Object();
        Object one = map.get(key, (CacheLoader)loader);
        LocalCacheTest.assertEquals((int)1, (int)loader.getCount());
        Object two = map.get(key, (CacheLoader)loader);
        LocalCacheTest.assertNotSame((Object)one, (Object)two);
        LocalCacheTest.assertEquals((int)2, (int)loader.getCount());
    }

    public void testValues() {
        LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder());
        map.put((Object)"foo", (Object)"bar");
        map.put((Object)"baz", (Object)"bar");
        map.put((Object)"quux", (Object)"quux");
        LocalCacheTest.assertFalse((boolean)(map.values() instanceof Set));
        LocalCacheTest.assertTrue((boolean)map.values().removeAll((Collection<?>)ImmutableSet.of((Object)"bar")));
        LocalCacheTest.assertEquals((int)1, (int)map.size());
    }

    public void testCopyEntry_computing() {
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch computingSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(2);
        final Object computedObject = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                computingSignal.countDown();
                startSignal.await();
                return computedObject;
            }
        };
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().concurrencyLevel(1).removalListener(listener);
        final LocalCache map = LocalCacheTest.makeLocalCache(builder);
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        final Object one = new Object();
        int hash = map.hash(one);
        int index = hash & table.length() - 1;
        new Thread((CacheLoader)loader, doneSignal){
            final /* synthetic */ CacheLoader val$loader;
            final /* synthetic */ CountDownLatch val$doneSignal;
            {
                this.val$loader = cacheLoader;
                this.val$doneSignal = countDownLatch;
            }

            public void run() {
                try {
                    map.get(one, this.val$loader);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                this.val$doneSignal.countDown();
            }
        }.start();
        try {
            computingSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        new Thread((CacheLoader)loader, doneSignal){
            final /* synthetic */ CacheLoader val$loader;
            final /* synthetic */ CountDownLatch val$doneSignal;
            {
                this.val$loader = cacheLoader;
                this.val$doneSignal = countDownLatch;
            }

            public void run() {
                try {
                    map.get(one, this.val$loader);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                this.val$doneSignal.countDown();
            }
        }.start();
        LocalCache.ReferenceEntry entry = segment.getEntry(one, hash);
        LocalCache.ReferenceEntry newEntry = segment.copyEntry(entry, null);
        table.set(index, newEntry);
        LocalCache.LoadingValueReference valueReference = (LocalCache.LoadingValueReference)newEntry.getValueReference();
        LocalCacheTest.assertFalse((boolean)valueReference.futureValue.isDone());
        startSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        map.cleanUp();
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        LocalCacheTest.assertTrue((boolean)map.containsKey(one));
        LocalCacheTest.assertEquals((int)1, (int)map.size());
        LocalCacheTest.assertSame((Object)computedObject, (Object)map.get(one));
    }

    public void testRemovalListenerCheckedException() {
        final RuntimeException e = new RuntimeException();
        RemovalListener<Object, Object> listener = new RemovalListener<Object, Object>(){

            public void onRemoval(RemovalNotification<Object, Object> notification) {
                throw e;
            }
        };
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().removalListener((RemovalListener)listener);
        LocalCache cache = LocalCacheTest.makeLocalCache(builder);
        Object key = new Object();
        cache.put(key, new Object());
        this.checkNothingLogged();
        cache.remove(key);
        this.checkLogged(e);
    }

    public void testRemovalListener_replaced_computing() {
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch computingSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(1);
        final Object computedObject = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                computingSignal.countDown();
                startSignal.await();
                return computedObject;
            }
        };
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        CacheBuilder builder = LocalCacheTest.createCacheBuilder().removalListener(listener);
        final LocalCache map = LocalCacheTest.makeLocalCache(builder);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        final Object one = new Object();
        Object two = new Object();
        new Thread((CacheLoader)loader, doneSignal){
            final /* synthetic */ CacheLoader val$loader;
            final /* synthetic */ CountDownLatch val$doneSignal;
            {
                this.val$loader = cacheLoader;
                this.val$doneSignal = countDownLatch;
            }

            public void run() {
                try {
                    map.get(one, this.val$loader);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                this.val$doneSignal.countDown();
            }
        }.start();
        try {
            computingSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        map.put(one, two);
        LocalCacheTest.assertSame((Object)two, (Object)map.get(one));
        startSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        map.cleanUp();
        LocalCacheTest.assertNotified(listener, one, computedObject, RemovalCause.REPLACED);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testSegmentRefresh_duplicate() throws ExecutionException {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference valueRef = DummyValueReference.create(null);
        valueRef.setLoading(true);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        LocalCacheTest.assertNull((Object)segment.refresh(key, hash, TestingCacheLoaders.identityLoader(), false));
    }

    public void testRemovalListener_explicit() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().removalListener(listener));
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        Object five = new Object();
        Object six = new Object();
        map.put(one, two);
        map.remove(one);
        LocalCacheTest.assertNotified(listener, one, two, RemovalCause.EXPLICIT);
        map.put(two, three);
        map.remove(two, three);
        LocalCacheTest.assertNotified(listener, two, three, RemovalCause.EXPLICIT);
        map.put(three, four);
        Iterator i = map.entrySet().iterator();
        i.next();
        i.remove();
        LocalCacheTest.assertNotified(listener, three, four, RemovalCause.EXPLICIT);
        map.put(four, five);
        i = map.keySet().iterator();
        i.next();
        i.remove();
        LocalCacheTest.assertNotified(listener, four, five, RemovalCause.EXPLICIT);
        map.put(five, six);
        i = map.values().iterator();
        i.next();
        i.remove();
        LocalCacheTest.assertNotified(listener, five, six, RemovalCause.EXPLICIT);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testRemovalListener_replaced() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().removalListener(listener));
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        Object five = new Object();
        Object six = new Object();
        map.put(one, two);
        map.put(one, three);
        LocalCacheTest.assertNotified(listener, one, two, RemovalCause.REPLACED);
        ImmutableMap newMap = ImmutableMap.of((Object)one, (Object)four);
        map.putAll((Map)newMap);
        LocalCacheTest.assertNotified(listener, one, three, RemovalCause.REPLACED);
        map.replace(one, five);
        LocalCacheTest.assertNotified(listener, one, four, RemovalCause.REPLACED);
        map.replace(one, five, six);
        LocalCacheTest.assertNotified(listener, one, five, RemovalCause.REPLACED);
    }

    public void testRemovalListener_collected() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).softValues().removalListener(listener));
        LocalCache.Segment segment = map.segments[0];
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        map.put(one, two);
        map.put(two, three);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        int hash = map.hash(one);
        LocalCache.ReferenceEntry entry = segment.getEntry(one, hash);
        map.reclaimValue(entry.getValueReference());
        LocalCacheTest.assertNotified(listener, one, two, RemovalCause.COLLECTED);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testRemovalListener_expired() {
        FakeTicker ticker = new FakeTicker();
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).expireAfterWrite(3L, TimeUnit.NANOSECONDS).ticker((Ticker)ticker).removalListener(listener));
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        Object five = new Object();
        map.put(one, two);
        ticker.advance(1L);
        map.put(two, three);
        ticker.advance(1L);
        map.put(three, four);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        ticker.advance(1L);
        map.put(four, five);
        LocalCacheTest.assertNotified(listener, one, two, RemovalCause.EXPIRED);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testRemovalListener_size() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).maximumSize(2L).removalListener(listener));
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        map.put(one, two);
        map.put(two, three);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        map.put(three, four);
        LocalCacheTest.assertNotified(listener, one, two, RemovalCause.SIZE);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    static <K, V> void assertNotified(TestingRemovalListeners.QueuingRemovalListener<K, V> listener, K key, V value, RemovalCause cause) {
        RemovalNotification notification = (RemovalNotification)listener.remove();
        LocalCacheTest.assertSame(key, (Object)notification.getKey());
        LocalCacheTest.assertSame(value, (Object)notification.getValue());
        LocalCacheTest.assertSame((Object)cause, (Object)notification.getCause());
    }

    public void testNewEntry() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEntryTypeMakers()) {
            LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(builder);
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            LocalCache.ReferenceEntry entryOne = map.newEntry(keyOne, hashOne, null);
            LocalCache.ValueReference valueRefOne = map.newValueReference(entryOne, valueOne, 1);
            LocalCacheTest.assertSame((Object)valueOne, (Object)valueRefOne.get());
            entryOne.setValueReference(valueRefOne);
            LocalCacheTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            LocalCacheTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            LocalCacheTest.assertNull((Object)entryOne.getNext());
            LocalCacheTest.assertSame((Object)valueRefOne, (Object)entryOne.getValueReference());
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            LocalCache.ReferenceEntry entryTwo = map.newEntry(keyTwo, hashTwo, entryOne);
            LocalCache.ValueReference valueRefTwo = map.newValueReference(entryTwo, valueTwo, 1);
            LocalCacheTest.assertSame((Object)valueTwo, (Object)valueRefTwo.get());
            entryTwo.setValueReference(valueRefTwo);
            LocalCacheTest.assertSame((Object)keyTwo, (Object)entryTwo.getKey());
            LocalCacheTest.assertEquals((int)hashTwo, (int)entryTwo.getHash());
            LocalCacheTest.assertSame((Object)entryOne, (Object)entryTwo.getNext());
            LocalCacheTest.assertSame((Object)valueRefTwo, (Object)entryTwo.getValueReference());
        }
    }

    public void testCopyEntry() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEntryTypeMakers()) {
            LocalCache<Object, Object> map = LocalCacheTest.makeLocalCache(builder);
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            LocalCache.ReferenceEntry entryOne = map.newEntry(keyOne, hashOne, null);
            entryOne.setValueReference(map.newValueReference(entryOne, valueOne, 1));
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            LocalCache.ReferenceEntry entryTwo = map.newEntry(keyTwo, hashTwo, entryOne);
            entryTwo.setValueReference(map.newValueReference(entryTwo, valueTwo, 1));
            if (map.usesAccessQueue()) {
                LocalCache.connectAccessOrder((LocalCache.ReferenceEntry)entryOne, (LocalCache.ReferenceEntry)entryTwo);
            }
            if (map.usesWriteQueue()) {
                LocalCache.connectWriteOrder((LocalCache.ReferenceEntry)entryOne, (LocalCache.ReferenceEntry)entryTwo);
            }
            LocalCacheTest.assertConnected(map, entryOne, entryTwo);
            LocalCache.ReferenceEntry copyOne = map.copyEntry(entryOne, null);
            LocalCacheTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            LocalCacheTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            LocalCacheTest.assertNull((Object)entryOne.getNext());
            LocalCacheTest.assertSame((Object)valueOne, (Object)copyOne.getValueReference().get());
            LocalCacheTest.assertConnected(map, copyOne, entryTwo);
            LocalCache.ReferenceEntry copyTwo = map.copyEntry(entryTwo, copyOne);
            LocalCacheTest.assertSame((Object)keyTwo, (Object)copyTwo.getKey());
            LocalCacheTest.assertEquals((int)hashTwo, (int)copyTwo.getHash());
            LocalCacheTest.assertSame((Object)copyOne, (Object)copyTwo.getNext());
            LocalCacheTest.assertSame((Object)valueTwo, (Object)copyTwo.getValueReference().get());
            LocalCacheTest.assertConnected(map, copyOne, copyTwo);
        }
    }

    private static <K, V> void assertConnected(LocalCache<K, V> map, LocalCache.ReferenceEntry<K, V> one, LocalCache.ReferenceEntry<K, V> two) {
        if (map.usesWriteQueue()) {
            LocalCacheTest.assertSame(two, (Object)one.getNextInWriteQueue());
        }
        if (map.usesAccessQueue()) {
            LocalCacheTest.assertSame(two, (Object)one.getNextInAccessQueue());
        }
    }

    public void testSegmentGetAndContains() {
        FakeTicker ticker = new FakeTicker();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).ticker((Ticker)ticker).expireAfterAccess(1L, TimeUnit.NANOSECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        LocalCache.ReferenceEntry entry = map.newEntry(key, hash, null);
        LocalCache.ValueReference valueRef = map.newValueReference(entry, value, 1);
        entry.setValueReference(valueRef);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        LocalCacheTest.assertFalse((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertFalse((boolean)segment.containsValue(value));
        ++segment.count;
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(value));
        LocalCacheTest.assertNull((Object)segment.get(new Object(), hash));
        DummyEntry nullEntry = DummyEntry.create(null, hash, entry);
        Object nullValue = new Object();
        LocalCache.ValueReference nullValueRef = map.newValueReference(nullEntry, nullValue, 1);
        nullEntry.setValueReference(nullValueRef);
        table.set(index, nullEntry);
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(value));
        LocalCacheTest.assertFalse((boolean)segment.containsValue(nullValue));
        DummyEntry dummy = DummyEntry.create(new Object(), hash, entry);
        Object dummyValue = new Object();
        LocalCache.ValueReference dummyValueRef = map.newValueReference(dummy, dummyValue, 1);
        dummy.setValueReference(dummyValueRef);
        table.set(index, dummy);
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(value));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(dummyValue));
        dummy = DummyEntry.create(key, hash, entry);
        dummyValue = new Object();
        dummyValueRef = map.newValueReference(dummy, dummyValue, 1);
        dummy.setValueReference(dummyValueRef);
        table.set(index, dummy);
        LocalCacheTest.assertSame((Object)dummyValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(value));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(dummyValue));
        dummy.setAccessTime(ticker.read() - 2L);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        LocalCacheTest.assertFalse((boolean)segment.containsKey(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.containsValue(value));
        LocalCacheTest.assertFalse((boolean)segment.containsValue(dummyValue));
    }

    public void testSegmentReplaceValue() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.replace(key, hash, oldValue, newValue));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentReplace() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertNull((Object)segment.replace(key, hash, newValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.replace(key, hash, newValue));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertNull((Object)segment.replace(key, hash, newValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentPut() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.put(key, hash, oldValue, false));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, false));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        LocalCache.ReferenceEntry entry = segment.getEntry(key, hash);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertNull((Object)segment.put(key, hash, newValue, false));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPutIfAbsent() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.put(key, hash, oldValue, true));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, true));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCache.ReferenceEntry entry = segment.getEntry(key, hash);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertNull((Object)segment.put(key, hash, newValue, true));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPut_expand() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1));
        LocalCache.Segment segment = map.segments[0];
        LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
        int count = 1024;
        for (int i = 0; i < count; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            LocalCacheTest.assertNull((Object)segment.put(key, hash, value, false));
            LocalCacheTest.assertTrue((segment.table.length() > i ? 1 : 0) != 0);
        }
    }

    public void testSegmentPut_evict() {
        int maxSize = 10;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).maximumSize((long)maxSize));
        int originalCount = 1024;
        LinkedHashMap originalMap = Maps.newLinkedHashMap();
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            map.put(key, value);
            originalMap.put(key, value);
            if (i >= maxSize) {
                Iterator it = originalMap.keySet().iterator();
                it.next();
                it.remove();
            }
            LocalCacheTest.assertEquals((Object)originalMap, map);
        }
    }

    public void testSegmentStoreComputedValue() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).removalListener(listener));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry entry = DummyEntry.create(key, hash, null);
        LocalCache.LoadingValueReference valueRef = new LocalCache.LoadingValueReference();
        entry.setValueReference(valueRef);
        Object value = new Object();
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.storeLoadedValue(key, hash, valueRef, value));
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object value2 = new Object();
        LocalCacheTest.assertFalse((boolean)segment.storeLoadedValue(key, hash, valueRef, value2));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        RemovalNotification notification = (RemovalNotification)listener.remove();
        LocalCacheTest.assertEquals((Object)Maps.immutableEntry((Object)key, (Object)value2), (Object)notification);
        LocalCacheTest.assertEquals((Object)RemovalCause.REPLACED, (Object)notification.getCause());
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object value3 = new Object();
        map.clear();
        listener.clear();
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        LocalCacheTest.assertTrue((boolean)segment.storeLoadedValue(key, hash, valueRef, value3));
        LocalCacheTest.assertSame((Object)value3, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        Object value4 = new Object();
        DummyValueReference value3Ref = DummyValueReference.create(value3);
        valueRef = new LocalCache.LoadingValueReference(value3Ref);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        LocalCacheTest.assertSame((Object)value3, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertTrue((boolean)segment.storeLoadedValue(key, hash, valueRef, value4));
        LocalCacheTest.assertSame((Object)value4, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        notification = (RemovalNotification)listener.remove();
        LocalCacheTest.assertEquals((Object)Maps.immutableEntry((Object)key, (Object)value3), (Object)notification);
        LocalCacheTest.assertEquals((Object)RemovalCause.REPLACED, (Object)notification.getCause());
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
        entry.setValueReference(valueRef);
        table.set(index, entry);
        LocalCacheTest.assertSame((Object)value3, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        value3Ref.clear();
        LocalCacheTest.assertTrue((boolean)segment.storeLoadedValue(key, hash, valueRef, value4));
        LocalCacheTest.assertSame((Object)value4, (Object)segment.get(key, hash));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        notification = (RemovalNotification)listener.remove();
        LocalCacheTest.assertEquals((Object)Maps.immutableEntry((Object)key, null), (Object)notification);
        LocalCacheTest.assertEquals((Object)RemovalCause.COLLECTED, (Object)notification.getCause());
        LocalCacheTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testSegmentRemove() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.remove(key, hash));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.remove(key, hash));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertNull((Object)segment.remove(key, hash));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentRemoveValue() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue);
        entry.setValueReference(oldValueRef);
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.remove(key, hash));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertTrue((boolean)segment.remove(key, hash, oldValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        ++segment.count;
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertFalse((boolean)segment.remove(key, hash, newValue));
        LocalCacheTest.assertEquals((int)1, (int)segment.count);
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        LocalCacheTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        LocalCacheTest.assertFalse((boolean)segment.remove(key, hash, oldValue));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull((Object)segment.get(key, hash));
    }

    public void testExpand() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1));
        LocalCache.Segment segment = map.segments[0];
        LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        LocalCache.ReferenceEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            entry = map.newEntry(key, hash, entry);
            LocalCache.ValueReference valueRef = map.newValueReference(entry, value, 1);
            entry.setValueReference(valueRef);
        }
        segment.table.set(0, entry);
        segment.count = originalCount;
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        LocalCacheTest.assertEquals((int)originalCount, (int)originalMap.size());
        LocalCacheTest.assertEquals((Object)originalMap, map);
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            LocalCacheTest.assertEquals((int)i, (int)segment.table.length());
            LocalCacheTest.assertEquals((int)originalCount, (int)LocalCacheTest.countLiveEntries(map, 0L));
            LocalCacheTest.assertEquals((int)originalCount, (int)segment.count);
            LocalCacheTest.assertEquals((Object)originalMap, map);
        }
    }

    public void testGetCausesExpansion() throws ExecutionException {
        for (int count = 1; count <= 100; ++count) {
            LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1));
            LocalCache.Segment segment = map.segments[0];
            LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
            for (int i = 0; i < count; ++i) {
                Object key = new Object();
                final Object value = new Object();
                segment.get(key, key.hashCode(), (CacheLoader)new CacheLoader<Object, Object>(){

                    public Object load(Object key) {
                        return value;
                    }
                });
            }
            LocalCacheTest.assertEquals((int)count, (int)segment.count);
            LocalCacheTest.assertTrue((count <= segment.threshold ? 1 : 0) != 0);
            LocalCacheTest.assertTrue((count <= segment.table.length() * 3 / 4 ? 1 : 0) != 0);
            LocalCacheTest.assertTrue((count > segment.table.length() * 3 / 8 ? 1 : 0) != 0);
        }
    }

    public void testPutCausesExpansion() {
        for (int count = 1; count <= 100; ++count) {
            LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1));
            LocalCache.Segment segment = map.segments[0];
            LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
            for (int i = 0; i < count; ++i) {
                Object key = new Object();
                Object value = new Object();
                segment.put(key, key.hashCode(), value, true);
            }
            LocalCacheTest.assertEquals((int)count, (int)segment.count);
            LocalCacheTest.assertTrue((count <= segment.threshold ? 1 : 0) != 0);
            LocalCacheTest.assertTrue((count <= segment.table.length() * 3 / 4 ? 1 : 0) != 0);
            LocalCacheTest.assertTrue((count > segment.table.length() * 3 / 8 ? 1 : 0) != 0);
        }
    }

    public void testReclaimKey() {
        TestingRemovalListeners.CountingRemovalListener listener = TestingRemovalListeners.countingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(listener));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object keyOne = new Object();
        Object valueOne = new Object();
        int hashOne = map.hash(keyOne);
        DummyEntry<Object, Object> entryOne = LocalCacheTest.createDummyEntry(keyOne, hashOne, valueOne, null);
        Object keyTwo = new Object();
        Object valueTwo = new Object();
        int hashTwo = map.hash(keyTwo);
        DummyEntry<Object, Object> entryTwo = LocalCacheTest.createDummyEntry(keyTwo, hashTwo, valueTwo, entryOne);
        Object keyThree = new Object();
        Object valueThree = new Object();
        int hashThree = map.hash(keyThree);
        DummyEntry<Object, Object> entryThree = LocalCacheTest.createDummyEntry(keyThree, hashThree, valueThree, entryTwo);
        LocalCacheTest.assertEquals((int)0, (int)listener.getCount());
        LocalCacheTest.assertFalse((boolean)segment.reclaimKey(entryOne, hashOne));
        LocalCacheTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryOne);
        LocalCacheTest.assertFalse((boolean)segment.reclaimKey(entryTwo, hashTwo));
        LocalCacheTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryTwo);
        LocalCacheTest.assertFalse((boolean)segment.reclaimKey(entryThree, hashThree));
        LocalCacheTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryOne);
        segment.count = 1;
        LocalCacheTest.assertTrue((boolean)segment.reclaimKey(entryOne, hashOne));
        LocalCacheTest.assertEquals((int)1, (int)listener.getCount());
        LocalCacheTest.assertSame((Object)keyOne, listener.getLastEvictedKey());
        LocalCacheTest.assertSame((Object)valueOne, listener.getLastEvictedValue());
        LocalCacheTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        LocalCacheTest.assertFalse((boolean)segment.accessQueue.contains(entryOne));
        LocalCacheTest.assertFalse((boolean)segment.writeQueue.contains(entryOne));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull(table.get(0));
    }

    public void testRemoveEntryFromChain() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1));
        LocalCache.Segment segment = map.segments[0];
        Object keyOne = new Object();
        Object valueOne = new Object();
        int hashOne = map.hash(keyOne);
        DummyEntry<Object, Object> entryOne = LocalCacheTest.createDummyEntry(keyOne, hashOne, valueOne, null);
        Object keyTwo = new Object();
        Object valueTwo = new Object();
        int hashTwo = map.hash(keyTwo);
        DummyEntry<Object, Object> entryTwo = LocalCacheTest.createDummyEntry(keyTwo, hashTwo, valueTwo, entryOne);
        Object keyThree = new Object();
        Object valueThree = new Object();
        int hashThree = map.hash(keyThree);
        DummyEntry<Object, Object> entryThree = LocalCacheTest.createDummyEntry(keyThree, hashThree, valueThree, entryTwo);
        LocalCacheTest.assertNull((Object)segment.removeEntryFromChain(entryOne, entryOne));
        LocalCacheTest.assertSame(entryOne, (Object)segment.removeEntryFromChain(entryTwo, entryTwo));
        LocalCache.ReferenceEntry newFirst = segment.removeEntryFromChain(entryThree, entryTwo);
        LocalCacheTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        LocalCacheTest.assertSame((Object)valueThree, (Object)newFirst.getValueReference().get());
        LocalCacheTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        LocalCacheTest.assertSame(entryOne, (Object)newFirst.getNext());
        newFirst = segment.removeEntryFromChain(entryThree, entryOne);
        LocalCacheTest.assertSame((Object)keyTwo, (Object)newFirst.getKey());
        LocalCacheTest.assertSame((Object)valueTwo, (Object)newFirst.getValueReference().get());
        LocalCacheTest.assertEquals((int)hashTwo, (int)newFirst.getHash());
        newFirst = newFirst.getNext();
        LocalCacheTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        LocalCacheTest.assertSame((Object)valueThree, (Object)newFirst.getValueReference().get());
        LocalCacheTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        LocalCacheTest.assertNull((Object)newFirst.getNext());
    }

    public void testExpand_cleanup() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1));
        LocalCache.Segment segment = map.segments[0];
        LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        DummyEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = i % 3 == 0 ? null : new Object();
            int hash = map.hash(key);
            if (i % 3 == 1) {
                key = null;
            }
            entry = DummyEntry.create(key, hash, entry);
            DummyValueReference valueRef = DummyValueReference.create(value);
            entry.setValueReference(valueRef);
        }
        segment.table.set(0, entry);
        segment.count = originalCount;
        int liveCount = originalCount / 3;
        LocalCacheTest.assertEquals((int)1, (int)segment.table.length());
        LocalCacheTest.assertEquals((int)liveCount, (int)LocalCacheTest.countLiveEntries(map, 0L));
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        LocalCacheTest.assertEquals((int)liveCount, (int)originalMap.size());
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            LocalCacheTest.assertEquals((int)i, (int)segment.table.length());
            LocalCacheTest.assertEquals((int)liveCount, (int)LocalCacheTest.countLiveEntries(map, 0L));
            LocalCacheTest.assertTrue((segment.count >= liveCount ? 1 : 0) != 0);
            LocalCacheTest.assertTrue((segment.count <= originalCount ? 1 : 0) != 0);
            LocalCacheTest.assertEquals((Object)originalMap, (Object)ImmutableMap.copyOf(map));
        }
    }

    private static <K, V> int countLiveEntries(LocalCache<K, V> map, long now) {
        int result = 0;
        for (LocalCache.Segment segment : map.segments) {
            AtomicReferenceArray table = segment.table;
            for (int i = 0; i < table.length(); ++i) {
                for (LocalCache.ReferenceEntry e = (LocalCache.ReferenceEntry)table.get(i); e != null; e = e.getNext()) {
                    if (!map.isLive(e, now)) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public void testClear() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = LocalCacheTest.createDummyEntry(key, hash, value, null);
        segment.recordWrite(entry, 1, map.ticker.read());
        segment.table.set(0, entry);
        segment.readCount.incrementAndGet();
        segment.count = 1;
        segment.totalWeight = 1;
        LocalCacheTest.assertSame(entry, table.get(0));
        LocalCacheTest.assertSame(entry, segment.accessQueue.peek());
        LocalCacheTest.assertSame(entry, segment.writeQueue.peek());
        segment.clear();
        LocalCacheTest.assertNull(table.get(0));
        LocalCacheTest.assertTrue((boolean)segment.accessQueue.isEmpty());
        LocalCacheTest.assertTrue((boolean)segment.writeQueue.isEmpty());
        LocalCacheTest.assertEquals((int)0, (int)segment.readCount.get());
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertEquals((int)0, (int)segment.totalWeight);
    }

    public void testClear_notification() {
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(listener));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = LocalCacheTest.createDummyEntry(key, hash, value, null);
        segment.recordWrite(entry, 1, map.ticker.read());
        segment.table.set(0, entry);
        segment.readCount.incrementAndGet();
        segment.count = 1;
        segment.totalWeight = 1;
        LocalCacheTest.assertSame(entry, table.get(0));
        LocalCacheTest.assertSame(entry, segment.accessQueue.peek());
        LocalCacheTest.assertSame(entry, segment.writeQueue.peek());
        segment.clear();
        LocalCacheTest.assertNull(table.get(0));
        LocalCacheTest.assertTrue((boolean)segment.accessQueue.isEmpty());
        LocalCacheTest.assertTrue((boolean)segment.writeQueue.isEmpty());
        LocalCacheTest.assertEquals((int)0, (int)segment.readCount.get());
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertEquals((int)0, (int)segment.totalWeight);
        LocalCacheTest.assertNotified(listener, key, value, RemovalCause.EXPLICIT);
    }

    public void testRemoveEntry() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(TestingRemovalListeners.countingRemovalListener()));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = LocalCacheTest.createDummyEntry(key, hash, value, null);
        LocalCacheTest.assertFalse((boolean)segment.removeEntry(entry, hash, RemovalCause.COLLECTED));
        segment.recordWrite(entry, 1, map.ticker.read());
        table.set(0, entry);
        segment.count = 1;
        LocalCacheTest.assertTrue((boolean)segment.removeEntry(entry, hash, RemovalCause.COLLECTED));
        LocalCacheTest.assertNotificationEnqueued(map, key, value, hash);
        LocalCacheTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        LocalCacheTest.assertFalse((boolean)segment.accessQueue.contains(entry));
        LocalCacheTest.assertFalse((boolean)segment.writeQueue.contains(entry));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull(table.get(0));
    }

    public void testReclaimValue() {
        TestingRemovalListeners.CountingRemovalListener listener = TestingRemovalListeners.countingRemovalListener();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(listener));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference valueRef = DummyValueReference.create(value);
        entry.setValueReference(valueRef);
        LocalCacheTest.assertFalse((boolean)segment.reclaimValue(key, hash, valueRef));
        segment.recordWrite(entry, 1, map.ticker.read());
        table.set(0, entry);
        segment.count = 1;
        LocalCacheTest.assertTrue((boolean)segment.reclaimValue(key, hash, valueRef));
        LocalCacheTest.assertEquals((int)1, (int)listener.getCount());
        LocalCacheTest.assertSame((Object)key, listener.getLastEvictedKey());
        LocalCacheTest.assertSame((Object)value, listener.getLastEvictedValue());
        LocalCacheTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        LocalCacheTest.assertFalse((boolean)segment.accessQueue.contains(entry));
        LocalCacheTest.assertFalse((boolean)segment.writeQueue.contains(entry));
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull(table.get(0));
        table.set(0, entry);
        DummyValueReference otherValueRef = DummyValueReference.create(value);
        entry.setValueReference(otherValueRef);
        LocalCacheTest.assertFalse((boolean)segment.reclaimValue(key, hash, valueRef));
        LocalCacheTest.assertEquals((int)1, (int)listener.getCount());
        LocalCacheTest.assertTrue((boolean)segment.reclaimValue(key, hash, otherValueRef));
        LocalCacheTest.assertEquals((int)2, (int)listener.getCount());
        LocalCacheTest.assertSame((Object)key, listener.getLastEvictedKey());
        LocalCacheTest.assertSame((Object)value, listener.getLastEvictedValue());
    }

    public void testRemoveComputingValue() {
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).initialCapacity(1).maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(TestingRemovalListeners.countingRemovalListener()));
        LocalCache.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        LocalCacheTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        LocalCache.LoadingValueReference valueRef = new LocalCache.LoadingValueReference();
        entry.setValueReference((LocalCache.ValueReference<Object, Object>)valueRef);
        LocalCacheTest.assertFalse((boolean)segment.removeLoadingValue(key, hash, valueRef));
        table.set(0, entry);
        LocalCacheTest.assertTrue((boolean)segment.removeLoadingValue(key, hash, valueRef));
        LocalCacheTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        LocalCacheTest.assertEquals((int)0, (int)segment.count);
        LocalCacheTest.assertNull(table.get(0));
        Object value = new Object();
        DummyValueReference previousRef = DummyValueReference.create(value);
        valueRef = new LocalCache.LoadingValueReference(previousRef);
        entry.setValueReference((LocalCache.ValueReference<Object, Object>)valueRef);
        table.set(0, entry);
        segment.count = 1;
        LocalCacheTest.assertTrue((boolean)segment.removeLoadingValue(key, hash, valueRef));
        LocalCacheTest.assertSame(entry, table.get(0));
        LocalCacheTest.assertSame((Object)value, (Object)segment.get(key, hash));
        table.set(0, entry);
        DummyValueReference otherValueRef = DummyValueReference.create(value);
        entry.setValueReference(otherValueRef);
        LocalCacheTest.assertFalse((boolean)segment.removeLoadingValue(key, hash, valueRef));
        entry.setValueReference((LocalCache.ValueReference<Object, Object>)valueRef);
        LocalCacheTest.assertTrue((boolean)segment.removeLoadingValue(key, hash, valueRef));
    }

    private static <K, V> void assertNotificationEnqueued(LocalCache<K, V> map, K key, V value, int hash) {
        RemovalNotification notification = (RemovalNotification)map.removalNotificationQueue.poll();
        LocalCacheTest.assertSame(key, (Object)notification.getKey());
        LocalCacheTest.assertSame(value, (Object)notification.getValue());
    }

    public void testDrainRecencyQueueOnWrite() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            if (segment.recencyQueue == LocalCache.DISCARDING_QUEUE) continue;
            Object keyOne = new Object();
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (int i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            LocalCacheTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            map.put(keyTwo, valueTwo);
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
        }
    }

    public void testDrainRecencyQueueOnRead() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            int i;
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            if (segment.recencyQueue == LocalCache.DISCARDING_QUEUE) continue;
            Object keyOne = new Object();
            Object valueOne = new Object();
            map.put(keyOne, valueOne);
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            LocalCacheTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 126; ++i) {
                map.get(keyOne);
                LocalCacheTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            for (i = 0; i < 126; ++i) {
                map.put(new Object(), new Object());
            }
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            LocalCacheTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            for (Object key : map.keySet()) {
                map.get(key);
                LocalCacheTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
        }
    }

    public void testRecordRead() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                DummyEntry<Object, Object> entry = LocalCacheTest.createDummyEntry(key, hash, value, null);
                segment.recordWrite(entry, 1, map.ticker.read());
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                LocalCache.ReferenceEntry entry = (LocalCache.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                segment.recordRead(entry, map.ticker.read());
                reads.add(entry);
                i.remove();
            }
            LocalCacheTest.checkAndDrainRecencyQueue(map, segment, reads);
            readOrder.addAll(reads);
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
        }
    }

    public void testRecordReadOnGet() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                map.put(key, value);
                LocalCache.ReferenceEntry entry = segment.getEntry(key, hash);
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
            LocalCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                LocalCache.ReferenceEntry entry = (LocalCache.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                map.get(entry.getKey());
                reads.add(entry);
                i.remove();
                LocalCacheTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            int undrainedIndex = reads.size() - segment.recencyQueue.size();
            LocalCacheTest.checkAndDrainRecencyQueue(map, segment, reads.subList(undrainedIndex, reads.size()));
            readOrder.addAll(reads);
            LocalCacheTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
        }
    }

    public void testRecordWrite() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allEvictingMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            LocalCache.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                DummyEntry<Object, Object> entry = LocalCacheTest.createDummyEntry(key, hash, value, null);
                segment.recordWrite(entry, 1, map.ticker.read());
                writeOrder.add(entry);
            }
            LocalCacheTest.checkEvictionQueues(map, segment, writeOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
            Random random = new Random();
            ArrayList writes = Lists.newArrayList();
            Iterator i = writeOrder.iterator();
            while (i.hasNext()) {
                LocalCache.ReferenceEntry entry = (LocalCache.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                segment.recordWrite(entry, 1, map.ticker.read());
                writes.add(entry);
                i.remove();
            }
            writeOrder.addAll(writes);
            LocalCacheTest.checkEvictionQueues(map, segment, writeOrder, writeOrder);
            LocalCacheTest.checkExpirationTimes(map);
        }
    }

    static <K, V> void checkAndDrainRecencyQueue(LocalCache<K, V> map, LocalCache.Segment<K, V> segment, List<LocalCache.ReferenceEntry<K, V>> reads) {
        if (map.evictsBySize() || map.expiresAfterAccess()) {
            LocalCacheTest.assertSameEntries(reads, ImmutableList.copyOf((Collection)segment.recencyQueue));
        }
        segment.drainRecencyQueue();
    }

    static <K, V> void checkEvictionQueues(LocalCache<K, V> map, LocalCache.Segment<K, V> segment, List<LocalCache.ReferenceEntry<K, V>> readOrder, List<LocalCache.ReferenceEntry<K, V>> writeOrder) {
        if (map.evictsBySize() || map.expiresAfterAccess()) {
            LocalCacheTest.assertSameEntries(readOrder, ImmutableList.copyOf((Collection)segment.accessQueue));
        }
        if (map.expiresAfterWrite()) {
            LocalCacheTest.assertSameEntries(writeOrder, ImmutableList.copyOf((Collection)segment.writeQueue));
        }
    }

    private static <K, V> void assertSameEntries(List<LocalCache.ReferenceEntry<K, V>> expectedEntries, List<LocalCache.ReferenceEntry<K, V>> actualEntries) {
        int size = expectedEntries.size();
        LocalCacheTest.assertEquals((int)size, (int)actualEntries.size());
        for (int i = 0; i < size; ++i) {
            LocalCache.ReferenceEntry<K, V> expectedEntry = expectedEntries.get(i);
            LocalCache.ReferenceEntry<K, V> actualEntry = actualEntries.get(i);
            LocalCacheTest.assertSame((Object)expectedEntry.getKey(), (Object)actualEntry.getKey());
            LocalCacheTest.assertSame((Object)expectedEntry.getValueReference().get(), (Object)actualEntry.getValueReference().get());
        }
    }

    static <K, V> void checkExpirationTimes(LocalCache<K, V> map) {
        if (!map.expires()) {
            return;
        }
        for (LocalCache.Segment segment : map.segments) {
            long accessTime;
            long lastAccessTime = 0L;
            long lastWriteTime = 0L;
            for (LocalCache.ReferenceEntry e : segment.recencyQueue) {
                accessTime = e.getAccessTime();
                LocalCacheTest.assertTrue((accessTime >= lastAccessTime ? 1 : 0) != 0);
                lastAccessTime = accessTime;
                long writeTime = e.getWriteTime();
                LocalCacheTest.assertTrue((writeTime >= lastWriteTime ? 1 : 0) != 0);
                lastWriteTime = writeTime;
            }
            lastAccessTime = 0L;
            lastWriteTime = 0L;
            for (LocalCache.ReferenceEntry e : segment.accessQueue) {
                accessTime = e.getAccessTime();
                LocalCacheTest.assertTrue((accessTime >= lastAccessTime ? 1 : 0) != 0);
                lastAccessTime = accessTime;
            }
            for (LocalCache.ReferenceEntry e : segment.writeQueue) {
                long writeTime = e.getWriteTime();
                LocalCacheTest.assertTrue((writeTime >= lastWriteTime ? 1 : 0) != 0);
                lastWriteTime = writeTime;
            }
        }
    }

    public void testExpireAfterWrite() {
        FakeTicker ticker = new FakeTicker();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).ticker((Ticker)ticker).expireAfterWrite(2L, TimeUnit.NANOSECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        Object value = new Object();
        map.put(key, value);
        LocalCache.ReferenceEntry entry = map.getEntry(key);
        LocalCacheTest.assertTrue((boolean)map.isLive(entry, ticker.read()));
        segment.writeQueue.add(entry);
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key));
        LocalCacheTest.assertSame((Object)entry, segment.writeQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.writeQueue.size());
        segment.recordRead(entry, ticker.read());
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key));
        LocalCacheTest.assertSame((Object)entry, segment.writeQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.writeQueue.size());
        ticker.advance(1L);
        segment.recordRead(entry, ticker.read());
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key));
        LocalCacheTest.assertSame((Object)entry, segment.writeQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.writeQueue.size());
        ticker.advance(1L);
        LocalCacheTest.assertNull((Object)map.get(key));
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertNull((Object)map.get(key));
        LocalCacheTest.assertTrue((boolean)segment.writeQueue.isEmpty());
    }

    public void testExpireAfterAccess() {
        FakeTicker ticker = new FakeTicker();
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).ticker((Ticker)ticker).expireAfterAccess(2L, TimeUnit.NANOSECONDS));
        LocalCache.Segment segment = map.segments[0];
        Object key = new Object();
        Object value = new Object();
        map.put(key, value);
        LocalCache.ReferenceEntry entry = map.getEntry(key);
        LocalCacheTest.assertTrue((boolean)map.isLive(entry, ticker.read()));
        segment.accessQueue.add(entry);
        LocalCacheTest.assertSame((Object)value, (Object)map.get(key));
        LocalCacheTest.assertSame((Object)entry, segment.accessQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.accessQueue.size());
        segment.recordRead(entry, ticker.read());
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertTrue((boolean)map.containsKey(key));
        LocalCacheTest.assertSame((Object)entry, segment.accessQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.accessQueue.size());
        ticker.advance(1L);
        segment.recordRead(entry, ticker.read());
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertTrue((boolean)map.containsKey(key));
        LocalCacheTest.assertSame((Object)entry, segment.accessQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.accessQueue.size());
        ticker.advance(1L);
        segment.recordRead(entry, ticker.read());
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertTrue((boolean)map.containsKey(key));
        LocalCacheTest.assertSame((Object)entry, segment.accessQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.accessQueue.size());
        ticker.advance(1L);
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertTrue((boolean)map.containsKey(key));
        LocalCacheTest.assertSame((Object)entry, segment.accessQueue.peek());
        LocalCacheTest.assertEquals((int)1, (int)segment.accessQueue.size());
        ticker.advance(1L);
        LocalCacheTest.assertFalse((boolean)map.containsKey(key));
        LocalCacheTest.assertNull((Object)map.get(key));
        segment.expireEntries(ticker.read());
        LocalCacheTest.assertFalse((boolean)map.containsKey(key));
        LocalCacheTest.assertNull((Object)map.get(key));
        LocalCacheTest.assertTrue((boolean)segment.accessQueue.isEmpty());
    }

    public void testEvictEntries() {
        int maxSize = 10;
        LocalCache map = LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder().concurrencyLevel(1).maximumSize((long)maxSize));
        LocalCache.Segment segment = map.segments[0];
        int originalCount = 1024;
        LocalCache.ReferenceEntry entry = null;
        LinkedHashMap originalMap = Maps.newLinkedHashMap();
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            AtomicReferenceArray table = segment.table;
            int hash = map.hash(key);
            int index = hash & table.length() - 1;
            LocalCache.ReferenceEntry first = (LocalCache.ReferenceEntry)table.get(index);
            entry = map.newEntry(key, hash, first);
            LocalCache.ValueReference valueRef = map.newValueReference(entry, value, 1);
            entry.setValueReference(valueRef);
            segment.recordWrite(entry, 1, map.ticker.read());
            table.set(index, entry);
            originalMap.put(key, value);
        }
        segment.count = originalCount;
        segment.totalWeight = originalCount;
        LocalCacheTest.assertEquals((int)originalCount, (int)map.size());
        LocalCacheTest.assertEquals((Object)originalMap, map);
        Iterator it = originalMap.keySet().iterator();
        for (int i = 0; i < originalCount - maxSize; ++i) {
            it.next();
            it.remove();
        }
        segment.evictEntries();
        LocalCacheTest.assertEquals((int)maxSize, (int)map.size());
        LocalCacheTest.assertEquals((Object)originalMap, map);
    }

    public void testDrainKeyReferenceQueueOnWrite() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            if (!map.usesKeyReferences()) continue;
            LocalCache.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            LocalCache.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            LocalCacheTest.assertFalse((boolean)map.containsKey(keyOne));
            LocalCacheTest.assertFalse((boolean)map.containsValue(valueOne));
            LocalCacheTest.assertNull((Object)map.get(keyOne));
            LocalCacheTest.assertEquals((int)1, (int)map.size());
            LocalCacheTest.assertNull(segment.keyReferenceQueue.poll());
        }
    }

    public void testDrainValueReferenceQueueOnWrite() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            if (!map.usesValueReferences()) continue;
            LocalCache.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            LocalCache.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            LocalCache.ValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            LocalCacheTest.assertFalse((boolean)map.containsKey(keyOne));
            LocalCacheTest.assertFalse((boolean)map.containsValue(valueOne));
            LocalCacheTest.assertNull((Object)map.get(keyOne));
            LocalCacheTest.assertEquals((int)1, (int)map.size());
            LocalCacheTest.assertNull(segment.valueReferenceQueue.poll());
        }
    }

    public void testDrainKeyReferenceQueueOnRead() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            if (!map.usesKeyReferences()) continue;
            LocalCache.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            LocalCache.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                map.get(keyTwo);
            }
            LocalCacheTest.assertFalse((boolean)map.containsKey(keyOne));
            LocalCacheTest.assertFalse((boolean)map.containsValue(valueOne));
            LocalCacheTest.assertNull((Object)map.get(keyOne));
            LocalCacheTest.assertEquals((int)0, (int)map.size());
            LocalCacheTest.assertNull(segment.keyReferenceQueue.poll());
        }
    }

    public void testDrainValueReferenceQueueOnRead() {
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            LocalCache map = LocalCacheTest.makeLocalCache(builder.concurrencyLevel(1));
            if (!map.usesValueReferences()) continue;
            LocalCache.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            LocalCache.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            LocalCache.ValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                map.get(keyTwo);
            }
            LocalCacheTest.assertFalse((boolean)map.containsKey(keyOne));
            LocalCacheTest.assertFalse((boolean)map.containsValue(valueOne));
            LocalCacheTest.assertNull((Object)map.get(keyOne));
            LocalCacheTest.assertEquals((int)0, (int)map.size());
            LocalCacheTest.assertNull(segment.valueReferenceQueue.poll());
        }
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods(LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder()));
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        tester.testAllPublicInstanceMethods(LocalCacheTest.makeLocalCache(LocalCacheTest.createCacheBuilder()));
    }

    public void testSerializationProxyLoading() {
        SerializableCacheLoader loader = new SerializableCacheLoader();
        SerializableRemovalListener listener = new SerializableRemovalListener();
        SerializableWeigher weigher = new SerializableWeigher();
        SerializableTicker ticker = new SerializableTicker();
        LocalCache.LocalLoadingCache one = (LocalCache.LocalLoadingCache)CacheBuilder.newBuilder().weakKeys().softValues().expireAfterAccess(123L, TimeUnit.SECONDS).expireAfterWrite(27360L, TimeUnit.SECONDS).maximumWeight(789L).weigher(weigher).concurrencyLevel(12).removalListener(listener).ticker((Ticker)ticker).build((CacheLoader)loader);
        one.getUnchecked(new Object());
        LocalCacheTest.assertEquals((long)1L, (long)one.size());
        LocalCacheTest.assertFalse((boolean)one.asMap().isEmpty());
        LocalCache.LocalLoadingCache two = (LocalCache.LocalLoadingCache)SerializableTester.reserialize((Object)one);
        LocalCacheTest.assertEquals((long)0L, (long)two.size());
        LocalCacheTest.assertTrue((boolean)two.asMap().isEmpty());
        LocalCache localCacheOne = one.localCache;
        LocalCache localCacheTwo = two.localCache;
        LocalCacheTest.assertEquals((Object)localCacheOne.keyStrength, (Object)localCacheTwo.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheOne.keyStrength, (Object)localCacheTwo.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheOne.valueEquivalence, (Object)localCacheTwo.valueEquivalence);
        LocalCacheTest.assertEquals((Object)localCacheOne.valueEquivalence, (Object)localCacheTwo.valueEquivalence);
        LocalCacheTest.assertEquals((long)localCacheOne.maxWeight, (long)localCacheTwo.maxWeight);
        LocalCacheTest.assertEquals((Object)localCacheOne.weigher, (Object)localCacheTwo.weigher);
        LocalCacheTest.assertEquals((long)localCacheOne.expireAfterAccessNanos, (long)localCacheTwo.expireAfterAccessNanos);
        LocalCacheTest.assertEquals((long)localCacheOne.expireAfterWriteNanos, (long)localCacheTwo.expireAfterWriteNanos);
        LocalCacheTest.assertEquals((long)localCacheOne.refreshNanos, (long)localCacheTwo.refreshNanos);
        LocalCacheTest.assertEquals((Object)localCacheOne.removalListener, (Object)localCacheTwo.removalListener);
        LocalCacheTest.assertEquals((Object)localCacheOne.ticker, (Object)localCacheTwo.ticker);
        LocalCache.LocalLoadingCache three = (LocalCache.LocalLoadingCache)SerializableTester.reserialize((Object)two);
        LocalCache localCacheThree = three.localCache;
        LocalCacheTest.assertEquals((Object)localCacheTwo.defaultLoader, (Object)localCacheThree.defaultLoader);
        LocalCacheTest.assertEquals((Object)localCacheTwo.keyStrength, (Object)localCacheThree.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheTwo.keyStrength, (Object)localCacheThree.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheTwo.valueEquivalence, (Object)localCacheThree.valueEquivalence);
        LocalCacheTest.assertEquals((Object)localCacheTwo.valueEquivalence, (Object)localCacheThree.valueEquivalence);
        LocalCacheTest.assertEquals((long)localCacheTwo.maxWeight, (long)localCacheThree.maxWeight);
        LocalCacheTest.assertEquals((Object)localCacheTwo.weigher, (Object)localCacheThree.weigher);
        LocalCacheTest.assertEquals((long)localCacheTwo.expireAfterAccessNanos, (long)localCacheThree.expireAfterAccessNanos);
        LocalCacheTest.assertEquals((long)localCacheTwo.expireAfterWriteNanos, (long)localCacheThree.expireAfterWriteNanos);
        LocalCacheTest.assertEquals((Object)localCacheTwo.removalListener, (Object)localCacheThree.removalListener);
        LocalCacheTest.assertEquals((Object)localCacheTwo.ticker, (Object)localCacheThree.ticker);
    }

    public void testSerializationProxyManual() {
        SerializableRemovalListener listener = new SerializableRemovalListener();
        SerializableWeigher weigher = new SerializableWeigher();
        SerializableTicker ticker = new SerializableTicker();
        LocalCache.LocalManualCache one = (LocalCache.LocalManualCache)CacheBuilder.newBuilder().weakKeys().softValues().expireAfterAccess(123L, TimeUnit.NANOSECONDS).maximumWeight(789L).weigher(weigher).concurrencyLevel(12).removalListener(listener).ticker((Ticker)ticker).build();
        one.put(new Object(), new Object());
        LocalCacheTest.assertEquals((long)1L, (long)one.size());
        LocalCacheTest.assertFalse((boolean)one.asMap().isEmpty());
        LocalCache.LocalManualCache two = (LocalCache.LocalManualCache)SerializableTester.reserialize((Object)one);
        LocalCacheTest.assertEquals((long)0L, (long)two.size());
        LocalCacheTest.assertTrue((boolean)two.asMap().isEmpty());
        LocalCache localCacheOne = one.localCache;
        LocalCache localCacheTwo = two.localCache;
        LocalCacheTest.assertEquals((Object)localCacheOne.keyStrength, (Object)localCacheTwo.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheOne.keyStrength, (Object)localCacheTwo.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheOne.valueEquivalence, (Object)localCacheTwo.valueEquivalence);
        LocalCacheTest.assertEquals((Object)localCacheOne.valueEquivalence, (Object)localCacheTwo.valueEquivalence);
        LocalCacheTest.assertEquals((long)localCacheOne.maxWeight, (long)localCacheTwo.maxWeight);
        LocalCacheTest.assertEquals((Object)localCacheOne.weigher, (Object)localCacheTwo.weigher);
        LocalCacheTest.assertEquals((long)localCacheOne.expireAfterAccessNanos, (long)localCacheTwo.expireAfterAccessNanos);
        LocalCacheTest.assertEquals((long)localCacheOne.expireAfterWriteNanos, (long)localCacheTwo.expireAfterWriteNanos);
        LocalCacheTest.assertEquals((Object)localCacheOne.removalListener, (Object)localCacheTwo.removalListener);
        LocalCacheTest.assertEquals((Object)localCacheOne.ticker, (Object)localCacheTwo.ticker);
        LocalCache.LocalManualCache three = (LocalCache.LocalManualCache)SerializableTester.reserialize((Object)two);
        LocalCache localCacheThree = three.localCache;
        LocalCacheTest.assertEquals((Object)localCacheTwo.keyStrength, (Object)localCacheThree.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheTwo.keyStrength, (Object)localCacheThree.keyStrength);
        LocalCacheTest.assertEquals((Object)localCacheTwo.valueEquivalence, (Object)localCacheThree.valueEquivalence);
        LocalCacheTest.assertEquals((Object)localCacheTwo.valueEquivalence, (Object)localCacheThree.valueEquivalence);
        LocalCacheTest.assertEquals((long)localCacheTwo.maxWeight, (long)localCacheThree.maxWeight);
        LocalCacheTest.assertEquals((Object)localCacheTwo.weigher, (Object)localCacheThree.weigher);
        LocalCacheTest.assertEquals((long)localCacheTwo.expireAfterAccessNanos, (long)localCacheThree.expireAfterAccessNanos);
        LocalCacheTest.assertEquals((long)localCacheTwo.expireAfterWriteNanos, (long)localCacheThree.expireAfterWriteNanos);
        LocalCacheTest.assertEquals((Object)localCacheTwo.removalListener, (Object)localCacheThree.removalListener);
        LocalCacheTest.assertEquals((Object)localCacheTwo.ticker, (Object)localCacheThree.ticker);
    }

    private static Iterable<CacheBuilder<Object, Object>> allEntryTypeMakers() {
        ArrayList result = Lists.newArrayList(LocalCacheTest.allKeyValueStrengthMakers());
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            result.add(builder.maximumSize(315L));
        }
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            result.add(builder.expireAfterAccess(99999L, TimeUnit.SECONDS));
        }
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            result.add(builder.expireAfterWrite(99999L, TimeUnit.SECONDS));
        }
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            result.add(builder.maximumSize(315L).expireAfterAccess(99999L, TimeUnit.SECONDS));
        }
        for (CacheBuilder<Object, Object> builder : LocalCacheTest.allKeyValueStrengthMakers()) {
            result.add(builder.maximumSize(315L).expireAfterWrite(99999L, TimeUnit.SECONDS));
        }
        return result;
    }

    static Iterable<CacheBuilder<Object, Object>> allEvictingMakers() {
        return ImmutableList.of((Object)LocalCacheTest.createCacheBuilder().maximumSize(315L), (Object)LocalCacheTest.createCacheBuilder().expireAfterAccess(99999L, TimeUnit.SECONDS), (Object)LocalCacheTest.createCacheBuilder().expireAfterWrite(99999L, TimeUnit.SECONDS), (Object)LocalCacheTest.createCacheBuilder().maximumSize(315L).expireAfterAccess(315L, TimeUnit.SECONDS), (Object)LocalCacheTest.createCacheBuilder().maximumSize(315L).expireAfterWrite(315L, TimeUnit.SECONDS));
    }

    private static Iterable<CacheBuilder<Object, Object>> allKeyValueStrengthMakers() {
        return ImmutableList.of(LocalCacheTest.createCacheBuilder(), (Object)LocalCacheTest.createCacheBuilder().weakValues(), (Object)LocalCacheTest.createCacheBuilder().softValues(), (Object)LocalCacheTest.createCacheBuilder().weakKeys(), (Object)LocalCacheTest.createCacheBuilder().weakKeys().weakValues(), (Object)LocalCacheTest.createCacheBuilder().weakKeys().softValues());
    }

    private static <K, V> DummyEntry<K, V> createDummyEntry(K key, int hash, V value, LocalCache.ReferenceEntry<K, V> next) {
        DummyEntry entry = DummyEntry.create(key, hash, next);
        DummyValueReference valueRef = DummyValueReference.create(value);
        entry.setValueReference(valueRef);
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableWeigher<K, V>
    implements Weigher<K, V>,
    Serializable {
        private SerializableWeigher() {
        }

        public int weigh(K key, V value) {
            return 42;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object o) {
            return o instanceof SerializableWeigher;
        }
    }

    private static class SerializableTicker
    extends Ticker
    implements Serializable {
        private SerializableTicker() {
        }

        public long read() {
            return 42L;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object o) {
            return o instanceof SerializableTicker;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableRemovalListener<K, V>
    implements RemovalListener<K, V>,
    Serializable {
        private SerializableRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object o) {
            return o instanceof SerializableRemovalListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableCacheLoader
    extends CacheLoader<Object, Object>
    implements Serializable {
        private SerializableCacheLoader() {
        }

        public Object load(Object key) {
            return new Object();
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object o) {
            return o instanceof SerializableCacheLoader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DummyValueReference<K, V>
    implements LocalCache.ValueReference<K, V> {
        private V value;
        boolean loading = false;

        public DummyValueReference() {
            this.loading = true;
        }

        public DummyValueReference(V value) {
            this.value = value;
        }

        public static <K, V> DummyValueReference<K, V> create(V value) {
            return new DummyValueReference<K, V>(value);
        }

        public static <K, V> DummyValueReference<K, V> createLoading() {
            return new DummyValueReference<K, V>();
        }

        public V get() {
            return this.value;
        }

        public int getWeight() {
            return 1;
        }

        public LocalCache.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        public LocalCache.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, LocalCache.ReferenceEntry<K, V> entry) {
            return this;
        }

        public void setLoading(boolean loading) {
            this.loading = loading;
        }

        public boolean isLoading() {
            return this.loading;
        }

        public boolean isActive() {
            return !this.loading;
        }

        public V waitForValue() {
            return this.get();
        }

        public void notifyNewValue(V newValue) {
        }

        public void clear() {
            this.value = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DummyEntry<K, V>
    implements LocalCache.ReferenceEntry<K, V> {
        private K key;
        private final int hash;
        private final LocalCache.ReferenceEntry<K, V> next;
        private LocalCache.ValueReference<K, V> valueReference = LocalCache.unset();
        private long accessTime = Long.MAX_VALUE;
        private LocalCache.ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        private LocalCache.ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        private long writeTime = Long.MAX_VALUE;
        private LocalCache.ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        private LocalCache.ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        public DummyEntry(K key, int hash, LocalCache.ReferenceEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        public static <K, V> DummyEntry<K, V> create(K key, int hash, LocalCache.ReferenceEntry<K, V> next) {
            return new DummyEntry<K, V>(key, hash, next);
        }

        public void clearKey() {
            this.key = null;
        }

        public LocalCache.ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        public void setValueReference(LocalCache.ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        public LocalCache.ReferenceEntry<K, V> getNext() {
            return this.next;
        }

        public int getHash() {
            return this.hash;
        }

        public K getKey() {
            return this.key;
        }

        public long getAccessTime() {
            return this.accessTime;
        }

        public void setAccessTime(long time) {
            this.accessTime = time;
        }

        public LocalCache.ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        public void setNextInAccessQueue(LocalCache.ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        public LocalCache.ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        public void setPreviousInAccessQueue(LocalCache.ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }

        public long getWriteTime() {
            return this.writeTime;
        }

        public void setWriteTime(long time) {
            this.writeTime = time;
        }

        public LocalCache.ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        public void setNextInWriteQueue(LocalCache.ReferenceEntry<K, V> next) {
            this.nextWrite = next;
        }

        public LocalCache.ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        public void setPreviousInWriteQueue(LocalCache.ReferenceEntry<K, V> previous) {
            this.previousWrite = previous;
        }
    }
}

