/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
class TestingRemovalListeners {
    TestingRemovalListeners() {
    }

    static <K, V> NullRemovalListener<K, V> nullRemovalListener() {
        return new NullRemovalListener();
    }

    @GwtIncompatible(value="ConcurrentLinkedQueue")
    static <K, V> QueuingRemovalListener<K, V> queuingRemovalListener() {
        return new QueuingRemovalListener();
    }

    static <K, V> CountingRemovalListener<K, V> countingRemovalListener() {
        return new CountingRemovalListener();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullRemovalListener<K, V>
    implements RemovalListener<K, V> {
        NullRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountingRemovalListener<K, V>
    implements RemovalListener<K, V> {
        private final AtomicInteger count = new AtomicInteger();
        private volatile RemovalNotification<K, V> lastNotification;

        CountingRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            this.count.incrementAndGet();
            this.lastNotification = notification;
        }

        public int getCount() {
            return this.count.get();
        }

        public K getLastEvictedKey() {
            return (K)this.lastNotification.getKey();
        }

        public V getLastEvictedValue() {
            return (V)this.lastNotification.getValue();
        }

        public RemovalNotification<K, V> getLastNotification() {
            return this.lastNotification;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="ConcurrentLinkedQueue")
    static class QueuingRemovalListener<K, V>
    extends ConcurrentLinkedQueue<RemovalNotification<K, V>>
    implements RemovalListener<K, V> {
        QueuingRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            this.add(notification);
        }
    }
}

