/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.Weigher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingWeighers {
    static Weigher<Object, Object> constantWeigher(int constant) {
        return new ConstantWeigher(constant);
    }

    static Weigher<Integer, Object> intKeyWeigher() {
        return new IntKeyWeigher();
    }

    static Weigher<Object, Integer> intValueWeigher() {
        return new IntValueWeigher();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntValueWeigher
    implements Weigher<Object, Integer> {
        IntValueWeigher() {
        }

        public int weigh(Object key, Integer value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntKeyWeigher
    implements Weigher<Integer, Object> {
        IntKeyWeigher() {
        }

        public int weigh(Integer key, Object value) {
            return key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConstantWeigher
    implements Weigher<Object, Object> {
        private final int constant;

        ConstantWeigher(int constant) {
            this.constant = constant;
        }

        public int weigh(Object key, Object value) {
            return this.constant;
        }
    }
}

