/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class AbstractSequentialIteratorTest
extends TestCase {
    @GwtIncompatible(value="Too slow")
    public void testDoublerExhaustive() {
        new IteratorTester<Integer>(3, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)ImmutableList.of((Object)1, (Object)2), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return AbstractSequentialIteratorTest.newDoubler(1, 2);
            }
        }.test();
    }

    public void testDoubler() {
        Iterable<Integer> doubled = new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return AbstractSequentialIteratorTest.newDoubler(2, 32);
            }
        };
        Truth.ASSERT.that((Iterable)doubled).iteratesOverSequence((Object[])new Integer[]{2, 4, 8, 16, 32});
    }

    public void testSampleCode() {
        Iterable<Integer> actual = new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                AbstractSequentialIterator<Integer> powersOfTwo = new AbstractSequentialIterator<Integer>(Integer.valueOf(1)){

                    protected Integer computeNext(Integer previous) {
                        return previous == 0x40000000 ? null : Integer.valueOf(previous * 2);
                    }
                };
                return powersOfTwo;
            }
        };
        Truth.ASSERT.that((Iterable)actual).iteratesOverSequence((Object[])new Integer[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000});
    }

    public void testEmpty() {
        Iterator empty = AbstractSequentialIteratorTest.newEmpty();
        AbstractSequentialIteratorTest.assertFalse((boolean)empty.hasNext());
        try {
            empty.next();
            AbstractSequentialIteratorTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            empty.remove();
            AbstractSequentialIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBroken() {
        Iterator<Object> broken = AbstractSequentialIteratorTest.newBroken();
        AbstractSequentialIteratorTest.assertTrue((boolean)broken.hasNext());
        try {
            broken.next();
            AbstractSequentialIteratorTest.fail();
        }
        catch (MyException expected) {
            // empty catch block
        }
        try {
            broken.next();
            AbstractSequentialIteratorTest.fail();
        }
        catch (MyException myException) {
            // empty catch block
        }
    }

    private static Iterator<Integer> newDoubler(int first, final int last) {
        return new AbstractSequentialIterator<Integer>(Integer.valueOf(first)){

            protected Integer computeNext(Integer previous) {
                return previous == last ? null : Integer.valueOf(previous * 2);
            }
        };
    }

    private static <T> Iterator<T> newEmpty() {
        return new AbstractSequentialIterator<T>(null){

            protected T computeNext(T previous) {
                throw new AssertionFailedError();
            }
        };
    }

    private static Iterator<Object> newBroken() {
        return new AbstractSequentialIterator<Object>((Object)"UNUSED"){

            protected Object computeNext(Object previous) {
                throw new MyException();
            }
        };
    }

    private static class MyException
    extends RuntimeException {
        private MyException() {
        }
    }
}

