/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.ListMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestListMultimapGenerator;
import com.google.common.collect.testing.google.TestStringListMultimapGenerator;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class ArrayListMultimapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new TestStringListMultimapGenerator(){

            protected ListMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                ArrayListMultimap multimap = ArrayListMultimap.create();
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }
        }).named("ArrayListMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        suite.addTestSuite(ArrayListMultimapTest.class);
        return suite;
    }

    protected ListMultimap<String, Integer> create() {
        return ArrayListMultimap.create();
    }

    public void testGetRandomAccess() {
        ListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        ArrayListMultimapTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        ArrayListMultimapTest.assertTrue((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    public void testRemoveAllRandomAccess() {
        ListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        ArrayListMultimapTest.assertTrue((boolean)(multimap.removeAll((Object)"foo") instanceof RandomAccess));
        ArrayListMultimapTest.assertTrue((boolean)(multimap.removeAll((Object)"bar") instanceof RandomAccess));
    }

    public void testReplaceValuesRandomAccess() {
        ListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        ArrayListMultimapTest.assertTrue((boolean)(multimap.replaceValues((Object)"foo", Arrays.asList(2, 4)) instanceof RandomAccess));
        ArrayListMultimapTest.assertTrue((boolean)(multimap.replaceValues((Object)"bar", Arrays.asList(2, 4)) instanceof RandomAccess));
    }

    public void testSublistConcurrentModificationException() {
        ListMultimap<String, Integer> multimap = this.create();
        multimap.putAll((Object)"foo", Arrays.asList(1, 2, 3, 4, 5));
        List list = multimap.get((Object)"foo");
        Truth.ASSERT.that(multimap.get((Object)"foo")).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3, 4, 5}).inOrder();
        List sublist = list.subList(0, 5);
        Truth.ASSERT.that(sublist).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3, 4, 5}).inOrder();
        sublist.clear();
        ArrayListMultimapTest.assertTrue((boolean)sublist.isEmpty());
        multimap.put((Object)"foo", (Object)6);
        try {
            sublist.isEmpty();
            ArrayListMultimapTest.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException expected) {
            // empty catch block
        }
    }

    public void testCreateFromMultimap() {
        ListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"bar", (Object)2);
        ArrayListMultimap copy = ArrayListMultimap.create(multimap);
        ArrayListMultimapTest.assertEquals(multimap, (Object)copy);
    }

    public void testCreate() {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        ArrayListMultimapTest.assertEquals((int)3, (int)multimap.expectedValuesPerKey);
    }

    public void testCreateFromSizes() {
        ArrayListMultimap multimap = ArrayListMultimap.create((int)15, (int)20);
        ArrayListMultimapTest.assertEquals((int)20, (int)multimap.expectedValuesPerKey);
    }

    public void testCreateFromIllegalSizes() {
        try {
            ArrayListMultimap.create((int)15, (int)-2);
            ArrayListMultimapTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ArrayListMultimap.create((int)-15, (int)2);
            ArrayListMultimapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateFromHashMultimap() {
        HashMultimap original = HashMultimap.create();
        ArrayListMultimap multimap = ArrayListMultimap.create((Multimap)original);
        ArrayListMultimapTest.assertEquals((int)3, (int)multimap.expectedValuesPerKey);
    }

    public void testCreateFromArrayListMultimap() {
        ArrayListMultimap original = ArrayListMultimap.create((int)15, (int)20);
        ArrayListMultimap multimap = ArrayListMultimap.create((Multimap)original);
        ArrayListMultimapTest.assertEquals((int)20, (int)multimap.expectedValuesPerKey);
    }

    public void testTrimToSize() {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)2);
        multimap.put((Object)"bar", (Object)3);
        multimap.trimToSize();
        ArrayListMultimapTest.assertEquals((int)3, (int)multimap.size());
        Truth.ASSERT.that(multimap.get((Object)"foo")).has().exactly((Object)1, (Object)2, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that(multimap.get((Object)"bar")).has().item((Object)3);
    }
}

