/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class ComparisonChainTest
extends TestCase {
    private static final DontCompareMe DONT_COMPARE_ME = new DontCompareMe();

    public void testDegenerate() {
        ComparisonChainTest.assertEquals((int)0, (int)ComparisonChain.start().result());
    }

    public void testOneEqual() {
        ComparisonChainTest.assertEquals((int)0, (int)ComparisonChain.start().compare((Comparable)((Object)"a"), (Comparable)((Object)"a")).result());
    }

    public void testOneEqualUsingComparator() {
        ComparisonChainTest.assertEquals((int)0, (int)ComparisonChain.start().compare((Object)"a", (Object)"A", String.CASE_INSENSITIVE_ORDER).result());
    }

    public void testManyEqual() {
        ComparisonChainTest.assertEquals((int)0, (int)ComparisonChain.start().compare(1, 1).compare(1L, 1L).compareFalseFirst(true, true).compare(1.0, 1.0).compare(1.0f, 1.0f).compare((Object)"a", (Object)"a", (Comparator)Ordering.usingToString()).result());
    }

    public void testShortCircuitLess() {
        ComparisonChainTest.assertTrue((ComparisonChain.start().compare((Comparable)((Object)"a"), (Comparable)((Object)"b")).compare((Comparable)DONT_COMPARE_ME, (Comparable)DONT_COMPARE_ME).result() < 0 ? 1 : 0) != 0);
    }

    public void testShortCircuitGreater() {
        ComparisonChainTest.assertTrue((ComparisonChain.start().compare((Comparable)((Object)"b"), (Comparable)((Object)"a")).compare((Comparable)DONT_COMPARE_ME, (Comparable)DONT_COMPARE_ME).result() > 0 ? 1 : 0) != 0);
    }

    public void testShortCircuitSecondStep() {
        ComparisonChainTest.assertTrue((ComparisonChain.start().compare((Comparable)((Object)"a"), (Comparable)((Object)"a")).compare((Comparable)((Object)"a"), (Comparable)((Object)"b")).compare((Comparable)DONT_COMPARE_ME, (Comparable)DONT_COMPARE_ME).result() < 0 ? 1 : 0) != 0);
    }

    public void testCompareFalseFirst() {
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareFalseFirst(true, true).result() == 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareFalseFirst(true, false).result() > 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareFalseFirst(false, true).result() < 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareFalseFirst(false, false).result() == 0 ? 1 : 0) != 0);
    }

    public void testCompareTrueFirst() {
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareTrueFirst(true, true).result() == 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareTrueFirst(true, false).result() < 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareTrueFirst(false, true).result() > 0 ? 1 : 0) != 0);
        ComparisonChainTest.assertTrue((ComparisonChain.start().compareTrueFirst(false, false).result() == 0 ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DontCompareMe
    implements Comparable<DontCompareMe> {
        private DontCompareMe() {
        }

        @Override
        public int compareTo(DontCompareMe o) {
            throw new AssertionFailedError();
        }
    }
}

