/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ComputingConcurrentHashMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.collect.MapMakerInternalMapTest;
import com.google.common.testing.NullPointerTester;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputingConcurrentHashMapTest
extends TestCase {
    private static <K, V> ComputingConcurrentHashMap<K, V> makeComputingMap(MapMaker maker, Function<? super K, ? extends V> computingFunction) {
        return new ComputingConcurrentHashMap(maker, computingFunction);
    }

    private static <K, V> MapMaker.ComputingMapAdapter<K, V> makeAdaptedMap(MapMaker maker, Function<? super K, ? extends V> computingFunction) {
        return new MapMaker.ComputingMapAdapter(maker, computingFunction);
    }

    private MapMaker createMapMaker() {
        MapMaker maker = new MapMaker();
        maker.useCustomMap = true;
        return maker;
    }

    public void testComputingFunction() {
        Function computingFunction = Functions.identity();
        ComputingConcurrentHashMap map = ComputingConcurrentHashMapTest.makeComputingMap(this.createMapMaker(), computingFunction);
        ComputingConcurrentHashMapTest.assertSame((Object)computingFunction, (Object)map.computingFunction);
    }

    public void testCompute() throws ExecutionException {
        CountingFunction computingFunction = new CountingFunction();
        ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(this.createMapMaker(), computingFunction);
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        Object key = new Object();
        Object value = map.getOrCompute(key);
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)computingFunction.getCount());
        ComputingConcurrentHashMapTest.assertEquals((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)computingFunction.getCount());
    }

    public void testComputeNull() {
        ConstantLoader computingFunction = new ConstantLoader(null);
        MapMaker.ComputingMapAdapter map = ComputingConcurrentHashMapTest.makeAdaptedMap(this.createMapMaker(), computingFunction);
        try {
            map.get(new Object());
            ComputingConcurrentHashMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRecordReadOnCompute() throws ExecutionException {
        CountingFunction computingFunction = new CountingFunction();
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            MapMakerInternalMap.ReferenceEntry entry;
            ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(maker.concurrencyLevel(1), computingFunction);
            MapMakerInternalMap.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 315; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                map.getOrCompute(key);
                entry = segment.getEntry(key, hash);
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
            ComputingConcurrentHashMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                entry = (MapMakerInternalMap.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                map.getOrCompute(entry.getKey());
                reads.add(entry);
                i.remove();
                ComputingConcurrentHashMapTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            int undrainedIndex = reads.size() - segment.recencyQueue.size();
            MapMakerInternalMapTest.checkAndDrainRecencyQueue(map, segment, reads.subList(undrainedIndex, reads.size()));
            readOrder.addAll(reads);
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
        }
    }

    public void testComputeExistingEntry() throws ExecutionException {
        CountingFunction computingFunction = new CountingFunction();
        ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(this.createMapMaker(), computingFunction);
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        Object key = new Object();
        Object value = new Object();
        map.put(key, value);
        ComputingConcurrentHashMapTest.assertEquals((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
    }

    public void testComputePartiallyCollectedKey() throws ExecutionException {
        MapMaker maker = this.createMapMaker().concurrencyLevel(1);
        CountingFunction computingFunction = new CountingFunction();
        ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(maker, computingFunction);
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        int index = hash & table.length() - 1;
        MapMakerInternalMapTest.DummyEntry<Object, Object> entry = MapMakerInternalMapTest.DummyEntry.create(key, hash, null);
        MapMakerInternalMapTest.DummyValueReference<Object, Object> valueRef = MapMakerInternalMapTest.DummyValueReference.create(value, entry);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        ++segment.count;
        ComputingConcurrentHashMapTest.assertSame((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)segment.count);
        entry.clearKey();
        ComputingConcurrentHashMapTest.assertNotSame((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)computingFunction.getCount());
        ComputingConcurrentHashMapTest.assertEquals((int)2, (int)segment.count);
    }

    public void testComputePartiallyCollectedValue() throws ExecutionException {
        MapMaker maker = this.createMapMaker().concurrencyLevel(1);
        CountingFunction computingFunction = new CountingFunction();
        ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(maker, computingFunction);
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        int index = hash & table.length() - 1;
        MapMakerInternalMapTest.DummyEntry<Object, Object> entry = MapMakerInternalMapTest.DummyEntry.create(key, hash, null);
        MapMakerInternalMapTest.DummyValueReference<Object, Object> valueRef = MapMakerInternalMapTest.DummyValueReference.create(value, entry);
        entry.setValueReference(valueRef);
        table.set(index, entry);
        ++segment.count;
        ComputingConcurrentHashMapTest.assertSame((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)segment.count);
        valueRef.clear(null);
        ComputingConcurrentHashMapTest.assertNotSame((Object)value, (Object)map.getOrCompute(key));
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)computingFunction.getCount());
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)segment.count);
    }

    public void testComputeExpiredEntry() throws ExecutionException {
        MapMaker maker = this.createMapMaker().expireAfterWrite(1L, TimeUnit.NANOSECONDS);
        CountingFunction computingFunction = new CountingFunction();
        ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(maker, computingFunction);
        ComputingConcurrentHashMapTest.assertEquals((int)0, (int)computingFunction.getCount());
        Object key = new Object();
        Object one = map.getOrCompute(key);
        ComputingConcurrentHashMapTest.assertEquals((int)1, (int)computingFunction.getCount());
        Object two = map.getOrCompute(key);
        ComputingConcurrentHashMapTest.assertNotSame((Object)one, (Object)two);
        ComputingConcurrentHashMapTest.assertEquals((int)2, (int)computingFunction.getCount());
    }

    public void testRemovalListener_replaced() {
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch computingSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(1);
        final Object computedObject = new Object();
        Function<Object, Object> computingFunction = new Function<Object, Object>(){

            public Object apply(Object key) {
                computingSignal.countDown();
                try {
                    startSignal.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return computedObject;
            }
        };
        MapMakerInternalMapTest.QueuingRemovalListener listener = new MapMakerInternalMapTest.QueuingRemovalListener();
        MapMaker maker = (MapMaker)this.createMapMaker().removalListener(listener);
        final ComputingConcurrentHashMap<Object, Object> map = ComputingConcurrentHashMapTest.makeComputingMap(maker, computingFunction);
        ComputingConcurrentHashMapTest.assertTrue((boolean)listener.isEmpty());
        final Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        new Thread(){

            public void run() {
                try {
                    map.getOrCompute(one);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                doneSignal.countDown();
            }
        }.start();
        try {
            computingSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        map.put(one, two);
        startSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ComputingConcurrentHashMapTest.assertNotNull((Object)map.putIfAbsent(one, three));
        MapMakerInternalMapTest.assertNotified(listener, one, computedObject, MapMaker.RemovalCause.REPLACED);
        ComputingConcurrentHashMapTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        IdentityLoader computingFunction = new IdentityLoader();
        tester.testAllPublicInstanceMethods(ComputingConcurrentHashMapTest.makeComputingMap(this.createMapMaker(), computingFunction));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IdentityLoader<T>
    implements Function<T, T> {
        IdentityLoader() {
        }

        public T apply(T key) {
            return key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConstantLoader<K, V>
    implements Function<K, V> {
        private final V constant;

        public ConstantLoader(V constant) {
            this.constant = constant;
        }

        public V apply(K key) {
            return this.constant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingFunction
    implements Function<Object, Object> {
        private final AtomicInteger count = new AtomicInteger();

        private CountingFunction() {
        }

        public Object apply(Object from) {
            this.count.incrementAndGet();
            return new Object();
        }

        public int getCount() {
            return this.count.get();
        }
    }
}

