/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ConcurrentHashMultisetTest
extends TestCase {
    private static final String KEY = "puppies";
    ConcurrentMap<String, AtomicInteger> backingMap;
    ConcurrentHashMultiset<String> multiset;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)ConcurrentHashMultisetTest.concurrentHashMultisetGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).named("ConcurrentHashMultiset")).createTestSuite());
        suite.addTestSuite(ConcurrentHashMultisetTest.class);
        return suite;
    }

    private static TestStringMultisetGenerator concurrentHashMultisetGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return ConcurrentHashMultiset.create(Arrays.asList(elements));
            }
        };
    }

    protected void setUp() {
        this.backingMap = (ConcurrentMap)EasyMock.createMock(ConcurrentMap.class);
        EasyMock.expect((Object)this.backingMap.isEmpty()).andReturn((Object)true);
        this.replay();
        this.multiset = new ConcurrentHashMultiset(this.backingMap);
        this.verify();
        this.reset();
    }

    public void testCount_elementPresent() {
        int COUNT = 12;
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)new AtomicInteger(12));
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)12, (int)this.multiset.count((Object)KEY));
        this.verify();
    }

    public void testCount_elementAbsent() {
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)this.multiset.count((Object)KEY));
        this.verify();
    }

    public void testAdd_zero() {
        int INITIAL_COUNT = 32;
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)new AtomicInteger(32));
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)32, (int)this.multiset.add((Object)KEY, 0));
        this.verify();
    }

    public void testAdd_firstFewWithSuccess() {
        int COUNT = 400;
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        EasyMock.expect((Object)this.backingMap.putIfAbsent((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn(null);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)this.multiset.add((Object)KEY, 400));
        this.verify();
    }

    public void testAdd_laterFewWithSuccess() {
        int INITIAL_COUNT = 32;
        int COUNT_TO_ADD = 400;
        AtomicInteger initial = new AtomicInteger(INITIAL_COUNT);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)initial);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)INITIAL_COUNT, (int)this.multiset.add((Object)KEY, COUNT_TO_ADD));
        ConcurrentHashMultisetTest.assertEquals((int)(INITIAL_COUNT + COUNT_TO_ADD), (int)initial.get());
        this.verify();
    }

    public void testAdd_laterFewWithOverflow() {
        int INITIAL_COUNT = 92384930;
        int COUNT_TO_ADD = 2055098718;
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)new AtomicInteger(92384930));
        this.replay();
        try {
            this.multiset.add((Object)KEY, 2055098718);
            ConcurrentHashMultisetTest.fail((String)"Must reject arguments that would cause counter overflow.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verify();
    }

    public void testAdd_withFailures() {
        AtomicInteger existing = new AtomicInteger(12);
        AtomicInteger existingZero = new AtomicInteger(0);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        EasyMock.expect((Object)this.backingMap.putIfAbsent((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn((Object)existingZero);
        EasyMock.expect((Object)this.backingMap.replace((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.eq((Object)existingZero), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn((Object)false);
        EasyMock.expect((Object)this.backingMap.putIfAbsent((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn((Object)existing);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)existingZero);
        EasyMock.expect((Object)this.backingMap.replace((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.eq((Object)existingZero), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn((Object)false);
        EasyMock.expect((Object)this.backingMap.putIfAbsent((String)EasyMock.eq((Object)KEY), (AtomicInteger)EasyMock.isA(AtomicInteger.class))).andReturn((Object)existing);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)existing);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)this.multiset.add((Object)KEY, 3), (int)12);
        ConcurrentHashMultisetTest.assertEquals((int)15, (int)existing.get());
        this.verify();
    }

    public void testRemove_zeroFromSome() {
        int INITIAL_COUNT = 14;
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)new AtomicInteger(14));
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)14, (int)this.multiset.remove((Object)KEY, 0));
        this.verify();
    }

    public void testRemove_zeroFromNone() {
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)this.multiset.remove((Object)KEY, 0));
        this.verify();
    }

    public void testRemove_nonePresent() {
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)this.multiset.remove((Object)KEY, 400));
        this.verify();
    }

    public void testRemove_someRemaining() {
        int countToRemove = 30;
        int countRemaining = 1;
        AtomicInteger current = new AtomicInteger(countToRemove + countRemaining);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)current);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)(countToRemove + countRemaining), (int)this.multiset.remove((Object)KEY, countToRemove));
        ConcurrentHashMultisetTest.assertEquals((int)countRemaining, (int)current.get());
        this.verify();
    }

    public void testRemove_noneRemaining() {
        int countToRemove = 30;
        AtomicInteger current = new AtomicInteger(countToRemove);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)current);
        EasyMock.expect((Object)this.backingMap.remove(KEY, current)).andReturn((Object)false);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)countToRemove, (int)this.multiset.remove((Object)KEY, countToRemove));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)current.get());
        this.verify();
    }

    public void testRemoveExactly() {
        ConcurrentHashMultiset cms = ConcurrentHashMultiset.create();
        cms.add((Object)"a", 2);
        cms.add((Object)"b", 3);
        try {
            cms.removeExactly((Object)"a", -2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConcurrentHashMultisetTest.assertTrue((boolean)cms.removeExactly((Object)"a", 0));
        ConcurrentHashMultisetTest.assertEquals((int)2, (int)cms.count((Object)"a"));
        ConcurrentHashMultisetTest.assertTrue((boolean)cms.removeExactly((Object)"c", 0));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)cms.count((Object)"c"));
        ConcurrentHashMultisetTest.assertFalse((boolean)cms.removeExactly((Object)"a", 4));
        ConcurrentHashMultisetTest.assertEquals((int)2, (int)cms.count((Object)"a"));
        ConcurrentHashMultisetTest.assertTrue((boolean)cms.removeExactly((Object)"a", 2));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)cms.count((Object)"a"));
        ConcurrentHashMultisetTest.assertTrue((boolean)cms.removeExactly((Object)"b", 2));
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)cms.count((Object)"b"));
    }

    public void testIteratorRemove_actualMap() {
        this.multiset = ConcurrentHashMultiset.create();
        this.multiset.add((Object)KEY);
        this.multiset.add((Object)"puppies_2");
        this.multiset.add((Object)KEY);
        int mutations = 0;
        Iterator it = this.multiset.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
            ++mutations;
        }
        ConcurrentHashMultisetTest.assertTrue((boolean)this.multiset.isEmpty());
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)mutations);
    }

    public void testSetCount_basic() {
        int initialCount = 20;
        int countToSet = 40;
        AtomicInteger current = new AtomicInteger(initialCount);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)current);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)initialCount, (int)this.multiset.setCount((Object)KEY, countToSet));
        ConcurrentHashMultisetTest.assertEquals((int)countToSet, (int)current.get());
        this.verify();
    }

    public void testSetCount_asRemove() {
        int countToRemove = 40;
        AtomicInteger current = new AtomicInteger(countToRemove);
        EasyMock.expect(this.backingMap.get(KEY)).andReturn((Object)current);
        EasyMock.expect((Object)this.backingMap.remove(KEY, current)).andReturn((Object)true);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)countToRemove, (int)this.multiset.setCount((Object)KEY, 0));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)current.get());
        this.verify();
    }

    public void testSetCount_0_nonePresent() {
        EasyMock.expect(this.backingMap.get(KEY)).andReturn(null);
        this.replay();
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)this.multiset.setCount((Object)KEY, 0));
        this.verify();
    }

    public void testCreate() {
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create();
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.isEmpty());
        SerializableTester.reserializeAndAssert((Object)multiset);
    }

    public void testCreateFromIterable() {
        List<Integer> iterable = Arrays.asList(1, 2, 2, 3, 4);
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create(iterable);
        ConcurrentHashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)2));
        SerializableTester.reserializeAndAssert((Object)multiset);
    }

    public void testIdentityKeyEquality_strongKeys() {
        this.testIdentityKeyEquality(MapMakerInternalMap.Strength.STRONG);
    }

    public void testIdentityKeyEquality_weakKeys() {
        this.testIdentityKeyEquality(MapMakerInternalMap.Strength.WEAK);
    }

    private void testIdentityKeyEquality(MapMakerInternalMap.Strength keyStrength) {
        MapMaker mapMaker = new MapMaker().setKeyStrength(keyStrength).keyEquivalence(Equivalence.identity());
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        String s1 = new String("a");
        String s2 = new String("a");
        ConcurrentHashMultisetTest.assertEquals((String)s1, (String)s2);
        ConcurrentHashMultisetTest.assertTrue((s1 != s2 ? 1 : 0) != 0);
        multiset.add((Object)s1);
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)s1));
        ConcurrentHashMultisetTest.assertFalse((boolean)multiset.contains((Object)s2));
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)multiset.count((Object)s2));
        multiset.add((Object)s1);
        multiset.add((Object)s2, 3);
        ConcurrentHashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)multiset.count((Object)s2));
        multiset.remove((Object)s1);
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)multiset.count((Object)s2));
    }

    public void testLogicalKeyEquality_strongKeys() {
        this.testLogicalKeyEquality(MapMakerInternalMap.Strength.STRONG);
    }

    public void testLogicalKeyEquality_weakKeys() {
        this.testLogicalKeyEquality(MapMakerInternalMap.Strength.WEAK);
    }

    private void testLogicalKeyEquality(MapMakerInternalMap.Strength keyStrength) {
        MapMaker mapMaker = new MapMaker().setKeyStrength(keyStrength).keyEquivalence(Equivalence.equals());
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        String s1 = new String("a");
        String s2 = new String("a");
        ConcurrentHashMultisetTest.assertEquals((String)s1, (String)s2);
        multiset.add((Object)s1);
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)s1));
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)s2));
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)multiset.count((Object)s2));
        multiset.add((Object)s2, 3);
        ConcurrentHashMultisetTest.assertEquals((int)4, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)4, (int)multiset.count((Object)s2));
        multiset.remove((Object)s1);
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)multiset.count((Object)s2));
    }

    public void testSerializationWithMapMaker1() {
        MapMaker mapMaker = new MapMaker();
        this.multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        SerializableTester.reserializeAndAssert(this.multiset);
    }

    public void testSerializationWithMapMaker2() {
        MapMaker mapMaker = new MapMaker();
        this.multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        this.multiset.addAll((Collection)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"b"));
        SerializableTester.reserializeAndAssert(this.multiset);
    }

    public void testSerializationWithMapMaker3() {
        MapMaker mapMaker = new MapMaker().expireAfterWrite(1L, TimeUnit.SECONDS);
        this.multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        this.multiset.addAll((Collection)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"b"));
        SerializableTester.reserializeAndAssert(this.multiset);
    }

    public void testSerializationWithMapMaker_preservesIdentityKeyEquivalence() {
        MapMaker mapMaker = new MapMaker().keyEquivalence(Equivalence.identity());
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        multiset = (ConcurrentHashMultiset)SerializableTester.reserializeAndAssert((Object)multiset);
        String s1 = new String("a");
        String s2 = new String("a");
        ConcurrentHashMultisetTest.assertEquals((String)s1, (String)s2);
        ConcurrentHashMultisetTest.assertTrue((s1 != s2 ? 1 : 0) != 0);
        multiset.add((Object)s1);
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)s1));
        ConcurrentHashMultisetTest.assertFalse((boolean)multiset.contains((Object)s2));
        ConcurrentHashMultisetTest.assertEquals((int)1, (int)multiset.count((Object)s1));
        ConcurrentHashMultisetTest.assertEquals((int)0, (int)multiset.count((Object)s2));
    }

    public void testWithMapMakerEvictionListener() {
        final ArrayList notificationQueue = Lists.newArrayList();
        MapMaker.RemovalListener<String, Number> removalListener = new MapMaker.RemovalListener<String, Number>(){

            public void onRemoval(MapMaker.RemovalNotification<String, Number> notification) {
                notificationQueue.add(notification);
            }
        };
        MapMaker mapMaker = new MapMaker().concurrencyLevel(1).maximumSize(1);
        mapMaker.removalListener((MapMaker.RemovalListener)removalListener);
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create((MapMaker)mapMaker);
        multiset.add((Object)"a", 5);
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)"a"));
        ConcurrentHashMultisetTest.assertEquals((int)5, (int)multiset.count((Object)"a"));
        multiset.add((Object)"b", 3);
        ConcurrentHashMultisetTest.assertFalse((boolean)multiset.contains((Object)"a"));
        ConcurrentHashMultisetTest.assertTrue((boolean)multiset.contains((Object)"b"));
        ConcurrentHashMultisetTest.assertEquals((int)3, (int)multiset.count((Object)"b"));
        MapMaker.RemovalNotification notification = (MapMaker.RemovalNotification)Iterables.getOnlyElement((Iterable)notificationQueue);
        ConcurrentHashMultisetTest.assertEquals((String)"a", (String)((String)notification.getKey()));
        ConcurrentHashMultisetTest.assertEquals((int)5, (int)((Number)notification.getValue()).intValue());
    }

    private void replay() {
        EasyMock.replay((Object[])new Object[]{this.backingMap});
    }

    private void verify() {
        EasyMock.verify((Object[])new Object[]{this.backingMap});
    }

    private void reset() {
        EasyMock.reset((Object[])new Object[]{this.backingMap});
    }
}

