/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.MapConstraintsTest;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ConstrainedMapTest
extends TestCase {
    private static final String TEST_KEY = "42";
    private static final String TEST_VALUE = "test";
    private static final MapConstraint<String, String> TEST_CONSTRAINT = new TestConstraint();

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ConstrainedMapGenerator()).named("Maps.constrainedMap[HashMap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTestSuite(ConstrainedMapTest.class);
        return suite;
    }

    public void testPutWithForbiddenKeyForbiddenValue() {
        Map map = MapConstraints.constrainedMap(new HashMap(), TEST_CONSTRAINT);
        try {
            map.put(TEST_KEY, TEST_VALUE);
            ConstrainedMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPutWithForbiddenKeyAllowedValue() {
        Map map = MapConstraints.constrainedMap(new HashMap(), TEST_CONSTRAINT);
        try {
            map.put(TEST_KEY, "allowed");
            ConstrainedMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPutWithAllowedKeyForbiddenValue() {
        Map map = MapConstraints.constrainedMap(new HashMap(), TEST_CONSTRAINT);
        try {
            map.put("allowed", TEST_VALUE);
            ConstrainedMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestConstraint
    implements MapConstraint<String, String> {
        private static final long serialVersionUID = 0L;

        private TestConstraint() {
        }

        public void checkKeyValue(String key, String value) {
            if (ConstrainedMapTest.TEST_KEY.equals(key)) {
                throw new MapConstraintsTest.TestKeyException();
            }
            if (ConstrainedMapTest.TEST_VALUE.equals(value)) {
                throw new MapConstraintsTest.TestValueException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConstrainedMapGenerator
    extends TestStringMapGenerator {
        protected Map<String, String> create(Map.Entry<String, String>[] entries) {
            Map map = MapConstraints.constrainedMap(new HashMap(), (MapConstraint)TEST_CONSTRAINT);
            for (Map.Entry<String, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }
    }
}

