/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class EnumHashBiMapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new EnumHashBiMapGenerator()).named("EnumHashBiMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTestSuite(EnumHashBiMapTest.class);
        return suite;
    }

    public void testCreate() {
        EnumHashBiMap bimap = EnumHashBiMap.create(Currency.class);
        EnumHashBiMapTest.assertTrue((boolean)bimap.isEmpty());
        EnumHashBiMapTest.assertEquals((String)"{}", (String)bimap.toString());
        EnumHashBiMapTest.assertEquals((Object)HashBiMap.create(), (Object)bimap);
        bimap.put((Enum)Currency.DOLLAR, (Object)"dollar");
        EnumHashBiMapTest.assertEquals((String)"dollar", (String)((String)bimap.get((Object)Currency.DOLLAR)));
        EnumHashBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), (Object)bimap.inverse().get((Object)"dollar"));
    }

    public void testCreateFromMap() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)"dollar", (Object)((Object)Currency.PESO), (Object)"peso", (Object)((Object)Currency.FRANC), (Object)"franc");
        EnumHashBiMap bimap = EnumHashBiMap.create((Map)map);
        EnumHashBiMapTest.assertEquals((String)"dollar", (String)((String)bimap.get((Object)Currency.DOLLAR)));
        EnumHashBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), (Object)bimap.inverse().get((Object)"dollar"));
        try {
            EnumHashBiMap.create(Collections.emptyMap());
            EnumHashBiMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        EnumHashBiMap emptyBimap = EnumHashBiMap.create(Currency.class);
        bimap = EnumHashBiMap.create((Map)emptyBimap);
        EnumHashBiMapTest.assertTrue((boolean)bimap.isEmpty());
        EnumBiMap emptyBimap2 = EnumBiMap.create(Currency.class, Country.class);
        EnumHashBiMap bimap2 = EnumHashBiMap.create((Map)emptyBimap2);
        EnumHashBiMapTest.assertTrue((boolean)bimap2.isEmpty());
    }

    public void testEnumHashBiMapConstructor() {
        EnumHashBiMap bimap1 = EnumHashBiMap.create(Currency.class);
        bimap1.put((Enum)Currency.DOLLAR, (Object)"dollar");
        EnumHashBiMap bimap2 = EnumHashBiMap.create((Map)bimap1);
        EnumHashBiMapTest.assertEquals((String)"dollar", (String)((String)bimap2.get((Object)Currency.DOLLAR)));
        EnumHashBiMapTest.assertEquals((Object)bimap1, (Object)bimap2);
        bimap2.inverse().put((Object)"franc", (Object)Currency.FRANC);
        EnumHashBiMapTest.assertEquals((String)"franc", (String)((String)bimap2.get((Object)Currency.FRANC)));
        EnumHashBiMapTest.assertNull((Object)bimap1.get((Object)Currency.FRANC));
        EnumHashBiMapTest.assertFalse((boolean)bimap2.equals((Object)bimap1));
        EnumHashBiMap emptyBimap = EnumHashBiMap.create(Currency.class);
        EnumHashBiMap bimap3 = EnumHashBiMap.create((Map)emptyBimap);
        EnumHashBiMapTest.assertEquals((Object)bimap3, (Object)emptyBimap);
    }

    public void testEnumBiMapConstructor() {
        EnumBiMap bimap1 = EnumBiMap.create(Currency.class, Country.class);
        bimap1.put((Object)Currency.DOLLAR, (Object)Country.SWITZERLAND);
        EnumHashBiMap bimap2 = EnumHashBiMap.create((Map)bimap1);
        EnumHashBiMapTest.assertEquals((Object)((Object)Country.SWITZERLAND), (Object)bimap2.get((Object)Currency.DOLLAR));
        EnumHashBiMapTest.assertEquals((Object)bimap1, (Object)bimap2);
        bimap2.inverse().put((Object)"franc", (Object)Currency.FRANC);
        EnumHashBiMapTest.assertEquals((Object)"franc", (Object)bimap2.get((Object)Currency.FRANC));
        EnumHashBiMapTest.assertNull((Object)bimap1.get((Object)Currency.FRANC));
        EnumHashBiMapTest.assertFalse((boolean)bimap2.equals((Object)bimap1));
        EnumBiMap emptyBimap = EnumBiMap.create(Currency.class, Country.class);
        EnumHashBiMap bimap3 = EnumHashBiMap.create((Map)emptyBimap);
        EnumHashBiMapTest.assertEquals((Object)bimap3, (Object)emptyBimap);
    }

    public void testKeyType() {
        EnumHashBiMap bimap = EnumHashBiMap.create(Currency.class);
        EnumHashBiMapTest.assertEquals(Currency.class, (Object)bimap.keyType());
    }

    public void testEntrySet() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)"dollar", (Object)((Object)Currency.PESO), (Object)"peso", (Object)((Object)Currency.FRANC), (Object)"franc");
        EnumHashBiMap bimap = EnumHashBiMap.create((Map)map);
        Set uniqueEntries = Sets.newIdentityHashSet();
        uniqueEntries.addAll(bimap.entrySet());
        EnumHashBiMapTest.assertEquals((int)3, (int)uniqueEntries.size());
    }

    @GwtIncompatible(value="serialize")
    public void testSerializable() {
        SerializableTester.reserializeAndAssert((Object)EnumHashBiMap.create(Currency.class));
    }

    @GwtIncompatible(value="reflection")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(EnumHashBiMap.class);
        new NullPointerTester().testAllPublicInstanceMethods((Object)EnumHashBiMap.create(Currency.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumHashBiMapGenerator
    implements TestBiMapGenerator<Country, String> {
        public BiMap<Country, String> create(Object ... entries) {
            EnumHashBiMap result = EnumHashBiMap.create(Country.class);
            for (Object o : entries) {
                Map.Entry entry = (Map.Entry)o;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        public SampleElements<Map.Entry<Country, String>> samples() {
            return new SampleElements((Object)Maps.immutableEntry((Object)((Object)Country.CANADA), (Object)"DOLLAR"), (Object)Maps.immutableEntry((Object)((Object)Country.CHILE), (Object)"PESO"), (Object)Maps.immutableEntry((Object)((Object)Country.UK), (Object)"POUND"), (Object)Maps.immutableEntry((Object)((Object)Country.JAPAN), (Object)"YEN"), (Object)Maps.immutableEntry((Object)((Object)Country.SWITZERLAND), (Object)"FRANC"));
        }

        public Map.Entry<Country, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<Country, String>> order(List<Map.Entry<Country, String>> insertionOrder) {
            return insertionOrder;
        }

        public Country[] createKeyArray(int length) {
            return new Country[length];
        }

        public String[] createValueArray(int length) {
            return new String[length];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Country {
        CANADA,
        CHILE,
        JAPAN,
        SWITZERLAND,
        UK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Currency {
        DOLLAR,
        FRANC,
        PESO,
        POUND,
        YEN;

    }
}

