/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.EvictingQueue;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class EvictingQueueTest
extends TestCase {
    public void testCreateWithNegativeSize() throws Exception {
        try {
            EvictingQueue.create((int)-1);
            EvictingQueueTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateWithZeroSize() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)0);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertTrue((boolean)queue.offer((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertFalse((boolean)queue.remove((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        try {
            queue.element();
            EvictingQueueTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        EvictingQueueTest.assertNull((Object)queue.peek());
        EvictingQueueTest.assertNull((Object)queue.poll());
        try {
            queue.remove();
            EvictingQueueTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemainingCapacity_maxSize0() {
        EvictingQueue queue = EvictingQueue.create((int)0);
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testRemainingCapacity_maxSize1() {
        EvictingQueue queue = EvictingQueue.create((int)1);
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testRemainingCapacity_maxSize3() {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)2, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testEvictingAfterOne() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)1);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"hi"));
        EvictingQueueTest.assertEquals((String)"hi", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"hi", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)1, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"there"));
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)1, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testEvictingAfterThree() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"one"));
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"two"));
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"three"));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"four"));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)2, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testAddAll() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.addAll(Arrays.asList("one", "two", "three")));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.addAll(Arrays.asList("four")));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)2, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(EvictingQueue.class);
        tester.testAllPublicConstructors(EvictingQueue.class);
        EvictingQueue queue = EvictingQueue.create((int)5);
        queue.add((Object)"one");
        tester.testAllPublicInstanceMethods((Object)queue);
    }

    public void testSerialization() {
        EvictingQueue original = EvictingQueue.create((int)5);
        original.add((Object)"one");
        original.add((Object)"two");
        original.add((Object)"three");
        EvictingQueue copy = (EvictingQueue)SerializableTester.reserialize((Object)original);
        EvictingQueueTest.assertEquals((int)copy.maxSize, (int)original.maxSize);
        EvictingQueueTest.assertEquals((String)"one", (String)((String)copy.remove()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)copy.remove()));
        EvictingQueueTest.assertEquals((String)"three", (String)((String)copy.remove()));
        EvictingQueueTest.assertTrue((boolean)copy.isEmpty());
    }
}

