/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Map;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtIncompatible(value="nottested")
public class FilteredMultimapTest
extends TestCase {
    private static final Predicate<Map.Entry<String, Integer>> ENTRY_PREDICATE = new Predicate<Map.Entry<String, Integer>>(){

        public boolean apply(Map.Entry<String, Integer> entry) {
            return !"badkey".equals(entry.getKey()) && !Integer.valueOf(55556).equals(entry.getValue());
        }
    };
    private static final Predicate<String> KEY_PREDICATE = new Predicate<String>(){

        public boolean apply(String key) {
            return !"badkey".equals(key);
        }
    };
    private static final Predicate<Integer> VALUE_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer value) {
            return !Integer.valueOf(55556).equals(value);
        }
    };

    protected Multimap<String, Integer> create() {
        HashMultimap unfiltered = HashMultimap.create();
        unfiltered.put((Object)"foo", (Object)55556);
        unfiltered.put((Object)"badkey", (Object)1);
        return Multimaps.filterEntries((Multimap)unfiltered, ENTRY_PREDICATE);
    }

    public void testFilterKeys() {
        HashMultimap unfiltered = HashMultimap.create();
        unfiltered.put((Object)"foo", (Object)55556);
        unfiltered.put((Object)"badkey", (Object)1);
        Multimap filtered = Multimaps.filterKeys((Multimap)unfiltered, KEY_PREDICATE);
        FilteredMultimapTest.assertEquals((int)1, (int)filtered.size());
        FilteredMultimapTest.assertTrue((boolean)filtered.containsEntry((Object)"foo", (Object)55556));
    }

    public void testFilterValues() {
        HashMultimap unfiltered = HashMultimap.create();
        unfiltered.put((Object)"foo", (Object)55556);
        unfiltered.put((Object)"badkey", (Object)1);
        Multimap filtered = Multimaps.filterValues((Multimap)unfiltered, VALUE_PREDICATE);
        FilteredMultimapTest.assertEquals((int)1, (int)filtered.size());
        FilteredMultimapTest.assertFalse((boolean)filtered.containsEntry((Object)"foo", (Object)55556));
        FilteredMultimapTest.assertTrue((boolean)filtered.containsEntry((Object)"badkey", (Object)1));
    }

    public void testFilterFiltered() {
        HashMultimap unfiltered = HashMultimap.create();
        unfiltered.put((Object)"foo", (Object)55556);
        unfiltered.put((Object)"badkey", (Object)1);
        unfiltered.put((Object)"foo", (Object)1);
        Multimap keyFiltered = Multimaps.filterKeys((Multimap)unfiltered, KEY_PREDICATE);
        Multimap filtered = Multimaps.filterValues((Multimap)keyFiltered, VALUE_PREDICATE);
        FilteredMultimapTest.assertEquals((int)1, (int)filtered.size());
        FilteredMultimapTest.assertTrue((boolean)filtered.containsEntry((Object)"foo", (Object)1));
        FilteredMultimapTest.assertTrue((boolean)filtered.keySet().retainAll(Arrays.asList("cat", "dog")));
        FilteredMultimapTest.assertEquals((int)0, (int)filtered.size());
    }
}

