/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingMapTest
extends ForwardingTestCase {
    Map<String, Boolean> forward;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return new StandardImplForwardingMap(map);
            }
        }).named("ForwardingMap[LinkedHashMap] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, String> entry : entries) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return new StandardImplForwardingMap(builder.build());
            }
        }).named("ForwardingMap[ImmutableMap] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        final Map map = this.createProxyInstance(Map.class);
        this.forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }
        };
    }

    public void testSize() {
        this.forward().size();
        ForwardingMapTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward().isEmpty();
        ForwardingMapTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testRemove() {
        this.forward().remove(null);
        ForwardingMapTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward().clear();
        ForwardingMapTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContainsKey() {
        this.forward().containsKey("asdf");
        ForwardingMapTest.assertEquals((String)"[containsKey(Object)]", (String)this.getCalls());
    }

    public void testContainsValue() {
        this.forward().containsValue(false);
        ForwardingMapTest.assertEquals((String)"[containsValue(Object)]", (String)this.getCalls());
    }

    public void testGet_Object() {
        this.forward().get("asdf");
        ForwardingMapTest.assertEquals((String)"[get(Object)]", (String)this.getCalls());
    }

    public void testPut_Key_Value() {
        this.forward().put("key", false);
        ForwardingMapTest.assertEquals((String)"[put(Object,Object)]", (String)this.getCalls());
    }

    public void testPutAll_Map() {
        this.forward().putAll(new HashMap());
        ForwardingMapTest.assertEquals((String)"[putAll(Map)]", (String)this.getCalls());
    }

    public void testKeySet() {
        this.forward().keySet();
        ForwardingMapTest.assertEquals((String)"[keySet]", (String)this.getCalls());
    }

    public void testValues() {
        this.forward().values();
        ForwardingMapTest.assertEquals((String)"[values]", (String)this.getCalls());
    }

    public void testEntrySet() {
        this.forward().entrySet();
        ForwardingMapTest.assertEquals((String)"[entrySet]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward().toString();
        ForwardingMapTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    public void testEquals_Object() {
        this.forward().equals("asdf");
        ForwardingMapTest.assertEquals((String)"[equals(Object)]", (String)this.getCalls());
    }

    public void testHashCode() {
        this.forward().hashCode();
        ForwardingMapTest.assertEquals((String)"[hashCode]", (String)this.getCalls());
    }

    public void testStandardEntrySet() throws InvocationTargetException {
        final Map map = (Map)EasyMock.createMock(Map.class);
        final Set entrySet = (Set)EasyMock.createMock(Set.class);
        EasyMock.expect((Object)map.containsKey(EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.expect(map.get(EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expect((Object)map.isEmpty()).andReturn((Object)true).anyTimes();
        EasyMock.expect(map.remove(EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expect((Object)map.size()).andReturn((Object)0).anyTimes();
        EasyMock.expect(entrySet.iterator()).andReturn((Object)Iterators.emptyIterator()).anyTimes();
        map.clear();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{map, entrySet});
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Set<Map.Entry<String, Boolean>> entrySet() {
                return new ForwardingMap.StandardEntrySet(){

                    public Iterator<Map.Entry<String, Boolean>> iterator() {
                        return entrySet.iterator();
                    }
                };
            }
        };
        ForwardingMapTest.callAllPublicMethods(Set.class, forward.entrySet());
        EasyMock.verify((Object[])new Object[]{map, entrySet});
    }

    public void testStandardKeySet() throws InvocationTargetException {
        Set entrySet = (Set)EasyMock.createMock(Set.class);
        EasyMock.expect(entrySet.iterator()).andReturn((Object)Iterators.emptyIterator()).anyTimes();
        final Map map = (Map)EasyMock.createMock(Map.class);
        EasyMock.expect((Object)map.containsKey(EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)map.isEmpty()).andReturn((Object)true).anyTimes();
        EasyMock.expect(map.remove(EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expect((Object)map.size()).andReturn((Object)0).anyTimes();
        EasyMock.expect(map.entrySet()).andReturn((Object)entrySet).anyTimes();
        map.clear();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{entrySet, map});
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Set<String> keySet() {
                return new ForwardingMap.StandardKeySet((ForwardingMap)this);
            }
        };
        ForwardingMapTest.callAllPublicMethods(Set.class, forward.keySet());
        EasyMock.verify((Object[])new Object[]{entrySet, map});
    }

    public void testStandardValues() throws InvocationTargetException {
        Set entrySet = (Set)EasyMock.createMock(Set.class);
        EasyMock.expect(entrySet.iterator()).andReturn((Object)Iterators.emptyIterator()).anyTimes();
        final Map map = (Map)EasyMock.createMock(Map.class);
        EasyMock.expect((Object)map.containsValue(EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)map.isEmpty()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)map.size()).andReturn((Object)0).anyTimes();
        EasyMock.expect(map.entrySet()).andReturn((Object)entrySet).anyTimes();
        map.clear();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{entrySet, map});
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Collection<Boolean> values() {
                return new ForwardingMap.StandardValues((ForwardingMap)this);
            }
        };
        ForwardingMapTest.callAllPublicMethods(Collection.class, forward.values());
        EasyMock.verify((Object[])new Object[]{entrySet, map});
    }

    public void testToStringWithNullKeys() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put(null, "baz");
        StandardImplForwardingMap forwardingMap = new StandardImplForwardingMap(Maps.newHashMap());
        forwardingMap.put("foo", "bar");
        forwardingMap.put(null, "baz");
        ForwardingMapTest.assertEquals((String)((Object)hashmap).toString(), (String)forwardingMap.toString());
    }

    public void testToStringWithNullValues() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put("baz", null);
        StandardImplForwardingMap forwardingMap = new StandardImplForwardingMap(Maps.newHashMap());
        forwardingMap.put("foo", "bar");
        forwardingMap.put("baz", null);
        ForwardingMapTest.assertEquals((String)((Object)hashmap).toString(), (String)forwardingMap.toString());
    }

    Map<String, Boolean> forward() {
        return this.forward;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StandardImplForwardingMap<K, V>
    extends ForwardingMap<K, V> {
        private final Map<K, V> backingMap;

        StandardImplForwardingMap(Map<K, V> backingMap) {
            this.backingMap = backingMap;
        }

        protected Map<K, V> delegate() {
            return this.backingMap;
        }

        public boolean containsKey(Object key) {
            return this.standardContainsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.standardContainsValue(value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            this.standardPutAll(map);
        }

        public V remove(Object object) {
            return (V)this.standardRemove(object);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public Set<K> keySet() {
            return new ForwardingMap.StandardKeySet((ForwardingMap)this);
        }

        public Collection<V> values() {
            return new ForwardingMap.StandardValues((ForwardingMap)this);
        }

        public String toString() {
            return this.standardToString();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingMap.StandardEntrySet(){

                public Iterator<Map.Entry<K, V>> iterator() {
                    return StandardImplForwardingMap.this.delegate().entrySet().iterator();
                }
            };
        }

        public void clear() {
            this.standardClear();
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }
    }
}

