/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.MinimalSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingSetTest
extends ForwardingTestCase {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    Set<String> forward;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingSet(Sets.newLinkedHashSet(Arrays.asList(elements)));
            }
        }).named("ForwardingSet[LinkedHashSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingSet(MinimalSet.of((Object[])elements));
            }
        }).named("ForwardingSet[MinimalSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        final Set set = this.createProxyInstance(Set.class);
        this.forward = new ForwardingSet<String>(){

            protected Set<String> delegate() {
                return set;
            }
        };
    }

    public void testAdd_T() {
        this.forward().add("asdf");
        ForwardingSetTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward().addAll(EMPTY_LIST);
        ForwardingSetTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward().clear();
        ForwardingSetTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_Object() {
        this.forward().contains(null);
        ForwardingSetTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward().containsAll(EMPTY_LIST);
        ForwardingSetTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward().isEmpty();
        ForwardingSetTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward().iterator();
        ForwardingSetTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward().remove(null);
        ForwardingSetTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward().removeAll(EMPTY_LIST);
        ForwardingSetTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward().retainAll(EMPTY_LIST);
        ForwardingSetTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward().size();
        ForwardingSetTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward().toArray();
        ForwardingSetTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward().toArray(new String[0]);
        ForwardingSetTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward().toString();
        ForwardingSetTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    Set<String> forward() {
        return this.forward;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StandardImplForwardingSet<T>
    extends ForwardingSet<T> {
        private final Set<T> backingSet;

        StandardImplForwardingSet(Set<T> backingSet) {
            this.backingSet = backingSet;
        }

        protected Set<T> delegate() {
            return this.backingSet;
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }
    }
}

