/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class ImmutableEnumMapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ImmutableEnumMapGenerator()).named("Maps.immutableEnumMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableEnumMapTest.class);
        return suite;
    }

    public void testEmptyImmutableEnumMap() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of());
        ImmutableEnumMapTest.assertEquals((Object)ImmutableMap.of(), (Object)map);
    }

    public void testImmutableEnumMapOrdering() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)AnEnum.C, (Object)"c", (Object)AnEnum.A, (Object)"a", (Object)AnEnum.E, (Object)"e"));
        Truth.ASSERT.that((Collection)map.entrySet()).has().exactly((Object)Helpers.mapEntry((Object)AnEnum.A, (Object)"a"), (Object)Helpers.mapEntry((Object)AnEnum.C, (Object)"c"), (Object[])new Map.Entry[]{Helpers.mapEntry((Object)AnEnum.E, (Object)"e")}).inOrder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableEnumMapGenerator
    extends TestEnumMapGenerator {
        protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<AnEnum, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return Maps.immutableEnumMap((Map)map);
        }
    }
}

