/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LenientSerializableTester;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MapInterfaceTest;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.MinimalSet;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.UnhashableObject;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MapGenerators;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class ImmutableMapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new MapGenerators.ImmutableMapGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.KNOWN_ORDER, MapFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).named("ImmutableMap")).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new MapGenerators.ImmutableMapCopyOfGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).named("ImmutableMap.copyOf")).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new MapGenerators.ImmutableMapCopyOfEnumMapGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).named("ImmutableMap.copyOf[EnumMap]")).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new MapGenerators.ImmutableMapUnhashableValuesGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).named("ImmutableMap.values, unhashable")).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new MapGenerators.ImmutableMapKeyListGenerator()).named("ImmutableMap.keySet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new MapGenerators.ImmutableMapEntryListGenerator()).named("ImmutableMap.entrySet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new MapGenerators.ImmutableMapValueListGenerator()).named("ImmutableMap.values.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testNullGet() {
        ImmutableMap map = ImmutableMap.of((Object)"one", (Object)1);
        ImmutableMapTest.assertNull((Object)map.get(null));
    }

    public void testAsMultimap() {
        ImmutableMap map = ImmutableMap.of((Object)"one", (Object)1, (Object)"won", (Object)1, (Object)"two", (Object)2, (Object)"too", (Object)2, (Object)"three", (Object)3);
        ImmutableSetMultimap expected = ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"won", (Object)1, (Object)"two", (Object)2, (Object)"too", (Object)2, (Object)"three", (Object)3);
        ImmutableMapTest.assertEquals((Object)expected, (Object)map.asMultimap());
    }

    public void testAsMultimapWhenEmpty() {
        ImmutableMap map = ImmutableMap.of();
        ImmutableSetMultimap expected = ImmutableSetMultimap.of();
        ImmutableMapTest.assertEquals((Object)expected, (Object)map.asMultimap());
    }

    public void testAsMultimapCaches() {
        ImmutableMap map = ImmutableMap.of((Object)"one", (Object)1);
        ImmutableSetMultimap multimap1 = map.asMultimap();
        ImmutableSetMultimap multimap2 = map.asMultimap();
        ImmutableMapTest.assertEquals((int)1, (int)multimap1.asMap().size());
        ImmutableMapTest.assertSame((Object)multimap1, (Object)multimap2);
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(ImmutableMap.class);
        tester.testAllPublicInstanceMethods((Object)new ImmutableMap.Builder());
        tester.testAllPublicInstanceMethods((Object)ImmutableMap.of());
        tester.testAllPublicInstanceMethods((Object)ImmutableMap.of((Object)"one", (Object)1));
        tester.testAllPublicInstanceMethods((Object)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3));
    }

    private static <K, V> void assertMapEquals(Map<K, V> map, Object ... alternatingKeysAndValues) {
        ImmutableMapTest.assertEquals((int)map.size(), (int)(alternatingKeysAndValues.length / 2));
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ImmutableMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getKey());
            ImmutableMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getValue());
        }
    }

    public void testMutableValues() {
        IntHolder holderA = new IntHolder(1);
        IntHolder holderB = new IntHolder(2);
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)holderA, (Object)"b", (Object)holderB);
        holderA.value = 3;
        ImmutableMapTest.assertTrue((boolean)map.entrySet().contains(Maps.immutableEntry((Object)"a", (Object)new IntHolder(3))));
        ImmutableMap intMap = ImmutableMap.of((Object)"a", (Object)3, (Object)"b", (Object)2);
        ImmutableMapTest.assertEquals((int)intMap.hashCode(), (int)map.entrySet().hashCode());
        ImmutableMapTest.assertEquals((int)intMap.hashCode(), (int)map.hashCode());
    }

    public void testCopyOfEnumMap() {
        EnumMap<AnEnum, String> map = new EnumMap<AnEnum, String>(AnEnum.class);
        map.put(AnEnum.B, "foo");
        map.put(AnEnum.C, "bar");
        ImmutableMapTest.assertTrue((boolean)(ImmutableMap.copyOf(map) instanceof ImmutableEnumMap));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testViewSerialization() {
        ImmutableMap map = ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3);
        LenientSerializableTester.reserializeAndAssertLenient(map.entrySet());
        LenientSerializableTester.reserializeAndAssertLenient(map.keySet());
        Collection reserializedValues = (Collection)SerializableTester.reserialize(map.values());
        ImmutableMapTest.assertEquals((Object)Lists.newArrayList(map.values()), (Object)Lists.newArrayList((Iterable)reserializedValues));
        ImmutableMapTest.assertTrue((boolean)(reserializedValues instanceof ImmutableCollection));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableList.of(), ImmutableList.of()}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1), ImmutableList.of((Object)1)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2), ImmutableList.of((Object)1, (Object)2)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11)}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)100, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)200, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)300, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)400, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)500, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)600, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)700, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)800, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)900, (Object)10, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)1000, (Object)11, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)1100, (Object)12, (Object[])new Integer[0])}).addEqualityGroup(new Object[]{ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)1200, (Object[])new Integer[0])}).testEquals();
    }

    private static class IntHolder
    implements Serializable {
        public int value;
        private static final long serialVersionUID = 5L;

        public IntHolder(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof IntHolder && ((IntHolder)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    public static class CreationTests
    extends TestCase {
        public void testEmptyBuilder() {
            ImmutableMap map = new ImmutableMap.Builder().build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
        }

        public void testSingletonBuilder() {
            ImmutableMap map = new ImmutableMap.Builder().put((Object)"one", (Object)1).build();
            ImmutableMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
        }

        public void testBuilder() {
            ImmutableMap map = new ImmutableMap.Builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build();
            ImmutableMapTest.assertMapEquals((Map)map, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
        }

        public void testBuilder_withImmutableEntry() {
            ImmutableMap map = new ImmutableMap.Builder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
            ImmutableMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
        }

        public void testBuilder_withImmutableEntryAndNullContents() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put(Maps.immutableEntry((Object)"one", (Object)null));
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                builder.put(Maps.immutableEntry((Object)null, (Object)1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilder_withMutableEntry() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            final StringHolder holder = new StringHolder();
            holder.string = "one";
            AbstractMapEntry<String, Integer> entry = new AbstractMapEntry<String, Integer>(){

                public String getKey() {
                    return holder.string;
                }

                public Integer getValue() {
                    return 1;
                }
            };
            builder.put((Map.Entry)entry);
            holder.string = "two";
            ImmutableMapTest.assertMapEquals((Map)builder.build(), new Object[]{"one", 1});
        }

        public void testBuilderPutAllWithEmptyMap() {
            ImmutableMap map = new ImmutableMap.Builder().putAll(Collections.emptyMap()).build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
        }

        public void testBuilderPutAll() {
            LinkedHashMap<String, Integer> toPut = new LinkedHashMap<String, Integer>();
            toPut.put("one", 1);
            toPut.put("two", 2);
            toPut.put("three", 3);
            LinkedHashMap<String, Integer> moreToPut = new LinkedHashMap<String, Integer>();
            moreToPut.put("four", 4);
            moreToPut.put("five", 5);
            ImmutableMap map = new ImmutableMap.Builder().putAll(toPut).putAll(moreToPut).build();
            ImmutableMapTest.assertMapEquals((Map)map, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
        }

        public void testBuilderReuse() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            ImmutableMap mapOne = builder.put((Object)"one", (Object)1).put((Object)"two", (Object)2).build();
            ImmutableMap mapTwo = builder.put((Object)"three", (Object)3).put((Object)"four", (Object)4).build();
            ImmutableMapTest.assertMapEquals((Map)mapOne, new Object[]{"one", 1, "two", 2});
            ImmutableMapTest.assertMapEquals((Map)mapTwo, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
        }

        public void testBuilderPutNullKeyFailsAtomically() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            builder.put((Object)"foo", (Object)2);
            ImmutableMapTest.assertMapEquals((Map)builder.build(), new Object[]{"foo", 2});
        }

        public void testBuilderPutImmutableEntryWithNullKeyFailsAtomically() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put(Maps.immutableEntry((Object)null, (Object)1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            builder.put((Object)"foo", (Object)2);
            ImmutableMapTest.assertMapEquals((Map)builder.build(), new Object[]{"foo", 2});
        }

        public void testBuilderPutMutableEntryWithNullKeyFailsAtomically() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put(new SimpleEntry<Object, Integer>(null, 1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            builder.put((Object)"foo", (Object)2);
            ImmutableMapTest.assertMapEquals((Map)builder.build(), new Object[]{"foo", 2});
        }

        public void testBuilderPutNullKey() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValue() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.put((Object)"one", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullKeyViaPutAll() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.putAll(Collections.singletonMap(null, 1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValueViaPutAll() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            try {
                builder.putAll(Collections.singletonMap("one", null));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testPuttingTheSameKeyTwiceThrowsOnBuild() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"one", (Object)1).put((Object)"one", (Object)1);
            try {
                builder.build();
                CreationTests.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testOf() {
            ImmutableMapTest.assertMapEquals((Map)ImmutableMap.of((Object)"one", (Object)1), new Object[]{"one", 1});
            ImmutableMapTest.assertMapEquals((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2), new Object[]{"one", 1, "two", 2});
            ImmutableMapTest.assertMapEquals((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3), new Object[]{"one", 1, "two", 2, "three", 3});
            ImmutableMapTest.assertMapEquals((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
            ImmutableMapTest.assertMapEquals((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4, (Object)"five", (Object)5), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
        }

        public void testOfNullKey() {
            try {
                ImmutableMap.of(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                ImmutableMap.of((Object)"one", (Object)1, null, (Object)2);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfNullValue() {
            try {
                ImmutableMap.of((Object)"one", null);
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                ImmutableMap.of((Object)"one", (Object)1, (Object)"two", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfWithDuplicateKey() {
            try {
                ImmutableMap.of((Object)"one", (Object)1, (Object)"one", (Object)1);
                CreationTests.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testCopyOfEmptyMap() {
            ImmutableMap copy = ImmutableMap.copyOf(Collections.emptyMap());
            CreationTests.assertEquals(Collections.emptyMap(), (Object)copy);
            CreationTests.assertSame((Object)copy, (Object)ImmutableMap.copyOf((Map)copy));
        }

        public void testCopyOfSingletonMap() {
            ImmutableMap copy = ImmutableMap.copyOf(Collections.singletonMap("one", 1));
            ImmutableMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableMap.copyOf((Map)copy));
        }

        public void testCopyOf() {
            LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableMap copy = ImmutableMap.copyOf(original);
            ImmutableMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1, "two", 2, "three", 3});
            CreationTests.assertSame((Object)copy, (Object)ImmutableMap.copyOf((Map)copy));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SimpleEntry<K, V>
        extends AbstractMapEntry<K, V> {
            public K key;
            public V value;

            SimpleEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }
        }

        private static class StringHolder {
            String string;

            private StringHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="GWT's ImmutableMap emulation is backed by java.util.HashMap.")
    public static class MapTestsWithSingletonUnhashableValue
    extends MapTestsWithUnhashableValues {
        @Override
        protected Map<Integer, UnhashableObject> makePopulatedMap() {
            SampleElements.Unhashables unhashables = new SampleElements.Unhashables();
            return ImmutableMap.of((Object)0, (Object)unhashables.e0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="GWT's ImmutableMap emulation is backed by java.util.HashMap.")
    public static class MapTestsWithUnhashableValues
    extends AbstractMapTests<Integer, UnhashableObject> {
        @Override
        protected Map<Integer, UnhashableObject> makeEmptyMap() {
            return ImmutableMap.of();
        }

        protected Map<Integer, UnhashableObject> makePopulatedMap() {
            SampleElements.Unhashables unhashables = new SampleElements.Unhashables();
            return ImmutableMap.of((Object)0, (Object)unhashables.e0, (Object)1, (Object)unhashables.e1, (Object)2, (Object)unhashables.e2);
        }

        protected Integer getKeyNotInPopulatedMap() {
            return 3;
        }

        protected UnhashableObject getValueNotInPopulatedMap() {
            return (UnhashableObject)new SampleElements.Unhashables().e3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapTestsWithBadHashes
    extends AbstractMapTests<Object, Integer> {
        @Override
        protected Map<Object, Integer> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        protected Map<Object, Integer> makePopulatedMap() {
            SampleElements.Colliders colliders = new SampleElements.Colliders();
            return ImmutableMap.of((Object)colliders.e0, (Object)0, (Object)colliders.e1, (Object)1, (Object)colliders.e2, (Object)2, (Object)colliders.e3, (Object)3);
        }

        protected Object getKeyNotInPopulatedMap() {
            return new SampleElements.Colliders().e4;
        }

        protected Integer getValueNotInPopulatedMap() {
            return 4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="SerializableTester")
    public static class ReserializedMapTests
    extends AbstractMapTests<String, Integer> {
        protected Map<String, Integer> makePopulatedMap() {
            return (Map)SerializableTester.reserialize((Object)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3));
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingletonMapTests
    extends AbstractMapTests<String, Integer> {
        protected Map<String, Integer> makePopulatedMap() {
            return ImmutableMap.of((Object)"one", (Object)1);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapTests
    extends AbstractMapTests<String, Integer> {
        @Override
        protected Map<String, Integer> makeEmptyMap() {
            return ImmutableMap.of();
        }

        protected Map<String, Integer> makePopulatedMap() {
            return ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractMapTests<K, V>
    extends MapInterfaceTest<K, V> {
        private static final Joiner joiner = Joiner.on((String)", ");

        public AbstractMapTests() {
            super(false, false, false, false, false);
        }

        protected Map<K, V> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        protected void assertMoreInvariants(Map<K, V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                AbstractMapTests.assertEquals((String)(entry.getKey() + "=" + entry.getValue()), (String)entry.toString());
            }
            AbstractMapTests.assertEquals((String)("{" + joiner.join(map.entrySet()) + "}"), (String)map.toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.entrySet()) + "]"), (String)map.entrySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.keySet()) + "]"), (String)map.keySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.values()) + "]"), (String)map.values().toString());
            AbstractMapTests.assertEquals((Object)MinimalSet.from(map.entrySet()), map.entrySet());
            AbstractMapTests.assertEquals((Object)Sets.newHashSet(map.keySet()), map.keySet());
        }
    }
}

