/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.LenientSerializableTester;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.collect.testing.google.UnmodifiableCollectionTests;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class ImmutableMultisetTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return ImmutableMultiset.copyOf((Object[])elements);
            }
        }).named("ImmutableMultiset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return ImmutableMultiset.copyOf((Object[])elements).elementSet();
            }
        }).named("ImmutableMultiset, element set")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return ImmutableMultiset.copyOf((Object[])elements).asList();
            }

            public List<String> order(List<String> insertionOrder) {
                ArrayList<String> order = new ArrayList<String>();
                for (String s : insertionOrder) {
                    int index = order.indexOf(s);
                    if (index == -1) {
                        order.add(s);
                        continue;
                    }
                    order.add(index, s);
                }
                return order;
            }
        }).named("ImmutableMultiset.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                HashSet<String> set = new HashSet<String>();
                ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                for (String s : elements) {
                    Preconditions.checkArgument((boolean)set.add(s));
                    builder.addCopies((Object)s, 2);
                }
                ImmutableSet elementSet = (ImmutableSet)builder.build().elementSet();
                return elementSet.asList();
            }
        }).named("ImmutableMultiset.elementSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testCreation_noArgs() {
        ImmutableMultiset multiset = ImmutableMultiset.of();
        ImmutableMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCreation_oneElement() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a");
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCreation_twoElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b");
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b")), (Object)multiset);
    }

    public void testCreation_threeElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c");
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c")), (Object)multiset);
    }

    public void testCreation_fourElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c", (Object)"d");
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d")), (Object)multiset);
    }

    public void testCreation_fiveElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e");
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e")), (Object)multiset);
    }

    public void testCreation_sixElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object[])new String[0]);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e", "f")), (Object)multiset);
    }

    public void testCreation_sevenElements() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object[])new String[]{"g"});
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e", "f", "g")), (Object)multiset);
    }

    public void testCreation_emptyArray() {
        Object[] array = new String[]{};
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Object[])array);
        ImmutableMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCreation_arrayOfOneElement() {
        Object[] array = new String[]{"a"};
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Object[])array);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCreation_arrayOfArray() {
        String[] array = new String[]{"a"};
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)array);
        HashMultiset expected = HashMultiset.create();
        expected.add((Object)array);
        ImmutableMultisetTest.assertEquals((Object)expected, (Object)multiset);
    }

    public void testCreation_arrayContainingOnlyNull() {
        Object[] array = new String[]{null};
        try {
            ImmutableMultiset.copyOf((Object[])array);
            ImmutableMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_collection_empty() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[0]);
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_collection_oneElement() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a"});
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_collection_general() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", "b", "a"});
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_collectionContainingNull() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", null, "b"});
        try {
            ImmutableMultiset.copyOf((Iterable)c);
            ImmutableMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_multiset_empty() {
        HashMultiset c = HashMultiset.create();
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_multiset_oneElement() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a"));
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_multiset_general() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a", "b", "a"));
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)c);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_multisetContainingNull() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a", null, "b"));
        try {
            ImmutableMultiset.copyOf((Iterable)c);
            ImmutableMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_iterator_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterator)iterator);
        ImmutableMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_iterator_oneElement() {
        UnmodifiableIterator iterator = Iterators.singletonIterator((Object)"a");
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterator)iterator);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_iterator_general() {
        Iterator<String> iterator = Arrays.asList("a", "b", "a").iterator();
        ImmutableMultiset multiset = ImmutableMultiset.copyOf(iterator);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_iteratorContainingNull() {
        Iterator<String> iterator = Arrays.asList("a", null, "b").iterator();
        try {
            ImmutableMultiset.copyOf(iterator);
            ImmutableMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_plainIterable() {
        CountingIterable iterable = new CountingIterable();
        ImmutableMultiset multiset = ImmutableMultiset.copyOf((Iterable)iterable);
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
        ImmutableMultisetTest.assertEquals((int)1, (int)iterable.count);
    }

    public void testCopyOf_shortcut_empty() {
        ImmutableMultiset c = ImmutableMultiset.of();
        ImmutableMultisetTest.assertSame((Object)c, (Object)ImmutableMultiset.copyOf((Iterable)c));
    }

    public void testCopyOf_shortcut_singleton() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a");
        ImmutableMultisetTest.assertSame((Object)c, (Object)ImmutableMultiset.copyOf((Iterable)c));
    }

    public void testCopyOf_shortcut_immutableMultiset() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c");
        ImmutableMultisetTest.assertSame((Object)c, (Object)ImmutableMultiset.copyOf((Iterable)c));
    }

    public void testBuilderAdd() {
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().add((Object)"a").add((Object)"b").add((Object)"a").add((Object)"c").build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a", "c")), (Object)multiset);
    }

    public void testBuilderAddAll() {
        List<String> a = Arrays.asList("a", "b");
        List<String> b = Arrays.asList("c", "d");
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().addAll(a).addAll(b).build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d")), (Object)multiset);
    }

    public void testBuilderAddAllMultiset() {
        HashMultiset a = HashMultiset.create(Arrays.asList("a", "b", "b"));
        HashMultiset b = HashMultiset.create(Arrays.asList("c", "b"));
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().addAll((Iterable)a).addAll((Iterable)b).build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "b", "b", "c")), (Object)multiset);
    }

    public void testBuilderAddAllIterator() {
        Iterator<String> iterator = Arrays.asList("a", "b", "a", "c").iterator();
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().addAll(iterator).build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a", "c")), (Object)multiset);
    }

    public void testBuilderAddCopies() {
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().addCopies((Object)"a", 2).addCopies((Object)"b", 3).addCopies((Object)"c", 0).build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "a", "b", "b", "b")), (Object)multiset);
    }

    public void testBuilderSetCount() {
        ImmutableMultiset multiset = new ImmutableMultiset.Builder().add((Object)"a").setCount((Object)"a", 2).setCount((Object)"b", 3).build();
        ImmutableMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "a", "b", "b", "b")), (Object)multiset);
    }

    public void testBuilderAddHandlesNullsCorrectly() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.add((Object)null);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderAddAllHandlesNullsCorrectly() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.addAll((Iterable)null);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = ImmutableMultiset.builder();
        List<String> listWithNulls = Arrays.asList("a", null, "b");
        try {
            builder.addAll(listWithNulls);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = ImmutableMultiset.builder();
        LinkedHashMultiset multisetWithNull = LinkedHashMultiset.create(Arrays.asList("a", null, "b"));
        try {
            builder.addAll((Iterable)multisetWithNull);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    public void testBuilderAddCopiesHandlesNullsCorrectly() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.addCopies(null, 2);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderAddCopiesIllegal() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.addCopies((Object)"a", -2);
            ImmutableMultisetTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilderSetCountHandlesNullsCorrectly() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.setCount(null, 2);
            ImmutableMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderSetCountIllegal() {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        try {
            builder.setCount((Object)"a", -2);
            ImmutableMultisetTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(ImmutableMultiset.class);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization_empty() {
        ImmutableMultiset c = ImmutableMultiset.of();
        ImmutableMultisetTest.assertSame((Object)c, (Object)SerializableTester.reserialize((Object)c));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization_multiple() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a");
        Collection copy = (Collection)SerializableTester.reserializeAndAssert((Object)c);
        Truth.ASSERT.that(copy).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b"}).inOrder();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization_elementSet() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a");
        Set copy = LenientSerializableTester.reserializeAndAssertLenient(c.elementSet());
        Truth.ASSERT.that(copy).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization_entrySet() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c");
        SerializableTester.reserializeAndAssert((Object)c.entrySet());
    }

    public void testEquals_immutableMultiset() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a");
        ImmutableMultisetTest.assertEquals((Object)c, (Object)ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a"));
        ImmutableMultisetTest.assertEquals((Object)c, (Object)ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b"));
        Truth.ASSERT.that((Collection)c).isNotEqualTo((Object)ImmutableMultiset.of((Object)"a", (Object)"b"));
        Truth.ASSERT.that((Collection)c).isNotEqualTo((Object)ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
    }

    public void testIterationOrder() {
        ImmutableMultiset c = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a");
        Truth.ASSERT.that((Collection)c).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b"}).inOrder();
    }

    public void testMultisetWrites() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a");
        UnmodifiableCollectionTests.assertMultisetIsUnmodifiable((Multiset)multiset, (Object)"test");
    }

    public void testAsList() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b", (Object)"b", (Object)"b");
        ImmutableList list = multiset.asList();
        ImmutableMultisetTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"b", (Object)"b"), (Object)list);
        ImmutableMultisetTest.assertEquals((int)2, (int)list.indexOf((Object)"b"));
        ImmutableMultisetTest.assertEquals((int)4, (int)list.lastIndexOf((Object)"b"));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization_asList() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b", (Object)"b", (Object)"b");
        SerializableTester.reserializeAndAssert((Object)multiset.asList());
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableMultiset.of(), ImmutableMultiset.of()}).addEqualityGroup(new Object[]{ImmutableMultiset.of((Object)1), ImmutableMultiset.of((Object)1)}).addEqualityGroup(new Object[]{ImmutableMultiset.of((Object)1, (Object)1), ImmutableMultiset.of((Object)1, (Object)1)}).addEqualityGroup(new Object[]{ImmutableMultiset.of((Object)1, (Object)2, (Object)1), ImmutableMultiset.of((Object)2, (Object)1, (Object)1)}).testEquals();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingIterable
    implements Iterable<String> {
        int count = 0;

        private CountingIterable() {
        }

        @Override
        public Iterator<String> iterator() {
            ++this.count;
            return Arrays.asList("a", "b", "a").iterator();
        }
    }
}

