/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractImmutableSetTest;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.SetGenerators;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class ImmutableSetTest
extends AbstractImmutableSetTest {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetCopyOfGenerator()).named(ImmutableSetTest.class.getName())).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetWithBadHashesGenerator()).named(ImmutableSetTest.class.getName() + ", with bad hashes")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.DegeneratedImmutableSetGenerator()).named(ImmutableSetTest.class.getName() + ", degenerate")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SetGenerators.ImmutableSetAsListGenerator()).named("ImmutableSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableSetTest.class);
        return suite;
    }

    @Override
    protected Set<String> of() {
        return ImmutableSet.of();
    }

    @Override
    protected Set<String> of(String e) {
        return ImmutableSet.of((Object)e);
    }

    @Override
    protected Set<String> of(String e1, String e2) {
        return ImmutableSet.of((Object)e1, (Object)e2);
    }

    @Override
    protected Set<String> of(String e1, String e2, String e3) {
        return ImmutableSet.of((Object)e1, (Object)e2, (Object)e3);
    }

    @Override
    protected Set<String> of(String e1, String e2, String e3, String e4) {
        return ImmutableSet.of((Object)e1, (Object)e2, (Object)e3, (Object)e4);
    }

    @Override
    protected Set<String> of(String e1, String e2, String e3, String e4, String e5) {
        return ImmutableSet.of((Object)e1, (Object)e2, (Object)e3, (Object)e4, (Object)e5);
    }

    @Override
    protected Set<String> of(String e1, String e2, String e3, String e4, String e5, String e6, String ... rest) {
        return ImmutableSet.of((Object)e1, (Object)e2, (Object)e3, (Object)e4, (Object)e5, (Object)e6, (Object[])rest);
    }

    @Override
    protected Set<String> copyOf(String[] elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    @Override
    protected Set<String> copyOf(Collection<String> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    protected Set<String> copyOf(Iterable<String> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    protected Set<String> copyOf(Iterator<String> elements) {
        return ImmutableSet.copyOf(elements);
    }

    public void testCreation_allDuplicates() {
        ImmutableSet set = ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new String[]{"a", "a"}));
        ImmutableSetTest.assertTrue((boolean)(set instanceof SingletonImmutableSet));
        ImmutableSetTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a"}), (Object)Lists.newArrayList((Iterable)set));
    }

    public void testCreation_oneDuplicate() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object[])new String[]{"g", "h", "i", "j", "k", "l", "m", "a"});
        ImmutableSetTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}), (Object)Lists.newArrayList((Iterable)set));
    }

    public void testCreation_manyDuplicates() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"c", (Object)"c", (Object)"c", (Object[])new String[]{"b", "b", "a", "a", "c", "c", "c", "a"});
        Truth.ASSERT.that((Collection)set).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c"}).inOrder();
    }

    public void testCreation_arrayOfArray() {
        String[] array = new String[]{"a"};
        ImmutableSet set = ImmutableSet.of((Object)array);
        ImmutableSetTest.assertEquals(Collections.singleton(array), (Object)set);
    }

    @GwtIncompatible(value="ImmutableSet.chooseTableSize")
    public void testChooseTableSize() {
        ImmutableSetTest.assertEquals((int)8, (int)ImmutableSet.chooseTableSize((int)3));
        ImmutableSetTest.assertEquals((int)8, (int)ImmutableSet.chooseTableSize((int)4));
        ImmutableSetTest.assertEquals((int)0x20000000, (int)ImmutableSet.chooseTableSize((int)0x10000000));
        ImmutableSetTest.assertEquals((int)0x20000000, (int)ImmutableSet.chooseTableSize((int)0x10000000));
        ImmutableSetTest.assertEquals((int)0x40000000, (int)ImmutableSet.chooseTableSize((int)0x20000000));
        ImmutableSetTest.assertEquals((int)0x40000000, (int)ImmutableSet.chooseTableSize((int)0x20000000));
        try {
            ImmutableSet.chooseTableSize((int)0x40000000);
            ImmutableSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="RegularImmutableSet.table not in emulation")
    public void testResizeTable() {
        this.verifyTableSize(100, 2, 4);
        this.verifyTableSize(100, 5, 8);
        this.verifyTableSize(100, 33, 64);
        this.verifyTableSize(17, 17, 32);
        this.verifyTableSize(17, 16, 32);
        this.verifyTableSize(17, 15, 32);
    }

    @GwtIncompatible(value="RegularImmutableSet.table not in emulation")
    private void verifyTableSize(int inputSize, int setSize, int tableSize) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < inputSize; ++i) {
            builder.add((Object)(i % setSize));
        }
        ImmutableSet set = builder.build();
        ImmutableSetTest.assertTrue((boolean)(set instanceof RegularImmutableSet));
        ImmutableSetTest.assertEquals((String)("Input size " + inputSize + " and set size " + setSize), (int)tableSize, (int)((RegularImmutableSet)set).table.length);
    }

    public void testCopyOf_copiesImmutableSortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)((Object)"a"));
        ImmutableSet copy = ImmutableSet.copyOf((Collection)sortedSet);
        ImmutableSetTest.assertNotSame((Object)sortedSet, (Object)copy);
    }

    @GwtIncompatible(value="GWT is single threaded")
    public void testCopyOf_threadSafe() {
        this.verifyThreadSafe();
    }

    @Override
    <E extends Comparable<E>> ImmutableSet.Builder<E> builder() {
        return ImmutableSet.builder();
    }

    @Override
    int getComplexBuilderSetLastElement() {
        return 49151;
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableSet.of(), ImmutableSet.of()}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)1), ImmutableSet.of((Object)1), ImmutableSet.of((Object)1, (Object)1)}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)1, (Object)2, (Object)1), ImmutableSet.of((Object)2, (Object)1, (Object)1)}).testEquals();
    }
}

