/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.NullPointerTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class IterablesTest
extends TestCase {
    private static final Predicate<CharSequence> STARTSWITH_A = new Predicate<CharSequence>(){

        public boolean apply(CharSequence input) {
            return input.length() > 0 && input.charAt(0) == 'a';
        }
    };

    public void testSize0() {
        Set iterable = Collections.emptySet();
        IterablesTest.assertEquals((int)0, (int)Iterables.size(iterable));
    }

    public void testSize1Collection() {
        Set<String> iterable = Collections.singleton("a");
        IterablesTest.assertEquals((int)1, (int)Iterables.size(iterable));
    }

    public void testSize2NonCollection() {
        Iterable<Integer> iterable = new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Arrays.asList(0, 1).iterator();
            }
        };
        IterablesTest.assertEquals((int)2, (int)Iterables.size((Iterable)iterable));
    }

    public void testSize_collection_doesntIterate() {
        List<Integer> nums = Arrays.asList(1, 2, 3, 4, 5);
        ArrayList<Integer> collection = new ArrayList<Integer>(nums){

            @Override
            public Iterator<Integer> iterator() {
                throw new AssertionFailedError("Don't iterate me!");
            }
        };
        IterablesTest.assertEquals((int)5, (int)Iterables.size((Iterable)collection));
    }

    private static Iterable<String> iterable(String ... elements) {
        final List<String> list = Arrays.asList(elements);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return list.iterator();
            }
        };
    }

    public void test_contains_null_set_yes() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", null, "b"});
        IterablesTest.assertTrue((boolean)Iterables.contains((Iterable)set, null));
    }

    public void test_contains_null_set_no() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b"});
        IterablesTest.assertFalse((boolean)Iterables.contains((Iterable)set, null));
    }

    public void test_contains_null_iterable_yes() {
        Iterable<String> set = IterablesTest.iterable("a", null, "b");
        IterablesTest.assertTrue((boolean)Iterables.contains(set, null));
    }

    public void test_contains_null_iterable_no() {
        Iterable<String> set = IterablesTest.iterable("a", "b");
        IterablesTest.assertFalse((boolean)Iterables.contains(set, null));
    }

    public void test_contains_nonnull_set_yes() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", null, "b"});
        IterablesTest.assertTrue((boolean)Iterables.contains((Iterable)set, (Object)"b"));
    }

    public void test_contains_nonnull_set_no() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b"});
        IterablesTest.assertFalse((boolean)Iterables.contains((Iterable)set, (Object)"c"));
    }

    public void test_contains_nonnull_iterable_yes() {
        Iterable<String> set = IterablesTest.iterable("a", null, "b");
        IterablesTest.assertTrue((boolean)Iterables.contains(set, (Object)"b"));
    }

    public void test_contains_nonnull_iterable_no() {
        Iterable<String> set = IterablesTest.iterable("a", "b");
        IterablesTest.assertFalse((boolean)Iterables.contains(set, (Object)"c"));
    }

    public void testGetOnlyElement_noDefault_valid() {
        List<String> iterable = Collections.singletonList("foo");
        IterablesTest.assertEquals((String)"foo", (String)((String)Iterables.getOnlyElement(iterable)));
    }

    public void testGetOnlyElement_noDefault_empty() {
        List iterable = Collections.emptyList();
        try {
            Iterables.getOnlyElement(iterable);
            IterablesTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetOnlyElement_noDefault_multiple() {
        List<String> iterable = Arrays.asList("foo", "bar");
        try {
            Iterables.getOnlyElement(iterable);
            IterablesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetOnlyElement_withDefault_singleton() {
        List<String> iterable = Collections.singletonList("foo");
        IterablesTest.assertEquals((String)"foo", (String)((String)Iterables.getOnlyElement(iterable, (Object)"bar")));
    }

    public void testGetOnlyElement_withDefault_empty() {
        List iterable = Collections.emptyList();
        IterablesTest.assertEquals((String)"bar", (String)((String)Iterables.getOnlyElement(iterable, (Object)"bar")));
    }

    public void testGetOnlyElement_withDefault_empty_null() {
        List iterable = Collections.emptyList();
        IterablesTest.assertNull((Object)Iterables.getOnlyElement(iterable, null));
    }

    public void testGetOnlyElement_withDefault_multiple() {
        List<String> iterable = Arrays.asList("foo", "bar");
        try {
            Iterables.getOnlyElement(iterable, (Object)"x");
            IterablesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Iterables.toArray(Iterable, Class)")
    public void testToArrayEmpty() {
        List iterable = Collections.emptyList();
        Object[] array = (String[])Iterables.toArray(iterable, String.class);
        IterablesTest.assertTrue((boolean)Arrays.equals(new String[0], array));
    }

    @GwtIncompatible(value="Iterables.toArray(Iterable, Class)")
    public void testToArraySingleton() {
        List<String> iterable = Collections.singletonList("a");
        Object[] array = (String[])Iterables.toArray(iterable, String.class);
        IterablesTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, array));
    }

    @GwtIncompatible(value="Iterables.toArray(Iterable, Class)")
    public void testToArray() {
        Object[] sourceArray = new String[]{"a", "b", "c"};
        List<String> iterable = Arrays.asList(sourceArray);
        Object[] newArray = (String[])Iterables.toArray(iterable, String.class);
        IterablesTest.assertTrue((boolean)Arrays.equals(sourceArray, newArray));
    }

    public void testAny() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.equalTo((Object)"pants");
        IterablesTest.assertFalse((boolean)Iterables.any((Iterable)list, (Predicate)predicate));
        list.add("cool");
        IterablesTest.assertFalse((boolean)Iterables.any((Iterable)list, (Predicate)predicate));
        list.add("pants");
        IterablesTest.assertTrue((boolean)Iterables.any((Iterable)list, (Predicate)predicate));
    }

    public void testAll() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.equalTo((Object)"cool");
        IterablesTest.assertTrue((boolean)Iterables.all((Iterable)list, (Predicate)predicate));
        list.add("cool");
        IterablesTest.assertTrue((boolean)Iterables.all((Iterable)list, (Predicate)predicate));
        list.add("pants");
        IterablesTest.assertFalse((boolean)Iterables.all((Iterable)list, (Predicate)predicate));
    }

    public void testFind() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        IterablesTest.assertEquals((String)"cool", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.equalTo((Object)"cool"))));
        IterablesTest.assertEquals((String)"pants", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.equalTo((Object)"pants"))));
        try {
            Iterables.find((Iterable)list, (Predicate)Predicates.alwaysFalse());
            IterablesTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        IterablesTest.assertEquals((String)"cool", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.alwaysTrue())));
        IterablesTest.assertCanIterateAgain(list);
    }

    public void testFind_withDefault() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        IterablesTest.assertEquals((String)"cool", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.equalTo((Object)"cool"), (Object)"woot")));
        IterablesTest.assertEquals((String)"pants", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.equalTo((Object)"pants"), (Object)"woot")));
        IterablesTest.assertEquals((String)"woot", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.alwaysFalse(), (Object)"woot")));
        IterablesTest.assertNull((Object)Iterables.find((Iterable)list, (Predicate)Predicates.alwaysFalse(), null));
        IterablesTest.assertEquals((String)"cool", (String)((String)Iterables.find((Iterable)list, (Predicate)Predicates.alwaysTrue(), (Object)"woot")));
        IterablesTest.assertCanIterateAgain(list);
    }

    public void testTryFind() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        IterablesTest.assertEquals((Object)Optional.of((Object)"cool"), (Object)Iterables.tryFind((Iterable)list, (Predicate)Predicates.equalTo((Object)"cool")));
        IterablesTest.assertEquals((Object)Optional.of((Object)"pants"), (Object)Iterables.tryFind((Iterable)list, (Predicate)Predicates.equalTo((Object)"pants")));
        IterablesTest.assertEquals((Object)Optional.of((Object)"cool"), (Object)Iterables.tryFind((Iterable)list, (Predicate)Predicates.alwaysTrue()));
        IterablesTest.assertEquals((Object)Optional.absent(), (Object)Iterables.tryFind((Iterable)list, (Predicate)Predicates.alwaysFalse()));
        IterablesTest.assertCanIterateAgain(list);
    }

    @GwtIncompatible(value="Iterables.filter(Iterable, Class)")
    public void testFilterByType() throws Exception {
        HasBoth hasBoth = new HasBoth();
        ArrayList alist = Lists.newArrayList((Object[])new TypeA[]{new TypeA(), new TypeA(), hasBoth, new TypeA()});
        Iterable blist = Iterables.filter((Iterable)alist, TypeB.class);
        Truth.ASSERT.that(blist).iteratesOverSequence((Object[])new TypeB[]{hasBoth});
    }

    public void testTransform() {
        List<String> input = Arrays.asList("1", "2", "3");
        Iterable result = Iterables.transform(input, (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        });
        ArrayList actual = Lists.newArrayList((Iterable)result);
        List<Integer> expected = Arrays.asList(1, 2, 3);
        IterablesTest.assertEquals(expected, (Object)actual);
        IterablesTest.assertCanIterateAgain(result);
        IterablesTest.assertEquals((String)"[1, 2, 3]", (String)result.toString());
    }

    public void testPoorlyBehavedTransform() {
        List<String> input = Arrays.asList("1", null, "3");
        Iterable result = Iterables.transform(input, (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        });
        Iterator resultIterator = result.iterator();
        resultIterator.next();
        try {
            resultIterator.next();
            IterablesTest.fail((String)"Expected NFE");
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    public void testNullFriendlyTransform() {
        List<Integer> input = Arrays.asList(1, 2, null, 3);
        Iterable result = Iterables.transform(input, (Function)new Function<Integer, String>(){

            public String apply(Integer from) {
                return String.valueOf(from);
            }
        });
        ArrayList actual = Lists.newArrayList((Iterable)result);
        List<String> expected = Arrays.asList("1", "2", "null", "3");
        IterablesTest.assertEquals(expected, (Object)actual);
    }

    public void testCycle() {
        String string;
        Iterable cycle = Iterables.cycle((Object[])new String[]{"a", "b"});
        int howManyChecked = 0;
        Iterator i$ = cycle.iterator();
        while (i$.hasNext()) {
            string = (String)i$.next();
            String expected = howManyChecked % 2 == 0 ? "a" : "b";
            IterablesTest.assertEquals((String)expected, (String)string);
            if (howManyChecked++ != 5) continue;
            break;
        }
        if ((i$ = cycle.iterator()).hasNext()) {
            string = (String)i$.next();
            IterablesTest.assertEquals((String)"a", (String)string);
        }
        IterablesTest.assertEquals((String)"[a, b] (cycled)", (String)cycle.toString());
    }

    public void testConcatIterable() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{4});
        ArrayList input = Lists.newArrayList((Object[])new List[]{list1, list2});
        Iterable result = Iterables.concat((Iterable)input);
        IterablesTest.assertEquals(Arrays.asList(1, 4), (Object)Lists.newArrayList((Iterable)result));
        list1.add(2);
        ArrayList list3 = Lists.newArrayList((Object[])new Integer[]{3});
        input.add(1, list3);
        IterablesTest.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)Lists.newArrayList((Iterable)result));
        IterablesTest.assertEquals((String)"[1, 2, 3, 4]", (String)result.toString());
    }

    public void testConcatVarargs() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{4});
        ArrayList list3 = Lists.newArrayList((Object[])new Integer[]{7, 8});
        ArrayList list4 = Lists.newArrayList((Object[])new Integer[]{9});
        ArrayList list5 = Lists.newArrayList((Object[])new Integer[]{10});
        Iterable result = Iterables.concat((Iterable[])new Iterable[]{list1, list2, list3, list4, list5});
        IterablesTest.assertEquals(Arrays.asList(1, 4, 7, 8, 9, 10), (Object)Lists.newArrayList((Iterable)result));
        IterablesTest.assertEquals((String)"[1, 4, 7, 8, 9, 10]", (String)result.toString());
    }

    public void testConcatNullPointerException() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{4});
        try {
            Iterables.concat((Iterable)list1, null, (Iterable)list2);
            IterablesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConcatPeformingFiniteCycle() {
        List<Integer> iterable = Arrays.asList(1, 2, 3);
        int n = 4;
        Iterable repeated = Iterables.concat(Collections.nCopies(n, iterable));
        Truth.ASSERT.that(repeated).iteratesOverSequence((Object[])new Integer[]{1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3});
    }

    public void testPartition_badSize() {
        Set<Integer> source = Collections.singleton(1);
        try {
            Iterables.partition(source, (int)0);
            IterablesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPartition_empty() {
        Set source = Collections.emptySet();
        Iterable partitions = Iterables.partition(source, (int)1);
        IterablesTest.assertTrue((boolean)Iterables.isEmpty((Iterable)partitions));
    }

    public void testPartition_singleton1() {
        Set<Integer> source = Collections.singleton(1);
        Iterable partitions = Iterables.partition(source, (int)1);
        IterablesTest.assertEquals((int)1, (int)Iterables.size((Iterable)partitions));
        IterablesTest.assertEquals(Collections.singletonList(1), partitions.iterator().next());
    }

    public void testPartition_view() {
        List<Integer> list = Arrays.asList(1, 2);
        Iterable partitions = Iterables.partition(list, (int)2);
        list.set(0, 3);
        Iterator iterator = partitions.iterator();
        list.set(1, 4);
        List first = (List)iterator.next();
        list.set(0, 5);
        IterablesTest.assertEquals((Object)ImmutableList.of((Object)3, (Object)4), (Object)first);
    }

    @GwtIncompatible(value="?")
    public void testPartitionRandomAccessInput() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        Iterable partitions = Iterables.partition(source, (int)2);
        Iterator iterator = partitions.iterator();
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
    }

    @GwtIncompatible(value="?")
    public void testPartitionNonRandomAccessInput() {
        LinkedList source = Lists.newLinkedList(Arrays.asList(1, 2, 3));
        Iterable partitions = Iterables.partition((Iterable)source, (int)2);
        Iterator iterator = partitions.iterator();
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
    }

    public void testPaddedPartition_basic() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5);
        Iterable partitions = Iterables.paddedPartition(list, (int)2);
        IterablesTest.assertEquals((int)3, (int)Iterables.size((Iterable)partitions));
        IterablesTest.assertEquals(Arrays.asList(5, null), (Object)Iterables.getLast((Iterable)partitions));
    }

    public void testPaddedPartitionRandomAccessInput() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        Iterable partitions = Iterables.paddedPartition(source, (int)2);
        Iterator iterator = partitions.iterator();
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
    }

    public void testPaddedPartitionNonRandomAccessInput() {
        LinkedList source = Lists.newLinkedList(Arrays.asList(1, 2, 3));
        Iterable partitions = Iterables.paddedPartition((Iterable)source, (int)2);
        Iterator iterator = partitions.iterator();
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
        IterablesTest.assertTrue((boolean)(iterator.next() instanceof RandomAccess));
    }

    public void testAddAllToList() {
        ArrayList alreadyThere = Lists.newArrayList((Object[])new String[]{"already", "there"});
        ArrayList freshlyAdded = Lists.newArrayList((Object[])new String[]{"freshly", "added"});
        boolean changed = Iterables.addAll((Collection)alreadyThere, (Iterable)freshlyAdded);
        Truth.ASSERT.that((List)alreadyThere).has().exactly((Object)"already", (Object)"there", (Object[])new String[]{"freshly", "added"}).inOrder();
        IterablesTest.assertTrue((boolean)changed);
    }

    private static void assertCanIterateAgain(Iterable<?> iterable) {
        for (Object obj : iterable) {
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Iterables.class);
    }

    public void testElementsEqual() throws Exception {
        List<Integer> a = Arrays.asList(4, 8, 15, 16, 23, 42);
        List<Integer> b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IterablesTest.assertTrue((boolean)Iterables.elementsEqual(a, b));
        a = Arrays.asList(4, 8, 15, 12, 23, 42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IterablesTest.assertFalse((boolean)Iterables.elementsEqual(a, b));
        a = Arrays.asList(4, 8, 15, null, 23, 42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IterablesTest.assertFalse((boolean)Iterables.elementsEqual(a, b));
        IterablesTest.assertFalse((boolean)Iterables.elementsEqual(b, a));
        a = Arrays.asList(4, 8, 15, 16, 23);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IterablesTest.assertFalse((boolean)Iterables.elementsEqual(a, b));
        IterablesTest.assertFalse((boolean)Iterables.elementsEqual(b, a));
    }

    public void testToString() {
        ArrayList list = Collections.emptyList();
        IterablesTest.assertEquals((String)"[]", (String)Iterables.toString(list));
        list = Lists.newArrayList((Object[])new String[]{"yam", "bam", "jam", "ham"});
        IterablesTest.assertEquals((String)"[yam, bam, jam, ham]", (String)Iterables.toString((Iterable)list));
    }

    public void testLimit() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"});
        Iterable limited = Iterables.limit((Iterable)iterable, (int)2);
        ImmutableList expected = ImmutableList.of((Object)"foo", (Object)"bar");
        ArrayList actual = Lists.newArrayList((Iterable)limited);
        IterablesTest.assertEquals((Object)expected, (Object)actual);
        IterablesTest.assertCanIterateAgain(limited);
        IterablesTest.assertEquals((String)"[foo, bar]", (String)limited.toString());
    }

    public void testLimit_illegalArgument() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        try {
            Iterables.limit((Iterable)list, (int)-1);
            IterablesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        List emptyList = Collections.emptyList();
        IterablesTest.assertTrue((boolean)Iterables.isEmpty(emptyList));
        List<String> singletonList = Collections.singletonList("foo");
        IterablesTest.assertFalse((boolean)Iterables.isEmpty(singletonList));
    }

    public void testSkip_simple() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e");
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e"}), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)set, (int)2)));
        IterablesTest.assertEquals((String)"[c, d, e]", (String)Iterables.skip((Iterable)set, (int)2).toString());
    }

    public void testSkip_simpleList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e"}), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)list, (int)2)));
        IterablesTest.assertEquals((String)"[c, d, e]", (String)Iterables.skip((Iterable)list, (int)2).toString());
    }

    public void testSkip_pastEnd() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b");
        IterablesTest.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)set, (int)20)));
    }

    public void testSkip_pastEndList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        IterablesTest.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)list, (int)20)));
    }

    public void testSkip_skipNone() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b");
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)set, (int)0)));
    }

    public void testSkip_skipNoneList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)Lists.newArrayList((Iterable)Iterables.skip((Iterable)list, (int)0)));
    }

    public void testSkip_removal() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b"});
        Iterator iterator = Iterables.skip((Iterable)set, (int)2).iterator();
        try {
            iterator.next();
        }
        catch (NoSuchElementException suppressed) {
            // empty catch block
        }
        try {
            iterator.remove();
            IterablesTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSkip_allOfMutableList_modifiable() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        Iterator iterator = Iterables.skip((Iterable)list, (int)2).iterator();
        try {
            iterator.remove();
            IterablesTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSkip_allOfImmutableList_modifiable() {
        ImmutableList list = ImmutableList.of((Object)"a", (Object)"b");
        Iterator iterator = Iterables.skip((Iterable)list, (int)2).iterator();
        try {
            iterator.remove();
            IterablesTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="slow (~35s)")
    public void testSkip_iterator() {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterables.skip((Iterable)Sets.newLinkedHashSet(Arrays.asList(1, 2, 3)), (int)1).iterator();
            }
        }.test();
    }

    @GwtIncompatible(value="slow (~35s)")
    public void testSkip_iteratorList() {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterables.skip((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), (int)1).iterator();
            }
        }.test();
    }

    public void testSkip_nonStructurallyModifiedList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable tail = Iterables.skip((Iterable)list, (int)1);
        Iterator tailIterator = tail.iterator();
        list.set(2, "C");
        IterablesTest.assertEquals((String)"b", (String)((String)tailIterator.next()));
        IterablesTest.assertEquals((String)"C", (String)((String)tailIterator.next()));
        IterablesTest.assertFalse((boolean)tailIterator.hasNext());
    }

    public void testSkip_structurallyModifiedSkipSome() throws Exception {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList("a", "b", "c"));
        Iterable tail = Iterables.skip((Iterable)set, (int)1);
        set.remove("b");
        set.addAll(Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
        Truth.ASSERT.that(tail).iteratesOverSequence((Object[])new String[]{"c", "A", "B", "C"});
    }

    public void testSkip_structurallyModifiedSkipSomeList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable tail = Iterables.skip((Iterable)list, (int)1);
        list.subList(1, 3).clear();
        list.addAll(0, Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
        Truth.ASSERT.that(tail).iteratesOverSequence((Object[])new String[]{"B", "C", "a"});
    }

    public void testSkip_structurallyModifiedSkipAll() throws Exception {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList("a", "b", "c"));
        Iterable tail = Iterables.skip((Iterable)set, (int)2);
        set.remove("a");
        set.remove("b");
        IterablesTest.assertFalse((boolean)tail.iterator().hasNext());
    }

    public void testSkip_structurallyModifiedSkipAllList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable tail = Iterables.skip((Iterable)list, (int)2);
        list.subList(0, 2).clear();
        IterablesTest.assertTrue((boolean)Iterables.isEmpty((Iterable)tail));
    }

    public void testSkip_illegalArgument() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        try {
            Iterables.skip((Iterable)list, (int)-1);
            IterablesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testGetOnAbc(Iterable<String> iterable) {
        try {
            Iterables.get(iterable, (int)-1);
            IterablesTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        IterablesTest.assertEquals((String)"a", (String)((String)Iterables.get(iterable, (int)0)));
        IterablesTest.assertEquals((String)"b", (String)((String)Iterables.get(iterable, (int)1)));
        IterablesTest.assertEquals((String)"c", (String)((String)Iterables.get(iterable, (int)2)));
        try {
            Iterables.get(iterable, (int)3);
            IterablesTest.fail();
        }
        catch (IndexOutOfBoundsException nsee) {
            // empty catch block
        }
        try {
            Iterables.get(iterable, (int)4);
            IterablesTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void testGetOnEmpty(Iterable<String> iterable) {
        try {
            Iterables.get(iterable, (int)0);
            IterablesTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGet_list() {
        this.testGetOnAbc(Lists.newArrayList((Object[])new String[]{"a", "b", "c"}));
    }

    public void testGet_emptyList() {
        this.testGetOnEmpty(Collections.<String>emptyList());
    }

    public void testGet_sortedSet() {
        this.testGetOnAbc((Iterable<String>)ImmutableSortedSet.of((Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"a")));
    }

    public void testGet_emptySortedSet() {
        this.testGetOnEmpty((Iterable<String>)ImmutableSortedSet.of());
    }

    public void testGet_iterable() {
        this.testGetOnAbc((Iterable<String>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"));
    }

    public void testGet_emptyIterable() {
        this.testGetOnEmpty(Sets.newHashSet());
    }

    public void testGet_withDefault_negativePosition() {
        try {
            Iterables.get((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (int)-1, (Object)"d");
            IterablesTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGet_withDefault_simple() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        IterablesTest.assertEquals((String)"b", (String)((String)Iterables.get((Iterable)list, (int)1, (Object)"d")));
    }

    public void testGet_withDefault_iterable() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        IterablesTest.assertEquals((String)"b", (String)((String)Iterables.get((Iterable)set, (int)1, (Object)"d")));
    }

    public void testGet_withDefault_last() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        IterablesTest.assertEquals((String)"c", (String)((String)Iterables.get((Iterable)list, (int)2, (Object)"d")));
    }

    public void testGet_withDefault_lastPlusOne() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        IterablesTest.assertEquals((String)"d", (String)((String)Iterables.get((Iterable)list, (int)3, (Object)"d")));
    }

    public void testGet_withDefault_doesntIterate() {
        DiesOnIteratorArrayList list = new DiesOnIteratorArrayList();
        list.add("a");
        IterablesTest.assertEquals((String)"a", (String)((String)Iterables.get((Iterable)list, (int)0, (Object)"b")));
    }

    public void testGetFirst_withDefault_singleton() {
        List<String> iterable = Collections.singletonList("foo");
        IterablesTest.assertEquals((String)"foo", (String)((String)Iterables.getFirst(iterable, (Object)"bar")));
    }

    public void testGetFirst_withDefault_empty() {
        List iterable = Collections.emptyList();
        IterablesTest.assertEquals((String)"bar", (String)((String)Iterables.getFirst(iterable, (Object)"bar")));
    }

    public void testGetFirst_withDefault_empty_null() {
        List iterable = Collections.emptyList();
        IterablesTest.assertNull((Object)Iterables.getFirst(iterable, null));
    }

    public void testGetFirst_withDefault_multiple() {
        List<String> iterable = Arrays.asList("foo", "bar");
        IterablesTest.assertEquals((String)"foo", (String)((String)Iterables.getFirst(iterable, (Object)"qux")));
    }

    public void testGetLast_list() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        IterablesTest.assertEquals((String)"c", (String)((String)Iterables.getLast((Iterable)list)));
    }

    public void testGetLast_emptyList() {
        List list = Collections.emptyList();
        try {
            Iterables.getLast(list);
            IterablesTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetLast_sortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"a"));
        IterablesTest.assertEquals((String)"c", (String)((String)Iterables.getLast((Iterable)sortedSet)));
    }

    public void testGetLast_withDefault_singleton() {
        List<String> iterable = Collections.singletonList("foo");
        IterablesTest.assertEquals((String)"foo", (String)((String)Iterables.getLast(iterable, (Object)"bar")));
    }

    public void testGetLast_withDefault_empty() {
        List iterable = Collections.emptyList();
        IterablesTest.assertEquals((String)"bar", (String)((String)Iterables.getLast(iterable, (Object)"bar")));
    }

    public void testGetLast_withDefault_empty_null() {
        List iterable = Collections.emptyList();
        IterablesTest.assertNull((Object)Iterables.getLast(iterable, null));
    }

    public void testGetLast_withDefault_multiple() {
        List<String> iterable = Arrays.asList("foo", "bar");
        IterablesTest.assertEquals((String)"bar", (String)((String)Iterables.getLast(iterable, (Object)"qux")));
    }

    public void testGetLast_withDefault_not_empty_list() {
        DiesOnIteratorArrayList diesOnIteratorList = new DiesOnIteratorArrayList();
        diesOnIteratorList.add("bar");
        IterablesTest.assertEquals((String)"bar", (String)((String)Iterables.getLast((Iterable)diesOnIteratorList, (Object)"qux")));
    }

    public void testGetLast_emptySortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of();
        try {
            Iterables.getLast((Iterable)sortedSet);
            IterablesTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetLast_iterable() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        IterablesTest.assertEquals((String)"c", (String)((String)Iterables.getLast((Iterable)set)));
    }

    public void testGetLast_emptyIterable() {
        HashSet set = Sets.newHashSet();
        try {
            Iterables.getLast((Iterable)set);
            IterablesTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testUnmodifiableIterable() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable iterable = Iterables.unmodifiableIterable((Iterable)list);
        Iterator iterator = iterable.iterator();
        iterator.next();
        try {
            iterator.remove();
            IterablesTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        IterablesTest.assertEquals((String)"[a, b, c]", (String)iterable.toString());
    }

    public void testUnmodifiableIterableShortCircuit() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable iterable = Iterables.unmodifiableIterable((Iterable)list);
        Iterable iterable2 = Iterables.unmodifiableIterable((Iterable)iterable);
        IterablesTest.assertSame((Object)iterable, (Object)iterable2);
        ImmutableList immutableList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        IterablesTest.assertSame((Object)immutableList, (Object)Iterables.unmodifiableIterable((ImmutableCollection)immutableList));
        IterablesTest.assertSame((Object)immutableList, (Object)Iterables.unmodifiableIterable((Iterable)immutableList));
    }

    public void testFrequency_multiset() {
        ImmutableMultiset multiset = ImmutableMultiset.of((Object)"a", (Object)"b", (Object)"a", (Object)"c", (Object)"b", (Object)"a", (Object[])new String[0]);
        IterablesTest.assertEquals((int)3, (int)Iterables.frequency((Iterable)multiset, (Object)"a"));
        IterablesTest.assertEquals((int)2, (int)Iterables.frequency((Iterable)multiset, (Object)"b"));
        IterablesTest.assertEquals((int)1, (int)Iterables.frequency((Iterable)multiset, (Object)"c"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)multiset, (Object)"d"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)multiset, (Object)4.2));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)multiset, null));
    }

    public void testFrequency_set() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b", "c"});
        IterablesTest.assertEquals((int)1, (int)Iterables.frequency((Iterable)set, (Object)"a"));
        IterablesTest.assertEquals((int)1, (int)Iterables.frequency((Iterable)set, (Object)"b"));
        IterablesTest.assertEquals((int)1, (int)Iterables.frequency((Iterable)set, (Object)"c"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)set, (Object)"d"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)set, (Object)4.2));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)set, null));
    }

    public void testFrequency_list() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "a", "c", "b", "a"});
        IterablesTest.assertEquals((int)3, (int)Iterables.frequency((Iterable)list, (Object)"a"));
        IterablesTest.assertEquals((int)2, (int)Iterables.frequency((Iterable)list, (Object)"b"));
        IterablesTest.assertEquals((int)1, (int)Iterables.frequency((Iterable)list, (Object)"c"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)list, (Object)"d"));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)list, (Object)4.2));
        IterablesTest.assertEquals((int)0, (int)Iterables.frequency((Iterable)list, null));
    }

    public void testRemoveAll_collection() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IterablesTest.assertTrue((boolean)Iterables.removeAll((Iterable)list, (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.removeAll((Iterable)list, (Collection)Lists.newArrayList((Object[])new String[]{"x", "y", "z"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testRemoveAll_iterable() {
        final ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return list.iterator();
            }
        };
        IterablesTest.assertTrue((boolean)Iterables.removeAll((Iterable)iterable, (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.removeAll((Iterable)iterable, (Collection)Lists.newArrayList((Object[])new String[]{"x", "y", "z"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testRetainAll_collection() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IterablesTest.assertTrue((boolean)Iterables.retainAll((Iterable)list, (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.retainAll((Iterable)list, (Collection)Lists.newArrayList((Object[])new String[]{"b", "e", "d"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
    }

    public void testRetainAll_iterable() {
        final ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return list.iterator();
            }
        };
        IterablesTest.assertTrue((boolean)Iterables.retainAll((Iterable)iterable, (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.retainAll((Iterable)iterable, (Collection)Lists.newArrayList((Object[])new String[]{"b", "e", "d"})));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
    }

    public void testRemoveIf_randomAccess() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IterablesTest.assertTrue((boolean)Iterables.removeIf((Iterable)list, (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("b") || s.equals("d") || s.equals("f");
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.removeIf((Iterable)list, (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("x") || s.equals("y") || s.equals("z");
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testRemoveIf_transformedList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
        List transformed = Lists.transform((List)list, (Function)new Function<String, Integer>(){

            public Integer apply(String s) {
                return Integer.valueOf(s);
            }
        });
        IterablesTest.assertTrue((boolean)Iterables.removeIf((Iterable)transformed, (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer n) {
                return (n & 1) == 0;
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"1", "3", "5"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.removeIf((Iterable)transformed, (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer n) {
                return (n & 1) == 0;
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"1", "3", "5"}), (Object)list);
    }

    public void testRemoveIf_noRandomAccess() {
        LinkedList list = Lists.newLinkedList(Arrays.asList("a", "b", "c", "d", "e"));
        IterablesTest.assertTrue((boolean)Iterables.removeIf((Iterable)list, (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("b") || s.equals("d") || s.equals("f");
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IterablesTest.assertFalse((boolean)Iterables.removeIf((Iterable)list, (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("x") || s.equals("y") || s.equals("z");
            }
        }));
        IterablesTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testIterableWithToString() {
        IterablesTest.assertEquals((String)"[]", (String)IterablesTest.create(new String[0]).toString());
        IterablesTest.assertEquals((String)"[a]", (String)IterablesTest.create("a").toString());
        IterablesTest.assertEquals((String)"[a, b, c]", (String)IterablesTest.create("a", "b", "c").toString());
        IterablesTest.assertEquals((String)"[c, a, a]", (String)IterablesTest.create("c", "a", "a").toString());
    }

    public void testIterableWithToStringNull() {
        IterablesTest.assertEquals((String)"[null]", (String)IterablesTest.create(new String[]{null}).toString());
        IterablesTest.assertEquals((String)"[null, null]", (String)IterablesTest.create(null, null).toString());
        IterablesTest.assertEquals((String)"[, null, a]", (String)IterablesTest.create("", null, "a").toString());
    }

    private static Iterable<String> create(String ... strings) {
        final List<String> list = Arrays.asList(strings);
        return new FluentIterable<String>(){

            public Iterator<String> iterator() {
                return list.iterator();
            }
        };
    }

    public void testConsumingIterable() {
        ArrayList list = Lists.newArrayList(Arrays.asList("a", "b"));
        Iterable consumingIterable = Iterables.consumingIterable((Iterable)list);
        IterablesTest.assertEquals((String)"Iterables.consumingIterable(...)", (String)consumingIterable.toString());
        Iterator consumingIterator = consumingIterable.iterator();
        Truth.ASSERT.that((List)list).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
        IterablesTest.assertTrue((boolean)consumingIterator.hasNext());
        Truth.ASSERT.that((List)list).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
        IterablesTest.assertEquals((String)"a", (String)((String)consumingIterator.next()));
        Truth.ASSERT.that((List)list).has().item((Object)"b");
        IterablesTest.assertTrue((boolean)consumingIterator.hasNext());
        IterablesTest.assertEquals((String)"b", (String)((String)consumingIterator.next()));
        Truth.ASSERT.that((List)list).isEmpty();
        IterablesTest.assertFalse((boolean)consumingIterator.hasNext());
    }

    @GwtIncompatible(value="?")
    public void testConsumingIterable_duelingIterators() {
        ArrayList list = Lists.newArrayList(Arrays.asList("a", "b"));
        Iterator i1 = Iterables.consumingIterable((Iterable)list).iterator();
        Iterator i2 = Iterables.consumingIterable((Iterable)list).iterator();
        i1.next();
        try {
            i2.next();
            IterablesTest.fail((String)"Concurrent modification should throw an exception.");
        }
        catch (ConcurrentModificationException cme) {
            // empty catch block
        }
    }

    public void testConsumingIterable_queue_iterator() {
        ImmutableList items = ImmutableList.of((Object)4, (Object)8, (Object)15, (Object)16, (Object)23, (Object)42);
        new IteratorTester<Integer>(3, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)items, AbstractIteratorTester.KnownOrder.KNOWN_ORDER, (List)items){
            final /* synthetic */ List val$items;
            {
                this.val$items = list;
                super(x0, x1, x2, x3);
            }

            protected Iterator<Integer> newTargetIterator() {
                return Iterables.consumingIterable((Iterable)Lists.newLinkedList((Iterable)this.val$items)).iterator();
            }
        }.test();
    }

    public void testConsumingIterable_queue_removesFromQueue() {
        LinkedList queue = Lists.newLinkedList(Arrays.asList(5, 14));
        Iterator consumingIterator = Iterables.consumingIterable((Iterable)queue).iterator();
        IterablesTest.assertEquals((int)5, (int)((Integer)queue.peek()));
        IterablesTest.assertEquals((int)5, (int)((Integer)consumingIterator.next()));
        IterablesTest.assertEquals((int)14, (int)((Integer)queue.peek()));
        IterablesTest.assertTrue((boolean)consumingIterator.hasNext());
        IterablesTest.assertTrue((boolean)queue.isEmpty());
    }

    public void testConsumingIterable_noIteratorCall() {
        UnIterableQueue queue = new UnIterableQueue(Lists.newLinkedList(Arrays.asList(5, 14)));
        Iterator consumingIterator = Iterables.consumingIterable(queue).iterator();
        IterablesTest.assertEquals((int)5, (int)((Integer)consumingIterator.next()));
    }

    public void testIndexOf_empty() {
        ArrayList list = new ArrayList();
        IterablesTest.assertEquals((int)-1, (int)Iterables.indexOf(list, (Predicate)Predicates.equalTo((Object)"")));
    }

    public void testIndexOf_oneElement() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"bob"});
        IterablesTest.assertEquals((int)0, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"bob")));
        IterablesTest.assertEquals((int)-1, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"jack")));
    }

    public void testIndexOf_twoElements() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"mary", "bob"});
        IterablesTest.assertEquals((int)0, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"mary")));
        IterablesTest.assertEquals((int)1, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"bob")));
        IterablesTest.assertEquals((int)-1, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"jack")));
    }

    public void testIndexOf_withDuplicates() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"mary", "bob", "bob", "bob", "sam"});
        IterablesTest.assertEquals((int)0, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"mary")));
        IterablesTest.assertEquals((int)1, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"bob")));
        IterablesTest.assertEquals((int)4, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"sam")));
        IterablesTest.assertEquals((int)-1, (int)Iterables.indexOf((Iterable)list, (Predicate)Predicates.equalTo((Object)"jack")));
    }

    public void testIndexOf_genericPredicate() {
        ArrayList sequences = Lists.newArrayList();
        sequences.add("bob");
        sequences.add(new StringBuilder("charlie"));
        sequences.add(new StringBuffer("henry"));
        sequences.add(new StringBuilder("apple"));
        sequences.add("lemon");
        IterablesTest.assertEquals((int)3, (int)Iterables.indexOf((Iterable)sequences, STARTSWITH_A));
    }

    public void testIndexOf_genericPredicate2() {
        ArrayList sequences = Lists.newArrayList((Object[])new String[]{"bob", "charlie", "henry", "apple", "lemon"});
        IterablesTest.assertEquals((int)3, (int)Iterables.indexOf((Iterable)sequences, STARTSWITH_A));
    }

    public void testMergeSorted_empty() {
        ImmutableList elements = ImmutableList.of();
        Iterable iterable = Iterables.mergeSorted((Iterable)elements, (Comparator)Ordering.natural());
        Iterator iterator = iterable.iterator();
        IterablesTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            IterablesTest.fail((String)"next() on empty iterator should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testMergeSorted_single_empty() {
        ImmutableList iterable0 = ImmutableList.of();
        ImmutableList iterables = ImmutableList.of((Object)iterable0);
        IterablesTest.verifyMergeSorted((Iterable<Iterable<Integer>>)iterables, (Iterable<Integer>)ImmutableList.of());
    }

    public void testMergeSorted_single() {
        ImmutableList iterable0 = ImmutableList.of((Object)1, (Object)2, (Object)3);
        ImmutableList iterables = ImmutableList.of((Object)iterable0);
        IterablesTest.verifyMergeSorted((Iterable<Iterable<Integer>>)iterables, (Iterable<Integer>)iterable0);
    }

    public void testMergeSorted_pyramid() {
        LinkedList iterables = Lists.newLinkedList();
        ArrayList allIntegers = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            LinkedList list = Lists.newLinkedList();
            for (int j = 0; j < i; ++j) {
                list.add(j);
                allIntegers.add(j);
            }
            iterables.add(Ordering.natural().sortedCopy((Iterable)list));
        }
        IterablesTest.verifyMergeSorted(iterables, allIntegers);
    }

    public void testMergeSorted_skipping_pyramid() {
        LinkedList iterables = Lists.newLinkedList();
        ArrayList allIntegers = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            LinkedList list = Lists.newLinkedList();
            for (int j = 0; j < i; ++j) {
                list.add(j * i);
                allIntegers.add(j * i);
            }
            iterables.add(Ordering.natural().sortedCopy((Iterable)list));
        }
        IterablesTest.verifyMergeSorted(iterables, allIntegers);
    }

    @GwtIncompatible(value="reflection")
    public void testIterables_nullCheck() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Iterables.class).thatReturn(Iterable.class).testNulls();
    }

    private static void verifyMergeSorted(Iterable<Iterable<Integer>> iterables, Iterable<Integer> unsortedExpected) {
        List expected = Ordering.natural().sortedCopy(unsortedExpected);
        Iterable mergedIterator = Iterables.mergeSorted(iterables, (Comparator)Ordering.natural());
        IterablesTest.assertEquals((Object)Lists.newLinkedList((Iterable)expected), (Object)Lists.newLinkedList((Iterable)mergedIterator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnIterableQueue<T>
    extends ForwardingQueue<T> {
        private Queue<T> queue;

        UnIterableQueue(Queue<T> queue) {
            this.queue = queue;
        }

        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        protected Queue<T> delegate() {
            return this.queue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DiesOnIteratorTreeSet
    extends TreeSet<String> {
        private DiesOnIteratorTreeSet() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiesOnIteratorArrayList
    extends ArrayList<String> {
        private DiesOnIteratorArrayList() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    private static class HasBoth
    extends TypeA
    implements TypeB {
        private HasBoth() {
        }
    }

    private static interface TypeB {
    }

    private static class TypeA {
        private TypeA() {
        }
    }
}

