/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class LinkedHashMultimapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedHashMultimap multimap = LinkedHashMultimap.create();
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }
        }).named("LinkedHashMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        suite.addTestSuite(LinkedHashMultimapTest.class);
        return suite;
    }

    public void testValueSetHashTableExpansion() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        for (int z = 1; z <= 100; ++z) {
            multimap.put((Object)"a", (Object)z);
            LinkedHashMultimap.ValueSet valueSet = (LinkedHashMultimap.ValueSet)multimap.backingMap().get("a");
            LinkedHashMultimapTest.assertEquals((int)z, (int)valueSet.size());
            LinkedHashMultimapTest.assertFalse((boolean)Hashing.needsResizing((int)valueSet.size(), (int)valueSet.hashTable.length, (double)1.0));
        }
    }

    private Multimap<String, Integer> initializeMultimap5() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)5);
        multimap.put((Object)"bar", (Object)4);
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"cow", (Object)2);
        multimap.put((Object)"bar", (Object)1);
        return multimap;
    }

    public void testToString() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"bar", (Object)1);
        multimap.putAll((Object)"foo", Arrays.asList(-1, 2, 4));
        multimap.putAll((Object)"bar", Arrays.asList(2, 3));
        multimap.put((Object)"foo", (Object)1);
        LinkedHashMultimapTest.assertEquals((String)"{foo=[3, -1, 2, 4, 1], bar=[1, 2, 3]}", (String)multimap.toString());
    }

    public void testOrderingReadOnly() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        this.assertOrderingReadOnly(multimap);
    }

    public void testOrderingUnmodifiable() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        this.assertOrderingReadOnly((Multimap<String, Integer>)Multimaps.unmodifiableMultimap(multimap));
    }

    public void testOrderingSynchronized() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        this.assertOrderingReadOnly((Multimap<String, Integer>)Multimaps.synchronizedMultimap(multimap));
    }

    @GwtIncompatible(value="SeriazableTester")
    public void testSerializationOrdering() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        Multimap copy = (Multimap)SerializableTester.reserializeAndAssert(multimap);
        this.assertOrderingReadOnly((Multimap<String, Integer>)copy);
    }

    @GwtIncompatible(value="SeriazableTester")
    public void testSerializationOrderingKeysAndEntries() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"a", (Object)1);
        multimap.put((Object)"b", (Object)2);
        multimap.put((Object)"a", (Object)3);
        multimap.put((Object)"c", (Object)4);
        multimap.remove((Object)"a", (Object)1);
        multimap = (Multimap)SerializableTester.reserializeAndAssert((Object)multimap);
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c"}).inOrder();
        Truth.ASSERT.that(multimap.entries()).has().exactly((Object)Helpers.mapEntry((Object)"b", (Object)2), (Object)Helpers.mapEntry((Object)"a", (Object)3), (Object[])new Map.Entry[]{Helpers.mapEntry((Object)"c", (Object)4)}).inOrder();
    }

    private void assertOrderingReadOnly(Multimap<String, Integer> multimap) {
        Truth.ASSERT.that(multimap.get((Object)"foo")).has().exactly((Object)5, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that(multimap.get((Object)"bar")).has().exactly((Object)4, (Object)1, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that(multimap.get((Object)"cow")).has().item((Object)2);
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"cow"}).inOrder();
        Truth.ASSERT.that(multimap.values()).has().exactly((Object)5, (Object)4, (Object[])new Integer[]{3, 2, 1}).inOrder();
        Iterator entryIterator = multimap.entries().iterator();
        LinkedHashMultimapTest.assertEquals((Object)Maps.immutableEntry((Object)"foo", (Object)5), entryIterator.next());
        LinkedHashMultimapTest.assertEquals((Object)Maps.immutableEntry((Object)"bar", (Object)4), entryIterator.next());
        LinkedHashMultimapTest.assertEquals((Object)Maps.immutableEntry((Object)"foo", (Object)3), entryIterator.next());
        LinkedHashMultimapTest.assertEquals((Object)Maps.immutableEntry((Object)"cow", (Object)2), entryIterator.next());
        LinkedHashMultimapTest.assertEquals((Object)Maps.immutableEntry((Object)"bar", (Object)1), entryIterator.next());
        Iterator collectionIterator = multimap.asMap().entrySet().iterator();
        Map.Entry entry = collectionIterator.next();
        LinkedHashMultimapTest.assertEquals((String)"foo", (String)((String)entry.getKey()));
        Truth.ASSERT.that((Collection)entry.getValue()).has().exactly((Object)5, (Object)3, (Object[])new Integer[0]).inOrder();
        entry = collectionIterator.next();
        LinkedHashMultimapTest.assertEquals((String)"bar", (String)((String)entry.getKey()));
        Truth.ASSERT.that((Collection)entry.getValue()).has().exactly((Object)4, (Object)1, (Object[])new Integer[0]).inOrder();
        entry = collectionIterator.next();
        LinkedHashMultimapTest.assertEquals((String)"cow", (String)((String)entry.getKey()));
        Truth.ASSERT.that((Collection)entry.getValue()).has().item((Object)2);
    }

    public void testOrderingUpdates() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        Truth.ASSERT.that(multimap.replaceValues((Object)"foo", Arrays.asList(6, 7))).has().exactly((Object)5, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"cow"}).inOrder();
        Truth.ASSERT.that(multimap.removeAll((Object)"foo")).has().exactly((Object)6, (Object)7, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"bar", (Object)"cow", (Object[])new String[0]).inOrder();
        LinkedHashMultimapTest.assertTrue((boolean)multimap.remove((Object)"bar", (Object)4));
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"bar", (Object)"cow", (Object[])new String[0]).inOrder();
        LinkedHashMultimapTest.assertTrue((boolean)multimap.remove((Object)"bar", (Object)1));
        Truth.ASSERT.that((Collection)multimap.keySet()).has().item((Object)"cow");
        multimap.put((Object)"bar", (Object)9);
        Truth.ASSERT.that((Collection)multimap.keySet()).has().exactly((Object)"cow", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testToStringNullExact() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"foo", (Object)-1);
        multimap.put(null, null);
        multimap.put((Object)"bar", (Object)1);
        multimap.put((Object)"foo", (Object)2);
        multimap.put(null, (Object)0);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"bar", null);
        multimap.put((Object)"foo", null);
        multimap.put((Object)"foo", (Object)4);
        multimap.put(null, (Object)-1);
        multimap.put((Object)"bar", (Object)3);
        multimap.put((Object)"bar", (Object)1);
        multimap.put((Object)"foo", (Object)1);
        LinkedHashMultimapTest.assertEquals((String)"{foo=[3, -1, 2, null, 4, 1], null=[null, 0, -1], bar=[1, 2, null, 3]}", (String)multimap.toString());
    }

    public void testPutMultimapOrdered() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.putAll(this.initializeMultimap5());
        this.assertOrderingReadOnly((Multimap<String, Integer>)multimap);
    }

    public void testKeysToString_ordering() {
        Multimap<String, Integer> multimap = this.initializeMultimap5();
        LinkedHashMultimapTest.assertEquals((String)"[foo x 2, bar x 2, cow]", (String)multimap.keys().toString());
    }

    public void testCreate() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        LinkedHashMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)3), (Object)multimap.get((Object)"foo"));
    }

    public void testCreateFromMultimap() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"a", (Object)1);
        multimap.put((Object)"b", (Object)2);
        multimap.put((Object)"a", (Object)3);
        multimap.put((Object)"c", (Object)4);
        LinkedHashMultimap copy = LinkedHashMultimap.create((Multimap)multimap);
        new EqualsTester().addEqualityGroup(new Object[]{multimap, copy}).testEquals();
    }

    public void testCreateFromSizes() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create((int)20, (int)15);
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        LinkedHashMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)3), (Object)multimap.get((Object)"foo"));
    }

    public void testCreateFromIllegalSizes() {
        try {
            LinkedHashMultimap.create((int)-20, (int)15);
            LinkedHashMultimapTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            LinkedHashMultimap.create((int)20, (int)-15);
            LinkedHashMultimapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testGetIteration() {
        new IteratorTester<Integer>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Sets.newLinkedHashSet(Arrays.asList(2, 3, 4, 7, 8)), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Integer> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3, 4));
                this.multimap.putAll((Object)"bar", Arrays.asList(5, 6));
                this.multimap.putAll((Object)"foo", Arrays.asList(7, 8));
                return this.multimap.get((Object)"foo").iterator();
            }

            protected void verify(List<Integer> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)this.multimap.get((Object)"foo"));
            }
        }.test();
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testEntriesIteration() {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList(Maps.immutableEntry((Object)"foo", (Object)2), Maps.immutableEntry((Object)"foo", (Object)3), Maps.immutableEntry((Object)"bar", (Object)4), Maps.immutableEntry((Object)"bar", (Object)5), Maps.immutableEntry((Object)"foo", (Object)6)));
        new IteratorTester<Map.Entry<String, Integer>>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)set, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Map.Entry<String, Integer>> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                return this.multimap.entries().iterator();
            }

            protected void verify(List<Map.Entry<String, Integer>> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)this.multimap.entries());
            }
        }.test();
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testKeysIteration() {
        new IteratorTester<String>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new String[]{"foo", "foo", "bar", "bar", "foo"}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<String> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                return this.multimap.keys().iterator();
            }

            protected void verify(List<String> elements) {
                Assert.assertEquals(elements, (Object)Lists.newArrayList((Iterable)this.multimap.keys()));
            }
        }.test();
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testValuesIteration() {
        new IteratorTester<Integer>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 5, 6}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Integer> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                return this.multimap.values().iterator();
            }

            protected void verify(List<Integer> elements) {
                Assert.assertEquals(elements, (Object)Lists.newArrayList((Iterable)this.multimap.values()));
            }
        }.test();
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testKeySetIteration() {
        new IteratorTester<String>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Sets.newLinkedHashSet(Arrays.asList("foo", "bar", "baz", "dog", "cat")), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<String> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                this.multimap.putAll((Object)"baz", Arrays.asList(7, 8));
                this.multimap.putAll((Object)"dog", Arrays.asList(9));
                this.multimap.putAll((Object)"bar", Arrays.asList(10, 11));
                this.multimap.putAll((Object)"cat", Arrays.asList(12, 13, 14));
                return this.multimap.keySet().iterator();
            }

            protected void verify(List<String> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)this.multimap.keySet());
            }
        }.test();
    }

    @GwtIncompatible(value="unreasonably slow")
    public void testAsSetIteration() {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList(Maps.immutableEntry((Object)"foo", (Object)Sets.newHashSet((Object[])new Integer[]{2, 3, 6})), Maps.immutableEntry((Object)"bar", (Object)Sets.newHashSet((Object[])new Integer[]{4, 5, 10, 11})), Maps.immutableEntry((Object)"baz", (Object)Sets.newHashSet((Object[])new Integer[]{7, 8})), Maps.immutableEntry((Object)"dog", (Object)Sets.newHashSet((Object[])new Integer[]{9})), Maps.immutableEntry((Object)"cat", (Object)Sets.newHashSet((Object[])new Integer[]{12, 13, 14}))));
        new IteratorTester<Map.Entry<String, Collection<Integer>>>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)set, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Map.Entry<String, Collection<Integer>>> newTargetIterator() {
                this.multimap = LinkedHashMultimap.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                this.multimap.putAll((Object)"baz", Arrays.asList(7, 8));
                this.multimap.putAll((Object)"dog", Arrays.asList(9));
                this.multimap.putAll((Object)"bar", Arrays.asList(10, 11));
                this.multimap.putAll((Object)"cat", Arrays.asList(12, 13, 14));
                return this.multimap.asMap().entrySet().iterator();
            }

            protected void verify(List<Map.Entry<String, Collection<Integer>>> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), this.multimap.asMap().entrySet());
            }
        }.test();
    }
}

