/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.google.ListGenerators;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class ListsTest
extends TestCase {
    private static final Collection<Integer> SOME_COLLECTION = Arrays.asList(0, 1, 1);
    private static final Iterable<Integer> SOME_ITERABLE = new SomeIterable();
    private static final List<Integer> SOME_LIST = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
    private static final List<Integer> SOME_SEQUENTIAL_LIST = Lists.newLinkedList(Arrays.asList(1, 2, 3, 4));
    private static final List<String> SOME_STRING_LIST = Arrays.asList("1", "2", "3", "4");
    private static final Function<Number, String> SOME_FUNCTION = new SomeFunction();

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ListsTest.class);
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                Object[] rest = new String[elements.length - 1];
                System.arraycopy(elements, 1, rest, 0, elements.length - 1);
                return Lists.asList((Object)elements[0], (Object[])rest);
            }
        }).named("Lists.asList, 2 parameter")).withFeatures(new Feature[]{CollectionSize.SEVERAL, CollectionSize.ONE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                Object[] rest = new String[elements.length - 2];
                System.arraycopy(elements, 2, rest, 0, elements.length - 2);
                return Lists.asList((Object)elements[0], (Object)elements[1], (Object[])rest);
            }
        }).named("Lists.asList, 3 parameter")).withFeatures(new Feature[]{CollectionSize.SEVERAL, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        final RemoveFirstFunction removeFirst = new RemoveFirstFunction();
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                ArrayList fromList = Lists.newArrayList();
                for (String element : elements) {
                    fromList.add("q" + (String)Preconditions.checkNotNull((Object)element));
                }
                return Lists.transform((List)fromList, (Function)removeFirst);
            }
        }).named("Lists.transform, random access, no nulls")).withFeatures(new Feature[]{CollectionSize.ANY, ListFeature.REMOVE_OPERATIONS, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                LinkedList fromList = Lists.newLinkedList();
                for (String element : elements) {
                    fromList.add("q" + (String)Preconditions.checkNotNull((Object)element));
                }
                return Lists.transform((List)fromList, (Function)removeFirst);
            }
        }).named("Lists.transform, sequential access, no nulls")).withFeatures(new Feature[]{CollectionSize.ANY, ListFeature.REMOVE_OPERATIONS, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                ArrayList fromList = Lists.newArrayList((Object[])elements);
                return Lists.transform((List)fromList, (Function)Functions.identity());
            }
        }).named("Lists.transform, random access, nulls")).withFeatures(new Feature[]{CollectionSize.ANY, ListFeature.REMOVE_OPERATIONS, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                LinkedList fromList = Lists.newLinkedList(Arrays.asList(elements));
                return Lists.transform((List)fromList, (Function)Functions.identity());
            }
        }).named("Lists.transform, sequential access, nulls")).withFeatures(new Feature[]{CollectionSize.ANY, ListFeature.REMOVE_OPERATIONS, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                ArrayList list = Lists.newArrayList();
                for (int i = elements.length - 1; i >= 0; --i) {
                    list.add(elements[i]);
                }
                return Lists.reverse((List)list);
            }
        }).named("Lists.reverse[ArrayList]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, ListFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                String[] reverseElements = new String[elements.length];
                int i = elements.length - 1;
                int j = 0;
                while (i >= 0) {
                    reverseElements[j] = elements[i];
                    --i;
                    ++j;
                }
                return Lists.reverse(Arrays.asList(reverseElements));
            }
        }).named("Lists.reverse[Arrays.asList]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, ListFeature.SUPPORTS_SET})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                LinkedList list = Lists.newLinkedList();
                for (int i = elements.length - 1; i >= 0; --i) {
                    list.add(elements[i]);
                }
                return Lists.reverse((List)list);
            }
        }).named("Lists.reverse[LinkedList]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, ListFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = elements.length - 1; i >= 0; --i) {
                    builder.add((Object)elements[i]);
                }
                return Lists.reverse((List)builder.build());
            }
        }).named("Lists.reverse[ImmutableList]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.CharactersOfStringGenerator()).named("Lists.charactersOf[String]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.CharactersOfCharSequenceGenerator()).named("Lists.charactersOf[CharSequence]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testCharactersOfIsView() {
        StringBuilder builder = new StringBuilder("abc");
        List chars = Lists.charactersOf((CharSequence)builder);
        ListsTest.assertEquals(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')), (Object)chars);
        builder.append("def");
        ListsTest.assertEquals(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f')), (Object)chars);
        builder.deleteCharAt(5);
        ListsTest.assertEquals(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e')), (Object)chars);
    }

    public void testNewArrayListEmpty() {
        ArrayList list = Lists.newArrayList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    public void testNewArrayListWithCapacity() {
        ArrayList list = Lists.newArrayListWithCapacity((int)0);
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
        ArrayList bigger = Lists.newArrayListWithCapacity((int)256);
        ListsTest.assertEquals(Collections.emptyList(), (Object)bigger);
    }

    public void testNewArrayListWithCapacity_negative() {
        try {
            Lists.newArrayListWithCapacity((int)-1);
            ListsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewArrayListWithExpectedSize() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)0);
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
        ArrayList bigger = Lists.newArrayListWithExpectedSize((int)256);
        ListsTest.assertEquals(Collections.emptyList(), (Object)bigger);
    }

    public void testNewArrayListWithExpectedSize_negative() {
        try {
            Lists.newArrayListWithExpectedSize((int)-1);
            ListsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewArrayListVarArgs() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{0, 1, 1});
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testComputeArrayListCapacity() {
        ListsTest.assertEquals((int)5, (int)Lists.computeArrayListCapacity((int)0));
        ListsTest.assertEquals((int)13, (int)Lists.computeArrayListCapacity((int)8));
        ListsTest.assertEquals((int)89, (int)Lists.computeArrayListCapacity((int)77));
        ListsTest.assertEquals((int)22000005, (int)Lists.computeArrayListCapacity((int)20000000));
        ListsTest.assertEquals((int)Integer.MAX_VALUE, (int)Lists.computeArrayListCapacity((int)2147482647));
    }

    public void testNewArrayListFromCollection() {
        ArrayList list = Lists.newArrayList(SOME_COLLECTION);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewArrayListFromIterable() {
        ArrayList list = Lists.newArrayList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewArrayListFromIterator() {
        ArrayList list = Lists.newArrayList(SOME_COLLECTION.iterator());
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewLinkedListEmpty() {
        LinkedList list = Lists.newLinkedList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    public void testNewLinkedListFromCollection() {
        LinkedList list = Lists.newLinkedList(SOME_COLLECTION);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewLinkedListFromIterable() {
        LinkedList list = Lists.newLinkedList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    @GwtIncompatible(value="CopyOnWriteArrayList")
    public void testNewCOWALEmpty() {
        CopyOnWriteArrayList list = Lists.newCopyOnWriteArrayList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    @GwtIncompatible(value="CopyOnWriteArrayList")
    public void testNewCOWALFromIterable() {
        CopyOnWriteArrayList list = Lists.newCopyOnWriteArrayList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Lists.class);
    }

    public void testArraysAsList() {
        ArrayList ourWay = Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"});
        List<String> otherWay = Arrays.asList("foo", "bar", "baz");
        ListsTest.assertEquals((Object)ourWay, otherWay);
        otherWay.set(0, "FOO");
        ListsTest.assertEquals((String)"FOO", (String)otherWay.get(0));
        try {
            otherWay.add("nope");
            ListsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            otherWay.remove(2);
            ListsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAsList1() {
        List list = Lists.asList((Object)"foo", (Object[])new String[]{"bar", "baz"});
        this.checkFooBarBazList(list);
        SerializableTester.reserializeAndAssert((Object)list);
        ListsTest.assertTrue((boolean)(list instanceof RandomAccess));
        new IteratorTester<String>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList("foo", "bar", "baz"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return Lists.asList((Object)"foo", (Object[])new String[]{"bar", "baz"}).iterator();
            }
        }.test();
    }

    private void checkFooBarBazList(List<String> list) {
        Truth.ASSERT.that(list).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
        ListsTest.assertEquals((int)3, (int)list.size());
        ListsTest.assertIndexIsOutOfBounds(list, -1);
        ListsTest.assertEquals((String)"foo", (String)list.get(0));
        ListsTest.assertEquals((String)"bar", (String)list.get(1));
        ListsTest.assertEquals((String)"baz", (String)list.get(2));
        ListsTest.assertIndexIsOutOfBounds(list, 3);
    }

    public void testAsList1Small() {
        List list = Lists.asList((Object)"foo", (Object[])new String[0]);
        Truth.ASSERT.that(list).has().item((Object)"foo");
        ListsTest.assertEquals((int)1, (int)list.size());
        ListsTest.assertIndexIsOutOfBounds(list, -1);
        ListsTest.assertEquals((String)"foo", (String)((String)list.get(0)));
        ListsTest.assertIndexIsOutOfBounds(list, 1);
        ListsTest.assertTrue((boolean)(list instanceof RandomAccess));
        new IteratorTester<String>(3, (Iterable)IteratorFeature.UNMODIFIABLE, Collections.singletonList("foo"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return Lists.asList((Object)"foo", (Object[])new String[0]).iterator();
            }
        }.test();
    }

    public void testAsList2() {
        List list = Lists.asList((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"});
        this.checkFooBarBazList(list);
        ListsTest.assertTrue((boolean)(list instanceof RandomAccess));
        new IteratorTester<String>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList("foo", "bar", "baz"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return Lists.asList((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).iterator();
            }
        }.test();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testAsList2Small() {
        List list = Lists.asList((Object)"foo", (Object)"bar", (Object[])new String[0]);
        Truth.ASSERT.that(list).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
        ListsTest.assertEquals((int)2, (int)list.size());
        ListsTest.assertIndexIsOutOfBounds(list, -1);
        ListsTest.assertEquals((String)"foo", (String)((String)list.get(0)));
        ListsTest.assertEquals((String)"bar", (String)((String)list.get(1)));
        ListsTest.assertIndexIsOutOfBounds(list, 2);
        SerializableTester.reserializeAndAssert((Object)list);
        ListsTest.assertTrue((boolean)(list instanceof RandomAccess));
        new IteratorTester<String>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList("foo", "bar"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return Lists.asList((Object)"foo", (Object)"bar", (Object[])new String[0]).iterator();
            }
        }.test();
    }

    private static void assertIndexIsOutOfBounds(List<String> list, int index) {
        try {
            list.get(index);
            ListsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testReverseViewRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List toList = Lists.reverse((List)fromList);
        ListsTest.assertReverseView(fromList, toList);
    }

    public void testReverseViewSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List toList = Lists.reverse((List)fromList);
        ListsTest.assertReverseView(fromList, toList);
    }

    private static void assertReverseView(List<Integer> fromList, List<Integer> toList) {
        fromList.set(0, 5);
        ListsTest.assertEquals(Arrays.asList(4, 3, 2, 5), toList);
        fromList.add(6);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 2, 5), toList);
        fromList.add(2, 9);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 9, 2, 5), toList);
        fromList.remove((Object)2);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 9, 5), toList);
        fromList.remove(3);
        ListsTest.assertEquals(Arrays.asList(6, 3, 9, 5), toList);
        toList.remove(0);
        ListsTest.assertEquals(Arrays.asList(5, 9, 3), fromList);
        toList.add(7);
        ListsTest.assertEquals(Arrays.asList(7, 5, 9, 3), fromList);
        toList.add(5);
        ListsTest.assertEquals(Arrays.asList(5, 7, 5, 9, 3), fromList);
        toList.remove((Object)5);
        ListsTest.assertEquals(Arrays.asList(5, 7, 9, 3), fromList);
        toList.set(1, 8);
        ListsTest.assertEquals(Arrays.asList(5, 7, 8, 3), fromList);
        toList.clear();
        ListsTest.assertEquals(Collections.emptyList(), fromList);
    }

    private static <E> List<E> list(E ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    public void testCartesianProduct_binary1x1() {
        Truth.ASSERT.that(Lists.cartesianProduct((List[])new List[]{ListsTest.list(1), ListsTest.list(2)})).has().item(ListsTest.list(1, 2));
    }

    public void testCartesianProduct_binary1x2() {
        Truth.ASSERT.that(Lists.cartesianProduct((List[])new List[]{ListsTest.list(1), ListsTest.list(2, 3)})).has().exactly(ListsTest.list(1, 2), ListsTest.list(1, 3), (Object[])new List[0]).inOrder();
    }

    public void testCartesianProduct_binary2x2() {
        Truth.ASSERT.that(Lists.cartesianProduct((List[])new List[]{ListsTest.list(1, 2), ListsTest.list(3, 4)})).has().exactly(ListsTest.list(1, 3), ListsTest.list(1, 4), (Object[])new List[]{ListsTest.list(2, 3), ListsTest.list(2, 4)}).inOrder();
    }

    public void testCartesianProduct_2x2x2() {
        Truth.ASSERT.that(Lists.cartesianProduct((List[])new List[]{ListsTest.list(0, 1), ListsTest.list(0, 1), ListsTest.list(0, 1)})).has().exactly(ListsTest.list(0, 0, 0), ListsTest.list(0, 0, 1), (Object[])new List[]{ListsTest.list(0, 1, 0), ListsTest.list(0, 1, 1), ListsTest.list(1, 0, 0), ListsTest.list(1, 0, 1), ListsTest.list(1, 1, 0), ListsTest.list(1, 1, 1)}).inOrder();
    }

    public void testCartesianProduct_contains() {
        List actual = Lists.cartesianProduct((List[])new List[]{ListsTest.list(1, 2), ListsTest.list(3, 4)});
        ListsTest.assertTrue((boolean)actual.contains(ListsTest.list(1, 3)));
        ListsTest.assertTrue((boolean)actual.contains(ListsTest.list(1, 4)));
        ListsTest.assertTrue((boolean)actual.contains(ListsTest.list(2, 3)));
        ListsTest.assertTrue((boolean)actual.contains(ListsTest.list(2, 4)));
        ListsTest.assertFalse((boolean)actual.contains(ListsTest.list(3, 1)));
    }

    public void testCartesianProduct_unrelatedTypes() {
        List<Integer> x = ListsTest.list(1, 2);
        List<String> y = ListsTest.list("3", "4");
        List<Object> exp1 = ListsTest.list(1, "3");
        List<Object> exp2 = ListsTest.list(1, "4");
        List<Object> exp3 = ListsTest.list(2, "3");
        List<Object> exp4 = ListsTest.list(2, "4");
        Truth.ASSERT.that(Lists.cartesianProduct((List[])new List[]{x, y})).has().exactly(exp1, exp2, (Object[])new List[]{exp3, exp4}).inOrder();
    }

    public void testCartesianProductTooBig() {
        List<String> list = Collections.nCopies(10000, "foo");
        try {
            Lists.cartesianProduct((List[])new List[]{list, list, list, list, list});
            ListsTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformHashCodeRandomAccess() {
        List list = Lists.transform(SOME_LIST, SOME_FUNCTION);
        ListsTest.assertEquals((int)SOME_STRING_LIST.hashCode(), (int)list.hashCode());
    }

    public void testTransformHashCodeSequential() {
        List list = Lists.transform(SOME_SEQUENTIAL_LIST, SOME_FUNCTION);
        ListsTest.assertEquals((int)SOME_STRING_LIST.hashCode(), (int)list.hashCode());
    }

    public void testTransformModifiableRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformModifiable(list);
    }

    public void testTransformModifiableSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformModifiable(list);
    }

    private static void assertTransformModifiable(List<String> list) {
        try {
            list.add("5");
            ListsTest.fail((String)"transformed list is addable");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        list.remove(0);
        ListsTest.assertEquals(Arrays.asList("2", "3", "4"), list);
        list.remove("3");
        ListsTest.assertEquals(Arrays.asList("2", "4"), list);
        try {
            list.set(0, "5");
            ListsTest.fail((String)"transformed list is setable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        list.clear();
        ListsTest.assertEquals(Collections.emptyList(), list);
    }

    public void testTransformViewRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List toList = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformView(fromList, toList);
    }

    public void testTransformViewSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List toList = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformView(fromList, toList);
    }

    private static void assertTransformView(List<Integer> fromList, List<String> toList) {
        fromList.set(0, 5);
        ListsTest.assertEquals(Arrays.asList("5", "2", "3", "4"), toList);
        fromList.add(6);
        ListsTest.assertEquals(Arrays.asList("5", "2", "3", "4", "6"), toList);
        fromList.remove((Object)2);
        ListsTest.assertEquals(Arrays.asList("5", "3", "4", "6"), toList);
        fromList.remove(2);
        ListsTest.assertEquals(Arrays.asList("5", "3", "6"), toList);
        toList.remove(2);
        ListsTest.assertEquals(Arrays.asList(5, 3), fromList);
        toList.remove("5");
        ListsTest.assertEquals(Arrays.asList(3), fromList);
        toList.clear();
        ListsTest.assertEquals(Collections.emptyList(), fromList);
    }

    public void testTransformRandomAccess() {
        List list = Lists.transform(SOME_LIST, SOME_FUNCTION);
        ListsTest.assertTrue((boolean)(list instanceof RandomAccess));
    }

    public void testTransformSequential() {
        List list = Lists.transform(SOME_SEQUENTIAL_LIST, SOME_FUNCTION);
        ListsTest.assertFalse((boolean)(list instanceof RandomAccess));
    }

    public void testTransformListIteratorRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformListIterator(list);
    }

    public void testTransformListIteratorSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformListIterator(list);
    }

    public void testTransformPreservesIOOBEsThrownByFunction() {
        try {
            Lists.transform((List)ImmutableList.of((Object)"foo", (Object)"bar"), (Function)new Function<String, String>(){

                public String apply(String input) {
                    throw new IndexOutOfBoundsException();
                }
            }).toArray();
            ListsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static void assertTransformListIterator(List<String> list) {
        ListIterator<String> iterator = list.listIterator(1);
        ListsTest.assertEquals((int)1, (int)iterator.nextIndex());
        ListsTest.assertEquals((String)"2", (String)iterator.next());
        ListsTest.assertEquals((String)"3", (String)iterator.next());
        ListsTest.assertEquals((String)"4", (String)iterator.next());
        ListsTest.assertEquals((int)4, (int)iterator.nextIndex());
        try {
            iterator.next();
            ListsTest.fail((String)"did not detect end of list");
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        ListsTest.assertEquals((int)3, (int)iterator.previousIndex());
        ListsTest.assertEquals((String)"4", (String)iterator.previous());
        ListsTest.assertEquals((String)"3", (String)iterator.previous());
        ListsTest.assertEquals((String)"2", (String)iterator.previous());
        ListsTest.assertTrue((boolean)iterator.hasPrevious());
        ListsTest.assertEquals((String)"1", (String)iterator.previous());
        ListsTest.assertFalse((boolean)iterator.hasPrevious());
        ListsTest.assertEquals((int)-1, (int)iterator.previousIndex());
        try {
            iterator.previous();
            ListsTest.fail((String)"did not detect beginning of list");
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        iterator.remove();
        ListsTest.assertEquals(Arrays.asList("2", "3", "4"), list);
        ListsTest.assertFalse((boolean)list.isEmpty());
        try {
            iterator.add("1");
            ListsTest.fail((String)"transformed list iterator is addable");
        }
        catch (UnsupportedOperationException expected) {
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            iterator.set("1");
            ListsTest.fail((String)"transformed list iterator is settable");
        }
        catch (UnsupportedOperationException expected) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTransformIteratorRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformIterator(list);
    }

    public void testTransformIteratorSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List list = Lists.transform((List)fromList, SOME_FUNCTION);
        ListsTest.assertTransformIterator(list);
    }

    @GwtIncompatible(value="EsayMock")
    public void testTransformedSequentialIterationUsesBackingListIterationOnly() {
        ArrayList randomAccessList = Lists.newArrayList(SOME_SEQUENTIAL_LIST);
        ListIterator<Integer> sampleListIterator = SOME_SEQUENTIAL_LIST.listIterator();
        List listMock = (List)EasyMock.createMock(IntegerList.class);
        EasyMock.expect((Object)listMock.size()).andReturn((Object)SOME_SEQUENTIAL_LIST.size());
        EasyMock.expect(listMock.listIterator(0)).andReturn(sampleListIterator);
        EasyMock.replay((Object[])new Object[]{listMock});
        List transform = Lists.transform((List)listMock, SOME_FUNCTION);
        ListsTest.assertTrue((boolean)Iterables.elementsEqual((Iterable)transform, (Iterable)Lists.transform((List)randomAccessList, SOME_FUNCTION)));
        EasyMock.verify((Object[])new Object[]{listMock});
    }

    private static void assertTransformIterator(List<String> list) {
        Iterator<String> iterator = list.iterator();
        ListsTest.assertTrue((boolean)iterator.hasNext());
        ListsTest.assertEquals((String)"1", (String)iterator.next());
        ListsTest.assertTrue((boolean)iterator.hasNext());
        ListsTest.assertEquals((String)"2", (String)iterator.next());
        ListsTest.assertTrue((boolean)iterator.hasNext());
        ListsTest.assertEquals((String)"3", (String)iterator.next());
        ListsTest.assertTrue((boolean)iterator.hasNext());
        ListsTest.assertEquals((String)"4", (String)iterator.next());
        ListsTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            ListsTest.fail((String)"did not detect end of list");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        iterator.remove();
        ListsTest.assertEquals(Arrays.asList("1", "2", "3"), list);
        ListsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testPartition_badSize() {
        List<Integer> source = Collections.singletonList(1);
        try {
            Lists.partition(source, (int)0);
            ListsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPartition_empty() {
        List source = Collections.emptyList();
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertTrue((boolean)partitions.isEmpty());
        ListsTest.assertEquals((int)0, (int)partitions.size());
    }

    public void testPartition_1_1() {
        List<Integer> source = Collections.singletonList(1);
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertEquals((int)1, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
    }

    public void testPartition_1_2() {
        List<Integer> source = Collections.singletonList(1);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertEquals((int)1, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
    }

    public void testPartition_2_1() {
        List<Integer> source = Arrays.asList(1, 2);
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertEquals((int)2, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
        ListsTest.assertEquals(Collections.singletonList(2), partitions.get(1));
    }

    public void testPartition_3_2() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertEquals((int)2, (int)partitions.size());
        ListsTest.assertEquals(Arrays.asList(1, 2), partitions.get(0));
        ListsTest.assertEquals(Arrays.asList(3), partitions.get(1));
    }

    @GwtIncompatible(value="ArrayList.subList doesn't implement RandomAccess in GWT.")
    public void testPartitionRandomAccessTrue() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertTrue((String)("partition should be RandomAccess, but not: " + partitions.getClass()), (boolean)(partitions instanceof RandomAccess));
        ListsTest.assertTrue((String)("partition[0] should be RandomAccess, but not: " + ((List)partitions.get(0)).getClass()), (boolean)(partitions.get(0) instanceof RandomAccess));
        ListsTest.assertTrue((String)("partition[1] should be RandomAccess, but not: " + ((List)partitions.get(1)).getClass()), (boolean)(partitions.get(1) instanceof RandomAccess));
    }

    public void testPartitionRandomAccessFalse() {
        LinkedList source = Lists.newLinkedList(Arrays.asList(1, 2, 3));
        List partitions = Lists.partition((List)source, (int)2);
        ListsTest.assertFalse((boolean)(partitions instanceof RandomAccess));
        ListsTest.assertFalse((boolean)(partitions.get(0) instanceof RandomAccess));
        ListsTest.assertFalse((boolean)(partitions.get(1) instanceof RandomAccess));
    }

    public void testPartition_view() {
        List<Integer> list = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(list, (int)3);
        list.set(0, 3);
        Iterator iterator = partitions.iterator();
        list.set(1, 4);
        List first = (List)iterator.next();
        list.set(2, 5);
        ListsTest.assertEquals(Arrays.asList(3, 4, 5), (Object)first);
        first.set(1, 6);
        ListsTest.assertEquals(Arrays.asList(3, 6, 5), list);
    }

    public void testPartitionSize_1() {
        List<Integer> list = Arrays.asList(1, 2, 3);
        ListsTest.assertEquals((int)1, (int)Lists.partition(list, (int)Integer.MAX_VALUE).size());
        ListsTest.assertEquals((int)1, (int)Lists.partition(list, (int)0x7FFFFFFE).size());
    }

    @GwtIncompatible(value="cannot do such a big explicit copy")
    public void testPartitionSize_2() {
        ListsTest.assertEquals((int)2, (int)Lists.partition(Collections.nCopies(0x40000001, 1), (int)0x40000000).size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IntegerList
    extends List<Integer> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SomeFunction
    implements Function<Number, String>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private SomeFunction() {
        }

        public String apply(Number n) {
            return String.valueOf(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SomeIterable
    implements Iterable<Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private SomeIterable() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return SOME_COLLECTION.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoveFirstFunction
    implements Function<String, String>,
    Serializable {
        private RemoveFirstFunction() {
        }

        public String apply(String from) {
            return from.length() == 0 ? from : from.substring(1);
        }
    }
}

