/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ConstraintsTest;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class MapConstraintsTest
extends TestCase {
    private static final String TEST_KEY = "test";
    private static final Integer TEST_VALUE = 42;
    static final MapConstraint<String, Integer> TEST_CONSTRAINT = new TestConstraint();

    public void testNotNull() {
        MapConstraint constraint = MapConstraints.notNull();
        constraint.checkKeyValue((Object)"foo", (Object)1);
        MapConstraintsTest.assertEquals((String)"Not null", (String)constraint.toString());
        try {
            constraint.checkKeyValue(null, (Object)1);
            MapConstraintsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            constraint.checkKeyValue((Object)"foo", null);
            MapConstraintsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            constraint.checkKeyValue(null, null);
            MapConstraintsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstrainedMapLegal() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put(TEST_KEY, TEST_VALUE);
        constrained.put("foo", 1);
        map.putAll(ImmutableMap.of((Object)"bar", (Object)2));
        constrained.putAll(ImmutableMap.of((Object)"baz", (Object)3));
        MapConstraintsTest.assertTrue((boolean)map.equals(constrained));
        MapConstraintsTest.assertTrue((boolean)constrained.equals(map));
        MapConstraintsTest.assertEquals(map.entrySet(), constrained.entrySet());
        MapConstraintsTest.assertEquals(map.keySet(), constrained.keySet());
        MapConstraintsTest.assertEquals((Object)HashMultiset.create(map.values()), (Object)HashMultiset.create(constrained.values()));
        MapConstraintsTest.assertFalse((boolean)(map.values() instanceof Serializable));
        MapConstraintsTest.assertEquals((String)((Object)map).toString(), (String)constrained.toString());
        MapConstraintsTest.assertEquals((int)map.hashCode(), (int)constrained.hashCode());
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)TEST_KEY, (Object)TEST_VALUE), (Object)Maps.immutableEntry((Object)"foo", (Object)1), (Object[])new Map.Entry[]{Maps.immutableEntry((Object)"bar", (Object)2), Maps.immutableEntry((Object)"baz", (Object)3)}).inOrder();
    }

    public void testConstrainedMapIllegal() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        try {
            constrained.put(TEST_KEY, TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.put("baz", TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.put(TEST_KEY, 3);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll(ImmutableMap.of((Object)"baz", (Object)3, (Object)TEST_KEY, (Object)4));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException testKeyException) {
            // empty catch block
        }
        MapConstraintsTest.assertEquals(Collections.emptySet(), map.entrySet());
        MapConstraintsTest.assertEquals(Collections.emptySet(), constrained.entrySet());
    }

    public void testConstrainedBiMapLegal() {
        AbstractBiMap<String, Integer> map = new AbstractBiMap<String, Integer>((Map)Maps.newLinkedHashMap(), (Map)Maps.newLinkedHashMap()){};
        BiMap constrained = MapConstraints.constrainedBiMap((BiMap)map, TEST_CONSTRAINT);
        map.put((Object)TEST_KEY, (Object)TEST_VALUE);
        constrained.put((Object)"foo", (Object)1);
        map.putAll((Map)ImmutableMap.of((Object)"bar", (Object)2));
        constrained.putAll((Map)ImmutableMap.of((Object)"baz", (Object)3));
        MapConstraintsTest.assertTrue((boolean)map.equals((Object)constrained));
        MapConstraintsTest.assertTrue((boolean)constrained.equals(map));
        MapConstraintsTest.assertEquals((Object)map.entrySet(), (Object)constrained.entrySet());
        MapConstraintsTest.assertEquals((Object)map.keySet(), (Object)constrained.keySet());
        MapConstraintsTest.assertEquals((Object)map.values(), (Object)constrained.values());
        MapConstraintsTest.assertEquals((String)map.toString(), (String)constrained.toString());
        MapConstraintsTest.assertEquals((int)map.hashCode(), (int)constrained.hashCode());
        Truth.ASSERT.that((Collection)map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)TEST_KEY, (Object)TEST_VALUE), (Object)Maps.immutableEntry((Object)"foo", (Object)1), (Object[])new Map.Entry[]{Maps.immutableEntry((Object)"bar", (Object)2), Maps.immutableEntry((Object)"baz", (Object)3)}).inOrder();
    }

    public void testConstrainedBiMapIllegal() {
        AbstractBiMap<String, Integer> map = new AbstractBiMap<String, Integer>((Map)Maps.newLinkedHashMap(), (Map)Maps.newLinkedHashMap()){};
        BiMap constrained = MapConstraints.constrainedBiMap((BiMap)map, TEST_CONSTRAINT);
        try {
            constrained.put((Object)TEST_KEY, (Object)TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.put((Object)"baz", (Object)TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.put((Object)TEST_KEY, (Object)3);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Map)ImmutableMap.of((Object)"baz", (Object)3, (Object)TEST_KEY, (Object)4));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.forcePut((Object)TEST_KEY, (Object)3);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.inverse().forcePut((Object)TEST_VALUE, (Object)"baz");
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.inverse().forcePut((Object)3, (Object)TEST_KEY);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException testKeyException) {
            // empty catch block
        }
        MapConstraintsTest.assertEquals(Collections.emptySet(), (Object)map.entrySet());
        MapConstraintsTest.assertEquals(Collections.emptySet(), (Object)constrained.entrySet());
    }

    public void testConstrainedMultimapLegal() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)TEST_KEY, (Object)TEST_VALUE);
        constrained.put((Object)"foo", (Object)1);
        multimap.get((Object)"bar").add(2);
        constrained.get((Object)"baz").add(3);
        multimap.get((Object)"qux").addAll(Arrays.asList(4));
        constrained.get((Object)"zig").addAll(Arrays.asList(5));
        multimap.putAll((Object)"zag", Arrays.asList(6));
        constrained.putAll((Object)"bee", Arrays.asList(7));
        multimap.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)"bim", (Object)8).build());
        constrained.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)"bop", (Object)9).build());
        multimap.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)"dig", (Object)10).build());
        constrained.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)"dag", (Object)11).build());
        MapConstraintsTest.assertTrue((boolean)multimap.equals((Object)constrained));
        MapConstraintsTest.assertTrue((boolean)constrained.equals((Object)multimap));
        Truth.ASSERT.that((List)ImmutableList.copyOf((Collection)multimap.entries())).is((Object)ImmutableList.copyOf((Collection)constrained.entries()));
        Truth.ASSERT.that((Collection)constrained.asMap().get("foo")).has().item((Object)1);
        MapConstraintsTest.assertNull(constrained.asMap().get("missing"));
        MapConstraintsTest.assertEquals((Object)multimap.asMap(), (Object)constrained.asMap());
        MapConstraintsTest.assertEquals((Object)multimap.values(), (Object)constrained.values());
        MapConstraintsTest.assertEquals((Object)multimap.keys(), (Object)constrained.keys());
        MapConstraintsTest.assertEquals((Object)multimap.keySet(), (Object)constrained.keySet());
        MapConstraintsTest.assertEquals((String)multimap.toString(), (String)constrained.toString());
        MapConstraintsTest.assertEquals((int)multimap.hashCode(), (int)constrained.hashCode());
        Truth.ASSERT.that(multimap.entries()).has().exactly((Object)Maps.immutableEntry((Object)TEST_KEY, (Object)TEST_VALUE), (Object)Maps.immutableEntry((Object)"foo", (Object)1), (Object[])new Map.Entry[]{Maps.immutableEntry((Object)"bar", (Object)2), Maps.immutableEntry((Object)"baz", (Object)3), Maps.immutableEntry((Object)"qux", (Object)4), Maps.immutableEntry((Object)"zig", (Object)5), Maps.immutableEntry((Object)"zag", (Object)6), Maps.immutableEntry((Object)"bee", (Object)7), Maps.immutableEntry((Object)"bim", (Object)8), Maps.immutableEntry((Object)"bop", (Object)9), Maps.immutableEntry((Object)"dig", (Object)10), Maps.immutableEntry((Object)"dag", (Object)11)}).inOrder();
        MapConstraintsTest.assertFalse((boolean)(constrained.asMap().values() instanceof Serializable));
        Iterator iterator = constrained.asMap().values().iterator();
        iterator.next();
        ((Collection)iterator.next()).add(12);
        MapConstraintsTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)12));
    }

    public void testConstrainedTypePreservingList() {
        ListMultimap multimap = MapConstraints.constrainedListMultimap((ListMultimap)LinkedListMultimap.create(), TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof List));
        MapConstraintsTest.assertFalse((boolean)(multimap.entries() instanceof Set));
        MapConstraintsTest.assertFalse((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
    }

    public void testConstrainedTypePreservingRandomAccessList() {
        ListMultimap multimap = MapConstraints.constrainedListMultimap((ListMultimap)ArrayListMultimap.create(), TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof List));
        MapConstraintsTest.assertFalse((boolean)(multimap.entries() instanceof Set));
        MapConstraintsTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
    }

    public void testConstrainedTypePreservingSet() {
        SetMultimap multimap = MapConstraints.constrainedSetMultimap((SetMultimap)LinkedHashMultimap.create(), TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof Set));
    }

    public void testConstrainedTypePreservingSortedSet() {
        Comparator comparator = Collections.reverseOrder();
        TreeMultimap delegate = TreeMultimap.create((Comparator)Ordering.natural(), comparator);
        SortedSetMultimap multimap = MapConstraints.constrainedSortedSetMultimap((SortedSetMultimap)delegate, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof SortedSet));
        MapConstraintsTest.assertSame(comparator, (Object)multimap.valueComparator());
        MapConstraintsTest.assertSame(comparator, multimap.get((Object)"foo").comparator());
    }

    public void testConstrainedMultimapIllegal() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        try {
            constrained.put((Object)TEST_KEY, (Object)1);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.put((Object)"foo", (Object)TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.put((Object)TEST_KEY, (Object)TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)TEST_KEY).add(1);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)"foo").add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)TEST_KEY).add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)TEST_KEY).addAll(Arrays.asList(1));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)"foo").addAll(Arrays.asList(1, TEST_VALUE));
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)TEST_KEY).addAll(Arrays.asList(1, TEST_VALUE));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Object)TEST_KEY, Arrays.asList(1));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Object)"foo", Arrays.asList(1, TEST_VALUE));
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Object)TEST_KEY, Arrays.asList(1, TEST_VALUE));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)TEST_KEY, (Object)2).put((Object)"foo", (Object)1).build());
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)"bar", (Object)TEST_VALUE).put((Object)"foo", (Object)1).build());
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.putAll((Multimap)new ImmutableMultimap.Builder().put((Object)TEST_KEY, (Object)TEST_VALUE).put((Object)"foo", (Object)1).build());
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.entries().add(Maps.immutableEntry((Object)TEST_KEY, (Object)1));
            MapConstraintsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            constrained.entries().addAll(Arrays.asList(Maps.immutableEntry((Object)"foo", (Object)1), Maps.immutableEntry((Object)TEST_KEY, (Object)2)));
            MapConstraintsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        MapConstraintsTest.assertTrue((boolean)multimap.isEmpty());
        MapConstraintsTest.assertTrue((boolean)constrained.isEmpty());
        constrained.put((Object)"foo", (Object)1);
        try {
            ((Collection)constrained.asMap().get("foo")).add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            ((Collection)constrained.asMap().values().iterator().next()).add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            ((Collection)constrained.asMap().values().toArray()[0]).add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException testValueException) {
            // empty catch block
        }
        Truth.ASSERT.that((List)ImmutableList.copyOf((Collection)multimap.entries())).is((Object)ImmutableList.copyOf((Collection)constrained.entries()));
        MapConstraintsTest.assertEquals((Object)multimap.asMap(), (Object)constrained.asMap());
        MapConstraintsTest.assertEquals((Object)multimap.values(), (Object)constrained.values());
        MapConstraintsTest.assertEquals((Object)multimap.keys(), (Object)constrained.keys());
        MapConstraintsTest.assertEquals((Object)multimap.keySet(), (Object)constrained.keySet());
        MapConstraintsTest.assertEquals((String)multimap.toString(), (String)constrained.toString());
        MapConstraintsTest.assertEquals((int)multimap.hashCode(), (int)constrained.hashCode());
    }

    public void testConstrainedMultimapQueue() {
        Multimap multimap = Multimaps.newMultimap(new HashMap(), (Supplier)new QueueSupplier());
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        constrained.put((Object)"foo", (Object)1);
        MapConstraintsTest.assertTrue((boolean)constrained.get((Object)"foo").contains(1));
        MapConstraintsTest.assertTrue((boolean)multimap.get((Object)"foo").contains(1));
        try {
            constrained.put((Object)TEST_KEY, (Object)1);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.put((Object)"foo", (Object)TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)"foo").add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.get((Object)TEST_KEY).add(1);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestKeyException testKeyException) {
            // empty catch block
        }
        MapConstraintsTest.assertEquals((int)1, (int)constrained.size());
        MapConstraintsTest.assertEquals((int)1, (int)multimap.size());
    }

    public void testMapEntrySetToArray() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put("foo", 1);
        Map.Entry entry = (Map.Entry)constrained.entrySet().toArray()[0];
        try {
            entry.setValue(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
    }

    public void testMapEntrySetContainsNefariousEntry() {
        TreeMap map = Maps.newTreeMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put("foo", 1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, (Object)TEST_VALUE);
        Set entries = constrained.entrySet();
        MapConstraintsTest.assertFalse((boolean)entries.contains(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.containsAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
    }

    public void testMultimapAsMapEntriesToArray() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = (Map.Entry)constrained.asMap().entrySet().toArray()[0];
        try {
            entry.setValue(Collections.emptySet());
            MapConstraintsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            ((Collection)entry.getValue()).add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testMultimapAsMapValuesToArray() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Collection collection = (Collection)constrained.asMap().values().toArray()[0];
        try {
            collection.add(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testMultimapEntriesContainsNefariousEntry() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, (Object)TEST_VALUE);
        Collection entries = constrained.entries();
        MapConstraintsTest.assertFalse((boolean)entries.contains(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.containsAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testMultimapEntriesRemoveNefariousEntry() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, (Object)TEST_VALUE);
        Collection entries = constrained.entries();
        MapConstraintsTest.assertFalse((boolean)entries.remove(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.removeAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testMultimapAsMapEntriesContainsNefariousEntry() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, Collections.singleton(TEST_VALUE));
        Set entries = constrained.asMap().entrySet();
        MapConstraintsTest.assertFalse((boolean)entries.contains(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.containsAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testMultimapAsMapEntriesRemoveNefariousEntry() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, Collections.singleton(TEST_VALUE));
        Set entries = constrained.asMap().entrySet();
        MapConstraintsTest.assertFalse((boolean)entries.remove(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.removeAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)multimap.containsValue((Object)TEST_VALUE));
    }

    public void testNefariousMapPutAll() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        Map<String, Integer> onceIterable = MapConstraintsTest.onceIterableMap("foo", 1);
        constrained.putAll(onceIterable);
        MapConstraintsTest.assertEquals((Object)1, constrained.get("foo"));
    }

    public void testNefariousMultimapPutAllIterable() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        Collection<Integer> onceIterable = ConstraintsTest.onceIterableCollection(1);
        constrained.putAll((Object)"foo", onceIterable);
        MapConstraintsTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)constrained.get((Object)"foo"));
    }

    public void testNefariousMultimapPutAllMultimap() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        SetMultimap onceIterable = Multimaps.forMap(MapConstraintsTest.onceIterableMap("foo", 1));
        constrained.putAll((Multimap)onceIterable);
        MapConstraintsTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)constrained.get((Object)"foo"));
    }

    public void testNefariousMultimapGetAddAll() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        Multimap constrained = MapConstraints.constrainedMultimap((Multimap)multimap, TEST_CONSTRAINT);
        Collection<Integer> onceIterable = ConstraintsTest.onceIterableCollection(1);
        constrained.get((Object)"foo").addAll(onceIterable);
        MapConstraintsTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)constrained.get((Object)"foo"));
    }

    static <K, V> Map<K, V> onceIterableMap(K key, V value) {
        final Map.Entry entry = Maps.immutableEntry(key, value);
        return new AbstractMap<K, V>(){
            boolean iteratorCalled;

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new ForwardingSet<Map.Entry<K, V>>(){

                    protected Set<Map.Entry<K, V>> delegate() {
                        return Collections.singleton(entry);
                    }

                    public Iterator<Map.Entry<K, V>> iterator() {
                        Assert.assertFalse((String)"Expected only one call to iterator()", (boolean)iteratorCalled);
                        iteratorCalled = true;
                        return super.iterator();
                    }
                };
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization() {
        MapConstraintsTest.assertSame((Object)MapConstraints.notNull(), (Object)SerializableTester.reserialize((Object)MapConstraints.notNull()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueSupplier
    implements Supplier<Queue<Integer>> {
        private QueueSupplier() {
        }

        public Queue<Integer> get() {
            return new LinkedList<Integer>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestConstraint
    implements MapConstraint<String, Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private TestConstraint() {
        }

        public void checkKeyValue(String key, Integer value) {
            if (MapConstraintsTest.TEST_KEY.equals(key)) {
                throw new TestKeyException();
            }
            if (TEST_VALUE.equals(value)) {
                throw new TestValueException();
            }
        }
    }

    static final class TestValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        TestValueException() {
        }
    }

    static final class TestKeyException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        TestKeyException() {
        }
    }
}

