/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMapTest;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MapMakerTest
extends TestCase {
    @GwtIncompatible(value="NullPointerTester")
    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new MapMaker());
    }

    @GwtIncompatible(value="threads")
    public void testRemovalNotification_clear() throws InterruptedException {
        CountDownLatch computingLatch = new CountDownLatch(1);
        DelayingIdentityLoader computingFunction = new DelayingIdentityLoader(computingLatch);
        MapMakerInternalMapTest.QueuingRemovalListener listener = new MapMakerInternalMapTest.QueuingRemovalListener();
        final ConcurrentMap map = new MapMaker().concurrencyLevel(1).removalListener(listener).makeComputingMap(computingFunction);
        map.put("a", "a");
        final CountDownLatch computationStarted = new CountDownLatch(1);
        final CountDownLatch computationComplete = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                computationStarted.countDown();
                map.get("b");
                computationComplete.countDown();
            }
        }).start();
        computationStarted.await();
        map.clear();
        computingLatch.countDown();
        computationComplete.await();
        MapMakerTest.assertEquals((int)1, (int)listener.size());
        MapMaker.RemovalNotification notification = (MapMaker.RemovalNotification)listener.remove();
        MapMakerTest.assertEquals((String)"a", (String)((String)notification.getKey()));
        MapMakerTest.assertEquals((String)"a", (String)((String)notification.getValue()));
        MapMakerTest.assertEquals((int)1, (int)map.size());
        MapMakerTest.assertEquals((String)"b", (String)((String)map.get("b")));
    }

    @GwtIncompatible(value="threads")
    public void testRemovalNotification_clear_basher() throws InterruptedException {
        CountDownLatch computationLatch = new CountDownLatch(1);
        MapMakerInternalMapTest.QueuingRemovalListener listener = new MapMakerInternalMapTest.QueuingRemovalListener();
        final ConcurrentMap map = new MapMaker().removalListener(listener).concurrencyLevel(20).makeComputingMap(new DelayingIdentityLoader(computationLatch));
        int nThreads = 100;
        int nTasks = 1000;
        int nSeededEntries = 100;
        HashSet expectedKeys = Sets.newHashSetWithExpectedSize((int)(nTasks + nSeededEntries));
        for (int i = 0; i < nSeededEntries; ++i) {
            String s = "b" + i;
            map.put(s, s);
            expectedKeys.add(s);
        }
        final AtomicInteger computedCount = new AtomicInteger();
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        final CountDownLatch tasksFinished = new CountDownLatch(nTasks);
        for (int i = 0; i < nTasks; ++i) {
            final String s = "a" + i;
            threadPool.submit(new Runnable(){

                public void run() {
                    map.get(s);
                    computedCount.incrementAndGet();
                    tasksFinished.countDown();
                }
            });
            expectedKeys.add(s);
        }
        computationLatch.countDown();
        while (computedCount.get() < nThreads) {
            Thread.yield();
        }
        map.clear();
        tasksFinished.await();
        HashMap removalNotifications = Maps.newHashMap();
        for (MapMaker.RemovalNotification removalNotification : listener) {
            removalNotifications.put(removalNotification.getKey(), removalNotification.getValue());
            MapMakerTest.assertEquals((String)"Unexpected key/value pair passed to removalListener", (String)((String)removalNotification.getKey()), (String)((String)removalNotification.getValue()));
        }
        for (int i = 0; i < nSeededEntries; ++i) {
            MapMakerTest.assertEquals((String)("b" + i), (String)((String)removalNotifications.get("b" + i)));
        }
        MapMakerTest.assertEquals((Object)expectedKeys, (Object)Sets.union(map.keySet(), removalNotifications.keySet()));
        MapMakerTest.assertTrue((boolean)Sets.intersection(map.keySet(), removalNotifications.keySet()).isEmpty());
    }

    public static class ComputingTest
    extends TestCase {
        public void testComputerThatReturnsNull() {
            ConcurrentMap map = new MapMaker().makeComputingMap((Function)new Function<Integer, String>(){

                public String apply(Integer key) {
                    return null;
                }
            });
            try {
                map.get(1);
                ComputingTest.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testRuntimeException() {
            final RuntimeException e = new RuntimeException();
            ConcurrentMap map = new MapMaker().makeComputingMap((Function)new Function<Object, Object>(){

                public Object apply(Object from) {
                    throw e;
                }
            });
            try {
                map.get(new Object());
                ComputingTest.fail();
            }
            catch (ComputationException ce) {
                ComputingTest.assertSame((Object)e, (Object)ce.getCause());
            }
        }
    }

    public static class RecursiveComputationTest
    extends TestCase {
        Function<Integer, String> recursiveComputer = new Function<Integer, String>(){

            public String apply(Integer key) {
                if (key > 0) {
                    return key + ", " + (String)RecursiveComputationTest.this.recursiveMap.get(key - 1);
                }
                return "0";
            }
        };
        ConcurrentMap<Integer, String> recursiveMap = new MapMaker().makeComputingMap(this.recursiveComputer);

        public void testRecursiveComputation() {
            RecursiveComputationTest.assertEquals((String)"3, 2, 1, 0", (String)((String)this.recursiveMap.get(3)));
        }
    }

    public static class MaximumSizeTest
    extends TestCase {
        public void testPut_sizeIsZero() {
            ConcurrentMap map = new MapMaker().maximumSize(0).makeMap();
            MaximumSizeTest.assertEquals((int)0, (int)map.size());
            map.put(new Object(), new Object());
            MaximumSizeTest.assertEquals((int)0, (int)map.size());
        }

        public void testSizeBasedEviction() {
            int i;
            int numKeys = 10;
            int mapSize = 5;
            ConcurrentMap map = new MapMaker().maximumSize(mapSize).makeMap();
            for (i = 0; i < numKeys; ++i) {
                map.put(i, i);
            }
            MaximumSizeTest.assertEquals((int)mapSize, (int)map.size());
            for (i = numKeys - mapSize; i < mapSize; ++i) {
                MaximumSizeTest.assertTrue((boolean)map.containsKey(i));
            }
        }
    }

    public static class MakerTest
    extends TestCase {
        public void testInitialCapacity_negative() {
            MapMaker maker = new MapMaker();
            try {
                maker.initialCapacity(-1);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void xtestInitialCapacity_setTwice() {
            MapMaker maker = new MapMaker().initialCapacity(16);
            try {
                maker.initialCapacity(16);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testExpiration_setTwice() {
            MapMaker maker = new MapMaker().expireAfterWrite(3600L, TimeUnit.SECONDS);
            try {
                maker.expireAfterWrite(3600L, TimeUnit.SECONDS);
                MakerTest.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public void testMaximumSize_setTwice() {
            MapMaker maker = new MapMaker().maximumSize(16);
            try {
                maker.maximumSize(16);
                MakerTest.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public void testReturnsPlainConcurrentHashMapWhenPossible() {
            ConcurrentMap map = new MapMaker().initialCapacity(5).makeMap();
            MakerTest.assertTrue((boolean)(map instanceof ConcurrentHashMap));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="threads")
    static final class DelayingIdentityLoader<T>
    implements Function<T, T> {
        private final CountDownLatch delayLatch;

        DelayingIdentityLoader(CountDownLatch delayLatch) {
            this.delayLatch = delayLatch;
        }

        public T apply(T key) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.delayLatch);
            return key;
        }
    }
}

