/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapInterfaceTest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class MapsTransformValuesTest
extends MapInterfaceTest<String, String> {
    protected MapsTransformValuesTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear) {
        super(allowsNullKeys, allowsNullValues, supportsPut, supportsRemove, supportsClear, supportsRemove);
    }

    public MapsTransformValuesTest() {
        super(false, true, false, true, true);
    }

    protected Map<String, String> makeEmptyMap() {
        return Maps.transformValues((Map)Maps.newHashMap(), (Function)Functions.identity());
    }

    protected Map<String, String> makePopulatedMap() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        return Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
    }

    protected String getKeyNotInPopulatedMap() throws UnsupportedOperationException {
        return "z";
    }

    protected String getValueNotInPopulatedMap() throws UnsupportedOperationException {
        return "26";
    }

    private void assertMapsEqual(Map<?, ?> expected, Map<?, ?> map) {
        MapsTransformValuesTest.assertEquals(expected, map);
        MapsTransformValuesTest.assertEquals((int)expected.hashCode(), (int)map.hashCode());
        MapsTransformValuesTest.assertEquals(expected.entrySet(), map.entrySet());
        Collection<?> expectedValues = expected.values();
        Collection<?> mapValues = map.values();
        MapsTransformValuesTest.assertEquals((int)expectedValues.size(), (int)mapValues.size());
        MapsTransformValuesTest.assertTrue((boolean)expectedValues.containsAll(mapValues));
        MapsTransformValuesTest.assertTrue((boolean)mapValues.containsAll(expectedValues));
    }

    public void testTransformEmptyMapEquality() {
        Map map = Maps.transformValues((Map)ImmutableMap.of(), (Function)Functions.toStringFunction());
        this.assertMapsEqual(Maps.newHashMap(), map);
    }

    public void testTransformSingletonMapEquality() {
        Map map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1), (Function)Functions.toStringFunction());
        ImmutableMap expected = ImmutableMap.of((Object)"a", (Object)"1");
        this.assertMapsEqual((Map<?, ?>)expected, map);
        MapsTransformValuesTest.assertEquals((String)((String)expected.get("a")), (String)((String)map.get("a")));
    }

    public void testTransformIdentityFunctionEquality() {
        ImmutableMap underlying = ImmutableMap.of((Object)"a", (Object)1);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.identity());
        this.assertMapsEqual((Map<?, ?>)underlying, map);
    }

    public void testTransformPutEntryIsUnsupported() {
        Map map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1), (Function)Functions.toStringFunction());
        try {
            map.put("b", "2");
            MapsTransformValuesTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.putAll(ImmutableMap.of((Object)"b", (Object)"2"));
            MapsTransformValuesTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.entrySet().iterator().next().setValue("one");
            MapsTransformValuesTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testTransformRemoveEntry() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        MapsTransformValuesTest.assertEquals((String)"1", (String)((String)map.remove("a")));
        MapsTransformValuesTest.assertNull(map.remove("b"));
    }

    public void testTransformEqualityOfMapsWithNullValues() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", null);
        underlying.put("b", "");
        Map map = Maps.transformValues((Map)underlying, (Function)new Function<String, Boolean>(){

            public Boolean apply(@Nullable String from) {
                return from == null;
            }
        });
        ImmutableMap expected = ImmutableMap.of((Object)"a", (Object)true, (Object)"b", (Object)false);
        this.assertMapsEqual((Map<?, ?>)expected, map);
        MapsTransformValuesTest.assertEquals(expected.get("a"), map.get("a"));
        MapsTransformValuesTest.assertEquals((boolean)expected.containsKey("a"), (boolean)map.containsKey("a"));
        MapsTransformValuesTest.assertEquals(expected.get("b"), map.get("b"));
        MapsTransformValuesTest.assertEquals((boolean)expected.containsKey("b"), (boolean)map.containsKey("b"));
        MapsTransformValuesTest.assertEquals(expected.get("c"), map.get("c"));
        MapsTransformValuesTest.assertEquals((boolean)expected.containsKey("c"), (boolean)map.containsKey("c"));
    }

    public void testTransformReflectsUnderlyingMap() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        MapsTransformValuesTest.assertEquals((int)underlying.size(), (int)map.size());
        underlying.put("d", 4);
        MapsTransformValuesTest.assertEquals((int)underlying.size(), (int)map.size());
        MapsTransformValuesTest.assertEquals((String)"4", (String)((String)map.get("d")));
        underlying.remove("c");
        MapsTransformValuesTest.assertEquals((int)underlying.size(), (int)map.size());
        MapsTransformValuesTest.assertFalse((boolean)map.containsKey("c"));
        underlying.clear();
        MapsTransformValuesTest.assertEquals((int)underlying.size(), (int)map.size());
    }

    public void testTransformChangesAreReflectedInUnderlyingMap() {
        LinkedHashMap underlying = Maps.newLinkedHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        underlying.put("d", 4);
        underlying.put("e", 5);
        underlying.put("f", 6);
        underlying.put("g", 7);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        map.remove("a");
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("a"));
        Set keys = map.keySet();
        keys.remove("b");
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("b"));
        Iterator keyIterator = keys.iterator();
        keyIterator.next();
        keyIterator.remove();
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("c"));
        Collection values = map.values();
        values.remove("4");
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("d"));
        Iterator valueIterator = values.iterator();
        valueIterator.next();
        valueIterator.remove();
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("e"));
        Set entries = map.entrySet();
        Map.Entry firstEntry = entries.iterator().next();
        entries.remove(firstEntry);
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("f"));
        Iterator entryIterator = entries.iterator();
        entryIterator.next();
        entryIterator.remove();
        MapsTransformValuesTest.assertFalse((boolean)underlying.containsKey("g"));
        MapsTransformValuesTest.assertTrue((boolean)underlying.isEmpty());
        MapsTransformValuesTest.assertTrue((boolean)map.isEmpty());
        MapsTransformValuesTest.assertTrue((boolean)keys.isEmpty());
        MapsTransformValuesTest.assertTrue((boolean)values.isEmpty());
        MapsTransformValuesTest.assertTrue((boolean)entries.isEmpty());
    }

    public void testTransformEquals() {
        ImmutableMap underlying = ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1, (Object)"c", (Object)2);
        Map expected = Maps.transformValues((Map)underlying, (Function)Functions.identity());
        this.assertMapsEqual(expected, expected);
        TreeMap equalToUnderlying = Maps.newTreeMap();
        equalToUnderlying.putAll(underlying);
        Map map = Maps.transformValues((Map)equalToUnderlying, (Function)Functions.identity());
        this.assertMapsEqual(expected, map);
        map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"c", (Object)3), (Function)new Function<Integer, Integer>(){

            public Integer apply(Integer from) {
                return from - 1;
            }
        });
        this.assertMapsEqual(expected, map);
    }

    public void testTransformEntrySetContains() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", null);
        underlying.put("b", true);
        underlying.put(null, true);
        Map map = Maps.transformValues((Map)underlying, (Function)new Function<Boolean, Boolean>(){

            public Boolean apply(@Nullable Boolean from) {
                return from == null ? Boolean.valueOf(true) : null;
            }
        });
        Set entries = map.entrySet();
        MapsTransformValuesTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)"a", (Object)true)));
        MapsTransformValuesTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)"b", (Object)null)));
        MapsTransformValuesTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)null, (Object)null)));
        MapsTransformValuesTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)"c", (Object)null)));
        MapsTransformValuesTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)null, (Object)true)));
    }

    public void testKeySetRemoveAllNullFromEmpty() {
        try {
            super.testKeySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testEntrySetRemoveAllNullFromEmpty() {
        try {
            super.testEntrySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

