/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultisetSetCountTester;
import com.google.common.collect.testing.google.ListMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.MultimapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.MultisetCountTester;
import com.google.common.collect.testing.google.MultisetIteratorTester;
import com.google.common.collect.testing.google.MultisetRemoveTester;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestListMultimapGenerator;
import com.google.common.collect.testing.google.TestMultimapGenerator;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringListMultimapGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtIncompatible(value="suite")
public class MultimapsCollectionTest
extends TestCase {
    private static final Feature<?>[] FOR_MAP_FEATURES_ONE = new Feature[]{CollectionSize.ONE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE};
    private static final Feature<?>[] FOR_MAP_FEATURES_ANY = new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MultisetTestSuiteBuilder.NoRecurse.NO_ENTRY_SET};
    static final Supplier<TreeSet<String>> STRING_TREESET_FACTORY = new Supplier<TreeSet<String>>(){

        public TreeSet<String> get() {
            return new TreeSet<String>((Comparator<String>)Ordering.natural().nullsLast());
        }
    };
    private static final Predicate<Map.Entry<Integer, String>> FILTER_GET_PREDICATE = new Predicate<Map.Entry<Integer, String>>(){

        public boolean apply(Map.Entry<Integer, String> entry) {
            return !"badvalue".equals(entry.getValue()) && 55556 != entry.getKey();
        }
    };
    private static final Predicate<Map.Entry<String, Integer>> FILTER_KEYSET_PREDICATE = new Predicate<Map.Entry<String, Integer>>(){

        public boolean apply(Map.Entry<String, Integer> entry) {
            return !"badkey".equals(entry.getKey()) && 55556 != entry.getValue();
        }
    };

    static void populateMultimapForGet(Multimap<Integer, String> multimap, String[] elements) {
        multimap.put((Object)2, (Object)"foo");
        for (String element : elements) {
            multimap.put((Object)3, (Object)element);
        }
    }

    static void populateMultimapForKeySet(Multimap<String, Integer> multimap, String[] elements) {
        for (String element : elements) {
            multimap.put((Object)element, (Object)2);
            multimap.put((Object)element, (Object)3);
        }
    }

    static void populateMultimapForValues(Multimap<Integer, String> multimap, String[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            multimap.put((Object)(i % 2), (Object)elements[i]);
        }
    }

    static void populateMultimapForKeys(Multimap<String, Integer> multimap, String[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            multimap.put((Object)elements[i], (Object)i);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(MultimapsCollectionTest.transformSuite());
        suite.addTest(MultimapsCollectionTest.filterSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new TestStringListMultimapGenerator(){

            protected ListMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }
        }).named("synchronized ArrayListMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                PopulatableMapAsMultimap multimap = PopulatableMapAsMultimap.create();
                MultimapsCollectionTest.populateMultimapForGet(multimap, elements);
                return multimap.build().get((Object)3);
            }
        }).named("Multimaps.forMap.get")).withFeatures(FOR_MAP_FEATURES_ONE)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                PopulatableMapAsMultimap multimap = PopulatableMapAsMultimap.create();
                MultimapsCollectionTest.populateMultimapForKeySet(multimap, elements);
                return multimap.build().keySet();
            }
        }).named("Multimaps.forMap.keySet")).withFeatures(FOR_MAP_FEATURES_ANY)).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                PopulatableMapAsMultimap multimap = PopulatableMapAsMultimap.create();
                MultimapsCollectionTest.populateMultimapForKeys(multimap, elements);
                return multimap.build().keys();
            }
        }).named("Multimaps.forMap.keys")).withFeatures(FOR_MAP_FEATURES_ANY)).suppressing((Collection)MultisetCountTester.getCountDuplicateInitializingMethods())).suppressing((Collection)AbstractMultisetSetCountTester.getSetCountDuplicateInitializingMethods())).suppressing((Collection)MultisetIteratorTester.getIteratorDuplicateInitializingMethods())).suppressing((Collection)MultisetRemoveTester.getRemoveDuplicateInitializingMethods())).createTestSuite());
        return suite;
    }

    private static Test transformSuite() {
        TestSuite suite = new TestSuite("Multimaps.transform*");
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)MultimapTestSuiteBuilder.using((TestMultimapGenerator)new TransformedMultimapGenerator<Multimap<String, String>>(){

            @Override
            Multimap<String, String> transform(Multimap<String, String> multimap) {
                return Multimaps.transformValues(multimap, (Function)FUNCTION);
            }
        }).named("Multimaps.transformValues[Multimap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)MultimapTestSuiteBuilder.using((TestMultimapGenerator)new TransformedMultimapGenerator<Multimap<String, String>>(){

            @Override
            Multimap<String, String> transform(Multimap<String, String> multimap) {
                return Multimaps.transformEntries(multimap, (Maps.EntryTransformer)ENTRY_TRANSFORMER);
            }
        }).named("Multimaps.transformEntries[Multimap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new TransformedListMultimapGenerator(){

            @Override
            ListMultimap<String, String> transform(Multimap<String, String> multimap) {
                return Multimaps.transformValues((ListMultimap)((ListMultimap)multimap), (Function)FUNCTION);
            }
        }).named("Multimaps.transformValues[ListMultimap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new TransformedListMultimapGenerator(){

            @Override
            ListMultimap<String, String> transform(Multimap<String, String> multimap) {
                return Multimaps.transformEntries((ListMultimap)((ListMultimap)multimap), (Maps.EntryTransformer)ENTRY_TRANSFORMER);
            }
        }).named("Multimaps.transformEntries[ListMultimap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    private static Test filterSuite() {
        TestSuite suite = new TestSuite("Multimaps.filter*");
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                multimap.put((Object)"foo", (Object)17);
                multimap.put((Object)"bar", (Object)32);
                multimap.put((Object)"foo", (Object)16);
                return Multimaps.filterKeys(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar"))));
            }
        }).named("Multimaps.filterKeys[SetMultimap, Predicate]")).withFeatures(new Feature[]{CollectionSize.ANY, MultimapFeature.VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new FilteredListMultimapGenerator(){

            @Override
            ListMultimap<String, Integer> filter(ListMultimap<String, Integer> multimap) {
                multimap.put((Object)"foo", (Object)17);
                multimap.put((Object)"bar", (Object)32);
                multimap.put((Object)"foo", (Object)16);
                return Multimaps.filterKeys(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar"))));
            }
        }).named("Multimaps.filterKeys[ListMultimap, Predicate]")).withFeatures(new Feature[]{CollectionSize.ANY, MultimapFeature.VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new FilteredListMultimapGenerator(){

            @Override
            ListMultimap<String, Integer> filter(ListMultimap<String, Integer> multimap) {
                multimap.put((Object)"foo", (Object)17);
                multimap.put((Object)"bar", (Object)32);
                multimap.put((Object)"foo", (Object)16);
                multimap = Multimaps.filterKeys(multimap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"foo")));
                return Multimaps.filterKeys((ListMultimap)multimap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"bar")));
            }
        }).named("Multimaps.filterKeys[Multimaps.filterKeys[ListMultimap], Predicate]")).withFeatures(new Feature[]{CollectionSize.ANY, MultimapFeature.VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                multimap.put((Object)"one", (Object)314);
                multimap.put((Object)"two", (Object)159);
                multimap.put((Object)"one", (Object)265);
                return Multimaps.filterValues(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)314, (Object)159, (Object)265))));
            }
        }).named("Multimaps.filterValues[SetMultimap, Predicate]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                ImmutableSetMultimap badEntries = ImmutableSetMultimap.of((Object)"foo", (Object)314, (Object)"one", (Object)159, (Object)"two", (Object)265, (Object)"bar", (Object)358);
                multimap.putAll((Multimap)badEntries);
                return Multimaps.filterEntries(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)badEntries.entries())));
            }
        }).named("Multimaps.filterEntries[SetMultimap, Predicate]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                ImmutableSetMultimap badEntries = ImmutableSetMultimap.of((Object)"foo", (Object)314, (Object)"one", (Object)159, (Object)"two", (Object)265, (Object)"bar", (Object)358);
                multimap.putAll((Multimap)badEntries);
                multimap = Multimaps.filterKeys(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar"))));
                return Multimaps.filterEntries((SetMultimap)multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)badEntries.entries())));
            }
        }).named("Multimaps.filterEntries[Multimaps.filterKeys[SetMultimap]]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                ImmutableSetMultimap badEntries = ImmutableSetMultimap.of((Object)"foo", (Object)314, (Object)"one", (Object)159, (Object)"two", (Object)265, (Object)"bar", (Object)358);
                multimap.putAll((Multimap)badEntries);
                multimap = Multimaps.filterEntries(multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableMap.of((Object)"one", (Object)159, (Object)"two", (Object)265).entrySet())));
                return Multimaps.filterKeys((SetMultimap)multimap, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar"))));
            }
        }).named("Multimaps.filterKeys[Multimaps.filterEntries[SetMultimap]]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new FilteredSetMultimapGenerator(){

            @Override
            SetMultimap<String, Integer> filter(SetMultimap<String, Integer> multimap) {
                ImmutableSetMultimap badEntries = ImmutableSetMultimap.of((Object)"foo", (Object)314, (Object)"bar", (Object)358);
                multimap.putAll((Multimap)badEntries);
                multimap = Multimaps.filterKeys(multimap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"foo")));
                multimap = Multimaps.filterKeys((SetMultimap)multimap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"bar")));
                return multimap;
            }
        }).named("Multimaps.filterKeys[Multimaps.filterKeys[SetMultimap]]")).withFeatures(new Feature[]{CollectionSize.ANY, MultimapFeature.VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class FilteredListMultimapGenerator
    extends TestFilteredMultimapGenerator<ListMultimap<String, Integer>>
    implements TestListMultimapGenerator<String, Integer> {
        FilteredListMultimapGenerator() {
        }

        public ListMultimap<String, Integer> create(Object ... elements) {
            LinkedListMultimap multimap = LinkedListMultimap.create();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)o;
                multimap.put(entry.getKey(), entry.getValue());
            }
            return this.filter((ListMultimap<String, Integer>)multimap);
        }

        abstract ListMultimap<String, Integer> filter(ListMultimap<String, Integer> var1);

        public Collection<Integer> createCollection(Iterable<? extends Integer> values) {
            return Lists.newArrayList(values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class FilteredSetMultimapGenerator
    extends TestFilteredMultimapGenerator<SetMultimap<String, Integer>>
    implements TestSetMultimapGenerator<String, Integer> {
        FilteredSetMultimapGenerator() {
        }

        abstract SetMultimap<String, Integer> filter(SetMultimap<String, Integer> var1);

        public SetMultimap<String, Integer> create(Object ... elements) {
            LinkedHashMultimap multimap = LinkedHashMultimap.create();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)o;
                multimap.put(entry.getKey(), entry.getValue());
            }
            return this.filter((SetMultimap<String, Integer>)multimap);
        }

        public Collection<Integer> createCollection(Iterable<? extends Integer> values) {
            return Sets.newLinkedHashSet(values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TestFilteredMultimapGenerator<M extends Multimap<String, Integer>>
    implements TestMultimapGenerator<String, Integer, M> {
        TestFilteredMultimapGenerator() {
        }

        public SampleElements<Map.Entry<String, Integer>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)"one", (Object)114), (Object)Helpers.mapEntry((Object)"two", (Object)37), (Object)Helpers.mapEntry((Object)"three", (Object)42), (Object)Helpers.mapEntry((Object)"four", (Object)19), (Object)Helpers.mapEntry((Object)"five", (Object)82));
        }

        public Map.Entry<String, Integer>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
            return insertionOrder;
        }

        public String[] createKeyArray(int length) {
            return new String[length];
        }

        public Integer[] createValueArray(int length) {
            return new Integer[length];
        }

        public SampleElements<String> sampleKeys() {
            return new SampleElements((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five");
        }

        public SampleElements<Integer> sampleValues() {
            return new SampleElements((Object)114, (Object)37, (Object)42, (Object)19, (Object)82);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TransformedListMultimapGenerator
    extends TransformedMultimapGenerator<ListMultimap<String, String>>
    implements TestListMultimapGenerator<String, String> {
        TransformedListMultimapGenerator() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TransformedMultimapGenerator<M extends Multimap<String, String>>
    implements TestMultimapGenerator<String, String, M> {
        static final Function<String, String> FUNCTION = new Function<String, String>(){

            public String apply(String value) {
                return Ascii.toLowerCase((String)value);
            }
        };
        static final Maps.EntryTransformer<String, String, String> ENTRY_TRANSFORMER = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return Ascii.toLowerCase((String)value);
            }
        };

        TransformedMultimapGenerator() {
        }

        public String[] createKeyArray(int length) {
            return new String[length];
        }

        public String[] createValueArray(int length) {
            return new String[length];
        }

        public SampleElements<String> sampleKeys() {
            return new SampleElements((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five");
        }

        public SampleElements<String> sampleValues() {
            return new SampleElements((Object)"january", (Object)"february", (Object)"march", (Object)"april", (Object)"may");
        }

        public Collection<String> createCollection(Iterable<? extends String> values) {
            return Lists.newArrayList(values);
        }

        public SampleElements<Map.Entry<String, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)"one", (Object)"january"), (Object)Helpers.mapEntry((Object)"two", (Object)"february"), (Object)Helpers.mapEntry((Object)"three", (Object)"march"), (Object)Helpers.mapEntry((Object)"four", (Object)"april"), (Object)Helpers.mapEntry((Object)"five", (Object)"may"));
        }

        public M create(Object ... elements) {
            ArrayListMultimap multimap = ArrayListMultimap.create();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)o;
                multimap.put(entry.getKey(), (Object)Ascii.toUpperCase((String)((String)entry.getValue())));
            }
            return this.transform((Multimap<String, String>)multimap);
        }

        abstract M transform(Multimap<String, String> var1);

        public Map.Entry<String, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TestEntriesListGenerator
    extends TestEntriesGenerator
    implements TestListGenerator<Map.Entry<String, Integer>> {
        @Override
        public List<Map.Entry<String, Integer>> create(Object ... elements) {
            return (List)super.create(elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TestEntriesGenerator
    implements TestCollectionGenerator<Map.Entry<String, Integer>> {
        TestEntriesGenerator() {
        }

        public SampleElements<Map.Entry<String, Integer>> samples() {
            return new SampleElements((Object)Maps.immutableEntry((Object)"bar", (Object)1), (Object)Maps.immutableEntry((Object)"bar", (Object)2), (Object)Maps.immutableEntry((Object)"foo", (Object)3), (Object)Maps.immutableEntry((Object)"bar", (Object)3), (Object)Maps.immutableEntry((Object)"cat", (Object)2));
        }

        public Collection<Map.Entry<String, Integer>> create(Object ... elements) {
            Multimap<String, Integer> multimap = this.createMultimap();
            for (Object element : elements) {
                Map.Entry entry = (Map.Entry)element;
                multimap.put(entry.getKey(), entry.getValue());
            }
            return multimap.entries();
        }

        abstract Multimap<String, Integer> createMultimap();

        public Map.Entry<String, Integer>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public List<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PopulatableMapAsMultimap<K, V>
    extends ForwardingMultimap<K, V> {
        final Map<K, V> map = Maps.newHashMap();
        final SetMultimap<K, V> unusableDelegate = (SetMultimap)Proxy.newProxyInstance(SetMultimap.class.getClassLoader(), new Class[]{SetMultimap.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException();
            }
        });

        static <K, V> PopulatableMapAsMultimap<K, V> create() {
            return new PopulatableMapAsMultimap<K, V>();
        }

        PopulatableMapAsMultimap() {
        }

        protected Multimap<K, V> delegate() {
            return this.unusableDelegate;
        }

        public boolean put(K key, V value) {
            this.map.put(key, value);
            return true;
        }

        SetMultimap<K, V> build() {
            return Multimaps.forMap(this.map);
        }
    }
}

