/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.DerivedComparable;
import com.google.common.testing.NullPointerTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class MultisetsTest
extends TestCase {
    public void testNewTreeMultisetDerived() {
        TreeMultiset set = TreeMultiset.create();
        MultisetsTest.assertTrue((boolean)set.isEmpty());
        set.add((Object)new DerivedComparable("foo"), 2);
        set.add((Object)new DerivedComparable("bar"), 3);
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new DerivedComparable("bar"), (Object)new DerivedComparable("bar"), (Object[])new DerivedComparable[]{new DerivedComparable("bar"), new DerivedComparable("foo"), new DerivedComparable("foo")}).inOrder();
    }

    public void testNewTreeMultisetNonGeneric() {
        TreeMultiset set = TreeMultiset.create();
        MultisetsTest.assertTrue((boolean)set.isEmpty());
        set.add((Object)new LegacyComparable("foo"), 2);
        set.add((Object)new LegacyComparable("bar"), 3);
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("bar"), (Object[])new LegacyComparable[]{new LegacyComparable("bar"), new LegacyComparable("foo"), new LegacyComparable("foo")}).inOrder();
    }

    public void testNewTreeMultisetComparator() {
        TreeMultiset multiset = TreeMultiset.create(Collections.reverseOrder());
        multiset.add((Object)"bar", 3);
        multiset.add((Object)"foo", 2);
        Truth.ASSERT.that((Collection)multiset).has().exactly((Object)"foo", (Object)"foo", (Object[])new String[]{"bar", "bar", "bar"}).inOrder();
    }

    public void testRetainOccurrencesEmpty() {
        HashMultiset multiset = HashMultiset.create();
        HashMultiset toRetain = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertFalse((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        Truth.ASSERT.that((Collection)multiset).isEmpty();
    }

    public void testRemoveOccurrencesEmpty() {
        HashMultiset multiset = HashMultiset.create();
        HashMultiset toRemove = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertFalse((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRemove));
        MultisetsTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testUnion() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "b", "c"));
        Truth.ASSERT.that((Collection)Multisets.union((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b", "b", "c"});
    }

    public void testUnionEqualMultisets() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testUnionEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms2, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testUnionNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testIntersectEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        Truth.ASSERT.that((Collection)Multisets.intersection((Multiset)ms1, (Multiset)ms2)).isEmpty();
    }

    public void testIntersectNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        Truth.ASSERT.that((Collection)Multisets.intersection((Multiset)ms1, (Multiset)ms2)).isEmpty();
    }

    public void testSum() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("b", "c"));
        Truth.ASSERT.that((Collection)Multisets.sum((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b", "b", "c"});
    }

    public void testSumEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        Truth.ASSERT.that((Collection)Multisets.sum((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"a"});
    }

    public void testSumNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        Truth.ASSERT.that((Collection)Multisets.sum((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"a"});
    }

    public void testDifferenceWithNoRemovedElements() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a"));
        Truth.ASSERT.that((Collection)Multisets.difference((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]);
    }

    public void testDifferenceWithRemovedElement() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("b"));
        Truth.ASSERT.that((Collection)Multisets.difference((Multiset)ms1, (Multiset)ms2)).has().exactly((Object)"a", (Object)"a", (Object[])new String[0]);
    }

    public void testDifferenceWithMoreElementsInSecondMultiset() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "b", "b"));
        Multiset diff = Multisets.difference((Multiset)ms1, (Multiset)ms2);
        Truth.ASSERT.that((Collection)diff).has().item((Object)"a");
        MultisetsTest.assertEquals((int)0, (int)diff.count((Object)"b"));
        MultisetsTest.assertEquals((int)1, (int)diff.count((Object)"a"));
        MultisetsTest.assertFalse((boolean)diff.contains((Object)"b"));
        MultisetsTest.assertTrue((boolean)diff.contains((Object)"a"));
    }

    public void testDifferenceEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.difference((Multiset)ms1, (Multiset)ms2));
    }

    public void testDifferenceNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.difference((Multiset)ms1, (Multiset)ms2));
    }

    public void testContainsOccurrencesEmpty() {
        HashMultiset superMultiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset subMultiset = HashMultiset.create();
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)subMultiset));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)subMultiset, (Multiset)superMultiset));
    }

    public void testContainsOccurrences() {
        HashMultiset superMultiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset subMultiset = HashMultiset.create(Arrays.asList("a", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)subMultiset));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)subMultiset, (Multiset)superMultiset));
        HashMultiset diffMultiset = HashMultiset.create(Arrays.asList("a", "b", "c"));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)diffMultiset));
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)diffMultiset, (Multiset)subMultiset));
    }

    public void testRetainEmptyOccurrences() {
        HashMultiset multiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset toRetain = HashMultiset.create();
        MultisetsTest.assertTrue((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        MultisetsTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testRetainOccurrences() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a", "c"));
        HashMultiset toRetain = HashMultiset.create(Arrays.asList("a", "b", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        Truth.ASSERT.that((Collection)multiset).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
    }

    public void testRemoveEmptyOccurrences() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset toRemove = HashMultiset.create();
        MultisetsTest.assertFalse((boolean)Multisets.removeOccurrences((Multiset)multiset, (Multiset)toRemove));
        Truth.ASSERT.that((Collection)multiset).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b"}).inOrder();
    }

    public void testRemoveOccurrences() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a", "c"));
        HashMultiset toRemove = HashMultiset.create(Arrays.asList("a", "b", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.removeOccurrences((Multiset)multiset, (Multiset)toRemove));
        Truth.ASSERT.that((Collection)multiset).has().exactly((Object)"a", (Object)"c", (Object[])new String[0]).inOrder();
    }

    public void testUnmodifiableMultisetShortCircuit() {
        HashMultiset mod = HashMultiset.create();
        Multiset unmod = Multisets.unmodifiableMultiset((Multiset)mod);
        MultisetsTest.assertNotSame((Object)mod, (Object)unmod);
        MultisetsTest.assertSame((Object)unmod, (Object)Multisets.unmodifiableMultiset((Multiset)unmod));
        ImmutableMultiset immutable = ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b", (Object)"a");
        MultisetsTest.assertSame((Object)immutable, (Object)Multisets.unmodifiableMultiset((ImmutableMultiset)immutable));
        MultisetsTest.assertSame((Object)immutable, (Object)Multisets.unmodifiableMultiset((Multiset)immutable));
    }

    public void testHighestCountFirst() {
        HashMultiset multiset = HashMultiset.create(Arrays.asList("a", "a", "a", "b", "c", "c"));
        ImmutableMultiset sortedMultiset = Multisets.copyHighestCountFirst((Multiset)multiset);
        Truth.ASSERT.that((Collection)sortedMultiset.entrySet()).has().exactly((Object)Multisets.immutableEntry((Object)"a", (int)3), (Object)Multisets.immutableEntry((Object)"c", (int)2), (Object[])new Multiset.Entry[]{Multisets.immutableEntry((Object)"b", (int)1)}).inOrder();
        Truth.ASSERT.that((Collection)sortedMultiset).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"a", "c", "c", "b"}).inOrder();
        Truth.ASSERT.that((Collection)Multisets.copyHighestCountFirst((Multiset)ImmutableMultiset.of())).isEmpty();
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Multisets.class);
    }
}

