/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class NewCustomTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        Supplier<TreeMap<Integer, Character>> factory = new Supplier<TreeMap<Integer, Character>>(){

            public TreeMap<Integer, Character> get() {
                return Maps.newTreeMap();
            }
        };
        LinkedHashMap backingMap = Maps.newLinkedHashMap();
        Table table = Tables.newCustomTable((Map)backingMap, (Supplier)factory);
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testRowKeySetOrdering() {
        this.table = this.create("foo", 3, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'));
        Truth.ASSERT.that((Collection)this.table.rowKeySet()).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testRowOrdering() {
        this.table = this.create("foo", 3, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'));
        Truth.ASSERT.that(this.table.row((Object)"foo").keySet()).has().exactly((Object)2, (Object)3, (Object[])new Integer[0]).inOrder();
    }
}

