/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Ints;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class OrderingTest
extends TestCase {
    private final Ordering<Number> numberOrdering = new NumberOrdering();
    private static final Ordering<Integer> DECREASING_INTEGER = Ordering.natural().reverse();
    private static final int RECURSE_DEPTH = 2;

    public void testAllEqual() {
        Ordering comparator = Ordering.allEqual();
        OrderingTest.assertSame((Object)comparator, (Object)comparator.reverse());
        OrderingTest.assertEquals((int)comparator.compare(null, null), (int)0);
        OrderingTest.assertEquals((int)comparator.compare(new Object(), new Object()), (int)0);
        OrderingTest.assertEquals((int)comparator.compare((Object)"apples", (Object)"oranges"), (int)0);
        OrderingTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
        OrderingTest.assertEquals((String)"Ordering.allEqual()", (String)comparator.toString());
        ImmutableList strings = ImmutableList.of((Object)"b", (Object)"a", (Object)"d", (Object)"c");
        OrderingTest.assertEquals((Object)strings, (Object)comparator.sortedCopy((Iterable)strings));
        OrderingTest.assertEquals((Object)strings, (Object)comparator.immutableSortedCopy((Iterable)strings));
    }

    public void testNatural() {
        Ordering comparator = Ordering.natural();
        Helpers.testComparator((Comparator)comparator, (Object[])new Integer[]{Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE});
        try {
            comparator.compare((Object)1, null);
            OrderingTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            comparator.compare(null, (Object)2);
            OrderingTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            comparator.compare(null, null);
            OrderingTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        OrderingTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
        OrderingTest.assertEquals((String)"Ordering.natural()", (String)comparator.toString());
    }

    public void testFrom() {
        Ordering caseInsensitiveOrdering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
        OrderingTest.assertEquals((int)0, (int)caseInsensitiveOrdering.compare((Object)"A", (Object)"a"));
        OrderingTest.assertTrue((caseInsensitiveOrdering.compare((Object)"a", (Object)"B") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((caseInsensitiveOrdering.compare((Object)"B", (Object)"a") > 0 ? 1 : 0) != 0);
        Ordering orderingFromOrdering = Ordering.from((Ordering)Ordering.natural());
        new EqualsTester().addEqualityGroup(new Object[]{caseInsensitiveOrdering, Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER)}).addEqualityGroup(new Object[]{orderingFromOrdering, Ordering.natural()}).testEquals();
    }

    public void testExplicit_none() {
        Ordering c = Ordering.explicit(Collections.emptyList());
        try {
            c.compare(0, 0);
            OrderingTest.fail();
        }
        catch (Ordering.IncomparableValueException expected) {
            OrderingTest.assertEquals((Object)0, (Object)expected.value);
        }
        SerializableTester.reserializeAndAssert((Object)c);
    }

    public void testExplicit_one() {
        Ordering c = Ordering.explicit((Object)0, (Object[])new Integer[0]);
        OrderingTest.assertEquals((int)0, (int)c.compare(0, 0));
        try {
            c.compare(0, 1);
            OrderingTest.fail();
        }
        catch (Ordering.IncomparableValueException expected) {
            OrderingTest.assertEquals((Object)1, (Object)expected.value);
        }
        SerializableTester.reserializeAndAssert((Object)c);
        OrderingTest.assertEquals((String)"Ordering.explicit([0])", (String)c.toString());
    }

    public void testExplicit_two() {
        Ordering c = Ordering.explicit((Object)42, (Object[])new Integer[]{5});
        OrderingTest.assertEquals((int)0, (int)c.compare(5, 5));
        OrderingTest.assertTrue((c.compare(5, 42) > 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((c.compare(42, 5) < 0 ? 1 : 0) != 0);
        try {
            c.compare(5, 666);
            OrderingTest.fail();
        }
        catch (Ordering.IncomparableValueException expected) {
            OrderingTest.assertEquals((Object)666, (Object)expected.value);
        }
        new EqualsTester().addEqualityGroup(new Object[]{c, Ordering.explicit((Object)42, (Object[])new Integer[]{5})}).addEqualityGroup(new Object[]{Ordering.explicit((Object)5, (Object[])new Integer[]{42})}).addEqualityGroup(new Object[]{Ordering.explicit((Object)42, (Object[])new Integer[0])}).testEquals();
        SerializableTester.reserializeAndAssert((Object)c);
    }

    public void testExplicit_sortingExample() {
        Ordering c = Ordering.explicit((Object)2, (Object[])new Integer[]{8, 6, 1, 7, 5, 3, 4, 0, 9});
        List<Integer> list = Arrays.asList(0, 3, 5, 6, 7, 8, 9);
        Collections.sort(list, c);
        Truth.ASSERT.that(list).has().exactly((Object)8, (Object)6, (Object[])new Integer[]{7, 5, 3, 0, 9}).inOrder();
        SerializableTester.reserializeAndAssert((Object)c);
    }

    public void testExplicit_withDuplicates() {
        try {
            Ordering.explicit((Object)1, (Object[])new Integer[]{2, 3, 4, 2});
            OrderingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testArbitrary_withoutCollisions() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 50; ++i) {
            list.add(new Object());
        }
        Ordering arbitrary = Ordering.arbitrary();
        Collections.sort(list, arbitrary);
        Helpers.testComparator((Comparator)arbitrary, (List)list);
        OrderingTest.assertEquals((String)"Ordering.arbitrary()", (String)arbitrary.toString());
    }

    public void testArbitrary_withCollisions() {
        List<Object> list = Lists.newArrayList();
        for (int i = 0; i < 50; ++i) {
            list.add(i);
        }
        Ordering.ArbitraryOrdering arbitrary = new Ordering.ArbitraryOrdering(){

            int identityHashCode(Object object) {
                return (Integer)object % 5;
            }
        };
        list = OrderingTest.shuffledCopy(list, new Random(1L));
        Collections.sort(list, arbitrary);
        Helpers.testComparator((Comparator)arbitrary, (List)list);
    }

    public void testUsingToString() {
        Ordering ordering = Ordering.usingToString();
        Helpers.testComparator((Comparator)ordering, (Object[])new Integer[]{1, 12, 124, 2});
        OrderingTest.assertEquals((String)"Ordering.usingToString()", (String)ordering.toString());
        OrderingTest.assertSame((Object)ordering, (Object)SerializableTester.reserialize((Object)ordering));
    }

    private static Ordering<String> byCharAt(int index) {
        return Ordering.natural().onResultOf((Function)CharAtFunction.values()[index]);
    }

    public void testCompound_static() {
        Ordering comparator = Ordering.compound((Iterable)ImmutableList.of(OrderingTest.byCharAt(0), OrderingTest.byCharAt(1), OrderingTest.byCharAt(2), OrderingTest.byCharAt(3), OrderingTest.byCharAt(4), OrderingTest.byCharAt(5)));
        Helpers.testComparator((Comparator)comparator, (List)ImmutableList.of((Object)"applesauce", (Object)"apricot", (Object)"artichoke", (Object)"banality", (Object)"banana", (Object)"banquet", (Object)"tangelo", (Object)"tangerine"));
        SerializableTester.reserializeAndAssert((Object)comparator);
    }

    public void testCompound_instance() {
        Ordering comparator = OrderingTest.byCharAt(1).compound(OrderingTest.byCharAt(0));
        Helpers.testComparator((Comparator)comparator, (List)ImmutableList.of((Object)"red", (Object)"yellow", (Object)"violet", (Object)"blue", (Object)"indigo", (Object)"green", (Object)"orange"));
    }

    public void testCompound_instance_generics() {
        Ordering objects = Ordering.explicit((Object)1, (Object[])new Object[0]);
        Ordering numbers = Ordering.explicit((Object)1, (Object[])new Number[0]);
        Ordering integers = Ordering.explicit((Object)1, (Object[])new Integer[0]);
        Ordering a = numbers.compound((Comparator)numbers);
        Ordering b = numbers.compound((Comparator)objects);
        Ordering c = objects.compound((Comparator)numbers);
        Ordering d = numbers.compound((Comparator)integers);
        Ordering e = integers.compound((Comparator)numbers);
        Ordering f = numbers.compound((Comparator)objects).compound((Comparator)objects);
        Ordering g = objects.compound((Comparator)numbers).compound((Comparator)objects);
        Ordering h = objects.compound((Comparator)objects).compound((Comparator)numbers);
        Ordering i = numbers.compound((Comparator)objects.compound((Comparator)objects));
        Ordering j = objects.compound((Comparator)numbers.compound((Comparator)objects));
        Ordering k = objects.compound((Comparator)objects.compound((Comparator)numbers));
        Ordering l = objects.compound((Comparator)numbers);
    }

    public void testReverse() {
        Ordering reverseOrder = this.numberOrdering.reverse();
        Helpers.testComparator((Comparator)reverseOrder, (Object[])new Integer[]{Integer.MAX_VALUE, 1, 0, -1, Integer.MIN_VALUE});
        new EqualsTester().addEqualityGroup(new Object[]{reverseOrder, this.numberOrdering.reverse()}).addEqualityGroup(new Object[]{Ordering.natural().reverse()}).addEqualityGroup(new Object[]{Collections.reverseOrder()}).testEquals();
    }

    public void testReverseOfReverseSameAsForward() {
        OrderingTest.assertSame(this.numberOrdering, (Object)this.numberOrdering.reverse().reverse());
    }

    public void testOnResultOf_natural() {
        Ordering comparator = Ordering.natural().onResultOf((Function)StringLengthFunction.StringLength);
        OrderingTest.assertTrue((comparator.compare("to", "be") == 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("or", "not") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("that", "to") > 0 ? 1 : 0) != 0);
        new EqualsTester().addEqualityGroup(new Object[]{comparator, Ordering.natural().onResultOf((Function)StringLengthFunction.StringLength)}).addEqualityGroup(new Object[]{DECREASING_INTEGER}).testEquals();
        SerializableTester.reserializeAndAssert((Object)comparator);
        OrderingTest.assertEquals((String)"Ordering.natural().onResultOf(StringLength)", (String)comparator.toString());
    }

    public void testOnResultOf_chained() {
        Ordering comparator = DECREASING_INTEGER.onResultOf((Function)StringLengthFunction.StringLength);
        OrderingTest.assertTrue((comparator.compare("to", "be") == 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("not", "or") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("to", "that") > 0 ? 1 : 0) != 0);
        new EqualsTester().addEqualityGroup(new Object[]{comparator, DECREASING_INTEGER.onResultOf((Function)StringLengthFunction.StringLength)}).addEqualityGroup(new Object[]{DECREASING_INTEGER.onResultOf(Functions.constant((Object)1))}).addEqualityGroup(new Object[]{Ordering.natural()}).testEquals();
        SerializableTester.reserializeAndAssert((Object)comparator);
        OrderingTest.assertEquals((String)"Ordering.natural().reverse().onResultOf(StringLength)", (String)comparator.toString());
    }

    public void testLexicographical() {
        Ordering ordering = Ordering.natural();
        Ordering lexy = ordering.lexicographical();
        ImmutableList empty = ImmutableList.of();
        ImmutableList a = ImmutableList.of((Object)"a");
        ImmutableList aa = ImmutableList.of((Object)"a", (Object)"a");
        ImmutableList ab = ImmutableList.of((Object)"a", (Object)"b");
        ImmutableList b = ImmutableList.of((Object)"b");
        Helpers.testComparator((Comparator)lexy, (Object[])new ImmutableList[]{empty, a, aa, ab, b});
        new EqualsTester().addEqualityGroup(new Object[]{lexy, ordering.lexicographical()}).addEqualityGroup(new Object[]{this.numberOrdering.lexicographical()}).addEqualityGroup(new Object[]{Ordering.natural()}).testEquals();
    }

    public void testNullsFirst() {
        Ordering ordering = Ordering.natural().nullsFirst();
        Helpers.testComparator((Comparator)ordering, (Object[])new Integer[]{null, Integer.MIN_VALUE, 0, 1});
        new EqualsTester().addEqualityGroup(new Object[]{ordering, Ordering.natural().nullsFirst()}).addEqualityGroup(new Object[]{this.numberOrdering.nullsFirst()}).addEqualityGroup(new Object[]{Ordering.natural()}).testEquals();
    }

    public void testNullsLast() {
        Ordering ordering = Ordering.natural().nullsLast();
        Helpers.testComparator((Comparator)ordering, (Object[])new Integer[]{0, 1, Integer.MAX_VALUE, null});
        new EqualsTester().addEqualityGroup(new Object[]{ordering, Ordering.natural().nullsLast()}).addEqualityGroup(new Object[]{this.numberOrdering.nullsLast()}).addEqualityGroup(new Object[]{Ordering.natural()}).testEquals();
    }

    public void testBinarySearch() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{0, 2, 3, 5, 7, 9});
        OrderingTest.assertEquals((int)4, (int)this.numberOrdering.binarySearch((List)ints, (Object)7));
    }

    public void testSortedCopy() {
        List<Integer> unsortedInts = Collections.unmodifiableList(Arrays.asList(5, 0, 3, null, 0, 9));
        List sortedInts = this.numberOrdering.nullsLast().sortedCopy(unsortedInts);
        OrderingTest.assertEquals(Arrays.asList(0, 0, 3, 5, 9, null), (Object)sortedInts);
        OrderingTest.assertEquals(Collections.emptyList(), (Object)this.numberOrdering.sortedCopy(Collections.emptyList()));
    }

    public void testImmutableSortedCopy() {
        ImmutableList unsortedInts = ImmutableList.of((Object)5, (Object)3, (Object)0, (Object)9, (Object)3);
        ImmutableList sortedInts = this.numberOrdering.immutableSortedCopy((Iterable)unsortedInts);
        OrderingTest.assertEquals(Arrays.asList(0, 3, 3, 5, 9), (Object)sortedInts);
        OrderingTest.assertEquals(Collections.emptyList(), (Object)this.numberOrdering.immutableSortedCopy(Collections.emptyList()));
        List<Integer> listWithNull = Arrays.asList(5, 3, null, 9);
        try {
            Ordering.natural().nullsFirst().immutableSortedCopy(listWithNull);
            OrderingTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    public void testIsOrdered() {
        OrderingTest.assertFalse((boolean)this.numberOrdering.isOrdered(Arrays.asList(5, 3, 0, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 5, 3, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 3, 5, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 0, 3, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Collections.singleton(1)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Collections.emptyList()));
    }

    public void testIsStrictlyOrdered() {
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(5, 3, 0, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 5, 3, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 3, 5, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 0, 3, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Collections.singleton(1)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Collections.emptyList()));
    }

    public void testLeastOfIterable_empty_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(new Integer[0]), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_empty_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.emptyIterator(), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_empty_1() {
        List result = this.numberOrdering.leastOf(Arrays.asList(new Integer[0]), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_empty_1() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.emptyIterator(), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_negativeOne() {
        try {
            this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), -1);
            OrderingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLeastOfIterator_simple_negativeOne() {
        try {
            this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), -1);
            OrderingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLeastOfIterable_singleton_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_singleton_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.singletonIterator((Object)3), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_simple_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_1() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1), (Object)result);
    }

    public void testLeastOfIterator_simple_1() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1), (Object)result);
    }

    public void testLeastOfIterable_simple_nMinusOne_withNullElement() {
        List<Integer> list = Arrays.asList(3, null, 5, -1);
        List result = Ordering.natural().nullsLast().leastOf(list, list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_nMinusOne_withNullElement() {
        UnmodifiableIterator itr = Iterators.forArray((Object[])new Integer[]{3, null, 5, -1});
        List result = Ordering.natural().nullsLast().leastOf((Iterator)itr, 3);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_simple_nMinusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4), (Object)result);
    }

    public void testLeastOfIterator_simple_nMinusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4), (Object)result);
    }

    public void testLeastOfIterable_simple_n() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_n() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_simple_n_withNullElement() {
        List<Integer> list = Arrays.asList(3, 4, 5, null, -1);
        List result = Ordering.natural().nullsLast().leastOf(list, list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals(Arrays.asList(-1, 3, 4, 5, null), (Object)result);
    }

    public void testLeastOfIterator_simple_n_withNullElement() {
        List<Integer> list = Arrays.asList(3, 4, 5, null, -1);
        List result = Ordering.natural().nullsLast().leastOf(list.iterator(), list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals(Arrays.asList(-1, 3, 4, 5, null), (Object)result);
    }

    public void testLeastOfIterable_simple_nPlusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size() + 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_nPlusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size() + 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_ties() {
        Integer foo = new Integer(0x7FFFFFF5);
        Integer bar = new Integer(0x7FFFFFF5);
        OrderingTest.assertNotSame((Object)foo, (Object)bar);
        OrderingTest.assertEquals((Object)foo, (Object)bar);
        List<Integer> list = Arrays.asList(3, foo, bar, -1);
        List result = this.numberOrdering.leastOf(list, list.size());
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)foo, (Object)bar), (Object)result);
    }

    public void testLeastOfIterator_ties() {
        Integer foo = new Integer(0x7FFFFFF5);
        Integer bar = new Integer(0x7FFFFFF5);
        OrderingTest.assertNotSame((Object)foo, (Object)bar);
        OrderingTest.assertEquals((Object)foo, (Object)bar);
        List<Integer> list = Arrays.asList(3, foo, bar, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size());
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)foo, (Object)bar), (Object)result);
    }

    @GwtIncompatible(value="slow")
    public void testLeastOf_reconcileAgainstSortAndSublist() {
        OrderingTest.runLeastOfComparison(1000, 300, 20);
    }

    public void testLeastOf_reconcileAgainstSortAndSublistSmall() {
        OrderingTest.runLeastOfComparison(10, 30, 2);
    }

    private static void runLeastOfComparison(int iterations, int elements, int seeds) {
        Random random = new Random(42L);
        Ordering ordering = Ordering.natural();
        for (int i = 0; i < iterations; ++i) {
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < elements; ++j) {
                list.add(random.nextInt(10 * i + j + 1));
            }
            for (int seed = 1; seed < seeds; ++seed) {
                int k = random.nextInt(10 * seed);
                OrderingTest.assertEquals(ordering.sortedCopy((Iterable)list).subList(0, k), (Object)ordering.leastOf((Iterable)list, k));
            }
        }
    }

    public void testLeastOfIterableLargeK() {
        List<Integer> list = Arrays.asList(4, 2, 3, 5, 1);
        OrderingTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)Ordering.natural().leastOf(list, Integer.MAX_VALUE));
    }

    public void testLeastOfIteratorLargeK() {
        List<Integer> list = Arrays.asList(4, 2, 3, 5, 1);
        OrderingTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)Ordering.natural().leastOf(list.iterator(), Integer.MAX_VALUE));
    }

    public void testGreatestOfIterable_simple() {
        List<Integer> list = Arrays.asList(3, 1, 3, 2, 4, 2, 4, 3);
        OrderingTest.assertEquals(Arrays.asList(4, 4, 3, 3), (Object)this.numberOrdering.greatestOf(list, 4));
    }

    public void testGreatestOfIterator_simple() {
        List<Integer> list = Arrays.asList(3, 1, 3, 2, 4, 2, 4, 3);
        OrderingTest.assertEquals(Arrays.asList(4, 4, 3, 3), (Object)this.numberOrdering.greatestOf(list.iterator(), 4));
    }

    private static void assertListImmutable(List<Integer> result) {
        try {
            result.set(0, 1);
            OrderingTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testIteratorMinAndMax() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{5, 3, 0, 9});
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max(ints.iterator())));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min(ints.iterator())));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        ints = Lists.newArrayList((Object[])new Integer[]{a, b, b});
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max(ints.iterator()));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min(ints.iterator()));
    }

    public void testIteratorMinExhaustsIterator() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{9, 0, 3, 5});
        Iterator iterator = ints.iterator();
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min(iterator)));
        OrderingTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIteratorMaxExhaustsIterator() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{9, 0, 3, 5});
        Iterator iterator = ints.iterator();
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max(iterator)));
        OrderingTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIterableMinAndMax() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{5, 3, 0, 9});
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Iterable)ints)));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Iterable)ints)));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        ints = Lists.newArrayList((Object[])new Integer[]{a, b, b});
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Iterable)ints));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Iterable)ints));
    }

    public void testVarargsMinAndMax() {
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)9, (Object)3, (Object)0, (Object[])new Integer[]{5, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)9, (Object)0, (Object[])new Integer[]{3, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)9, (Object[])new Integer[]{0, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{8, 9})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)0, (Object)3, (Object)5, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)0, (Object)3, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)9, (Object[])new Integer[]{0, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 0})));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Object)a, (Object)b, (Object)b, (Object[])new Integer[0]));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Object)a, (Object)b, (Object)b, (Object[])new Integer[0]));
    }

    public void testParameterMinAndMax() {
        OrderingTest.assertEquals((int)5, (int)((Integer)this.numberOrdering.max((Object)3, (Object)5)));
        OrderingTest.assertEquals((int)5, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3)));
        OrderingTest.assertEquals((int)3, (int)((Integer)this.numberOrdering.min((Object)3, (Object)5)));
        OrderingTest.assertEquals((int)3, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3)));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Object)a, (Object)b));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Object)a, (Object)b));
    }

    public void testCombinationsExhaustively_startingFromNatural() {
        OrderingTest.testExhaustively(Ordering.natural(), "a", "b", "d");
    }

    @GwtIncompatible(value="too slow")
    public void testCombinationsExhaustively_startingFromExplicit() {
        OrderingTest.testExhaustively(Ordering.explicit((Object)"a", (Object[])new String[]{"b", "c", "d"}), "a", "b", "d");
    }

    @GwtIncompatible(value="too slow")
    public void testCombinationsExhaustively_startingFromUsingToString() {
        OrderingTest.testExhaustively(Ordering.usingToString(), 1, 12, 2);
    }

    @GwtIncompatible(value="too slow")
    public void testCombinationsExhaustively_startingFromFromComparator() {
        OrderingTest.testExhaustively(Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER), "A", "b", "C", "d");
    }

    @GwtIncompatible(value="too slow")
    public void testCombinationsExhaustively_startingFromArbitrary() {
        Ordering arbitrary = Ordering.arbitrary();
        Object[] array = new Object[]{1, "foo", new Object()};
        Arrays.sort(array, arbitrary);
        OrderingTest.testExhaustively(arbitrary, array);
    }

    private static <T> void testExhaustively(Ordering<? super T> ordering, T ... strictlyOrderedElements) {
        Preconditions.checkArgument((strictlyOrderedElements.length >= 3 ? 1 : 0) != 0, (Object)"strictlyOrderedElements requires at least 3 elements");
        List<T> list = Arrays.asList(strictlyOrderedElements);
        Object[] emptyArray = Platform.newArray((Object[])strictlyOrderedElements, (int)0);
        Scenario<Object> starter = new Scenario<Object>(ordering, list, emptyArray);
        OrderingTest.verifyScenario(starter, 0);
    }

    private static <T> void verifyScenario(Scenario<T> scenario, int level) {
        scenario.testCompareTo();
        scenario.testIsOrdered();
        scenario.testMinAndMax();
        scenario.testBinarySearch();
        scenario.testSortedCopy();
        if (level < 2) {
            for (OrderingMutation alteration : OrderingMutation.values()) {
                OrderingTest.verifyScenario(alteration.mutate(scenario), level + 1);
            }
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Ordering.class);
        tester.testAllPublicInstanceMethods((Object)Ordering.usingToString().nullsFirst());
    }

    private static <T> List<T> shuffledCopy(List<T> in, Random random) {
        ArrayList mutable = Lists.newArrayList(in);
        ArrayList out = Lists.newArrayList();
        while (!mutable.isEmpty()) {
            out.add(mutable.remove(random.nextInt(mutable.size())));
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Composite<T>
    implements Comparable<Composite<T>> {
        final T value;
        final int rank;

        Composite(T value, int rank) {
            this.value = value;
            this.rank = rank;
        }

        @Override
        public int compareTo(Composite<T> that) {
            return Ints.compare((int)this.rank, (int)that.rank);
        }

        static <T> Function<Composite<T>, T> getValueFunction() {
            return new Function<Composite<T>, T>(){

                public T apply(Composite<T> from) {
                    return from.value;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OrderingMutation {
        REVERSE{

            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                ArrayList newList = Lists.newArrayList(scenario.strictlyOrderedList);
                Collections.reverse(newList);
                return new Scenario(scenario.ordering.reverse(), newList, scenario.emptyArray);
            }
        }
        ,
        NULLS_FIRST{

            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                ArrayList newList = Lists.newArrayList((Object[])new Object[]{null});
                for (Object t : scenario.strictlyOrderedList) {
                    if (t == null) continue;
                    newList.add(t);
                }
                return new Scenario(scenario.ordering.nullsFirst(), newList, scenario.emptyArray);
            }
        }
        ,
        NULLS_LAST{

            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                ArrayList newList = Lists.newArrayList();
                for (Object t : scenario.strictlyOrderedList) {
                    if (t == null) continue;
                    newList.add(t);
                }
                newList.add(null);
                return new Scenario(scenario.ordering.nullsLast(), newList, scenario.emptyArray);
            }
        }
        ,
        ON_RESULT_OF{

            @Override
            <T> Scenario<?> mutate(final Scenario<T> scenario) {
                Ordering ordering = scenario.ordering.onResultOf(new Function<Integer, T>(){

                    public T apply(@Nullable Integer from) {
                        return scenario.strictlyOrderedList.get(from);
                    }
                });
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < scenario.strictlyOrderedList.size(); ++i) {
                    list.add(i);
                }
                return new Scenario<Integer>(ordering, list, new Integer[0]);
            }
        }
        ,
        COMPOUND_THIS_WITH_NATURAL{

            /*
             * Exception decompiling
             */
            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        ,
        COMPOUND_NATURAL_WITH_THIS{

            /*
             * Exception decompiling
             */
            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        ,
        LEXICOGRAPHICAL{

            @Override
            <T> Scenario<?> mutate(Scenario<T> scenario) {
                ArrayList words = Lists.newArrayList();
                words.add(Collections.emptyList());
                for (Object t : scenario.strictlyOrderedList) {
                    words.add(Arrays.asList(t));
                    for (Object s : scenario.strictlyOrderedList) {
                        words.add(Arrays.asList(t, s));
                    }
                }
                return new Scenario<Iterable>(scenario.ordering.lexicographical(), words, new Iterable[0]);
            }
        };


        abstract <T> Scenario<?> mutate(Scenario<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Scenario<T> {
        final Ordering<T> ordering;
        final List<T> strictlyOrderedList;
        final T[] emptyArray;

        Scenario(Ordering<T> ordering, List<T> strictlyOrderedList, T[] emptyArray) {
            this.ordering = ordering;
            this.strictlyOrderedList = strictlyOrderedList;
            this.emptyArray = emptyArray;
        }

        void testCompareTo() {
            Helpers.testComparator(this.ordering, this.strictlyOrderedList);
        }

        void testIsOrdered() {
            Assert.assertTrue((boolean)this.ordering.isOrdered(this.strictlyOrderedList));
            Assert.assertTrue((boolean)this.ordering.isStrictlyOrdered(this.strictlyOrderedList));
        }

        void testMinAndMax() {
            List shuffledList = Lists.newArrayList(this.strictlyOrderedList);
            shuffledList = OrderingTest.shuffledCopy(shuffledList, new Random(5L));
            T min = this.strictlyOrderedList.get(0);
            T max = this.strictlyOrderedList.get(this.strictlyOrderedList.size() - 1);
            Object first = shuffledList.get(0);
            Object second = shuffledList.get(1);
            Object third = shuffledList.get(2);
            Object[] rest = shuffledList.subList(3, shuffledList.size()).toArray(this.emptyArray);
            Assert.assertEquals(min, (Object)this.ordering.min(shuffledList));
            Assert.assertEquals(min, (Object)this.ordering.min(shuffledList.iterator()));
            Assert.assertEquals(min, (Object)this.ordering.min(first, second, third, rest));
            Assert.assertEquals(min, (Object)this.ordering.min(min, max));
            Assert.assertEquals(min, (Object)this.ordering.min(max, min));
            Assert.assertEquals(max, (Object)this.ordering.max(shuffledList));
            Assert.assertEquals(max, (Object)this.ordering.max(shuffledList.iterator()));
            Assert.assertEquals(max, (Object)this.ordering.max(first, second, third, rest));
            Assert.assertEquals(max, (Object)this.ordering.max(min, max));
            Assert.assertEquals(max, (Object)this.ordering.max(max, min));
        }

        void testBinarySearch() {
            for (int i = 0; i < this.strictlyOrderedList.size(); ++i) {
                Assert.assertEquals((int)i, (int)this.ordering.binarySearch(this.strictlyOrderedList, this.strictlyOrderedList.get(i)));
            }
            ArrayList newList = Lists.newArrayList(this.strictlyOrderedList);
            Object valueNotInList = newList.remove(1);
            Assert.assertEquals((int)-2, (int)this.ordering.binarySearch((List)newList, valueNotInList));
        }

        void testSortedCopy() {
            List shuffledList = Lists.newArrayList(this.strictlyOrderedList);
            shuffledList = OrderingTest.shuffledCopy(shuffledList, new Random(5L));
            Assert.assertEquals(this.strictlyOrderedList, (Object)this.ordering.sortedCopy((Iterable)shuffledList));
            if (!this.strictlyOrderedList.contains(null)) {
                Assert.assertEquals(this.strictlyOrderedList, (Object)this.ordering.immutableSortedCopy((Iterable)shuffledList));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberOrdering
    extends Ordering<Number> {
        private static final long serialVersionUID = 0L;

        private NumberOrdering() {
        }

        public int compare(Number a, Number b) {
            return Double.valueOf(a.doubleValue()).compareTo(b.doubleValue());
        }

        public int hashCode() {
            return NumberOrdering.class.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof NumberOrdering;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StringLengthFunction implements Function<String, Integer>
    {
        StringLength;


        public Integer apply(String string) {
            return string.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CharAtFunction implements Function<String, Character>
    {
        AT0(0),
        AT1(1),
        AT2(2),
        AT3(3),
        AT4(4),
        AT5(5);

        final int index;

        private CharAtFunction(int index) {
            this.index = index;
        }

        public Character apply(String string) {
            return Character.valueOf(string.charAt(this.index));
        }
    }
}

