/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class PeekingIteratorTest
extends TestCase {
    private <T> void actsLikeIteratorHelper(final List<T> list) {
        new PeekingIteratorTester<T>(list).test();
        new IteratorTester<T>(list.size() * 2 + 2, IteratorFeature.UNMODIFIABLE, list, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<T> newTargetIterator() {
                Iterator iterator = Collections.unmodifiableList(list).iterator();
                return Iterators.peekingIterator(iterator);
            }
        }.test();
    }

    public void testPeekingIteratorBehavesLikeIteratorOnEmptyIterable() {
        this.actsLikeIteratorHelper(Collections.emptyList());
    }

    public void testPeekingIteratorBehavesLikeIteratorOnSingletonIterable() {
        this.actsLikeIteratorHelper(Collections.singletonList(new Object()));
    }

    @GwtIncompatible(value="works but takes 5 minutes to run")
    public void testPeekingIteratorBehavesLikeIteratorOnThreeElementIterable() {
        this.actsLikeIteratorHelper(Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
    }

    @GwtIncompatible(value="works but takes 5 minutes to run")
    public void testPeekingIteratorAcceptsNullElements() {
        this.actsLikeIteratorHelper(Lists.newArrayList((Object[])new String[]{null, "A", null}));
    }

    public void testPeekOnEmptyList() {
        List list = Collections.emptyList();
        Iterator iterator = list.iterator();
        PeekingIterator peekingIterator = Iterators.peekingIterator(iterator);
        try {
            peekingIterator.peek();
            PeekingIteratorTest.fail((String)"Should throw NoSuchElementException if nothing to peek()");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testPeekDoesntChangeIteration() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"A", "B", "C"});
        Iterator iterator = list.iterator();
        PeekingIterator peekingIterator = Iterators.peekingIterator(iterator);
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() at first element", (Object)"A", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() first element multiple times", (Object)"A", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"next() should still return first element after peeking", (Object)"A", (Object)peekingIterator.next());
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() at middle element", (Object)"B", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() middle element multiple times", (Object)"B", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"next() should still return middle element after peeking", (Object)"B", (Object)peekingIterator.next());
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() at last element", (Object)"C", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"Should be able to peek() last element multiple times", (Object)"C", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((String)"next() should still return last element after peeking", (Object)"C", (Object)peekingIterator.next());
        try {
            peekingIterator.peek();
            PeekingIteratorTest.fail((String)"Should throw exception if no next to peek()");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            peekingIterator.peek();
            PeekingIteratorTest.fail((String)"Should continue to throw exception if no next to peek()");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            peekingIterator.next();
            PeekingIteratorTest.fail((String)"next() should still throw exception after the end of iteration");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testCantRemoveAfterPeek() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"A", "B", "C"});
        Iterator iterator = list.iterator();
        PeekingIterator peekingIterator = Iterators.peekingIterator(iterator);
        PeekingIteratorTest.assertEquals((Object)"A", (Object)peekingIterator.next());
        PeekingIteratorTest.assertEquals((Object)"B", (Object)peekingIterator.peek());
        try {
            peekingIterator.remove();
            PeekingIteratorTest.fail((String)"remove() should throw IllegalStateException after a peek()");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        PeekingIteratorTest.assertEquals((String)"After remove() throws exception, peek should still be ok", (Object)"B", (Object)peekingIterator.peek());
        PeekingIteratorTest.assertEquals((Object)"B", (Object)peekingIterator.next());
        peekingIterator.remove();
        PeekingIteratorTest.assertEquals((String)"Should have removed an element", (int)2, (int)list.size());
        PeekingIteratorTest.assertFalse((String)"Second element should be gone", (boolean)list.contains("B"));
    }

    public void testPeekingIteratorDoesntAdvancePrematurely() throws Exception {
        ArrayList list = Collections.emptyList();
        PeekingIterator iterator = Iterators.peekingIterator(new ThrowsAtEndIterator(list));
        this.assertNextThrows((Iterator<?>)iterator);
        list = Lists.newArrayList((Object[])new Integer[]{1, 2});
        iterator = Iterators.peekingIterator(new ThrowsAtEndIterator(list));
        PeekingIteratorTest.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        PeekingIteratorTest.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        this.assertNextThrows((Iterator<?>)iterator);
    }

    private void assertNextThrows(Iterator<?> iterator) {
        try {
            iterator.next();
            PeekingIteratorTest.fail();
        }
        catch (ThrowsAtEndException throwsAtEndException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThrowsAtEndIterator<E>
    implements Iterator<E> {
        Iterator<E> iterator;

        public ThrowsAtEndIterator(Iterable<E> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public E next() {
            if (!this.iterator.hasNext()) {
                throw new ThrowsAtEndException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static class ThrowsAtEndException
    extends RuntimeException {
        ThrowsAtEndException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeekingIteratorTester<T>
    extends IteratorTester<T> {
        private Iterable<T> master;
        private List<T> targetList;

        public PeekingIteratorTester(Collection<T> master) {
            super(master.size() + 3, (Iterable)IteratorFeature.MODIFIABLE, master, AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
            this.master = master;
        }

        protected Iterator<T> newTargetIterator() {
            this.targetList = Lists.newArrayList(this.master);
            Iterator<T> iterator = this.targetList.iterator();
            return Iterators.peekingIterator(iterator);
        }

        protected void verify(List<T> elements) {
            Assert.assertEquals(elements, this.targetList);
        }
    }
}

