/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractImmutableTableTest;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class RegularImmutableTableTest
extends AbstractImmutableTableTest {
    private static final ImmutableSet<Table.Cell<Character, Integer, String>> CELLS = ImmutableSet.of((Object)Tables.immutableCell((Object)Character.valueOf('a'), (Object)1, (Object)"foo"), (Object)Tables.immutableCell((Object)Character.valueOf('b'), (Object)1, (Object)"bar"), (Object)Tables.immutableCell((Object)Character.valueOf('a'), (Object)2, (Object)"baz"));
    private static final ImmutableSet<Character> ROW_SPACE = ImmutableSet.of((Object)Character.valueOf('a'), (Object)Character.valueOf('b'));
    private static final ImmutableSet<Integer> COLUMN_SPACE = ImmutableSet.of((Object)1, (Object)2);
    private static final SparseImmutableTable<Character, Integer, String> SPARSE = new SparseImmutableTable(CELLS.asList(), ROW_SPACE, COLUMN_SPACE);
    private static final DenseImmutableTable<Character, Integer, String> DENSE = new DenseImmutableTable(CELLS.asList(), ROW_SPACE, COLUMN_SPACE);

    @Override
    Iterable<ImmutableTable<Character, Integer, String>> getTestInstances() {
        return ImmutableList.of(SPARSE, DENSE);
    }

    public void testCellSet() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals(CELLS, (Object)testInstance.cellSet());
        }
    }

    public void testValues() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            Truth.ASSERT.that((Collection)testInstance.values()).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
        }
    }

    public void testSize() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((int)3, (int)testInstance.size());
        }
    }

    public void testContainsValue() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsValue((Object)"foo"));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsValue((Object)"bar"));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsValue((Object)"baz"));
            RegularImmutableTableTest.assertFalse((boolean)testInstance.containsValue((Object)"blah"));
        }
    }

    public void testIsEmpty() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertFalse((boolean)testInstance.isEmpty());
        }
    }

    public void testForCells() {
        RegularImmutableTableTest.assertTrue((boolean)(RegularImmutableTable.forCells(CELLS) instanceof DenseImmutableTable));
        RegularImmutableTableTest.assertTrue((boolean)(RegularImmutableTable.forCells((Iterable)ImmutableSet.of((Object)Tables.immutableCell((Object)Character.valueOf('a'), (Object)1, (Object)"blah"), (Object)Tables.immutableCell((Object)Character.valueOf('b'), (Object)2, (Object)"blah"), (Object)Tables.immutableCell((Object)Character.valueOf('c'), (Object)3, (Object)"blah"))) instanceof SparseImmutableTable));
    }

    public void testGet() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((String)"foo", (String)((String)testInstance.get((Object)Character.valueOf('a'), (Object)1)));
            RegularImmutableTableTest.assertEquals((String)"bar", (String)((String)testInstance.get((Object)Character.valueOf('b'), (Object)1)));
            RegularImmutableTableTest.assertEquals((String)"baz", (String)((String)testInstance.get((Object)Character.valueOf('a'), (Object)2)));
            RegularImmutableTableTest.assertNull((Object)testInstance.get((Object)Character.valueOf('b'), (Object)2));
            RegularImmutableTableTest.assertNull((Object)testInstance.get((Object)Character.valueOf('c'), (Object)3));
        }
    }

    public void testColumn() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"foo", (Object)Character.valueOf('b'), (Object)"bar"), (Object)testInstance.column((Object)1));
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"baz"), (Object)testInstance.column((Object)2));
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)testInstance.column((Object)3));
        }
    }

    public void testColumnKeySet() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2), (Object)testInstance.columnKeySet());
        }
    }

    public void testColumnMap() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"foo", (Object)Character.valueOf('b'), (Object)"bar"), (Object)2, (Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"baz")), (Object)testInstance.columnMap());
        }
    }

    public void testContains() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertTrue((boolean)testInstance.contains((Object)Character.valueOf('a'), (Object)1));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.contains((Object)Character.valueOf('b'), (Object)1));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.contains((Object)Character.valueOf('a'), (Object)2));
            RegularImmutableTableTest.assertFalse((boolean)testInstance.contains((Object)Character.valueOf('b'), (Object)2));
            RegularImmutableTableTest.assertFalse((boolean)testInstance.contains((Object)Character.valueOf('c'), (Object)3));
        }
    }

    public void testContainsColumn() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsColumn((Object)1));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsColumn((Object)2));
            RegularImmutableTableTest.assertFalse((boolean)testInstance.containsColumn((Object)3));
        }
    }

    public void testContainsRow() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsRow((Object)Character.valueOf('a')));
            RegularImmutableTableTest.assertTrue((boolean)testInstance.containsRow((Object)Character.valueOf('b')));
            RegularImmutableTableTest.assertFalse((boolean)testInstance.containsRow((Object)Character.valueOf('c')));
        }
    }

    public void testRow() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"foo", (Object)2, (Object)"baz"), (Object)testInstance.row((Object)Character.valueOf('a')));
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"bar"), (Object)testInstance.row((Object)Character.valueOf('b')));
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)testInstance.row((Object)Character.valueOf('c')));
        }
    }

    public void testRowKeySet() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableSet.of((Object)Character.valueOf('a'), (Object)Character.valueOf('b')), (Object)testInstance.rowKeySet());
        }
    }

    public void testRowMap() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            RegularImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)ImmutableMap.of((Object)1, (Object)"foo", (Object)2, (Object)"baz"), (Object)Character.valueOf('b'), (Object)ImmutableMap.of((Object)1, (Object)"bar")), (Object)testInstance.rowMap());
        }
    }
}

