/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Collections2Test;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.MinimalIterable;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumSetGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.SetFeature;
import com.google.common.collect.testing.testers.CollectionIteratorTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class SetsTest
extends TestCase {
    private static final AbstractIteratorTester.KnownOrder KNOWN_ORDER = AbstractIteratorTester.KnownOrder.KNOWN_ORDER;
    private static final Collection<Integer> EMPTY_COLLECTION = Arrays.asList(new Integer[0]);
    private static final Collection<Integer> SOME_COLLECTION = Arrays.asList(0, 1, 1);
    private static final Iterable<Integer> SOME_ITERABLE = new Iterable<Integer>(){

        @Override
        public Iterator<Integer> iterator() {
            return SOME_COLLECTION.iterator();
        }
    };
    private static final List<Integer> LONGER_LIST = Arrays.asList(8, 6, 7, 5, 3, 0, 9);
    private static final Comparator<Integer> SOME_COMPARATOR = Collections.reverseOrder();

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SetsTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.newConcurrentHashSet(Arrays.asList(elements));
            }
        }).named("Sets.newConcurrentHashSet")).withFeatures(new Feature[]{CollectionSize.ANY, SetFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                int size = elements.length;
                HashSet set1 = size > 1 ? Sets.newHashSet(Arrays.asList(elements).subList(0, size - 1)) : Sets.newHashSet((Object[])elements);
                HashSet set2 = size > 0 ? Sets.newHashSet(Arrays.asList(elements).subList(1, size)) : Sets.newHashSet();
                return Sets.union((Set)set1, (Set)set2);
            }
        }).named("Sets.union")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashSet set1 = Sets.newHashSet((Object[])elements);
                set1.add(this.samples().e3);
                HashSet set2 = Sets.newHashSet((Object[])elements);
                set2.add(this.samples().e4);
                return Sets.intersection((Set)set1, (Set)set2);
            }
        }).named("Sets.intersection")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashSet set1 = Sets.newHashSet((Object[])elements);
                set1.add(this.samples().e3);
                HashSet set2 = Sets.newHashSet((Object[])new String[]{(String)this.samples().e3});
                return Sets.difference((Set)set1, (Set)set2);
            }
        }).named("Sets.difference")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestEnumSetGenerator(){

            protected Set<AnEnum> create(AnEnum[] elements) {
                AnEnum[] otherElements = new AnEnum[elements.length - 1];
                System.arraycopy(elements, 1, otherElements, 0, otherElements.length);
                return Sets.immutableEnumSet((Enum)elements[0], (Enum[])otherElements);
            }
        }).named("Sets.immutableEnumSet")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest(SetsTest.testsForFilter());
        suite.addTest(SetsTest.testsForFilterNoNulls());
        suite.addTest(SetsTest.testsForFilterFiltered());
        return suite;
    }

    @GwtIncompatible(value="suite")
    private static Test testsForFilter() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            public Set<String> create(String[] elements) {
                LinkedHashSet unfiltered = Sets.newLinkedHashSet();
                unfiltered.add("yyy");
                Collections.addAll(unfiltered, elements);
                unfiltered.add("zzz");
                return Sets.filter((Set)unfiltered, Collections2Test.NOT_YYY_ZZZ);
            }
        }).named("Sets.filter")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).suppressing(new Method[]{CollectionIteratorTester.getIteratorKnownOrderRemoveSupportedMethod()})).createTestSuite();
    }

    @GwtIncompatible(value="suite")
    private static Test testsForFilterNoNulls() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            public Set<String> create(String[] elements) {
                LinkedHashSet unfiltered = Sets.newLinkedHashSet();
                unfiltered.add("yyy");
                unfiltered.addAll(ImmutableList.copyOf((Object[])elements));
                unfiltered.add("zzz");
                return Sets.filter((Set)unfiltered, Collections2Test.LENGTH_1);
            }
        }).named("Sets.filter, no nulls")).withFeatures(new Feature[]{SetFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).suppressing(new Method[]{CollectionIteratorTester.getIteratorKnownOrderRemoveSupportedMethod()})).createTestSuite());
        return suite;
    }

    @GwtIncompatible(value="suite")
    private static Test testsForFilterFiltered() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            public Set<String> create(String[] elements) {
                LinkedHashSet unfiltered = Sets.newLinkedHashSet();
                unfiltered.add("yyy");
                unfiltered.addAll(ImmutableList.copyOf((Object[])elements));
                unfiltered.add("zzz");
                unfiltered.add("abc");
                return Sets.filter((Set)Sets.filter((Set)unfiltered, Collections2Test.LENGTH_1), Collections2Test.NOT_YYY_ZZZ);
            }
        }).named("Sets.filter, filtered input")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).suppressing(new Method[]{CollectionIteratorTester.getIteratorKnownOrderRemoveSupportedMethod()})).createTestSuite();
    }

    public void testImmutableEnumSet() {
        ImmutableSet units = Sets.immutableEnumSet((Enum)SomeEnum.D, (Enum[])new SomeEnum[]{SomeEnum.B});
        Truth.ASSERT.that((Collection)units).has().exactly((Object)SomeEnum.B, (Object)SomeEnum.D, (Object[])new SomeEnum[0]).inOrder();
        try {
            units.remove((Object)SomeEnum.B);
            SetsTest.fail((String)"ImmutableEnumSet should throw an exception on remove()");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            units.add(SomeEnum.C);
            SetsTest.fail((String)"ImmutableEnumSet should throw an exception on add()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="SerializableTester")
    public void testImmutableEnumSet_serialized() {
        ImmutableSet units = Sets.immutableEnumSet((Enum)SomeEnum.D, (Enum[])new SomeEnum[]{SomeEnum.B});
        Truth.ASSERT.that((Collection)units).has().exactly((Object)SomeEnum.B, (Object)SomeEnum.D, (Object[])new SomeEnum[0]).inOrder();
        Set copy = (Set)SerializableTester.reserializeAndAssert((Object)units);
        SetsTest.assertTrue((boolean)(copy instanceof ImmutableEnumSet));
    }

    public void testImmutableEnumSet_fromIterable() {
        ImmutableSet none = Sets.immutableEnumSet((Iterable)MinimalIterable.of((Object[])new SomeEnum[0]));
        Truth.ASSERT.that((Collection)none).isEmpty();
        ImmutableSet one = Sets.immutableEnumSet((Iterable)MinimalIterable.of((Object[])new SomeEnum[]{SomeEnum.B}));
        Truth.ASSERT.that((Collection)one).has().item((Object)SomeEnum.B);
        ImmutableSet two = Sets.immutableEnumSet((Iterable)MinimalIterable.of((Object[])new SomeEnum[]{SomeEnum.D, SomeEnum.B}));
        Truth.ASSERT.that((Collection)two).has().exactly((Object)SomeEnum.B, (Object)SomeEnum.D, (Object[])new SomeEnum[0]).inOrder();
    }

    @GwtIncompatible(value="java serialization not supported in GWT.")
    public void testImmutableEnumSet_deserializationMakesDefensiveCopy() throws Exception {
        ImmutableSet original = Sets.immutableEnumSet((Enum)SomeEnum.A, (Enum[])new SomeEnum[]{SomeEnum.B});
        int handleOffset = 6;
        byte[] serializedForm = SetsTest.serializeWithBackReference(original, handleOffset);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedForm));
        ImmutableSet deserialized = (ImmutableSet)in.readObject();
        EnumSet delegate = (EnumSet)in.readObject();
        SetsTest.assertEquals((Object)original, (Object)deserialized);
        SetsTest.assertTrue((boolean)delegate.remove((Object)SomeEnum.A));
        SetsTest.assertTrue((boolean)deserialized.contains((Object)SomeEnum.A));
    }

    @GwtIncompatible(value="java serialization not supported in GWT.")
    private static byte[] serializeWithBackReference(Object original, int handleOffset) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(original);
        byte[] handle = SetsTest.toByteArray(0x7E0000 + handleOffset);
        byte[] ref = SetsTest.prepended((byte)113, handle);
        bos.write(ref);
        return bos.toByteArray();
    }

    private static byte[] prepended(byte b, byte[] array) {
        byte[] out = new byte[array.length + 1];
        out[0] = b;
        System.arraycopy(array, 0, out, 1, array.length);
        return out;
    }

    @GwtIncompatible(value="java.nio.ByteBuffer")
    private static byte[] toByteArray(int h) {
        return ByteBuffer.allocate(4).putInt(h).array();
    }

    public void testNewEnumSet_empty() {
        EnumSet copy = Sets.newEnumSet(Collections.emptySet(), SomeEnum.class);
        SetsTest.assertEquals(EnumSet.noneOf(SomeEnum.class), (Object)copy);
    }

    public void testNewEnumSet_enumSet() {
        EnumSet<SomeEnum> set = EnumSet.of(SomeEnum.A, SomeEnum.D);
        SetsTest.assertEquals(set, (Object)Sets.newEnumSet(set, SomeEnum.class));
    }

    public void testNewEnumSet_collection() {
        ImmutableSet set = ImmutableSet.of((Object)((Object)SomeEnum.B), (Object)((Object)SomeEnum.C));
        SetsTest.assertEquals((Object)set, (Object)Sets.newEnumSet((Iterable)set, SomeEnum.class));
    }

    public void testNewEnumSet_iterable() {
        ImmutableSet set = ImmutableSet.of((Object)((Object)SomeEnum.A), (Object)((Object)SomeEnum.B), (Object)((Object)SomeEnum.C));
        SetsTest.assertEquals((Object)set, (Object)Sets.newEnumSet((Iterable)Iterables.unmodifiableIterable((Iterable)set), SomeEnum.class));
    }

    public void testNewHashSetEmpty() {
        HashSet set = Sets.newHashSet();
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewHashSetVarArgs() {
        HashSet set = Sets.newHashSet((Object[])new Integer[]{0, 1, 1});
        SetsTest.verifySetContents(set, Arrays.asList(0, 1));
    }

    public void testNewHashSetFromCollection() {
        HashSet set = Sets.newHashSet(SOME_COLLECTION);
        SetsTest.verifySetContents(set, SOME_COLLECTION);
    }

    public void testNewHashSetFromIterable() {
        HashSet set = Sets.newHashSet(SOME_ITERABLE);
        SetsTest.verifySetContents(set, SOME_ITERABLE);
    }

    public void testNewHashSetWithExpectedSizeSmall() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)0);
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewHashSetWithExpectedSizeLarge() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)1000);
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewHashSetFromIterator() {
        HashSet set = Sets.newHashSet(SOME_COLLECTION.iterator());
        SetsTest.verifySetContents(set, SOME_COLLECTION);
    }

    public void testNewConcurrentHashSetEmpty() {
        Set set = Sets.newConcurrentHashSet();
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewConcurrentHashSetFromCollection() {
        Set set = Sets.newConcurrentHashSet(SOME_COLLECTION);
        SetsTest.verifySetContents(set, SOME_COLLECTION);
    }

    public void testNewLinkedHashSetEmpty() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        SetsTest.verifyLinkedHashSetContents(set, EMPTY_COLLECTION);
    }

    public void testNewLinkedHashSetFromCollection() {
        LinkedHashSet set = Sets.newLinkedHashSet(LONGER_LIST);
        SetsTest.verifyLinkedHashSetContents(set, LONGER_LIST);
    }

    public void testNewLinkedHashSetFromIterable() {
        LinkedHashSet set = Sets.newLinkedHashSet((Iterable)new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return LONGER_LIST.iterator();
            }
        });
        SetsTest.verifyLinkedHashSetContents(set, LONGER_LIST);
    }

    public void testNewLinkedHashSetWithExpectedSizeSmall() {
        LinkedHashSet set = Sets.newLinkedHashSetWithExpectedSize((int)0);
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewLinkedHashSetWithExpectedSizeLarge() {
        LinkedHashSet set = Sets.newLinkedHashSetWithExpectedSize((int)1000);
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    public void testNewTreeSetEmpty() {
        TreeSet set = Sets.newTreeSet();
        SetsTest.verifySortedSetContents(set, EMPTY_COLLECTION, null);
    }

    public void testNewTreeSetEmptyDerived() {
        TreeSet set = Sets.newTreeSet();
        SetsTest.assertTrue((boolean)set.isEmpty());
        set.add(new Derived("foo"));
        set.add(new Derived("bar"));
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new Derived("bar"), (Object)new Derived("foo"), (Object[])new Derived[0]).inOrder();
    }

    public void testNewTreeSetEmptyNonGeneric() {
        TreeSet set = Sets.newTreeSet();
        SetsTest.assertTrue((boolean)set.isEmpty());
        set.add(new LegacyComparable("foo"));
        set.add(new LegacyComparable("bar"));
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("foo"), (Object[])new LegacyComparable[0]).inOrder();
    }

    public void testNewTreeSetFromCollection() {
        TreeSet set = Sets.newTreeSet(SOME_COLLECTION);
        SetsTest.verifySortedSetContents(set, SOME_COLLECTION, null);
    }

    public void testNewTreeSetFromIterable() {
        TreeSet set = Sets.newTreeSet(SOME_ITERABLE);
        SetsTest.verifySortedSetContents(set, SOME_ITERABLE, null);
    }

    public void testNewTreeSetFromIterableDerived() {
        List<Derived> iterable = Arrays.asList(new Derived("foo"), new Derived("bar"));
        TreeSet set = Sets.newTreeSet(iterable);
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new Derived("bar"), (Object)new Derived("foo"), (Object[])new Derived[0]).inOrder();
    }

    public void testNewTreeSetFromIterableNonGeneric() {
        List<LegacyComparable> iterable = Arrays.asList(new LegacyComparable("foo"), new LegacyComparable("bar"));
        TreeSet set = Sets.newTreeSet(iterable);
        Truth.ASSERT.that((Collection)set).has().exactly((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("foo"), (Object[])new LegacyComparable[0]).inOrder();
    }

    public void testNewTreeSetEmptyWithComparator() {
        TreeSet set = Sets.newTreeSet(SOME_COMPARATOR);
        SetsTest.verifySortedSetContents(set, EMPTY_COLLECTION, SOME_COMPARATOR);
    }

    public void testNewIdentityHashSet() {
        Set set = Sets.newIdentityHashSet();
        Integer value1 = new Integer(12357);
        Integer value2 = new Integer(12357);
        SetsTest.assertTrue((boolean)set.add(value1));
        SetsTest.assertFalse((boolean)set.contains(value2));
        SetsTest.assertTrue((boolean)set.contains(value1));
        SetsTest.assertTrue((boolean)set.add(value2));
        SetsTest.assertEquals((int)2, (int)set.size());
    }

    @GwtIncompatible(value="CopyOnWriteArraySet")
    public void testNewCOWASEmpty() {
        CopyOnWriteArraySet set = Sets.newCopyOnWriteArraySet();
        SetsTest.verifySetContents(set, EMPTY_COLLECTION);
    }

    @GwtIncompatible(value="CopyOnWriteArraySet")
    public void testNewCOWASFromIterable() {
        CopyOnWriteArraySet set = Sets.newCopyOnWriteArraySet(SOME_ITERABLE);
        SetsTest.verifySetContents(set, SOME_COLLECTION);
    }

    public void testComplementOfEnumSet() {
        EnumSet<SomeEnum> units = EnumSet.of(SomeEnum.B, SomeEnum.D);
        EnumSet otherUnits = Sets.complementOf(units);
        SetsTest.verifySetContents(otherUnits, EnumSet.of(SomeEnum.A, SomeEnum.C));
    }

    public void testComplementOfEnumSetWithType() {
        EnumSet<SomeEnum> units = EnumSet.of(SomeEnum.B, SomeEnum.D);
        EnumSet otherUnits = Sets.complementOf(units, SomeEnum.class);
        SetsTest.verifySetContents(otherUnits, EnumSet.of(SomeEnum.A, SomeEnum.C));
    }

    public void testComplementOfRegularSet() {
        HashSet units = Sets.newHashSet((Object[])new SomeEnum[]{SomeEnum.B, SomeEnum.D});
        EnumSet otherUnits = Sets.complementOf((Collection)units);
        SetsTest.verifySetContents(otherUnits, EnumSet.of(SomeEnum.A, SomeEnum.C));
    }

    public void testComplementOfRegularSetWithType() {
        HashSet units = Sets.newHashSet((Object[])new SomeEnum[]{SomeEnum.B, SomeEnum.D});
        EnumSet otherUnits = Sets.complementOf((Collection)units, SomeEnum.class);
        SetsTest.verifySetContents(otherUnits, EnumSet.of(SomeEnum.A, SomeEnum.C));
    }

    public void testComplementOfEmptySet() {
        Set noUnits = Collections.emptySet();
        EnumSet allUnits = Sets.complementOf(noUnits, SomeEnum.class);
        SetsTest.verifySetContents(EnumSet.allOf(SomeEnum.class), allUnits);
    }

    public void testComplementOfFullSet() {
        HashSet allUnits = Sets.newHashSet((Object[])SomeEnum.values());
        EnumSet noUnits = Sets.complementOf((Collection)allUnits, SomeEnum.class);
        SetsTest.verifySetContents(noUnits, EnumSet.noneOf(SomeEnum.class));
    }

    public void testComplementOfEmptyEnumSetWithoutType() {
        EnumSet<SomeEnum> noUnits = EnumSet.noneOf(SomeEnum.class);
        EnumSet allUnits = Sets.complementOf(noUnits);
        SetsTest.verifySetContents(allUnits, EnumSet.allOf(SomeEnum.class));
    }

    public void testComplementOfEmptySetWithoutTypeDoesntWork() {
        Set set = Collections.emptySet();
        try {
            Sets.complementOf(set);
            SetsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        new NullPointerTester().setDefault(Enum.class, (Object)SomeEnum.A).setDefault(Class.class, SomeEnum.class).testAllPublicStaticMethods(Sets.class);
    }

    public void testNewSetFromMap() {
        Set set = Sets.newSetFromMap(new HashMap());
        set.addAll(SOME_COLLECTION);
        SetsTest.verifySetContents(set, SOME_COLLECTION);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testNewSetFromMapSerialization() {
        Set set = Sets.newSetFromMap(new LinkedHashMap());
        set.addAll(SOME_COLLECTION);
        Set copy = (Set)SerializableTester.reserializeAndAssert((Object)set);
        Truth.ASSERT.that((Collection)copy).has().exactly((Object)0, (Object)1, (Object[])new Integer[0]).inOrder();
    }

    public void testNewSetFromMapIllegal() {
        LinkedHashMap<Integer, Boolean> map = new LinkedHashMap<Integer, Boolean>();
        map.put(2, true);
        try {
            Sets.newSetFromMap(map);
            SetsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCartesianProduct_zeroary() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[0])).has().exactly(SetsTest.list(new Object[0]));
    }

    public void testCartesianProduct_unary() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, 2)})).has().exactly(SetsTest.list(1), SetsTest.list(2), (Object[])new List[0]);
    }

    public void testCartesianProduct_binary0x0() {
        Set mt = Collections.emptySet();
        SetsTest.assertEmpty(Sets.cartesianProduct((Set[])new Set[]{mt, mt}));
    }

    public void testCartesianProduct_binary0x1() {
        Set mt = Collections.emptySet();
        SetsTest.assertEmpty(Sets.cartesianProduct((Set[])new Set[]{mt, SetsTest.set(1)}));
    }

    public void testCartesianProduct_binary1x0() {
        Set mt = Collections.emptySet();
        SetsTest.assertEmpty(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1), mt}));
    }

    private static void assertEmpty(Set<? extends List<?>> set) {
        SetsTest.assertTrue((boolean)set.isEmpty());
        SetsTest.assertEquals((int)0, (int)set.size());
        SetsTest.assertFalse((boolean)set.iterator().hasNext());
    }

    public void testCartesianProduct_binary1x1() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1), SetsTest.set(2)})).has().item(SetsTest.list(1, 2));
    }

    public void testCartesianProduct_binary1x2() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1), SetsTest.set(2, 3)})).has().exactly(SetsTest.list(1, 2), SetsTest.list(1, 3), (Object[])new List[0]).inOrder();
    }

    public void testCartesianProduct_binary2x2() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, 2), SetsTest.set(3, 4)})).has().exactly(SetsTest.list(1, 3), SetsTest.list(1, 4), (Object[])new List[]{SetsTest.list(2, 3), SetsTest.list(2, 4)}).inOrder();
    }

    public void testCartesianProduct_2x2x2() {
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(0, 1), SetsTest.set(0, 1), SetsTest.set(0, 1)})).has().exactly(SetsTest.list(0, 0, 0), SetsTest.list(0, 0, 1), (Object[])new List[]{SetsTest.list(0, 1, 0), SetsTest.list(0, 1, 1), SetsTest.list(1, 0, 0), SetsTest.list(1, 0, 1), SetsTest.list(1, 1, 0), SetsTest.list(1, 1, 1)}).inOrder();
    }

    public void testCartesianProduct_contains() {
        Set actual = Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, 2), SetsTest.set(3, 4)});
        SetsTest.assertTrue((boolean)actual.contains(SetsTest.list(1, 3)));
        SetsTest.assertTrue((boolean)actual.contains(SetsTest.list(1, 4)));
        SetsTest.assertTrue((boolean)actual.contains(SetsTest.list(2, 3)));
        SetsTest.assertTrue((boolean)actual.contains(SetsTest.list(2, 4)));
        SetsTest.assertFalse((boolean)actual.contains(SetsTest.list(3, 1)));
    }

    public void testCartesianProduct_unrelatedTypes() {
        Set<Integer> x = SetsTest.set(1, 2);
        Set<String> y = SetsTest.set("3", "4");
        List<Object> exp1 = SetsTest.list(1, "3");
        List<Object> exp2 = SetsTest.list(1, "4");
        List<Object> exp3 = SetsTest.list(2, "3");
        List<Object> exp4 = SetsTest.list(2, "4");
        Truth.ASSERT.that((Collection)Sets.cartesianProduct((Set[])new Set[]{x, y})).has().exactly(exp1, exp2, (Object[])new List[]{exp3, exp4}).inOrder();
    }

    public void testCartesianProductTooBig() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000)), (DiscreteDomain)DiscreteDomain.integers());
        try {
            Sets.cartesianProduct((Set[])new Set[]{set, set, set, set, set});
            SetsTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCartesianProduct_hashCode() {
        Set degenerate = Sets.cartesianProduct((Set[])new Set[0]);
        SetsTest.checkHashCode(degenerate);
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, 2)}));
        int num = 0x55555554;
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, 2, num)}));
        Set mt = Collections.emptySet();
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{mt, mt}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{mt, SetsTest.set(num)}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(num), mt}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(num), SetsTest.set(1)}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1), SetsTest.set(2, num)}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, num), SetsTest.set(2, num - 1)}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, num), SetsTest.set(2, num - 1), SetsTest.set(3, num + 1)}));
        SetsTest.checkHashCode(Sets.cartesianProduct((Set[])new Set[]{SetsTest.set(1, num, num + 1), SetsTest.set(2), SetsTest.set(3, num + 2), SetsTest.set(4, 5, 6, 7, 8)}));
    }

    public void testPowerSetEmpty() {
        ImmutableSet elements = ImmutableSet.of();
        Set powerSet = Sets.powerSet((Set)elements);
        SetsTest.assertEquals((int)1, (int)powerSet.size());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)ImmutableSet.of()), (Object)powerSet);
        SetsTest.assertEquals((int)0, (int)powerSet.hashCode());
    }

    public void testPowerSetContents() {
        ImmutableSet elements = ImmutableSet.of((Object)1, (Object)2, (Object)3);
        Set powerSet = Sets.powerSet((Set)elements);
        SetsTest.assertEquals((int)8, (int)powerSet.size());
        SetsTest.assertEquals((int)24, (int)powerSet.hashCode());
        HashSet expected = Sets.newHashSet();
        expected.add(ImmutableSet.of());
        expected.add(ImmutableSet.of((Object)1));
        expected.add(ImmutableSet.of((Object)2));
        expected.add(ImmutableSet.of((Object)3));
        expected.add(ImmutableSet.of((Object)1, (Object)2));
        expected.add(ImmutableSet.of((Object)1, (Object)3));
        expected.add(ImmutableSet.of((Object)2, (Object)3));
        expected.add(ImmutableSet.of((Object)1, (Object)2, (Object)3));
        HashSet almostPowerSet = Sets.newHashSet((Iterable)expected);
        almostPowerSet.remove(ImmutableSet.of((Object)1, (Object)2, (Object)3));
        almostPowerSet.add(ImmutableSet.of((Object)1, (Object)2, (Object)4));
        new EqualsTester().addEqualityGroup(new Object[]{expected, powerSet}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)1, (Object)2, (Object)3)}).addEqualityGroup(new Object[]{almostPowerSet}).testEquals();
        for (Set subset : expected) {
            SetsTest.assertTrue((boolean)powerSet.contains(subset));
        }
        SetsTest.assertFalse((boolean)powerSet.contains(ImmutableSet.of((Object)1, (Object)2, (Object)4)));
        SetsTest.assertFalse((boolean)powerSet.contains(Collections.singleton(null)));
        SetsTest.assertFalse((boolean)powerSet.contains(null));
        SetsTest.assertFalse((boolean)powerSet.contains("notASet"));
    }

    public void testPowerSetIteration_manual() {
        ImmutableSet elements = ImmutableSet.of((Object)1, (Object)2, (Object)3);
        Set powerSet = Sets.powerSet((Set)elements);
        Iterator i = powerSet.iterator();
        SetsTest.assertEquals((Object)ImmutableSet.of(), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)1), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)2), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)2, (Object)1), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)3), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)3, (Object)1), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)3, (Object)2), i.next());
        SetsTest.assertEquals((Object)ImmutableSet.of((Object)3, (Object)2, (Object)1), i.next());
        SetsTest.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            SetsTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="too slow for GWT")
    public void testPowerSetIteration_iteratorTester() {
        ImmutableSet elements = ImmutableSet.of((Object)1, (Object)2);
        LinkedHashSet expected = Sets.newLinkedHashSet();
        expected.add(ImmutableSet.of());
        expected.add(ImmutableSet.of((Object)1));
        expected.add(ImmutableSet.of((Object)2));
        expected.add(ImmutableSet.of((Object)1, (Object)2));
        final Set powerSet = Sets.powerSet((Set)elements);
        new IteratorTester<Set<Integer>>(6, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)expected, KNOWN_ORDER){

            protected Iterator<Set<Integer>> newTargetIterator() {
                return powerSet.iterator();
            }
        }.test();
    }

    public void testPowerSetIteration_iteratorTester_fast() {
        ImmutableSet elements = ImmutableSet.of((Object)1, (Object)2);
        LinkedHashSet expected = Sets.newLinkedHashSet();
        expected.add(ImmutableSet.of());
        expected.add(ImmutableSet.of((Object)1));
        expected.add(ImmutableSet.of((Object)2));
        expected.add(ImmutableSet.of((Object)1, (Object)2));
        final Set powerSet = Sets.powerSet((Set)elements);
        new IteratorTester<Set<Integer>>(4, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)expected, KNOWN_ORDER){

            protected Iterator<Set<Integer>> newTargetIterator() {
                return powerSet.iterator();
            }
        }.test();
    }

    public void testPowerSetSize() {
        SetsTest.assertPowerSetSize(1, new Object[0]);
        SetsTest.assertPowerSetSize(2, Character.valueOf('a'));
        SetsTest.assertPowerSetSize(4, Character.valueOf('a'), Character.valueOf('b'));
        SetsTest.assertPowerSetSize(8, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'));
        SetsTest.assertPowerSetSize(16, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('d'), Character.valueOf('e'));
        SetsTest.assertPowerSetSize(0x40000000, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'));
    }

    public void testPowerSetCreationErrors() {
        try {
            Sets.powerSet((Set)Sets.newHashSet((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5')}));
            SetsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Sets.powerSet(Collections.singleton(null));
            SetsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPowerSetEqualsAndHashCode_verifyAgainstHashSet() {
        ImmutableList allElements = ImmutableList.of((Object)4233352, (Object)3284593, (Object)3794208, (Object)3849533, (Object)4013967, (Object)2902658, (Object)1886275, (Object)2131109, (Object)985872, (Object)1843868);
        for (int i = 0; i < allElements.size(); ++i) {
            HashSet elements = Sets.newHashSet((Iterable)allElements.subList(0, i));
            Set powerSet1 = Sets.powerSet((Set)elements);
            Set powerSet2 = Sets.powerSet((Set)elements);
            new EqualsTester().addEqualityGroup(new Object[]{powerSet1, powerSet2, SetsTest.toHashSets(powerSet1)}).addEqualityGroup(new Object[]{ImmutableSet.of()}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)9999999)}).addEqualityGroup(new Object[]{"notASet"}).testEquals();
            SetsTest.assertEquals((int)SetsTest.toHashSets(powerSet1).hashCode(), (int)powerSet1.hashCode());
        }
    }

    public void testPowerSetHashCode_inputHashCodeTimesTooFarValueIsZero() {
        HashSet sumToEighthMaxIntElements = Sets.newHashSet((Object[])new Object[]{SetsTest.objectWithHashCode(0x20000000), SetsTest.objectWithHashCode(0)});
        SetsTest.assertPowerSetHashCode(0x40000000, sumToEighthMaxIntElements);
        HashSet sumToQuarterMaxIntElements = Sets.newHashSet((Object[])new Object[]{SetsTest.objectWithHashCode(0x40000000), SetsTest.objectWithHashCode(0)});
        SetsTest.assertPowerSetHashCode(Integer.MIN_VALUE, sumToQuarterMaxIntElements);
    }

    public void testPowerSetShowOff() {
        ImmutableSet zero = ImmutableSet.of();
        Set one = Sets.powerSet((Set)zero);
        Set two = Sets.powerSet((Set)one);
        Set four = Sets.powerSet((Set)two);
        Set sixteen = Sets.powerSet((Set)four);
        Set sixtyFiveThousandish = Sets.powerSet((Set)sixteen);
        SetsTest.assertEquals((int)65536, (int)sixtyFiveThousandish.size());
        SetsTest.assertTrue((boolean)Sets.powerSet(SetsTest.makeSetOfZeroToTwentyNine()).contains(SetsTest.makeSetOfZeroToTwentyNine()));
        SetsTest.assertFalse((boolean)Sets.powerSet(SetsTest.makeSetOfZeroToTwentyNine()).contains(ImmutableSet.of((Object)30)));
    }

    private static Set<Integer> makeSetOfZeroToTwentyNine() {
        HashSet zeroToTwentyNine = Sets.newHashSet();
        for (int i = 0; i < 30; ++i) {
            zeroToTwentyNine.add(i);
        }
        return zeroToTwentyNine;
    }

    private static <E> Set<Set<E>> toHashSets(Set<Set<E>> powerSet) {
        HashSet result = Sets.newHashSet();
        for (Set<E> subset : powerSet) {
            result.add(new HashSet<E>(subset));
        }
        return result;
    }

    private static Object objectWithHashCode(final int hashCode) {
        return new Object(){

            public int hashCode() {
                return hashCode;
            }
        };
    }

    private static void assertPowerSetHashCode(int expected, Set<?> elements) {
        SetsTest.assertEquals((int)expected, (int)Sets.powerSet(elements).hashCode());
    }

    private static void assertPowerSetSize(int i, Object ... elements) {
        SetsTest.assertEquals((int)i, (int)Sets.powerSet((Set)Sets.newHashSet((Object[])elements)).size());
    }

    private static void checkHashCode(Set<?> set) {
        SetsTest.assertEquals((int)Sets.newHashSet(set).hashCode(), (int)set.hashCode());
    }

    private static <E> Set<E> set(E ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    private static <E> List<E> list(E ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    private static <E> void verifyLinkedHashSetContents(LinkedHashSet<E> set, Collection<E> contents) {
        SetsTest.assertEquals((String)"LinkedHashSet should have preserved order for iteration", new ArrayList<E>(set), new ArrayList<E>(contents));
        SetsTest.verifySetContents(set, contents);
    }

    private static <E> void verifySortedSetContents(SortedSet<E> set, Iterable<E> iterable, @Nullable Comparator<E> comparator) {
        SetsTest.assertSame(comparator, set.comparator());
        SetsTest.verifySetContents(set, iterable);
    }

    private static <E> void verifySetContents(Set<E> set, Iterable<E> contents) {
        HashSet<E> expected = null;
        if (contents instanceof Set) {
            expected = (HashSet<E>)contents;
        } else {
            expected = new HashSet<E>();
            for (E element : contents) {
                expected.add(element);
            }
        }
        SetsTest.assertEquals(expected, set);
    }

    void ensureNotDirectlyModifiable(SortedSet<Integer> unmod) {
        try {
            unmod.add(4);
            SetsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.remove(4);
            SetsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.addAll(Collections.singleton(4));
            SetsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            Iterator iterator = unmod.iterator();
            iterator.next();
            iterator.remove();
            SetsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    static class Derived
    extends Base {
        private static final long serialVersionUID = 0L;

        public Derived(String s) {
            super(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Base
    implements Comparable<Base>,
    Serializable {
        private final String s;
        private static final long serialVersionUID = 0L;

        public Base(String s) {
            this.s = s;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Base) {
                return this.s.equals(((Base)other).s);
            }
            return false;
        }

        @Override
        public int compareTo(Base o) {
            return this.s.compareTo(o.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SomeEnum {
        A,
        B,
        C,
        D;

    }
}

